/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.time;

import com.datasqrl.function.FlinkTypeUtil;
import java.time.Instant;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;

public abstract class AbstractTimestampToEpoch
extends ScalarFunction {
    private final boolean isMilli;

    public Long eval(Instant instant) {
        long epoch = instant.toEpochMilli();
        if (!this.isMilli) {
            epoch /= 1000L;
        }
        return epoch;
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return FlinkTypeUtil.basicNullInference((DataType)DataTypes.BIGINT(), (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3));
    }

    public AbstractTimestampToEpoch(boolean isMilli) {
        this.isMilli = isMilli;
    }
}

