/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.time;

import com.datasqrl.time.TimeTumbleWindowFunction;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public class EndOfWeek
extends TimeTumbleWindowFunction {
    public EndOfWeek() {
        super(ChronoUnit.WEEKS, ChronoUnit.DAYS);
    }

    @Override
    public Instant eval(Instant instant, Long multiple, Long offset) {
        ZonedDateTime time;
        int daysToSubtract;
        if (multiple == null) {
            multiple = 1L;
        }
        if (offset == null) {
            offset = 0L;
        }
        if ((daysToSubtract = (time = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC)).getDayOfWeek().getValue() - 1 - offset.intValue()) < 0) {
            daysToSubtract = 7 + daysToSubtract;
        }
        return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC).truncatedTo(ChronoUnit.DAYS).minusDays(daysToSubtract).plus(1L, this.timeUnit).minusNanos(1L).toInstant();
    }
}

