/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.text;

import com.datasqrl.function.FlinkTypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;

public class TextSearch
extends ScalarFunction {
    public static void tokenizeTo(String text, Collection<String> collection) {
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            collection.add(tokenizer.nextToken().trim().toLowerCase());
        }
    }

    public Double eval(String query, String ... texts) {
        if (query == null) {
            return null;
        }
        ArrayList<String> queryWords = new ArrayList<String>();
        TextSearch.tokenizeTo(query, queryWords);
        if (queryWords.isEmpty()) {
            return 1.0;
        }
        HashSet searchWords = new HashSet();
        Arrays.stream(texts).forEach(text -> TextSearch.tokenizeTo(text, searchWords));
        double score = 0.0;
        for (String queryWord : queryWords) {
            if (!searchWords.contains(queryWord)) continue;
            score += 1.0;
        }
        return score / (double)queryWords.size();
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInference.newBuilder().inputTypeStrategy((InputTypeStrategy)FlinkTypeUtil.VariableArguments.builder().staticType(DataTypes.STRING()).variableType(DataTypes.STRING()).minVariableArguments(1).maxVariableArguments(256).build()).outputTypeStrategy(FlinkTypeUtil.nullPreservingOutputStrategy((DataType)DataTypes.DOUBLE())).build();
    }
}

