/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.text;

import com.datasqrl.function.FlinkTypeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;

public class BannedWordsFilter
extends ScalarFunction {
    private static final String BANNED_WORDS_FILENAME = "banned_words_list.txt";
    private Set<String> bannedWords;

    public void open(FunctionContext context) throws Exception {
        this.bannedWords = new HashSet<String>();
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(BANNED_WORDS_FILENAME);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                this.bannedWords.add(currentLine);
            }
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException(e);
        }
    }

    public Boolean eval(String text) {
        if (text == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            if (!this.bannedWords.contains(tokenizer.nextToken().trim().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return FlinkTypeUtil.basicNullInference((DataType)DataTypes.BOOLEAN(), (DataType)DataTypes.STRING());
    }
}

