/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.secure;

import com.datasqrl.function.FlinkTypeUtil;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;

public class RandomID
extends ScalarFunction {
    private static final SecureRandom random = new SecureRandom();
    private static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();

    public String eval(Long numBytes) {
        if (numBytes == null) {
            return null;
        }
        assert (numBytes >= 0L);
        byte[] buffer = new byte[numBytes.intValue()];
        random.nextBytes(buffer);
        return encoder.encodeToString(buffer);
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return FlinkTypeUtil.basicNullInferenceBuilder((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT()).typedArguments(List.of(DataTypes.BIGINT())).build();
    }
}

