/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.function;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.utils.AdaptedCallContext;

public class FlinkTypeUtil {
    public static TypeStrategy nullPreservingOutputStrategy(DataType outputType) {
        return callContext -> {
            DataType type = FlinkTypeUtil.getFirstArgumentType(callContext);
            if (type.getLogicalType().isNullable()) {
                return Optional.of((DataType)outputType.nullable());
            }
            return Optional.of((DataType)outputType.notNull());
        };
    }

    public static TypeInference basicNullInference(DataType outputType, DataType inputType) {
        return TypeInference.newBuilder().typedArguments(new DataType[]{inputType}).outputTypeStrategy(FlinkTypeUtil.nullPreservingOutputStrategy(outputType)).build();
    }

    public static TypeInference.Builder basicNullInferenceBuilder(DataType outputType, DataType inputType) {
        return TypeInference.newBuilder().typedArguments(new DataType[]{inputType}).outputTypeStrategy(FlinkTypeUtil.nullPreservingOutputStrategy(outputType));
    }

    public static DataType getFirstArgumentType(CallContext callContext) {
        if (callContext instanceof AdaptedCallContext) {
            Field privateField = AdaptedCallContext.class.getDeclaredField("originalContext");
            privateField.setAccessible(true);
            CallContext originalContext = (CallContext)privateField.get(callContext);
            return (DataType)originalContext.getArgumentDataTypes().get(0);
        }
        return (DataType)callContext.getArgumentDataTypes().get(0);
    }

    public static final class VariableArguments
    implements InputTypeStrategy {
        private final List<DataType> staticTypes;
        private final DataType variableType;
        private final int minVariableArguments;
        private final int maxVariableArguments;

        public ArgumentCount getArgumentCount() {
            return new ArgumentCount(){

                public boolean isValidCount(int count) {
                    int variableCount = count - staticTypes.size();
                    return variableCount >= minVariableArguments && variableCount <= maxVariableArguments;
                }

                public Optional<Integer> getMinCount() {
                    return Optional.of(staticTypes.size() + minVariableArguments);
                }

                public Optional<Integer> getMaxCount() {
                    return Optional.of(staticTypes.size() + maxVariableArguments);
                }
            };
        }

        public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
            int argCount = callContext.getArgumentDataTypes().size();
            int varArgs = argCount - this.staticTypes.size();
            if (varArgs < 0 || varArgs < this.minVariableArguments || varArgs > this.maxVariableArguments) {
                return Optional.empty();
            }
            ArrayList<DataType> result = new ArrayList<DataType>(argCount);
            result.addAll(this.staticTypes);
            for (int i = 0; i < varArgs; ++i) {
                result.add(this.variableType);
            }
            return Optional.of(result);
        }

        public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
            ArrayList<Signature.Argument> arguments = new ArrayList<Signature.Argument>(this.staticTypes.size() + 1);
            this.staticTypes.stream().map(DataType::toString).map(Signature.Argument::of).forEach(arguments::add);
            arguments.add(Signature.Argument.of((String)(this.variableType.toString() + "...")));
            return List.of(Signature.of(arguments));
        }

        VariableArguments(List<DataType> staticTypes, DataType variableType, int minVariableArguments, int maxVariableArguments) {
            this.staticTypes = staticTypes;
            this.variableType = variableType;
            this.minVariableArguments = minVariableArguments;
            this.maxVariableArguments = maxVariableArguments;
        }

        public static VariableArgumentsBuilder builder() {
            return new VariableArgumentsBuilder();
        }

        public List<DataType> getStaticTypes() {
            return this.staticTypes;
        }

        public DataType getVariableType() {
            return this.variableType;
        }

        public int getMinVariableArguments() {
            return this.minVariableArguments;
        }

        public int getMaxVariableArguments() {
            return this.maxVariableArguments;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableArguments)) {
                return false;
            }
            VariableArguments other = (VariableArguments)o;
            if (this.getMinVariableArguments() != other.getMinVariableArguments()) {
                return false;
            }
            if (this.getMaxVariableArguments() != other.getMaxVariableArguments()) {
                return false;
            }
            List<DataType> this$staticTypes = this.getStaticTypes();
            List<DataType> other$staticTypes = other.getStaticTypes();
            if (this$staticTypes == null ? other$staticTypes != null : !((Object)this$staticTypes).equals(other$staticTypes)) {
                return false;
            }
            DataType this$variableType = this.getVariableType();
            DataType other$variableType = other.getVariableType();
            return !(this$variableType == null ? other$variableType != null : !this$variableType.equals(other$variableType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinVariableArguments();
            result = result * 59 + this.getMaxVariableArguments();
            List<DataType> $staticTypes = this.getStaticTypes();
            result = result * 59 + ($staticTypes == null ? 43 : ((Object)$staticTypes).hashCode());
            DataType $variableType = this.getVariableType();
            result = result * 59 + ($variableType == null ? 43 : $variableType.hashCode());
            return result;
        }

        public String toString() {
            return "FlinkTypeUtil.VariableArguments(staticTypes=" + this.getStaticTypes() + ", variableType=" + this.getVariableType() + ", minVariableArguments=" + this.getMinVariableArguments() + ", maxVariableArguments=" + this.getMaxVariableArguments() + ")";
        }

        public static class VariableArgumentsBuilder {
            private ArrayList<DataType> staticTypes;
            private DataType variableType;
            private int minVariableArguments;
            private int maxVariableArguments;

            VariableArgumentsBuilder() {
            }

            public VariableArgumentsBuilder staticType(DataType staticType) {
                if (this.staticTypes == null) {
                    this.staticTypes = new ArrayList();
                }
                this.staticTypes.add(staticType);
                return this;
            }

            public VariableArgumentsBuilder staticTypes(Collection<? extends DataType> staticTypes) {
                if (staticTypes == null) {
                    throw new NullPointerException("staticTypes cannot be null");
                }
                if (this.staticTypes == null) {
                    this.staticTypes = new ArrayList();
                }
                this.staticTypes.addAll(staticTypes);
                return this;
            }

            public VariableArgumentsBuilder clearStaticTypes() {
                if (this.staticTypes != null) {
                    this.staticTypes.clear();
                }
                return this;
            }

            public VariableArgumentsBuilder variableType(DataType variableType) {
                this.variableType = variableType;
                return this;
            }

            public VariableArgumentsBuilder minVariableArguments(int minVariableArguments) {
                this.minVariableArguments = minVariableArguments;
                return this;
            }

            public VariableArgumentsBuilder maxVariableArguments(int maxVariableArguments) {
                this.maxVariableArguments = maxVariableArguments;
                return this;
            }

            public VariableArguments build() {
                List<DataType> staticTypes;
                switch (this.staticTypes == null ? 0 : this.staticTypes.size()) {
                    case 0: {
                        staticTypes = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        staticTypes = Collections.singletonList(this.staticTypes.get(0));
                        break;
                    }
                    default: {
                        staticTypes = Collections.unmodifiableList(new ArrayList<DataType>(this.staticTypes));
                    }
                }
                return new VariableArguments(staticTypes, this.variableType, this.minVariableArguments, this.maxVariableArguments);
            }

            public String toString() {
                return "FlinkTypeUtil.VariableArguments.VariableArgumentsBuilder(staticTypes=" + this.staticTypes + ", variableType=" + this.variableType + ", minVariableArguments=" + this.minVariableArguments + ", maxVariableArguments=" + this.maxVariableArguments + ")";
            }
        }
    }
}

