/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.json;

import com.datasqrl.json.FlinkJsonType;
import java.util.Set;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.types.Row;

public class ToJson
extends ScalarFunction {
    public static final ObjectMapper mapper = new ObjectMapper();

    public FlinkJsonType eval(String json) {
        if (json == null) {
            return null;
        }
        try {
            return new FlinkJsonType(mapper.readTree(json));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public FlinkJsonType eval(@DataTypeHint(inputGroup=InputGroup.ANY) Object json) {
        if (json == null) {
            return null;
        }
        if (json instanceof FlinkJsonType) {
            return (FlinkJsonType)json;
        }
        return new FlinkJsonType(this.unboxFlinkToJsonNode(json));
    }

    JsonNode unboxFlinkToJsonNode(Object json) {
        if (json instanceof Row) {
            Row row = (Row)json;
            ObjectNode objectNode = mapper.createObjectNode();
            Set fieldNames = row.getFieldNames(true);
            if (fieldNames == null) {
                return mapper.createObjectNode();
            }
            fieldNames.forEach(f -> objectNode.putPOJO(f, (Object)this.unboxFlinkToJsonNode(row.getField(f))));
        } else if (json instanceof Row[]) {
            Row[] rows = (Row[])json;
            ArrayNode arrayNode = mapper.createArrayNode();
            for (Row row : rows) {
                if (row == null) {
                    arrayNode.addNull();
                    continue;
                }
                ObjectNode objectNode = mapper.createObjectNode();
                Set fieldNames = row.getFieldNames(true);
                if (fieldNames == null) continue;
                fieldNames.forEach(f -> objectNode.putPOJO(f, (Object)this.unboxFlinkToJsonNode(row.getField(f))));
                arrayNode.add((JsonNode)objectNode);
            }
            return arrayNode;
        }
        return mapper.getNodeFactory().pojoNode(json);
    }
}

