/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.json;

import com.datasqrl.json.FlinkJsonType;
import com.datasqrl.json.FlinkJsonTypeSerializer;
import com.datasqrl.json.ObjectAgg;
import java.util.HashMap;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.functions.AggregateFunction;

@FunctionHint(output=@DataTypeHint(value="RAW", bridgedTo=FlinkJsonType.class, rawSerializer=FlinkJsonTypeSerializer.class))
public class JsonObjectAgg
extends AggregateFunction<Object, ObjectAgg> {
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectAgg createAccumulator() {
        return new ObjectAgg(new HashMap<String, JsonNode>());
    }

    public void accumulate(ObjectAgg accumulator, String key, String value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulate(ObjectAgg accumulator, String key, @DataTypeHint(inputGroup=InputGroup.ANY) Object value) {
        if (value instanceof FlinkJsonType) {
            this.accumulateObject(accumulator, key, ((FlinkJsonType)value).getJson());
        } else {
            accumulator.add(key, (JsonNode)this.mapper.getNodeFactory().pojoNode(value));
        }
    }

    public void accumulate(ObjectAgg accumulator, String key, Double value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulate(ObjectAgg accumulator, String key, Long value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulate(ObjectAgg accumulator, String key, Integer value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulateObject(ObjectAgg accumulator, String key, Object value) {
        accumulator.add(key, (JsonNode)this.mapper.getNodeFactory().pojoNode(value));
    }

    public void retract(ObjectAgg accumulator, String key, String value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAgg accumulator, String key, @DataTypeHint(inputGroup=InputGroup.ANY) Object value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAgg accumulator, String key, Double value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAgg accumulator, String key, Long value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAgg accumulator, String key, Integer value) {
        this.retractObject(accumulator, key);
    }

    public void retractObject(ObjectAgg accumulator, String key) {
        accumulator.remove(key);
    }

    public FlinkJsonType getValue(ObjectAgg accumulator) {
        ObjectNode objectNode = this.mapper.createObjectNode();
        accumulator.getObjects().forEach((arg_0, arg_1) -> ((ObjectNode)objectNode).putPOJO(arg_0, arg_1));
        return new FlinkJsonType((JsonNode)objectNode);
    }
}

