/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.json;

import com.datasqrl.json.FlinkJsonType;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.functions.ScalarFunction;

public class JsonExtract
extends ScalarFunction {
    public String eval(FlinkJsonType input, String pathSpec) {
        if (input == null) {
            return null;
        }
        try {
            JsonNode jsonNode = input.getJson();
            DocumentContext ctx = JsonPath.parse((String)jsonNode.toString());
            return (String)ctx.read(pathSpec, new Predicate[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String eval(FlinkJsonType input, String pathSpec, String defaultValue) {
        if (input == null) {
            return null;
        }
        try {
            DocumentContext ctx = JsonPath.parse((Object)input.getJson());
            JsonPath parse = JsonPath.compile((String)pathSpec, (Predicate[])new Predicate[0]);
            return (String)ctx.read(parse, String.class);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Boolean eval(FlinkJsonType input, String pathSpec, boolean defaultValue) {
        if (input == null) {
            return null;
        }
        try {
            DocumentContext ctx = JsonPath.parse((Object)input.getJson());
            JsonPath parse = JsonPath.compile((String)pathSpec, (Predicate[])new Predicate[0]);
            return (Boolean)ctx.read(parse, Boolean.class);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Double eval(FlinkJsonType input, String pathSpec, Double defaultValue) {
        if (input == null) {
            return null;
        }
        try {
            DocumentContext ctx = JsonPath.parse((Object)input.getJson());
            JsonPath parse = JsonPath.compile((String)pathSpec, (Predicate[])new Predicate[0]);
            return (Double)ctx.read(parse, Double.class);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Integer eval(FlinkJsonType input, String pathSpec, Integer defaultValue) {
        if (input == null) {
            return null;
        }
        try {
            DocumentContext ctx = JsonPath.parse((Object)input.getJson());
            JsonPath parse = JsonPath.compile((String)pathSpec, (Predicate[])new Predicate[0]);
            return (Integer)ctx.read(parse, Integer.class);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

