/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.json;

import com.datasqrl.json.ArrayAgg;
import com.datasqrl.json.FlinkJsonType;
import java.util.ArrayList;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.functions.AggregateFunction;

public class JsonArrayAgg
extends AggregateFunction<FlinkJsonType, ArrayAgg> {
    private final ObjectMapper mapper = new ObjectMapper();

    public ArrayAgg createAccumulator() {
        return new ArrayAgg(new ArrayList<JsonNode>());
    }

    public void accumulate(ArrayAgg accumulator, String value) {
        accumulator.add((JsonNode)this.mapper.getNodeFactory().textNode(value));
    }

    public void accumulate(ArrayAgg accumulator, FlinkJsonType value) {
        if (value != null) {
            accumulator.add(value.json);
        } else {
            accumulator.add(null);
        }
    }

    public void accumulate(ArrayAgg accumulator, Double value) {
        accumulator.add((JsonNode)this.mapper.getNodeFactory().numberNode(value));
    }

    public void accumulate(ArrayAgg accumulator, Long value) {
        accumulator.add((JsonNode)this.mapper.getNodeFactory().numberNode(value));
    }

    public void accumulate(ArrayAgg accumulator, Integer value) {
        accumulator.add((JsonNode)this.mapper.getNodeFactory().numberNode(value));
    }

    public void retract(ArrayAgg accumulator, String value) {
        accumulator.remove((JsonNode)this.mapper.getNodeFactory().textNode(value));
    }

    public void retract(ArrayAgg accumulator, FlinkJsonType value) {
        if (value != null) {
            accumulator.remove(value.json);
        } else {
            accumulator.remove(null);
        }
    }

    public void retract(ArrayAgg accumulator, Double value) {
        accumulator.remove((JsonNode)this.mapper.getNodeFactory().numberNode(value));
    }

    public void retract(ArrayAgg accumulator, Long value) {
        accumulator.remove((JsonNode)this.mapper.getNodeFactory().numberNode(value));
    }

    public void retract(ArrayAgg accumulator, Integer value) {
        accumulator.remove((JsonNode)this.mapper.getNodeFactory().numberNode(value));
    }

    public FlinkJsonType getValue(ArrayAgg accumulator) {
        ArrayNode arrayNode = this.mapper.createArrayNode();
        for (JsonNode o : accumulator.getObjects()) {
            if (o instanceof FlinkJsonType) {
                arrayNode.add(((FlinkJsonType)o).json);
                continue;
            }
            arrayNode.addPOJO((Object)o);
        }
        return new FlinkJsonType((JsonNode)arrayNode);
    }
}

