/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.json;

import com.datasqrl.flinkrunner.stdlib.json.FlinkJsonType;
import com.datasqrl.flinkrunner.stdlib.json.JsonFunctions;
import com.datasqrl.flinkrunner.stdlib.utils.AutoRegisterSystemFunction;
import com.google.auto.service.AutoService;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@AutoService(value={AutoRegisterSystemFunction.class})
public class jsonb_array
extends ScalarFunction
implements AutoRegisterSystemFunction {
    private static final ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();

    public FlinkJsonType eval(Object ... objects) {
        ArrayNode arrayNode = mapper.createArrayNode();
        for (Object value : objects) {
            if (value instanceof FlinkJsonType) {
                arrayNode.add(((FlinkJsonType)value).json);
                continue;
            }
            arrayNode.addPOJO(value);
        }
        return new FlinkJsonType((JsonNode)arrayNode);
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        InputTypeStrategy inputTypeStrategy = InputTypeStrategies.varyingSequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{JsonFunctions.createJsonArgumentTypeStrategy(typeFactory)});
        return TypeInference.newBuilder().inputTypeStrategy(inputTypeStrategy).outputTypeStrategy(TypeStrategies.explicit((DataType)JsonFunctions.createJsonType(typeFactory))).build();
    }
}

