/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.util.AbstractMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import lombok.Generated;
import org.datadog.jmxfetch.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTag {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicTag.class);
    private final String tagName;
    private final String beanName;
    private final String attributeName;

    public static DynamicTag parse(Object tagConfig) {
        if (tagConfig == null) {
            return null;
        }
        if (!(tagConfig instanceof Map)) {
            log.warn("Invalid dynamic tag config: expected map with 'tag_name', 'bean_name' and 'attribute' keys");
            return null;
        }
        Map config = (Map)tagConfig;
        Object tagNameObj = config.get("tag_name");
        Object beanObj = config.get("bean_name");
        Object attrObj = config.get("attribute");
        if (tagNameObj == null || beanObj == null || attrObj == null) {
            String missing = "Invalid dynamic tag config: missing" + (tagNameObj == null ? " tag_name" : "") + (beanObj == null ? " bean_name" : "") + (attrObj == null ? " attribute" : "");
            log.warn(missing);
            return null;
        }
        String tagName = tagNameObj.toString();
        String beanName = beanObj.toString();
        String attributeName = attrObj.toString();
        return new DynamicTag(tagName, beanName, attributeName);
    }

    private DynamicTag(String tagName, String beanName, String attributeName) {
        this.tagName = tagName;
        this.beanName = beanName;
        this.attributeName = attributeName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getBeanAttributeKey() {
        return this.beanName + "#" + this.attributeName;
    }

    public Map.Entry<String, String> resolve(Connection connection) {
        try {
            ObjectName objectName = new ObjectName(this.beanName);
            Object value = connection.getAttribute(objectName, this.attributeName);
            if (value == null) {
                log.warn("Dynamic tag '{}' resolved to null for bean '{}' attribute '{}'", new Object[]{this.tagName, this.beanName, this.attributeName});
                return null;
            }
            String stringValue = value.toString();
            log.info("Resolved dynamic tag '{}' to value '{}' from bean '{}' attribute '{}'", new Object[]{this.tagName, stringValue, this.beanName, this.attributeName});
            return new AbstractMap.SimpleEntry<String, String>(this.tagName, stringValue);
        }
        catch (MalformedObjectNameException e) {
            log.error("Invalid bean name '{}' for dynamic tag '{}': {}", new Object[]{this.beanName, this.tagName, e.getMessage()});
            return null;
        }
        catch (Exception e) {
            log.warn("Failed to resolve dynamic tag '{}' from bean '{}' attribute '{}': {}", new Object[]{this.tagName, this.beanName, this.attributeName, e.getMessage()});
            log.debug("Dynamic tag resolution error details", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return String.format("DynamicTag{name='%s', bean='%s', attribute='%s'}", this.tagName, this.beanName, this.attributeName);
    }
}

