/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import lombok.Generated;
import org.datadog.jmxfetch.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachApiConnection
extends Connection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachApiConnection.class);
    private static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private String processRegex;

    public AttachApiConnection(Map<String, Object> connectionParams) throws IOException {
        this.processRegex = (String)connectionParams.get("process_name_regex");
        this.env = new HashMap();
        this.address = this.getAddress(connectionParams);
        this.createConnection();
    }

    private JMXServiceURL getAddress(Map<String, Object> connectionParams) throws IOException {
        JMXServiceURL address;
        try {
            address = new JMXServiceURL(this.getJmxUrlForProcessRegex(this.processRegex));
        }
        catch (AttachNotSupportedException e) {
            throw new IOException("Unable to attach to process regex:  " + this.processRegex, e);
        }
        return address;
    }

    private String getJmxUrlForProcessRegex(String processRegex) throws AttachNotSupportedException, IOException {
        for (VirtualMachineDescriptor vmd : VirtualMachine.list()) {
            if (!vmd.displayName().matches(processRegex)) continue;
            VirtualMachine vm = VirtualMachine.attach(vmd);
            String connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            if (connectorAddress == null) {
                this.loadJmxAgent(vm);
                connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            }
            return connectorAddress;
        }
        throw new IOException("No match found. Available JVMs can be listed with the `list_jvms` command.");
    }

    private void loadJmxAgent(VirtualMachine vm) throws IOException {
        try {
            Method method = VirtualMachine.class.getMethod("startLocalManagementAgent", new Class[0]);
            log.info("Found startLocalManagementAgent API, attempting to use it.");
            method.invoke((Object)vm, new Object[0]);
        }
        catch (NoSuchMethodException noMethodE) {
            log.warn("startLocalManagementAgent method not found, must be on java 7", (Throwable)noMethodE);
            String agent = vm.getSystemProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "management-agent.jar";
            try {
                vm.loadAgent(agent);
            }
            catch (Exception e) {
                log.warn("Error initializing JMX agent from management-agent.jar", (Throwable)e);
            }
        }
        catch (Exception reflectionE) {
            log.warn("Error invoking the startLocalManagementAgent method", (Throwable)reflectionE);
        }
    }
}

