/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeeStatisticsAttributes {
    private static final List<String> COUNT_ATTRIBUTES = Collections.singletonList("count");
    private static final List<String> BOUNDARY_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("upperBound", "lowerBound"));
    private static final List<String> TIME_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("count", "minTime", "maxTime", "totalTime"));
    private static final List<String> RANGE_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("highWaterMark", "lowWaterMark", "current"));
    private static final List<String> BOUNDED_RANGE_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("upperBound", "lowerBound", "highWaterMark", "lowWaterMark", "current"));
    private static final Logger LOGGER = LoggerFactory.getLogger(JeeStatisticsAttributes.class);
    private static final WeakHashMap<ClassLoader, SoftReference<ReflectionHolder>> REFLECTION_CACHE = new WeakHashMap();

    private static ReflectionHolder getOrCreateReflectionHolder(ClassLoader classLoader) {
        SoftReference<ReflectionHolder> ref = REFLECTION_CACHE.get(classLoader);
        if (ref != null && ref.get() != null) {
            return ref.get();
        }
        ReflectionHolder holder = new ReflectionHolder(classLoader);
        REFLECTION_CACHE.put(classLoader, new SoftReference<ReflectionHolder>(holder));
        return holder;
    }

    public static List<String> attributesFor(Object instance) {
        ReflectionHolder rh = JeeStatisticsAttributes.getOrCreateReflectionHolder(instance.getClass().getClassLoader());
        if (rh.classCountStatistic != null && rh.classCountStatistic.isInstance(instance)) {
            return COUNT_ATTRIBUTES;
        }
        if (rh.classTimeStatistic != null && rh.classTimeStatistic.isInstance(instance)) {
            return TIME_ATTRIBUTES;
        }
        if (rh.classBoundedRangeStatistic != null && rh.classBoundedRangeStatistic.isInstance(instance)) {
            return BOUNDED_RANGE_ATTRIBUTES;
        }
        if (rh.classRangeStatistic != null && rh.classRangeStatistic.isInstance(instance)) {
            return RANGE_ATTRIBUTES;
        }
        if (rh.classBoundaryStatistic != null && rh.classBoundaryStatistic.isInstance(instance)) {
            return BOUNDARY_ATTRIBUTES;
        }
        return Collections.emptyList();
    }

    public static long dataFor(Object instance, String attribute) throws ReflectionException, AttributeNotFoundException {
        Class cls = null;
        ReflectionHolder rh = JeeStatisticsAttributes.getOrCreateReflectionHolder(instance.getClass().getClassLoader());
        if (rh.classCountStatistic != null && rh.classCountStatistic.isInstance(instance)) {
            cls = rh.classCountStatistic;
        } else if (rh.classTimeStatistic != null && rh.classTimeStatistic.isInstance(instance)) {
            cls = rh.classTimeStatistic;
        } else if (rh.classBoundedRangeStatistic != null && rh.classBoundedRangeStatistic.isInstance(instance)) {
            cls = rh.classBoundedRangeStatistic;
        } else if (rh.classRangeStatistic != null && rh.classRangeStatistic.isInstance(instance)) {
            cls = rh.classRangeStatistic;
        } else if (rh.classBoundaryStatistic != null && rh.classBoundaryStatistic.isInstance(instance)) {
            cls = rh.classBoundaryStatistic;
        }
        if (cls == null) {
            throw new AttributeNotFoundException("Not supported JSR-77 class: " + instance.getClass().getName());
        }
        MethodHandle methodHandle = (MethodHandle)((Map)rh.methodCache.get(cls)).get(attribute);
        if (methodHandle == null) {
            throw new AttributeNotFoundException("Unable to find getter for attribute " + attribute + " on class " + cls.getName());
        }
        try {
            return methodHandle.invoke(instance);
        }
        catch (Throwable t) {
            throw new ReflectionException(new Exception(t), "Unable to invoke getter for attribute" + attribute + " on class " + cls.getName());
        }
    }

    public static List<String> getStatisticNames(Object instance) {
        ReflectionHolder rh = JeeStatisticsAttributes.getOrCreateReflectionHolder(instance.getClass().getClassLoader());
        if (rh.mhStatGetStatisticNames == null || rh.mhStatGetStatistic == null) {
            return Collections.emptyList();
        }
        try {
            String[] names = rh.mhStatGetStatisticNames.invoke(instance);
            if (names != null) {
                ArrayList<String> ret = new ArrayList<String>();
                for (String name : names) {
                    Object stat = rh.mhStatGetStatistic.invoke(instance, name);
                    for (String attr : JeeStatisticsAttributes.attributesFor(stat)) {
                        ret.add(name + "." + attr);
                    }
                }
                return ret;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to get statistic names from jee stat class {}: {}", instance.getClass(), (Object)t.getMessage());
        }
        return Collections.emptyList();
    }

    public static long getStatisticDataFor(Object instance, String name) throws AttributeNotFoundException {
        ReflectionHolder rh = JeeStatisticsAttributes.getOrCreateReflectionHolder(instance.getClass().getClassLoader());
        if (rh.mhStatGetStatistic == null) {
            throw new IllegalStateException("Cannot fetch statistic data for instance type " + instance.getClass());
        }
        int idx = name.indexOf(".");
        if (idx == -1) {
            throw new AttributeNotFoundException("Invalid attribute name " + name);
        }
        String statName = name.substring(0, idx);
        String attrName = name.substring(idx + 1);
        try {
            Object stat = rh.mhStatGetStatistic.invoke(instance, statName);
            return JeeStatisticsAttributes.dataFor(stat, attrName);
        }
        catch (Throwable t) {
            throw new AttributeNotFoundException("Unable to get statistic with name " + name + "from jee stat class " + instance.getClass());
        }
    }

    public static boolean isJeeStat(Object instance) {
        ReflectionHolder rh = JeeStatisticsAttributes.getOrCreateReflectionHolder(instance.getClass().getClassLoader());
        return rh.classStat != null && rh.classStat.isInstance(instance);
    }

    public static boolean isJeeStatistic(Object instance) {
        ReflectionHolder rh = JeeStatisticsAttributes.getOrCreateReflectionHolder(instance.getClass().getClassLoader());
        return rh.classStatistic != null && rh.classStatistic.isInstance(instance);
    }

    private static class ReflectionHolder {
        public final Class<?> classStat;
        public final MethodHandle mhStatGetStatisticNames;
        public final MethodHandle mhStatGetStatistic;
        public final Class<?> classStatistic;
        private final Class<?> classCountStatistic;
        private final Class<?> classTimeStatistic;
        private final Class<?> classRangeStatistic;
        private final Class<?> classBoundaryStatistic;
        private final Class<?> classBoundedRangeStatistic;
        private final Map<Class<?>, Map<String, MethodHandle>> methodCache;

        ReflectionHolder(ClassLoader classLoader) {
            this.classStat = ReflectionHolder.maybeLookupClass("javax.management.j2ee.statistics.Stats", classLoader);
            if (this.classStat != null) {
                this.mhStatGetStatisticNames = ReflectionHolder.maybeFindMethodHandleFor(this.classStat, "getStatisticNames", new Class[0]);
                this.mhStatGetStatistic = ReflectionHolder.maybeFindMethodHandleFor(this.classStat, "getStatistic", String.class);
                this.classStatistic = ReflectionHolder.maybeLookupClass("javax.management.j2ee.statistics.Statistic", classLoader);
                this.classCountStatistic = ReflectionHolder.maybeLookupClass("javax.management.j2ee.statistics.CountStatistic", classLoader);
                this.classTimeStatistic = ReflectionHolder.maybeLookupClass("javax.management.j2ee.statistics.TimeStatistic", classLoader);
                this.classRangeStatistic = ReflectionHolder.maybeLookupClass("javax.management.j2ee.statistics.RangeStatistic", classLoader);
                this.classBoundaryStatistic = ReflectionHolder.maybeLookupClass("javax.management.j2ee.statistics.BoundaryStatistic", classLoader);
                this.classBoundedRangeStatistic = ReflectionHolder.maybeLookupClass("javax.management.j2ee.statistics.BoundedRangeStatistic", classLoader);
                this.methodCache = this.buildMethodCache();
            } else {
                this.mhStatGetStatisticNames = null;
                this.mhStatGetStatistic = null;
                this.classStatistic = null;
                this.classCountStatistic = null;
                this.classTimeStatistic = null;
                this.classRangeStatistic = null;
                this.classBoundaryStatistic = null;
                this.classBoundedRangeStatistic = null;
                this.methodCache = new WeakHashMap();
            }
        }

        private Map<Class<?>, Map<String, MethodHandle>> buildMethodCache() {
            HashMap map = new HashMap();
            if (this.classCountStatistic != null) {
                map.put(this.classCountStatistic, ReflectionHolder.buildMethodCacheFor(this.classCountStatistic, COUNT_ATTRIBUTES));
            }
            if (this.classTimeStatistic != null) {
                map.put(this.classTimeStatistic, ReflectionHolder.buildMethodCacheFor(this.classTimeStatistic, TIME_ATTRIBUTES));
            }
            if (this.classBoundaryStatistic != null) {
                map.put(this.classBoundaryStatistic, ReflectionHolder.buildMethodCacheFor(this.classBoundaryStatistic, BOUNDARY_ATTRIBUTES));
            }
            if (this.classRangeStatistic != null) {
                map.put(this.classRangeStatistic, ReflectionHolder.buildMethodCacheFor(this.classRangeStatistic, RANGE_ATTRIBUTES));
            }
            if (this.classBoundedRangeStatistic != null) {
                map.put(this.classBoundedRangeStatistic, ReflectionHolder.buildMethodCacheFor(this.classBoundedRangeStatistic, BOUNDED_RANGE_ATTRIBUTES));
            }
            return map;
        }

        private static MethodHandle maybeFindMethodHandleFor(final Class<?> cls, final String name, final Class<?> ... parameterTypes) {
            if (cls == null) {
                return null;
            }
            return AccessController.doPrivileged(new PrivilegedAction<MethodHandle>(){

                @Override
                public MethodHandle run() {
                    try {
                        return MethodHandles.lookup().unreflect(cls.getMethod(name, parameterTypes));
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unable to find method {} for class {}: {}", new Object[]{name, cls, t.getMessage()});
                        return null;
                    }
                }
            });
        }

        private static Map<String, MethodHandle> buildMethodCacheFor(Class<?> cls, List<String> attributes) {
            HashMap<String, MethodHandle> map = new HashMap<String, MethodHandle>();
            for (String attribute : attributes) {
                MethodHandle methodHandle = ReflectionHolder.maybeFindMethodHandleFor(cls, ReflectionHolder.getterMethodName(attribute), new Class[0]);
                if (methodHandle == null) continue;
                map.put(attribute, methodHandle);
            }
            return map;
        }

        private static Class<?> maybeLookupClass(String name, ClassLoader classLoader) {
            try {
                return Class.forName(name, false, classLoader);
            }
            catch (Throwable t) {
                LOGGER.debug("Class {} is unavailable for classloader {}. JEE statistics won't be extracted", (Object)name, (Object)classLoader);
                return null;
            }
        }

        private static String getterMethodName(String attribute) {
            return "get" + attribute.substring(0, 1).toUpperCase(Locale.ROOT) + attribute.substring(1);
        }
    }
}

