/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.ServiceCheck;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JmxAttribute;
import org.datadog.jmxfetch.reporter.LoggingErrorHandler;
import org.datadog.jmxfetch.reporter.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsdReporter
extends Reporter {
    private static final Logger log = LoggerFactory.getLogger(StatsdReporter.class);
    private StatsDClient statsDClient;
    private String statsdHost;
    private int statsdPort;
    private Boolean telemetry;
    private int queueSize;
    private boolean nonBlocking;
    private int socketBufferSize;
    private int socketTimeout;

    public StatsdReporter(String statsdHost, int statsdPort, boolean telemetry, int queueSize, boolean nonBlocking, int socketBufferSize, int socketTimeout) {
        this.statsdHost = statsdHost;
        this.statsdPort = statsdPort;
        this.telemetry = telemetry;
        this.queueSize = queueSize;
        this.nonBlocking = nonBlocking;
        this.socketBufferSize = socketBufferSize;
        this.socketTimeout = socketTimeout;
        this.init();
    }

    private void init() {
        String entityId = this.statsdPort == 0 ? "none" : null;
        int defaultUdsDatagramSize = 8192;
        this.handler = new LoggingErrorHandler();
        NonBlockingStatsDClientBuilder builder = new NonBlockingStatsDClientBuilder().hostname(this.statsdHost).port(this.statsdPort).enableTelemetry(this.telemetry.booleanValue()).queueSize(this.queueSize).blocking(!this.nonBlocking).errorHandler((StatsDClientErrorHandler)this.handler).entityID(entityId);
        String extraInitLog = "";
        if (this.statsdPort == 0) {
            int packetSize = defaultUdsDatagramSize;
            if (this.socketBufferSize != 0 && this.socketBufferSize < packetSize) {
                packetSize = this.socketBufferSize;
            }
            extraInitLog = extraInitLog + "maxPacketSize=" + packetSize;
            builder.maxPacketSizeBytes(packetSize);
            builder.constantTags(new String[]{"dd.internal.card:none"});
        }
        if (this.socketBufferSize != 0) {
            extraInitLog = extraInitLog + " socketBufferSize=" + this.socketBufferSize;
            builder.socketBufferSize(this.socketBufferSize);
        }
        if (this.socketTimeout != 0) {
            extraInitLog = extraInitLog + " socketTimeout=" + this.socketTimeout;
            builder.timeout(this.socketTimeout);
        }
        log.info("Initializing Statsd reporter with parameters host={} port={} telemetry={} queueSize={} entityId={} blocking={} {}", new Object[]{this.statsdHost, this.statsdPort, this.telemetry, this.queueSize, entityId, !this.nonBlocking, extraInitLog});
        this.statsDClient = builder.build();
    }

    @Override
    protected void sendMetricPoint(String metricType, String metricName, double value, String[] tags) {
        if (metricType.equals("monotonic_count")) {
            this.statsDClient.count(metricName, (long)value, tags);
        } else if (metricType.equals("histogram")) {
            this.statsDClient.histogram(metricName, value, tags);
        } else {
            this.statsDClient.gauge(metricName, value, tags);
        }
    }

    @Override
    public void doSendServiceCheck(String serviceCheckName, String status, String message, String[] tags) {
        ServiceCheck sc = ServiceCheck.builder().withName(serviceCheckName).withStatus(this.statusToServiceCheckStatus(status)).withMessage(message).withTags(tags).build();
        this.statsDClient.serviceCheck(sc);
    }

    @Override
    public void displayMetricReached() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayMatchingAttributeName(JmxAttribute jmxAttribute, int rank, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayNonMatchingAttributeName(JmxAttribute jmxAttribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayInstanceName(Instance instance) {
        throw new UnsupportedOperationException();
    }

    public String getStatsdHost() {
        return this.statsdHost;
    }

    public int getStatsdPort() {
        return this.statsdPort;
    }

    public boolean getTelemetry() {
        return this.telemetry;
    }

    public int getQueueSize() {
        return this.queueSize;
    }
}

