/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.Filter;
import org.datadog.jmxfetch.JmxSubAttribute;
import org.datadog.jmxfetch.Metric;
import org.datadog.jmxfetch.service.ServiceNameProvider;
import org.datadog.jmxfetch.util.JeeStatisticsAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxComplexAttribute
extends JmxSubAttribute {
    private static final Logger log = LoggerFactory.getLogger(JmxComplexAttribute.class);
    private static final List<String> COMPOSED_TYPES = Arrays.asList("javax.management.openmbean.CompositeData", "javax.management.openmbean.CompositeDataSupport", "javax.management.j2ee.statistics.Statistic", "javax.management.j2ee.statistics.Stats", "java.util.HashMap", "java.util.Map");
    private List<String> subAttributeList = new ArrayList<String>();

    public JmxComplexAttribute(MBeanAttributeInfo attribute, ObjectName beanName, String className, String instanceName, String checkName, Connection connection, ServiceNameProvider serviceNameProvider, Map<String, String> instanceTags, boolean emptyDefaultHostname, boolean normalizeBeanParamTags) {
        super(attribute, beanName, className, instanceName, checkName, connection, serviceNameProvider, instanceTags, false, emptyDefaultHostname, normalizeBeanParamTags);
    }

    private void populateSubAttributeList(Object attributeValue) {
        if (attributeValue instanceof CompositeData) {
            CompositeData data = (CompositeData)attributeValue;
            for (String key : data.getCompositeType().keySet()) {
                this.subAttributeList.add(key);
            }
        } else if (attributeValue instanceof Map) {
            Map data = (Map)attributeValue;
            for (String key : data.keySet()) {
                this.subAttributeList.add(key);
            }
        } else if (JeeStatisticsAttributes.isJeeStatistic(attributeValue)) {
            this.subAttributeList.addAll(JeeStatisticsAttributes.attributesFor(attributeValue));
        } else if (JeeStatisticsAttributes.isJeeStat(attributeValue)) {
            this.subAttributeList.addAll(JeeStatisticsAttributes.getStatisticNames(attributeValue));
        }
    }

    @Override
    public List<Metric> getMetrics() throws AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        ArrayList<Metric> metrics = new ArrayList<Metric>(this.subAttributeList.size());
        for (String subAttribute : this.subAttributeList) {
            Metric metric = this.getCachedMetric(subAttribute);
            double value = this.castToDouble(this.getValue(subAttribute), subAttribute);
            metric.setValue(value);
            metrics.add(metric);
        }
        return metrics;
    }

    private Object getValue(String subAttribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object value = this.getJmxValue();
        if (value instanceof CompositeData) {
            CompositeData data = (CompositeData)value;
            return data.get(subAttribute);
        }
        if (value instanceof Map) {
            Map data = (Map)value;
            return data.get(subAttribute);
        }
        if (JeeStatisticsAttributes.isJeeStatistic(value)) {
            return JeeStatisticsAttributes.dataFor(value, subAttribute);
        }
        if (JeeStatisticsAttributes.isJeeStat(value)) {
            return JeeStatisticsAttributes.getStatisticDataFor(value, subAttribute);
        }
        throw new NumberFormatException();
    }

    public static boolean matchAttributeType(String attributeType) {
        return COMPOSED_TYPES.contains(attributeType);
    }

    @Override
    public boolean match(Configuration configuration) {
        if (!this.matchDomain(configuration) || !this.matchClassName(configuration) || !this.matchBean(configuration) || this.excludeMatchDomain(configuration) || this.excludeMatchClassName(configuration) || this.excludeMatchBean(configuration)) {
            return false;
        }
        try {
            this.populateSubAttributeList(this.getJmxValue());
        }
        catch (Exception e) {
            return false;
        }
        return this.matchAttribute(configuration) && !this.excludeMatchAttribute(configuration);
    }

    private boolean matchSubAttribute(Filter params, String subAttributeName, boolean matchOnEmpty) {
        if (params.getAttribute() instanceof Map && ((Map)params.getAttribute()).containsKey(subAttributeName)) {
            return true;
        }
        if (params.getAttribute() instanceof List && ((List)params.getAttribute()).contains(subAttributeName)) {
            return true;
        }
        if (params.getAttribute() == null) {
            return matchOnEmpty;
        }
        return false;
    }

    private boolean matchAttribute(Configuration configuration) {
        if (this.matchSubAttribute(configuration.getInclude(), this.getAttributeName(), true)) {
            return true;
        }
        Iterator<String> it = this.subAttributeList.iterator();
        while (it.hasNext()) {
            String subAttribute = it.next();
            if (this.matchSubAttribute(configuration.getInclude(), this.getAttributeName() + "." + subAttribute, true)) continue;
            it.remove();
        }
        return this.subAttributeList.size() > 0;
    }

    private boolean excludeMatchAttribute(Configuration configuration) {
        Filter exclude = configuration.getExclude();
        if (exclude.getAttribute() != null && this.matchSubAttribute(exclude, this.getAttributeName(), false)) {
            return true;
        }
        Iterator<String> it = this.subAttributeList.iterator();
        while (it.hasNext()) {
            String subAttribute = it.next();
            if (!this.matchSubAttribute(exclude, this.getAttributeName() + "." + subAttribute, false)) continue;
            it.remove();
        }
        return this.subAttributeList.size() <= 0;
    }
}

