/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.security.auth.login.FailedLoginException;
import org.datadog.jmxfetch.AppConfig;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.JmxAttribute;
import org.datadog.jmxfetch.JmxComplexAttribute;
import org.datadog.jmxfetch.JmxSimpleAttribute;
import org.datadog.jmxfetch.JmxTabularAttribute;
import org.datadog.jmxfetch.Metric;
import org.datadog.jmxfetch.reporter.Reporter;
import org.datadog.jmxfetch.service.ConfigServiceNameProvider;
import org.datadog.jmxfetch.service.ServiceNameProvider;
import org.datadog.jmxfetch.util.InstanceTelemetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Instance {
    private static final Logger log = LoggerFactory.getLogger(Instance.class);
    private static final int MAX_RETURNED_METRICS = 350;
    private static final int DEFAULT_REFRESH_BEANS_PERIOD = 600;
    public static final String PROCESS_NAME_REGEX = "process_name_regex";
    public static final String JVM_DIRECT = "jvm_direct";
    public static final String ATTRIBUTE = "Attribute: ";
    private static final ThreadLocal<Yaml> YAML = new ThreadLocal<Yaml>(){

        @Override
        public Yaml initialValue() {
            return new Yaml();
        }
    };
    private Set<ObjectName> beans;
    private List<String> beanScopes;
    private List<Configuration> configurationList = new ArrayList<Configuration>();
    private List<JmxAttribute> matchingAttributes;
    private HashSet<JmxAttribute> failingAttributes;
    private Integer initialRefreshBeansPeriod;
    private Integer refreshBeansPeriod;
    private long lastCollectionTime;
    private Integer minCollectionPeriod;
    private long initialRefreshTime;
    private long lastRefreshTime;
    private Map<String, Object> instanceMap;
    private Map<String, Object> initConfig;
    private String instanceName;
    private ServiceNameProvider serviceNameProvider;
    private Map<String, String> tags;
    private String checkName;
    private String serviceCheckPrefix;
    private int maxReturnedMetrics;
    private boolean limitReached;
    private Connection connection;
    private AppConfig appConfig;
    private Boolean cassandraAliasing;
    private boolean emptyDefaultHostname;
    private InstanceTelemetry instanceTelemetryBean;
    private ObjectName instanceTelemetryBeanName;
    private MBeanServer mbs;
    private Boolean normalizeBeanParamTags;

    public Instance(Instance instance, AppConfig appConfig) {
        this(instance.getInstanceMap() != null ? new HashMap<String, Object>(instance.getInstanceMap()) : null, instance.getInitConfig() != null ? new HashMap<String, Object>(instance.getInitConfig()) : null, instance.getCheckName(), appConfig, instance.serviceNameProvider);
    }

    public Instance(Map<String, Object> instanceMap, Map<String, Object> initConfig, String checkName, AppConfig appConfig, ServiceNameProvider serviceNameProvider) {
        Boolean collectDefaultJvmMetrics;
        Boolean newGcMetrics;
        Object instanceConf;
        Object emptyDefaultHostnameObj;
        this.appConfig = appConfig;
        this.instanceMap = instanceMap != null ? new HashMap<String, Object>(instanceMap) : null;
        this.initConfig = initConfig != null ? new HashMap<String, Object>(initConfig) : null;
        this.instanceName = (String)instanceMap.get("name");
        this.tags = Instance.getTagsMap(instanceMap.get("tags"), appConfig);
        this.checkName = checkName;
        this.matchingAttributes = new ArrayList<JmxAttribute>();
        this.failingAttributes = new HashSet();
        if (appConfig.getRefreshBeansPeriod() == null) {
            this.refreshBeansPeriod = (Integer)instanceMap.get("refresh_beans");
            if (this.refreshBeansPeriod == null) {
                this.refreshBeansPeriod = 600;
            }
        } else {
            this.refreshBeansPeriod = appConfig.getRefreshBeansPeriod();
        }
        if (appConfig.getInitialRefreshBeansPeriod() == null) {
            this.initialRefreshBeansPeriod = (Integer)instanceMap.get("refresh_beans_initial");
            if (this.initialRefreshBeansPeriod == null) {
                this.initialRefreshBeansPeriod = this.refreshBeansPeriod;
            }
        } else {
            this.initialRefreshBeansPeriod = appConfig.getInitialRefreshBeansPeriod();
        }
        if (this.initialRefreshBeansPeriod > this.refreshBeansPeriod) {
            this.initialRefreshBeansPeriod = this.refreshBeansPeriod;
        }
        this.serviceNameProvider = new ConfigServiceNameProvider(instanceMap, initConfig, appConfig.getServiceNameProvider());
        this.minCollectionPeriod = (Integer)instanceMap.get("min_collection_interval");
        if (this.minCollectionPeriod == null && initConfig != null) {
            this.minCollectionPeriod = (Integer)initConfig.get("min_collection_interval");
        }
        this.emptyDefaultHostname = (emptyDefaultHostnameObj = this.instanceMap.get("empty_default_hostname")) != null ? (Boolean)emptyDefaultHostnameObj : false;
        this.lastCollectionTime = 0L;
        this.initialRefreshTime = 0L;
        this.lastRefreshTime = 0L;
        this.limitReached = false;
        Object maxReturnedMetrics = this.instanceMap.get("max_returned_metrics");
        this.maxReturnedMetrics = maxReturnedMetrics == null ? 350 : (Integer)maxReturnedMetrics;
        if (this.instanceName == null) {
            if (this.instanceMap.get(PROCESS_NAME_REGEX) != null) {
                this.instanceName = this.checkName + "-" + this.instanceMap.get(PROCESS_NAME_REGEX);
            } else if (this.instanceMap.get("host") != null) {
                this.instanceName = this.checkName + "-" + this.instanceMap.get("host") + "-" + this.instanceMap.get("port");
            } else {
                log.warn("Cannot determine a unique instance name. Please define a name in your instance configuration");
                this.instanceName = this.checkName;
            }
        }
        if (initConfig != null) {
            this.serviceCheckPrefix = (String)initConfig.get("service_check_prefix");
        }
        this.normalizeBeanParamTags = (Boolean)instanceMap.get("normalize_bean_param_tags");
        if (this.normalizeBeanParamTags == null) {
            this.normalizeBeanParamTags = false;
        }
        this.cassandraAliasing = (Boolean)instanceMap.get("cassandra_aliasing");
        if (this.cassandraAliasing == null) {
            this.cassandraAliasing = this.checkName.startsWith("cassandra") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((instanceConf = this.instanceMap.get("conf")) == null && this.initConfig != null) {
            instanceConf = this.initConfig.get("conf");
        }
        if (instanceConf == null) {
            log.warn("Cannot find a \"conf\" section in " + this.instanceName);
        } else {
            for (Map conf : (List)instanceConf) {
                this.configurationList.add(new Configuration(conf));
            }
        }
        Instance.loadMetricConfigFiles(appConfig, this.configurationList);
        Instance.loadMetricConfigResources(appConfig, this.configurationList);
        String gcMetricConfig = "old-gc-default-jmx-metrics.yaml";
        if (this.initConfig != null && (newGcMetrics = (Boolean)this.initConfig.get("new_gc_metrics")) != null && newGcMetrics.booleanValue()) {
            gcMetricConfig = "new-gc-default-jmx-metrics.yaml";
        }
        if ((collectDefaultJvmMetrics = (Boolean)instanceMap.get("collect_default_jvm_metrics")) == null || collectDefaultJvmMetrics.booleanValue()) {
            this.loadDefaultConfig("default-jmx-metrics.yaml");
            this.loadDefaultConfig(gcMetricConfig);
        } else {
            log.info("collect_default_jvm_metrics is false - not collecting default JVM metrics");
        }
        this.instanceTelemetryBean = new InstanceTelemetry();
        if (appConfig.getJmxfetchTelemetry()) {
            this.registerTelemetryBean(this.instanceTelemetryBean);
        }
    }

    private ObjectName getObjName(String domain, String instance) throws MalformedObjectNameException {
        return new ObjectName(domain + ":target_instance=" + ObjectName.quote(instance));
    }

    private InstanceTelemetry registerTelemetryBean(InstanceTelemetry bean) {
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        log.debug("Created jmx bean for instance: {}", (Object)this.getCheckName());
        try {
            this.instanceTelemetryBeanName = this.getObjName(this.appConfig.getJmxfetchTelemetryDomain(), this.getName());
        }
        catch (MalformedObjectNameException e) {
            log.warn("Could not construct bean name for jmxfetch_telemetry_domain '{}' and name '{}'", (Object)this.appConfig.getJmxfetchTelemetryDomain(), (Object)this.getName());
            return bean;
        }
        try {
            this.mbs.registerMBean(bean, this.instanceTelemetryBeanName);
            log.debug("Succesfully registered jmx bean for instance {} with ObjectName = {}", (Object)this.getName(), (Object)this.instanceTelemetryBeanName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            log.warn("Could not register bean named '{}' for instance: ", (Object)this.instanceTelemetryBeanName.toString(), (Object)e);
        }
        return bean;
    }

    public static boolean isDirectInstance(Map<String, Object> configInstance) {
        Object directInstance = configInstance.get(JVM_DIRECT);
        return directInstance instanceof Boolean && (Boolean)directInstance != false;
    }

    private void loadDefaultConfig(String configResourcePath) {
        List defaultConf = (List)YAML.get().load(this.getClass().getResourceAsStream(configResourcePath));
        for (Map conf : defaultConf) {
            this.configurationList.add(new Configuration(conf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadMetricConfigFiles(AppConfig appConfig, List<Configuration> configurationList) {
        List<String> metricConfigFiles = appConfig.getMetricConfigFiles();
        if (metricConfigFiles != null && !metricConfigFiles.isEmpty()) {
            log.warn("Loading files via metricConfigFiles setting is deprecated.  Please migrate to using standard agent config files in the conf.d directory.");
            for (String fileName : metricConfigFiles) {
                String yamlPath = new File(fileName).getAbsolutePath();
                FileInputStream yamlInputStream = null;
                log.info("Reading metric config file " + yamlPath);
                try {
                    yamlInputStream = new FileInputStream(yamlPath);
                    List confs = (List)YAML.get().load((InputStream)yamlInputStream);
                    for (Map conf : confs) {
                        configurationList.add(new Configuration(conf));
                    }
                }
                catch (FileNotFoundException e) {
                    log.warn("Cannot find metric config file " + yamlPath);
                }
                catch (Exception e) {
                    log.warn("Cannot parse yaml file " + yamlPath, (Throwable)e);
                }
                finally {
                    if (yamlInputStream == null) continue;
                    try {
                        yamlInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadMetricConfigResources(AppConfig config, List<Configuration> configurationList) {
        List<String> resourceConfigList = config.getMetricConfigResources();
        if (resourceConfigList != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String resourceName : resourceConfigList) {
                log.info("Reading metric config resource " + resourceName);
                InputStream inputStream = classLoader.getResourceAsStream(resourceName);
                if (inputStream == null) {
                    log.warn("Cannot find metric config resource" + resourceName);
                    continue;
                }
                try {
                    Map topYaml = (Map)YAML.get().load(inputStream);
                    List jmxConf = (List)topYaml.get("jmx_metrics");
                    if (jmxConf != null) {
                        for (Map conf : jmxConf) {
                            configurationList.add(new Configuration(conf));
                        }
                        continue;
                    }
                    log.warn("jmx_metrics block not found in resource " + resourceName);
                }
                catch (Exception e) {
                    log.warn("Cannot parse yaml resource " + resourceName, (Throwable)e);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static Map<String, String> getTagsMap(Object tagsMap, AppConfig appConfig) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (appConfig.getGlobalTags() != null) {
            tags.putAll(appConfig.getGlobalTags());
        }
        if (tagsMap != null) {
            if (tagsMap instanceof Map) {
                tags.putAll((Map)tagsMap);
            } else if (tagsMap instanceof List) {
                for (String tag : (List)tagsMap) {
                    tags.put(tag, null);
                }
            } else {
                log.warn("Unsupported type for tagsMap: " + tagsMap.getClass().getCanonicalName());
            }
        }
        return tags;
    }

    public boolean getCanonicalRateConfig() {
        Object canonical = null;
        if (this.initConfig != null) {
            canonical = this.initConfig.get("canonical_rate");
        }
        if (canonical == null) {
            return false;
        }
        if (canonical instanceof Boolean) {
            return (Boolean)canonical;
        }
        return false;
    }

    public Connection getConnection(Map<String, Object> connectionParams, boolean forceNewConnection) throws IOException {
        if (this.connection == null || !this.connection.isAlive()) {
            log.info("Connection closed or does not exist. Attempting to create a new connection...");
            return this.appConfig.getConnectionFactory().createConnection(connectionParams);
        }
        if (forceNewConnection) {
            log.info("Forcing a new connection, attempting to create...");
            this.connection.closeConnector();
            return this.appConfig.getConnectionFactory().createConnection(connectionParams);
        }
        return this.connection;
    }

    public void init(boolean forceNewConnection) throws IOException, FailedLoginException, SecurityException {
        log.info("Trying to connect to JMX Server at " + this.toString());
        this.connection = this.getConnection(this.instanceMap, forceNewConnection);
        log.info("Trying to collect bean list for the first time for JMX Server at {}", (Object)this);
        this.refreshBeansList();
        this.initialRefreshTime = this.lastRefreshTime;
        log.info("Connected to JMX Server at {} with {} beans", (Object)this, (Object)this.beans.size());
        this.getMatchingAttributes();
        log.info("Done initializing JMX Server at {}", (Object)this);
    }

    public String toString() {
        if (Instance.isDirectInstance(this.instanceMap)) {
            if (this.instanceMap.get("name") != null) {
                return "jvm_direct - name: `" + (String)this.instanceMap.get("name") + "`";
            }
            return JVM_DIRECT;
        }
        if (this.instanceMap.get(PROCESS_NAME_REGEX) != null) {
            return "process_regex: `" + this.instanceMap.get(PROCESS_NAME_REGEX) + "`";
        }
        if (this.instanceMap.get("name") != null) {
            return (String)this.instanceMap.get("name");
        }
        if (this.instanceMap.get("jmx_url") != null) {
            return (String)this.instanceMap.get("jmx_url");
        }
        return this.instanceMap.get("host") + ":" + this.instanceMap.get("port");
    }

    public List<Metric> getMetrics() throws IOException {
        Integer period;
        Integer n = period = this.initialRefreshTime == this.lastRefreshTime ? this.initialRefreshBeansPeriod : this.refreshBeansPeriod;
        if (this.isPeriodDue(this.lastRefreshTime, period)) {
            log.info("Refreshing bean list for " + this.getCheckName());
            this.refreshBeansList();
            this.getMatchingAttributes();
        }
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        Iterator<JmxAttribute> it = this.matchingAttributes.iterator();
        this.lastCollectionTime = System.currentTimeMillis();
        while (it.hasNext()) {
            JmxAttribute jmxAttr = it.next();
            try {
                List<Metric> jmxAttrMetrics = jmxAttr.getMetrics();
                metrics.addAll(jmxAttrMetrics);
                this.failingAttributes.remove(jmxAttr);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                log.debug("Cannot get metrics for attribute: " + jmxAttr, (Throwable)e);
                if (this.failingAttributes.contains(jmxAttr)) {
                    log.debug("Cannot generate metrics for attribute: " + jmxAttr + " twice in a row. Removing it from the attribute list");
                    it.remove();
                    continue;
                }
                this.failingAttributes.add(jmxAttr);
            }
        }
        if (this.instanceTelemetryBean != null) {
            this.instanceTelemetryBean.setBeansFetched(this.beans.size());
            this.instanceTelemetryBean.setTopLevelAttributeCount(this.matchingAttributes.size());
            this.instanceTelemetryBean.setMetricCount(metrics.size());
            log.debug("Updated jmx bean for instance: " + this.getCheckName() + " With beans fetched = " + this.instanceTelemetryBean.getBeansFetched() + " top attributes = " + this.instanceTelemetryBean.getTopLevelAttributeCount() + " metrics = " + this.instanceTelemetryBean.getMetricCount() + " wildcard domain query count = " + this.instanceTelemetryBean.getWildcardDomainQueryCount() + " bean match ratio = " + this.instanceTelemetryBean.getBeanMatchRatio());
        }
        return metrics;
    }

    public boolean isPeriodDue(long refTime, Integer refPeriod) {
        return (System.currentTimeMillis() - refTime) / 1000L >= (long)refPeriod.intValue();
    }

    public boolean timeToCollect() {
        if (this.minCollectionPeriod == null) {
            return true;
        }
        return this.isPeriodDue(this.lastCollectionTime, this.minCollectionPeriod);
    }

    private void getMatchingAttributes() throws IOException {
        this.limitReached = false;
        Reporter reporter = this.appConfig.getReporter();
        String action = this.appConfig.getAction();
        boolean metricReachedDisplayed = false;
        this.matchingAttributes.clear();
        this.failingAttributes.clear();
        int metricsCount = 0;
        int beansWithAttributeMatch = 0;
        if (!action.equals("collect")) {
            reporter.displayInstanceName(this);
        }
        for (ObjectName beanName : this.beans) {
            MBeanAttributeInfo[] attributeInfos;
            String className;
            boolean attributeMatched = false;
            if (this.limitReached) {
                log.debug("Limit reached");
                if (action.equals("collect")) break;
            }
            try {
                log.debug("Getting bean info for bean: {}", (Object)beanName);
                MBeanInfo info = this.connection.getMBeanInfo(beanName);
                log.debug("Getting class name for bean: {}", (Object)beanName);
                className = info.getClassName();
                log.debug("Getting attributes for bean: {}", (Object)beanName);
                attributeInfos = info.getAttributes();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                log.warn("Cannot get attributes or class name for bean {}: ", (Object)beanName, (Object)e);
                continue;
            }
            for (MBeanAttributeInfo attributeInfo : attributeInfos) {
                JmxAttribute jmxAttribute;
                String attributeType;
                if (metricsCount >= this.maxReturnedMetrics) {
                    this.limitReached = true;
                    if (action.equals("collect")) {
                        log.warn("Maximum number of metrics reached.");
                        break;
                    }
                    if (!(metricReachedDisplayed || action.equals("list_collected_attributes") || action.equals("list_not_matching_attributes"))) {
                        reporter.displayMetricReached();
                        metricReachedDisplayed = true;
                    }
                }
                if (JmxSimpleAttribute.matchAttributeType(attributeType = attributeInfo.getType())) {
                    log.debug(ATTRIBUTE + beanName + " : " + attributeInfo + " has attributeInfo simple type");
                    jmxAttribute = new JmxSimpleAttribute(attributeInfo, beanName, className, this.instanceName, this.checkName, this.connection, this.serviceNameProvider, this.tags, (boolean)this.cassandraAliasing, (Boolean)this.emptyDefaultHostname, this.normalizeBeanParamTags);
                } else if (JmxComplexAttribute.matchAttributeType(attributeType)) {
                    log.debug(ATTRIBUTE + beanName + " : " + attributeInfo + " has attributeInfo composite type");
                    jmxAttribute = new JmxComplexAttribute(attributeInfo, beanName, className, this.instanceName, this.checkName, this.connection, this.serviceNameProvider, this.tags, this.emptyDefaultHostname, this.normalizeBeanParamTags);
                } else if (JmxTabularAttribute.matchAttributeType(attributeType)) {
                    log.debug(ATTRIBUTE + beanName + " : " + attributeInfo + " has attributeInfo tabular type");
                    jmxAttribute = new JmxTabularAttribute(attributeInfo, beanName, className, this.instanceName, this.checkName, this.connection, this.serviceNameProvider, this.tags, this.emptyDefaultHostname, this.normalizeBeanParamTags);
                } else {
                    try {
                        log.debug(ATTRIBUTE + beanName + " : " + attributeInfo + " has an unsupported type: " + attributeType);
                    }
                    catch (NullPointerException e) {
                        log.warn("Caught unexpected NullPointerException");
                    }
                    continue;
                }
                for (Configuration conf : this.configurationList) {
                    try {
                        if (!jmxAttribute.match(conf)) continue;
                        jmxAttribute.setMatchingConf(conf);
                        metricsCount += jmxAttribute.getMetricsCount();
                        this.matchingAttributes.add(jmxAttribute);
                        if (!action.equals("list_everything") && !action.equals("list_matching_attributes") && (!action.equals("list_collected_attributes") || this.limitReached) && (!action.equals("list_limited_attributes") || !this.limitReached)) break;
                        reporter.displayMatchingAttributeName(jmxAttribute, metricsCount, this.maxReturnedMetrics);
                        break;
                    }
                    catch (Exception e) {
                        log.error("Error while trying to match attributeInfo configuration with the Attribute: " + beanName + " : " + attributeInfo, (Throwable)e);
                    }
                }
                if (jmxAttribute.getMatchingConf() == null && (action.equals("list_everything") || action.equals("list_not_matching_attributes"))) {
                    reporter.displayNonMatchingAttributeName(jmxAttribute);
                }
                if (jmxAttribute.getMatchingConf() == null) continue;
                attributeMatched = true;
            }
            if (!attributeMatched) continue;
            ++beansWithAttributeMatch;
        }
        if (this.instanceTelemetryBean != null) {
            this.instanceTelemetryBean.setBeanMatchRatio((double)beansWithAttributeMatch / (double)this.beans.size());
        }
        log.info("Found {} matching attributes", (Object)this.matchingAttributes.size());
    }

    public List<String> getBeansScopes() {
        if (this.beanScopes == null) {
            this.beanScopes = Configuration.getGreatestCommonScopes(this.configurationList);
        }
        return this.beanScopes;
    }

    private void refreshBeansList() throws IOException {
        boolean limitQueryScopes;
        this.beans = new HashSet<ObjectName>();
        String action = this.appConfig.getAction();
        boolean bl = limitQueryScopes = !action.equals("list_everything") && !action.equals("list_not_matching_attributes");
        if (limitQueryScopes) {
            try {
                List<String> beanScopes = this.getBeansScopes();
                for (String scope : beanScopes) {
                    ObjectName name = new ObjectName(scope);
                    this.beans.addAll(this.connection.queryNames(name));
                }
            }
            catch (MalformedObjectNameException e) {
                log.error("Unable to create ObjectName", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Unable to query mbean server", (Throwable)e);
            }
        }
        if (this.beans.isEmpty()) {
            this.beans = this.connection.queryNames(null);
            if (this.instanceTelemetryBean != null) {
                int wildcardQueryCount = this.instanceTelemetryBean.getWildcardDomainQueryCount();
                this.instanceTelemetryBean.setWildcardDomainQueryCount(wildcardQueryCount + 1);
            }
        }
        this.lastRefreshTime = System.currentTimeMillis();
    }

    public String[] getServiceCheckTags() {
        Iterable<String> services;
        ArrayList<String> tags = new ArrayList<String>();
        if (this.instanceMap.get("host") != null) {
            tags.add("jmx_server:" + this.instanceMap.get("host"));
        }
        if (this.tags != null) {
            for (Map.Entry<String, String> e : this.tags.entrySet()) {
                if (e.getValue() != null) {
                    tags.add(e.getKey() + ":" + e.getValue());
                    continue;
                }
                tags.add(e.getKey());
            }
        }
        if ((services = this.serviceNameProvider.getServiceNames()) != null) {
            for (String service : services) {
                tags.add("service:" + service);
            }
        }
        tags.add("instance:" + this.instanceName);
        if (this.emptyDefaultHostname) {
            tags.add("host:");
        }
        return tags.toArray(new String[tags.size()]);
    }

    public String getName() {
        return this.instanceName;
    }

    Map<String, Object> getInstanceMap() {
        return this.instanceMap;
    }

    Map<String, Object> getInitConfig() {
        return this.initConfig;
    }

    public String getCheckName() {
        return this.checkName;
    }

    public String getServiceCheckPrefix() {
        return this.serviceCheckPrefix;
    }

    public int getMaxNumberOfMetrics() {
        return this.maxReturnedMetrics;
    }

    public InstanceTelemetry getInstanceTelemetryBean() {
        return this.instanceTelemetryBean;
    }

    public boolean isLimitReached() {
        return this.limitReached;
    }

    private void cleanupTelemetryBean() {
        if (!this.appConfig.getJmxfetchTelemetry()) {
            return;
        }
        try {
            this.mbs.unregisterMBean(this.instanceTelemetryBeanName);
            log.debug("Successfully unregistered bean for instance: {}", (Object)this.getCheckName());
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            log.debug("Unable to unregister bean for instance: {}", (Object)this.getCheckName());
        }
    }

    public void cleanUp() {
        this.cleanupTelemetryBean();
        if (this.connection != null) {
            this.connection.closeConnector();
            this.connection = null;
        }
    }

    public synchronized void cleanUpAsync() {
        this.cleanupTelemetryBean();
        if (this.connection != null) {
            class AsyncCleaner
            implements Runnable {
                Connection conn;

                AsyncCleaner(Connection conn) {
                    this.conn = conn;
                }

                @Override
                public void run() {
                    this.conn.closeConnector();
                }
            }
            new Thread((Runnable)new AsyncCleaner(this.connection), "jmx-closer").start();
            this.connection = null;
        }
    }
}

