/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.datadog.jmxfetch.util.LogLevel;
import org.datadog.jmxfetch.util.StdoutConsoleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLogger {
    private static final Logger log = LoggerFactory.getLogger(CustomLogger.class);
    private static java.util.logging.Logger jmxfetchLogger;
    private static boolean enableFileLineLogging;
    private static boolean millisecondLogging;
    private static final boolean disableThreadLogging;
    private static final ConcurrentHashMap<String, AtomicInteger> messageCount;
    private static final String DATE_JDK14_LAYOUT = "yyyy-MM-dd HH:mm:ss z";
    private static final String DATE_JDK14_LAYOUT_RFC3339 = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final String JDK14_LAYOUT = "%s | JMX | %2$s | %3$s | %4$s%5$s%n";
    private static final String JDK14_WITH_THREADS_LAYOUT = "%s | JMX | %2$s | %3$s | %4$s | %5$s%6$s%n";
    private static final String JDK14_LAYOUT_FILE_LINE = "%s | JMX | %2$s | %3$s:%4$d | %5$s%6$s%n";
    private static final String JDK14_WITH_THREADS_LAYOUT_FILE_LINE = "%s | JMX | %2$s | %3$s | %4$s:%5$d | %6$s%7$s%n";
    private static final int MAX_FILE_SIZE = 0x500000;
    private static final int FILE_COUNT = 2;

    private static boolean isStdErr(String target) {
        List<String> stderrs = Arrays.asList("SYSTEM.ERR", "SYSTEM_ERR", "STDERR");
        return stderrs.contains(target.toUpperCase());
    }

    private static boolean isStdOut(String target) {
        List<String> stdouts = Arrays.asList("SYSTEM.OUT", "SYSTEM_OUT", "STDOUT");
        return stdouts.contains(target.toUpperCase());
    }

    public static synchronized void setup(LogLevel level, String logLocation, boolean logFormatRfc3339) {
        SimpleFormatter formatter = CustomLogger.getFormatter(logFormatRfc3339);
        Level julLevel = level.toJulLevel();
        LogManager manager = LogManager.getLogManager();
        manager.reset();
        ConsoleHandler stderrHandler = null;
        FileHandler fileHandler = null;
        if (logLocation != null && !logLocation.isEmpty()) {
            if (!CustomLogger.isStdOut(logLocation) && !CustomLogger.isStdErr(logLocation)) {
                try {
                    fileHandler = new FileHandler(logLocation, 0x500000, 2);
                    fileHandler.setFormatter(formatter);
                }
                catch (Exception e) {
                    fileHandler = null;
                    log.error("can't open the file handler:", (Throwable)e);
                }
            } else if (CustomLogger.isStdErr(logLocation)) {
                stderrHandler = new ConsoleHandler();
                stderrHandler.setFormatter(formatter);
                stderrHandler.setLevel(julLevel);
            }
        }
        StdoutConsoleHandler stdoutHandler = new StdoutConsoleHandler();
        stdoutHandler.setFormatter(formatter);
        stdoutHandler.setLevel(julLevel);
        jmxfetchLogger = java.util.logging.Logger.getLogger("org.datadog.jmxfetch");
        jmxfetchLogger.setLevel(julLevel);
        if (fileHandler != null) {
            jmxfetchLogger.addHandler(fileHandler);
        }
        jmxfetchLogger.addHandler(stdoutHandler);
        if (stderrHandler != null) {
            jmxfetchLogger.addHandler(stderrHandler);
        }
    }

    private static SimpleFormatter getFormatter(boolean logFormatRfc3339) {
        String dateFormat;
        String string = dateFormat = logFormatRfc3339 ? DATE_JDK14_LAYOUT_RFC3339 : DATE_JDK14_LAYOUT;
        if (millisecondLogging) {
            dateFormat = dateFormat.replace("ss", "ss.SSS");
        }
        final SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat, Locale.getDefault());
        return new SimpleFormatter(){

            private String simpleClassName(String str) {
                int start = str.lastIndexOf(46);
                int end = str.indexOf(36);
                if (start == -1 || start + 1 == str.length()) {
                    return str;
                }
                if (end == -1 || end <= start) {
                    end = str.length();
                }
                return str.substring(start + 1, end);
            }

            @Override
            public synchronized String format(LogRecord lr) {
                String exception = "";
                if (lr.getThrown() != null) {
                    StringWriter writer = new StringWriter();
                    PrintWriter stream = new PrintWriter(writer);
                    stream.println();
                    lr.getThrown().printStackTrace(stream);
                    stream.close();
                    exception = writer.toString();
                }
                if (enableFileLineLogging) {
                    Throwable throwable = new Throwable();
                    StackTraceElement logEmissionFrame = throwable.getStackTrace()[6];
                    if (!disableThreadLogging) {
                        return String.format(CustomLogger.JDK14_WITH_THREADS_LAYOUT_FILE_LINE, dateFormatter.format(new Date()), LogLevel.fromJulLevel(lr.getLevel()).toString(), Thread.currentThread().getName(), logEmissionFrame.getFileName(), logEmissionFrame.getLineNumber(), lr.getMessage(), exception);
                    }
                    return String.format(CustomLogger.JDK14_LAYOUT_FILE_LINE, dateFormatter.format(new Date()), LogLevel.fromJulLevel(lr.getLevel()).toString(), logEmissionFrame.getFileName(), logEmissionFrame.getLineNumber(), lr.getMessage(), exception);
                }
                if (!disableThreadLogging) {
                    return String.format(CustomLogger.JDK14_WITH_THREADS_LAYOUT, dateFormatter.format(new Date()), LogLevel.fromJulLevel(lr.getLevel()).toString(), Thread.currentThread().getName(), this.simpleClassName(lr.getSourceClassName()), lr.getMessage(), exception);
                }
                return String.format(CustomLogger.JDK14_LAYOUT, dateFormatter.format(new Date()), LogLevel.fromJulLevel(lr.getLevel()).toString(), this.simpleClassName(lr.getSourceClassName()), lr.getMessage(), exception);
            }
        };
    }

    public static synchronized void shutdown() {
        for (Handler handler : jmxfetchLogger.getHandlers()) {
            if (handler == null) continue;
            handler.close();
            jmxfetchLogger.removeHandler(handler);
        }
    }

    public static void laconic(Logger logger, LogLevel level, String message, int max) {
        if (CustomLogger.shouldLog(message, max)) {
            if (level == LogLevel.ERROR) {
                logger.error(message);
            } else if (level == LogLevel.WARN) {
                logger.warn(message);
            } else if (level == LogLevel.INFO) {
                logger.info(message);
            } else if (level == LogLevel.DEBUG) {
                logger.debug(message);
            }
        }
    }

    private static boolean shouldLog(String message, int max) {
        AtomicInteger winner;
        AtomicInteger count = messageCount.get(message);
        if (null == count && (winner = messageCount.putIfAbsent(message, count = new AtomicInteger())) != null) {
            count = winner;
        }
        if (count.get() <= max) {
            count.getAndIncrement();
            return true;
        }
        return false;
    }

    private CustomLogger() {
    }

    static {
        enableFileLineLogging = System.getProperty("jmxfetch.filelinelogging", "false").equals("true");
        millisecondLogging = System.getProperty("jmxfetch.millisecondLogging", "false").equals("true");
        disableThreadLogging = System.getProperty("jmxfetch.disableThreadLogging", "false").equals("true");
        messageCount = new ConcurrentHashMap();
    }
}

