/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.ServiceCheck;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JmxAttribute;
import org.datadog.jmxfetch.reporter.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsdReporter
extends Reporter {
    private static final Logger log = LoggerFactory.getLogger(StatsdReporter.class);
    private StatsDClient statsDClient;
    private String statsdHost;
    private int statsdPort;
    private long initializationTime;

    public StatsdReporter(String statsdHost, int statsdPort) {
        this.statsdHost = statsdHost;
        this.statsdPort = statsdPort;
        this.init();
    }

    private void init() {
        this.initializationTime = System.currentTimeMillis();
        String entityId = this.statsdPort == 0 ? "none" : null;
        this.statsDClient = new NonBlockingStatsDClient(null, this.statsdHost, this.statsdPort, Integer.MAX_VALUE, new String[0], (StatsDClientErrorHandler)new LoggingErrorHandler(), entityId);
    }

    @Override
    protected void sendMetricPoint(String metricType, String metricName, double value, String[] tags) {
        if (System.currentTimeMillis() - this.initializationTime > 300000L) {
            this.statsDClient.stop();
            this.init();
        }
        if (metricType.equals("monotonic_count")) {
            this.statsDClient.count(metricName, (long)value, tags);
        } else if (metricType.equals("histogram")) {
            this.statsDClient.histogram(metricName, value, tags);
        } else {
            this.statsDClient.gauge(metricName, value, tags);
        }
    }

    @Override
    public void doSendServiceCheck(String serviceCheckName, String status, String message, String[] tags) {
        if (System.currentTimeMillis() - this.initializationTime > 300000L) {
            this.statsDClient.stop();
            this.init();
        }
        ServiceCheck sc = ServiceCheck.builder().withName(serviceCheckName).withStatus(this.statusToServiceCheckStatus(status)).withMessage(message).withTags(tags).build();
        this.statsDClient.serviceCheck(sc);
    }

    @Override
    public void displayMetricReached() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayMatchingAttributeName(JmxAttribute jmxAttribute, int rank, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayNonMatchingAttributeName(JmxAttribute jmxAttribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayInstanceName(Instance instance) {
        throw new UnsupportedOperationException();
    }

    public String getStatsdHost() {
        return this.statsdHost;
    }

    public int getStatsdPort() {
        return this.statsdPort;
    }

    private class LoggingErrorHandler
    implements StatsDClientErrorHandler {
        private LoggingErrorHandler() {
        }

        public void handle(Exception exception) {
            log.error("statsd client error:", (Throwable)exception);
        }
    }
}

