/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.primitives.Bytes;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.datadog.jmxfetch.AppConfig;
import org.datadog.jmxfetch.AppShutdownHook;
import org.datadog.jmxfetch.HttpClient;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.InstanceCleanupTask;
import org.datadog.jmxfetch.InstanceInitializingTask;
import org.datadog.jmxfetch.InstanceTask;
import org.datadog.jmxfetch.JsonParser;
import org.datadog.jmxfetch.Metric;
import org.datadog.jmxfetch.MetricCollectionTask;
import org.datadog.jmxfetch.YamlParser;
import org.datadog.jmxfetch.reporter.Reporter;
import org.datadog.jmxfetch.tasks.TaskMethod;
import org.datadog.jmxfetch.tasks.TaskProcessException;
import org.datadog.jmxfetch.tasks.TaskProcessor;
import org.datadog.jmxfetch.tasks.TaskStatusHandler;
import org.datadog.jmxfetch.util.CustomLogger;
import org.datadog.jmxfetch.util.FileHelper;
import org.datadog.jmxfetch.util.ServiceCheckHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class App {
    private static final Logger log = LoggerFactory.getLogger(App.class);
    private static final String AUTO_DISCOVERY_PREFIX = "AD-";
    private static final String AD_CONFIG_SEP = "#### AUTO-DISCOVERY ####";
    private static final String AD_LEGACY_CONFIG_SEP = "#### SERVICE-DISCOVERY ####";
    private static final String AD_CONFIG_TERM = "#### AUTO-DISCOVERY TERM ####";
    private static final String AD_LEGACY_CONFIG_TERM = "#### SERVICE-DISCOVERY TERM ####";
    private static final int AD_MAX_NAME_LEN = 80;
    private static final int AD_MAX_MAG_INSTANCES = 4;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String COLLECTION_POOL_NAME = "jmxfetch-collectionPool";
    private static final String RECOVERY_POOL_NAME = "jmxfetch-recoveryPool";
    private static int loopCounter;
    private int lastJsonConfigTs;
    private Map<String, Object> adJsonConfigs;
    private Map<String, YamlParser> configs;
    private Map<String, YamlParser> adPipeConfigs = new ConcurrentHashMap<String, YamlParser>();
    private List<Instance> instances = new ArrayList<Instance>();
    private Map<String, Instance> brokenInstanceMap = new ConcurrentHashMap<String, Instance>();
    private AtomicBoolean reinit = new AtomicBoolean(false);
    private TaskProcessor collectionProcessor;
    private TaskProcessor recoveryProcessor;
    private AppConfig appConfig;
    private HttpClient client;

    public App(AppConfig appConfig) {
        this.appConfig = appConfig;
        ExecutorService collectionThreadPool = null;
        ExecutorService recoveryThreadPool = null;
        if (!appConfig.isEmbedded()) {
            collectionThreadPool = this.buildExecutorService(appConfig.getThreadPoolSize(), COLLECTION_POOL_NAME);
            recoveryThreadPool = this.buildExecutorService(appConfig.getReconnectionThreadPoolSize(), RECOVERY_POOL_NAME);
        }
        this.recoveryProcessor = new TaskProcessor(recoveryThreadPool, appConfig.getReporter());
        this.collectionProcessor = new TaskProcessor(collectionThreadPool, appConfig.getReporter());
        if (appConfig.remoteEnabled()) {
            this.client = new HttpClient(appConfig.getIpcHost(), appConfig.getIpcPort(), false);
        }
        this.configs = this.getConfigs(appConfig);
    }

    public static void main(String[] args) {
        AppConfig config = AppConfig.builder().build();
        JCommander commander = null;
        try {
            commander = new JCommander((Object)config, args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        if (config.isVersion() || "version".equals(config.getAction())) {
            JCommander.getConsole().println("JMX Fetch " + App.getVersion());
            System.exit(0);
        }
        if (config.isHelp() || "help".equals(config.getAction())) {
            commander.usage();
            System.exit(0);
        }
        CustomLogger.setup(Level.toLevel((String)config.getLogLevel()), config.getLogLocation(), config.isLogFormatRfc3339());
        App.attachShutdownHook();
        System.exit(App.run(config));
    }

    public static String getVersion() {
        try {
            Properties properties = new Properties();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            properties.load(classLoader.getResourceAsStream("project.properties"));
            return properties.getProperty("version");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "?.?.?";
        }
    }

    public static int run(AppConfig config) {
        Marker fatal = MarkerFactory.getMarker((String)"FATAL");
        String action = config.getAction();
        if (!AppConfig.ACTIONS.contains(action)) {
            log.error(fatal, action + " is not in " + AppConfig.ACTIONS + ". Exiting.");
            return 1;
        }
        if (!(action.equals("collect") || config.isConsoleReporter() || config.isJsonReporter())) {
            log.error(fatal, action + " argument can only be used with the console or json reporter. Exiting.");
            return 1;
        }
        if (action.equals("list_jvms")) {
            List<VirtualMachineDescriptor> descriptors = VirtualMachine.list();
            System.out.println("List of JVMs for user " + System.getProperty("user.name"));
            for (VirtualMachineDescriptor descriptor : descriptors) {
                System.out.println("\tJVM id " + descriptor.id() + ": '" + descriptor.displayName() + "'");
            }
            return 0;
        }
        log.info("JMX Fetch " + App.getVersion() + " has started");
        config.updateStatus();
        App app = new App(config);
        Runtime.getRuntime().addShutdownHook(new AppShutdownHook(app));
        if (!action.equals("collect")) {
            app.getJsonConfigs();
        }
        app.init(false);
        if (action.equals("collect")) {
            app.start();
        }
        if (action.equals("list_with_metrics")) {
            app.displayMetrics();
        }
        if (action.equals("list_with_rate_metrics")) {
            app.displayRateMetrics();
        }
        return 0;
    }

    private static void attachShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("JMXFetch is closing");
                LogManager.shutdown();
            }
        });
    }

    public void setReinit(boolean reinit) {
        this.reinit.set(reinit);
    }

    public static int getLoopCounter() {
        return loopCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInstances(Collection<Instance> instances) {
        ArrayList cleanupInstanceTasks = new ArrayList(instances.size());
        for (Instance instance : instances) {
            cleanupInstanceTasks.add(new InstanceCleanupTask(instance));
        }
        try {
            if (!this.recoveryProcessor.ready()) {
                log.warn("Executor has to be replaced for recovery processor, previous one hogging threads");
                this.recoveryProcessor.stop();
                this.recoveryProcessor.setThreadPoolExecutor(this.buildExecutorService(this.appConfig.getReconnectionThreadPoolSize(), RECOVERY_POOL_NAME));
            }
            List<TaskStatusHandler> list = this.recoveryProcessor.processTasks(cleanupInstanceTasks, this.appConfig.getReconnectionTimeout(), TimeUnit.SECONDS, new TaskMethod<Void>(){

                @Override
                public TaskStatusHandler invoke(Instance instance, Future<Void> future, Reporter reporter) {
                    return App.processRecoveryResults(instance, future, reporter);
                }
            });
        }
        catch (Exception e) {
            log.warn("Unable to terminate all connections gracefully - possible network connectivity issues.");
        }
        finally {
            instances.clear();
        }
    }

    private ExecutorService buildExecutorService(int size, final String poolName) {
        return Executors.newFixedThreadPool(size, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                String threadName = poolName + "-" + this.counter.incrementAndGet();
                Thread thread = new Thread(runnable, threadName);
                thread.setDaemon(App.this.appConfig.isDaemon());
                return thread;
            }
        });
    }

    private String getAutoDiscoveryName(String config) {
        String[] splitted = config.split(System.getProperty("line.separator"), 2);
        return AUTO_DISCOVERY_PREFIX + splitted[0].substring(2, splitted[0].length());
    }

    private FileInputStream newAutoDiscoveryPipe() {
        FileInputStream adPipe = null;
        String pipeName = this.appConfig.getAutoDiscoveryPipe();
        try {
            adPipe = new FileInputStream(pipeName);
            log.info("Named pipe for Auto-Discovery opened: " + pipeName);
        }
        catch (FileNotFoundException e) {
            log.info("Unable to open named pipe for Auto-Discovery: " + pipeName);
        }
        return adPipe;
    }

    public boolean processAutoDiscovery(byte[] buffer) {
        String[] discovered;
        boolean reinit = false;
        String configs = new String(buffer, UTF_8);
        String separator = AD_CONFIG_SEP;
        if (configs.indexOf(AD_LEGACY_CONFIG_SEP) != -1) {
            separator = AD_LEGACY_CONFIG_SEP;
        }
        for (String config : discovered = configs.split(separator + System.getProperty("line.separator"))) {
            if (config == null || config.isEmpty()) continue;
            String name = this.getAutoDiscoveryName(config);
            log.debug("Attempting to apply config. Name: " + name);
            ByteArrayInputStream stream = new ByteArrayInputStream(config.getBytes(UTF_8));
            YamlParser yaml = new YamlParser(stream);
            if (this.addConfig(name, yaml)) {
                reinit = true;
                log.debug("Configuration added succesfully reinit in order");
                continue;
            }
            log.debug("Unable to apply configuration.");
        }
        return reinit;
    }

    protected List<Instance> getInstances() {
        return this.instances;
    }

    void displayMetrics() {
        this.doIteration();
    }

    void displayRateMetrics() {
        this.doIteration();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        this.doIteration();
    }

    void start() {
        FileInputStream adPipe = null;
        if (this.appConfig.getAutoDiscoveryPipeEnabled()) {
            log.info("Auto Discovery enabled");
            adPipe = this.newAutoDiscoveryPipe();
            try {
                FileHelper.touch(new File(this.appConfig.getJmxLaunchFile()));
            }
            catch (IOException e) {
                log.warn("Unable to create launch file - Auto-Discovery configs will not be automatically resubmitted.");
            }
        }
        while (true) {
            if (this.appConfig.getExitWatcher().shouldExit()) {
                log.info("Exit file detected: stopping JMXFetch.");
                return;
            }
            if (adPipe == null && this.appConfig.getAutoDiscoveryPipeEnabled()) {
                adPipe = this.newAutoDiscoveryPipe();
            }
            try {
                if (adPipe != null && adPipe.available() > 0) {
                    byte[] buffer = new byte[]{};
                    boolean terminated = false;
                    while (!terminated) {
                        int len = adPipe.available();
                        if (len <= 0) continue;
                        byte[] minibuff = new byte[len];
                        adPipe.read(minibuff);
                        if (Bytes.indexOf((byte[])minibuff, (byte[])AD_LEGACY_CONFIG_TERM.getBytes()) > -1 || Bytes.indexOf((byte[])minibuff, (byte[])AD_CONFIG_TERM.getBytes()) > -1) {
                            terminated = true;
                        }
                        int oldLen = buffer.length;
                        buffer = Arrays.copyOf(buffer, buffer.length + len);
                        System.arraycopy(minibuff, 0, buffer, oldLen, len);
                    }
                    this.setReinit(this.processAutoDiscovery(buffer));
                }
                if (this.appConfig.remoteEnabled()) {
                    this.setReinit(this.getJsonConfigs());
                }
            }
            catch (IOException e) {
                log.warn("Unable to read from pipe- Service Discovery configuration may have been skipped.");
            }
            catch (Exception e) {
                log.warn("Problem parsing auto-discovery configuration: " + e);
            }
            long start = System.currentTimeMillis();
            if (this.reinit.get()) {
                log.info("Reinitializing...");
                this.init(true);
            }
            if (this.instances.size() > 0) {
                this.doIteration();
            } else {
                log.warn("No instance could be initiated. Retrying initialization.");
                this.lastJsonConfigTs = 0;
                this.appConfig.getStatus().flush();
                this.configs = this.getConfigs(this.appConfig);
                this.init(true);
            }
            long duration = System.currentTimeMillis() - start;
            log.debug("Iteration ran in " + duration + " ms");
            try {
                long loopPeriod = this.appConfig.getCheckPeriod();
                long sleepPeriod = duration > loopPeriod ? loopPeriod : loopPeriod - duration;
                log.debug("Sleeping for " + loopPeriod + " ms.");
                Thread.sleep(loopPeriod);
                continue;
            }
            catch (InterruptedException e) {
                log.warn(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    void stop() {
        this.collectionProcessor.stop();
        this.recoveryProcessor.stop();
    }

    public void doIteration() {
        Reporter reporter = this.appConfig.getReporter();
        ++loopCounter;
        try {
            ArrayList getMetricsTasks = new ArrayList(this.instances.size());
            for (Instance instance : this.instances) {
                getMetricsTasks.add(new MetricCollectionTask(instance));
            }
            if (!this.collectionProcessor.ready()) {
                log.warn("Executor has to be replaced for collection processor, previous one hogging threads");
                this.collectionProcessor.stop();
                this.collectionProcessor.setThreadPoolExecutor(this.buildExecutorService(this.appConfig.getThreadPoolSize(), COLLECTION_POOL_NAME));
            }
            List<TaskStatusHandler> statuses = this.collectionProcessor.processTasks(getMetricsTasks, this.appConfig.getCollectionTimeout(), TimeUnit.SECONDS, new TaskMethod<List<Metric>>(){

                @Override
                public TaskStatusHandler invoke(Instance instance, Future<List<Metric>> future, Reporter reporter) {
                    return App.processCollectionResults(instance, future, reporter);
                }
            });
            this.processCollectionStatus(getMetricsTasks, statuses);
        }
        catch (Exception e) {
            String instanceStatus = "ERROR";
            String scStatus = "ERROR";
            log.warn("JMXFetch internal error invoking concurrent tasks: ", (Throwable)e);
            for (Instance instance : this.instances) {
                String instanceMessage = "Internal JMXFetch error refreshing bean list for instance " + instance;
                this.reportStatus(this.appConfig, reporter, instance, 0, instanceMessage, instanceStatus);
                this.sendServiceCheck(reporter, instance, instanceMessage, scStatus);
            }
        }
        this.fixBrokenInstances(reporter);
        try {
            this.appConfig.getStatus().flush();
        }
        catch (Exception e) {
            log.error("Unable to flush stats.", (Throwable)e);
        }
    }

    private void fixBrokenInstances(Reporter reporter) {
        if (this.brokenInstanceMap.isEmpty()) {
            return;
        }
        log.debug("Trying to recover broken instances...");
        ArrayList fixInstanceTasks = new ArrayList(this.brokenInstanceMap.values().size());
        for (Instance instance : this.brokenInstanceMap.values()) {
            reporter.clearRatesAggregator(instance.getName());
            reporter.clearCountersAggregator(instance.getName());
            log.warn("Instance " + instance + " didn't return any metrics. Maybe the server got disconnected ? Trying to reconnect.");
            instance.cleanUpAsync();
            this.instances.remove(instance);
            Instance newInstance = new Instance(instance, this.appConfig);
            fixInstanceTasks.add(new InstanceInitializingTask(newInstance, true));
        }
        try {
            if (!this.recoveryProcessor.ready()) {
                log.warn("Executor has to be replaced for recovery processor, previous one hogging threads");
                this.recoveryProcessor.stop();
                this.recoveryProcessor.setThreadPoolExecutor(this.buildExecutorService(this.appConfig.getReconnectionThreadPoolSize(), RECOVERY_POOL_NAME));
            }
            Collections.shuffle(fixInstanceTasks);
            List<TaskStatusHandler> statuses = this.recoveryProcessor.processTasks(fixInstanceTasks, this.appConfig.getReconnectionTimeout(), TimeUnit.SECONDS, new TaskMethod<Void>(){

                @Override
                public TaskStatusHandler invoke(Instance instance, Future<Void> future, Reporter reporter) {
                    return App.processRecoveryResults(instance, future, reporter);
                }
            });
            this.processFixedStatus(fixInstanceTasks, statuses);
            this.processStatus(fixInstanceTasks, statuses);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug("Done trying to recover broken instances.");
    }

    public boolean addConfig(String name, YamlParser config) {
        if (name.length() > AUTO_DISCOVERY_PREFIX.length() + 80 + 4 + 2) {
            log.debug("Name too long - skipping: " + name);
            return false;
        }
        String patternText = "AD-(.{1,80})_(\\d{0,4})";
        Pattern pattern = Pattern.compile(patternText);
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            log.debug("Cannot match instance name: " + name);
            return false;
        }
        String check = matcher.group(1);
        if (this.configs.containsKey(check)) {
            log.debug("Key already present - skipping: " + name);
            return false;
        }
        this.adPipeConfigs.put(name, config);
        this.setReinit(true);
        return true;
    }

    public boolean addJsonConfig(String name, String json) {
        return false;
    }

    private Map<String, YamlParser> getConfigs(AppConfig config) {
        ConcurrentHashMap<String, YamlParser> configs = new ConcurrentHashMap<String, YamlParser>();
        this.loadFileConfigs(config, configs);
        this.loadResourceConfigs(config, configs);
        log.info("Found " + configs.size() + " config files");
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFileConfigs(AppConfig config, Map<String, YamlParser> configs) {
        List<String> fileList = config.getYamlFileList();
        if (fileList != null) {
            for (String fileName : fileList) {
                File file = new File(config.getConfdDirectory(), fileName);
                String name = file.getName().replace(".yaml", "");
                String yamlPath = file.getAbsolutePath();
                FileInputStream yamlInputStream = null;
                log.info("Reading " + yamlPath);
                try {
                    yamlInputStream = new FileInputStream(yamlPath);
                    configs.put(name, new YamlParser(yamlInputStream));
                }
                catch (FileNotFoundException e) {
                    log.warn("Cannot find " + yamlPath);
                }
                catch (Exception e) {
                    log.warn("Cannot parse yaml file " + yamlPath, (Throwable)e);
                }
                finally {
                    if (yamlInputStream == null) continue;
                    try {
                        yamlInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResourceConfigs(AppConfig config, Map<String, YamlParser> configs) {
        List<String> resourceConfigList = config.getInstanceConfigResources();
        if (resourceConfigList != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String resourceName : resourceConfigList) {
                String name = resourceName.replace(".yaml", "");
                log.info("Reading " + resourceName);
                InputStream inputStream = classLoader.getResourceAsStream(resourceName);
                if (inputStream == null) {
                    log.warn("Cannot find " + resourceName);
                    continue;
                }
                try {
                    configs.put(name, new YamlParser(inputStream));
                }
                catch (Exception e) {
                    log.warn("Cannot parse yaml file " + resourceName, (Throwable)e);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private boolean getJsonConfigs() {
        boolean update = false;
        if (this.client == null) {
            return update;
        }
        try {
            String uripath = "agent/jmx/configs?timestamp=" + this.lastJsonConfigTs;
            HttpClient.HttpResponse response = this.client.request("GET", "", uripath);
            if (!response.isResponse2xx()) {
                log.warn("Failed collecting JSON configs: [" + response.getResponseCode() + "] " + response.getResponseBody());
                return update;
            }
            if (response.getResponseCode() == 204) {
                log.debug("No configuration changes...");
                return update;
            }
            InputStream jsonInputStream = IOUtils.toInputStream((String)response.getResponseBody(), (Charset)UTF_8);
            JsonParser parser = new JsonParser(jsonInputStream);
            int timestamp = (Integer)parser.getJsonTimestamp();
            if (timestamp > this.lastJsonConfigTs) {
                this.adJsonConfigs = (Map)parser.getJsonConfigs();
                this.lastJsonConfigTs = timestamp;
                update = true;
                log.info("update is in order - updating timestamp: " + this.lastJsonConfigTs);
                for (String checkName : this.adJsonConfigs.keySet()) {
                    log.debug("received config for check '" + checkName + "'");
                }
            }
        }
        catch (JsonProcessingException e) {
            log.error("error processing JSON response: " + (Object)((Object)e));
        }
        catch (IOException e) {
            log.error("unable to collect remote JMX configs: " + e);
        }
        return update;
    }

    private void reportStatus(AppConfig appConfig, Reporter reporter, Instance instance, int metricCount, String message, String status) {
        String checkName = instance.getCheckName();
        appConfig.getStatus().addInstanceStats(checkName, instance.getName(), metricCount, reporter.getServiceCheckCount(checkName), message, status);
    }

    private void sendServiceCheck(Reporter reporter, Instance instance, String message, String status) {
        String checkName = instance.getCheckName();
        if (instance.getServiceCheckPrefix() != null) {
            this.sendCanConnectServiceCheck(reporter, checkName, instance.getServiceCheckPrefix(), status, message, instance.getServiceCheckTags());
        } else {
            this.sendCanConnectServiceCheck(reporter, checkName, checkName, status, message, instance.getServiceCheckTags());
            String formattedCheckName = ServiceCheckHelper.formatServiceCheckPrefix(checkName);
            if (!formattedCheckName.equals(checkName)) {
                this.sendCanConnectServiceCheck(reporter, checkName, formattedCheckName, status, message, instance.getServiceCheckTags());
            }
        }
        reporter.resetServiceCheckCount(checkName);
    }

    private void sendCanConnectServiceCheck(Reporter reporter, String checkName, String serviceCheckPrefix, String status, String message, String[] tags) {
        String serviceCheckName = String.format("%s.can_connect", serviceCheckPrefix);
        reporter.sendServiceCheck(checkName, serviceCheckName, status, message, tags);
    }

    private Instance instantiate(Map<String, Object> instanceMap, Map<String, Object> initConfig, String checkName, AppConfig appConfig) {
        Instance instance;
        Reporter reporter = appConfig.getReporter();
        try {
            instance = new Instance(instanceMap, initConfig, checkName, appConfig);
        }
        catch (Exception e) {
            String warning = "Unable to create instance. Please check your yaml file";
            appConfig.getStatus().addInitFailedCheck(checkName, warning, "ERROR");
            log.error(warning, (Throwable)e);
            return null;
        }
        return instance;
    }

    public void init(boolean forceNewConnection) {
        List configInstances;
        log.info("Cleaning up instances...");
        this.clearInstances(this.instances);
        this.clearInstances(this.brokenInstanceMap.values());
        this.brokenInstanceMap.clear();
        ArrayList<Instance> newInstances = new ArrayList<Instance>();
        log.info("Dealing with YAML config instances...");
        Iterator<Map.Entry<String, YamlParser>> it = this.configs.entrySet().iterator();
        Iterator<Map.Entry<String, YamlParser>> itPipeConfigs = this.adPipeConfigs.entrySet().iterator();
        while (it.hasNext() || itPipeConfigs.hasNext()) {
            Object entry;
            boolean fromPipeIterator = false;
            if (it.hasNext()) {
                entry = it.next();
            } else {
                entry = itPipeConfigs.next();
                fromPipeIterator = true;
            }
            String name = entry.getKey();
            YamlParser yamlConfig = (YamlParser)entry.getValue();
            if (!fromPipeIterator) {
                it.remove();
            }
            if ((configInstances = (List)yamlConfig.getYamlInstances()) == null || configInstances.size() == 0) {
                String warning = "No instance found in :" + name;
                log.warn(warning);
                this.appConfig.getStatus().addInitFailedCheck(name, warning, "ERROR");
                continue;
            }
            for (Map configInstance : configInstances) {
                if (this.appConfig.isTargetDirectInstances() != Instance.isDirectInstance(configInstance)) {
                    log.info("Skipping instance '{}'. targetDirectInstances={} != jvm_direct={}", new Object[]{name, this.appConfig.isTargetDirectInstances(), Instance.isDirectInstance(configInstance)});
                    continue;
                }
                log.info("Instantiating instance for: {}", (Object)name);
                Instance instance = this.instantiate(configInstance, (Map)yamlConfig.getInitConfig(), name, this.appConfig);
                newInstances.add(instance);
            }
        }
        log.info("Dealing with Auto-Config instances collected...");
        if (this.adJsonConfigs != null) {
            for (String check : this.adJsonConfigs.keySet()) {
                Map checkConfig = (Map)this.adJsonConfigs.get(check);
                Map initConfig = (Map)checkConfig.get("init_config");
                configInstances = (List)checkConfig.get("instances");
                String checkName = (String)checkConfig.get("check_name");
                for (Map configInstance : configInstances) {
                    log.info("Instantiating instance for: " + checkName);
                    Instance instance = this.instantiate(configInstance, initConfig, checkName, this.appConfig);
                    newInstances.add(instance);
                }
            }
        }
        ArrayList instanceInitTasks = new ArrayList(newInstances.size());
        for (Instance instance : newInstances) {
            instanceInitTasks.add(new InstanceInitializingTask(instance, forceNewConnection));
        }
        log.info("Started instance initialization...");
        try {
            if (!this.recoveryProcessor.ready()) {
                log.warn("Executor has to be replaced for recovery processor, previous one hogging threads");
                this.recoveryProcessor.stop();
                this.recoveryProcessor.setThreadPoolExecutor(this.buildExecutorService(this.appConfig.getReconnectionThreadPoolSize(), RECOVERY_POOL_NAME));
            }
            List<TaskStatusHandler> statuses = this.recoveryProcessor.processTasks(instanceInitTasks, this.appConfig.getCollectionTimeout(), TimeUnit.SECONDS, new TaskMethod<Void>(){

                @Override
                public TaskStatusHandler invoke(Instance instance, Future<Void> future, Reporter reporter) {
                    return App.processRecoveryResults(instance, future, reporter);
                }
            });
            log.info("Completed instance initialization...");
            this.processInstantiationStatus(instanceInitTasks, statuses);
            this.processStatus(instanceInitTasks, statuses);
        }
        catch (Exception e) {
            log.warn("Critical issue initializing instances: " + e);
        }
    }

    static TaskStatusHandler processRecoveryResults(Instance instance, Future<Void> future, Reporter reporter) {
        TaskStatusHandler status = new TaskStatusHandler();
        Exception exc = null;
        try {
            if (future.isDone()) {
                future.get();
            } else if (future.isCancelled()) {
                exc = new TaskProcessException("could not schedule reconnect for instance.");
            }
        }
        catch (Exception e) {
            exc = e;
        }
        if (exc != null) {
            status.setThrowableStatus(exc);
        }
        return status;
    }

    static TaskStatusHandler processCollectionResults(Instance instance, Future<List<Metric>> future, Reporter reporter) {
        TaskStatusHandler status = new TaskStatusHandler();
        Exception exc = null;
        try {
            int numberOfMetrics = 0;
            if (future.isDone()) {
                List<Metric> metrics = future.get();
                numberOfMetrics = metrics.size();
                status.setData(metrics);
                if (numberOfMetrics == 0) {
                    exc = new TaskProcessException("Instance " + instance + " didn't return any metrics");
                }
            } else if (future.isCancelled()) {
                exc = new TaskProcessException("metric collection could not be scheduled in time for: " + instance);
            }
        }
        catch (Exception e) {
            exc = e;
        }
        if (exc != null) {
            status.setThrowableStatus(exc);
        }
        return status;
    }

    private <T> void processInstantiationStatus(List<InstanceTask<T>> tasks, List<TaskStatusHandler> statuses) {
        ListIterator<TaskStatusHandler> sit = statuses.listIterator(statuses.size());
        int idx = statuses.size();
        while (sit.hasPrevious()) {
            Instance instance = tasks.get(--idx).getInstance();
            try {
                TaskStatusHandler status = sit.previous();
                status.raiseForStatus();
                this.instances.add(instance);
                log.info("Successfully initialized instance: " + instance.getName());
            }
            catch (Throwable e) {
                log.info("Could not initialize instance: " + instance.getName() + ": " + e.toString());
                instance.cleanUpAsync();
                this.brokenInstanceMap.put(instance.toString(), instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void processFixedStatus(List<InstanceTask<T>> tasks, List<TaskStatusHandler> statuses) {
        ListIterator<TaskStatusHandler> it = statuses.listIterator();
        int idx = 0;
        while (it.hasNext()) {
            TaskStatusHandler status = it.next();
            try {
                status.raiseForStatus();
                Instance instance = tasks.get(idx).getInstance();
                this.brokenInstanceMap.remove(instance.toString());
                this.instances.add(instance);
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                ++idx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void processStatus(List<InstanceTask<T>> tasks, List<TaskStatusHandler> statuses) {
        for (int i = 0; i < statuses.size(); ++i) {
            InstanceTask<T> task = tasks.get(i);
            TaskStatusHandler status = statuses.get(i);
            Instance instance = task.getInstance();
            Reporter reporter = this.appConfig.getReporter();
            String warning = task.getWarning();
            try {
                status.raiseForStatus();
                warning = null;
                continue;
            }
            catch (TaskProcessException taskProcessException) {
                continue;
            }
            catch (ExecutionException ee) {
                Throwable exc = ee.getCause();
                if (exc instanceof IOException) {
                    warning = warning + ". Is the target JMX Server or JVM running? ";
                    warning = warning + exc.getMessage();
                    continue;
                }
                if (exc instanceof SecurityException) {
                    warning = warning + " because of bad credentials. Please check your credentials";
                    continue;
                }
                if (exc instanceof FailedLoginException) {
                    warning = warning + " because of bad credentials. Please check your credentials";
                    continue;
                }
                warning = warning + " for an unknown reason." + exc.getMessage();
                continue;
            }
            catch (CancellationException ce) {
                warning = warning + " because connection timed out and was canceled. Please check your network.";
                continue;
            }
            catch (InterruptedException ie) {
                warning = warning + " attempt interrupted waiting on IO";
                continue;
            }
            catch (Throwable e) {
                warning = warning + " There was an unexpected exception: " + e.getMessage();
                continue;
            }
            finally {
                if (warning != null) {
                    log.warn(warning);
                    this.reportStatus(this.appConfig, reporter, instance, 0, warning, "ERROR");
                    this.sendServiceCheck(reporter, instance, warning, "ERROR");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void processCollectionStatus(List<InstanceTask<T>> tasks, List<TaskStatusHandler> statuses) {
        for (int i = 0; i < statuses.size(); ++i) {
            String instanceMessage = null;
            String instanceStatus = "OK";
            String scStatus = "OK";
            int numberOfMetrics = 0;
            InstanceTask<T> task = tasks.get(i);
            TaskStatusHandler status = statuses.get(i);
            Instance instance = task.getInstance();
            Reporter reporter = this.appConfig.getReporter();
            try {
                status.raiseForStatus();
                List metrics = (List)status.getData();
                numberOfMetrics = metrics.size();
                if (instance.isLimitReached()) {
                    instanceMessage = "Number of returned metrics is too high for instance: " + instance.getName() + ". Please read http://docs.datadoghq.com/integrations/java/ or get in touch with Datadog Support for more details. Truncating to " + instance.getMaxNumberOfMetrics() + " metrics.";
                    instanceStatus = "WARNING";
                    CustomLogger.laconic(log, Level.WARN, instanceMessage, 0);
                }
                if (numberOfMetrics <= 0) continue;
                reporter.sendMetrics(metrics, instance.getName(), instance.getCanonicalRateConfig());
                continue;
            }
            catch (TaskProcessException te) {
                instanceStatus = "WARNING";
                scStatus = "WARNING";
                instanceMessage = te.toString();
                log.warn(instanceMessage);
                continue;
            }
            catch (ExecutionException ee) {
                instanceMessage = task.getWarning();
                instanceStatus = "ERROR";
                this.brokenInstanceMap.put(instance.toString(), instance);
                log.debug("Adding broken instance to list: " + instance.getName());
                log.warn(instanceMessage, ee.getCause());
                continue;
            }
            catch (Throwable t) {
                log.debug("Adding broken instance to list: " + instance.getName());
                this.brokenInstanceMap.put(instance.toString(), instance);
                instanceStatus = "ERROR";
                instanceMessage = task.getWarning() + ": " + t.toString();
                log.warn(instanceMessage);
                continue;
            }
            finally {
                if (instanceStatus == "ERROR") {
                    scStatus = "ERROR";
                }
                this.reportStatus(this.appConfig, reporter, instance, numberOfMetrics, instanceMessage, instanceStatus);
                this.sendServiceCheck(reporter, instance, instanceMessage, scStatus);
            }
        }
    }
}

