/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.datadog.jmxfetch.AttachApiConnection;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JvmDirectConnection;
import org.datadog.jmxfetch.RemoteConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);
    public static final String PROCESS_NAME_REGEX = "process_name_regex";

    public static Connection createConnection(LinkedHashMap<String, Object> connectionParams) throws IOException {
        if (Instance.isDirectInstance(connectionParams)) {
            log.info("Connecting to JMX directly on the JVM");
            return new JvmDirectConnection();
        }
        if (connectionParams.get(PROCESS_NAME_REGEX) != null) {
            try {
                Class.forName("com.sun.tools.attach.AttachNotSupportedException");
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Unable to find tools.jar. Are you using a JDK and did you set the path to tools.jar ?");
            }
            log.info("Connecting using Attach API");
            return new AttachApiConnection(connectionParams);
        }
        log.info("Connecting using JMX Remote");
        return new RemoteConnection(connectionParams);
    }
}

