/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.Filter;

public abstract class JmxAttribute {
    protected static final String ALIAS = "alias";
    protected static final String METRIC_TYPE = "metric_type";
    protected static final Logger LOGGER = Logger.getLogger((String)JmxAttribute.class.getName());
    private static final List<String> EXCLUDED_BEAN_PARAMS = Arrays.asList("domain", "domain_regex", "bean_name", "bean", "bean_regex", "attribute", "exclude_tags", "tags");
    private static final String FIRST_CAP_PATTERN = "(.)([A-Z][a-z]+)";
    private static final String ALL_CAP_PATTERN = "([a-z0-9])([A-Z])";
    private static final String METRIC_REPLACEMENT = "([^a-zA-Z0-9_.]+)|(^[^a-zA-Z]+)";
    private static final String DOT_UNDERSCORE = "_*\\._*";
    protected static final String CASSANDRA_DOMAIN = "org.apache.cassandra.metrics";
    private MBeanAttributeInfo attribute;
    private Connection connection;
    private ObjectName beanName;
    private String domain;
    private String beanStringName;
    private HashMap<String, String> beanParameters;
    private String attributeName;
    private LinkedHashMap<String, LinkedHashMap<Object, Object>> valueConversions = new LinkedHashMap();
    protected String[] tags;
    private Configuration matchingConf;
    private LinkedList<String> defaultTagsList;
    private Boolean cassandraAliasing;

    JmxAttribute(MBeanAttributeInfo attribute, ObjectName beanName, String instanceName, Connection connection, HashMap<String, String> instanceTags, Boolean cassandraAliasing, boolean emptyDefaultHostname) {
        this.attribute = attribute;
        this.beanName = beanName;
        this.matchingConf = null;
        this.connection = connection;
        this.attributeName = attribute.getName();
        this.beanStringName = beanName.toString();
        this.cassandraAliasing = cassandraAliasing;
        int splitPosition = this.beanStringName.indexOf(58);
        String domain = this.beanStringName.substring(0, splitPosition);
        String beanParameters = this.beanStringName.substring(splitPosition + 1);
        this.domain = domain;
        HashMap<String, String> beanParametersHash = JmxAttribute.getBeanParametersHash(beanParameters);
        LinkedList<String> beanParametersList = this.getBeanParametersList(instanceName, beanParametersHash, instanceTags);
        this.beanParameters = beanParametersHash;
        this.defaultTagsList = JmxAttribute.sanitizeParameters(beanParametersList);
        if (emptyDefaultHostname) {
            this.defaultTagsList.add("host:");
        }
    }

    private void applyTagsBlackList() {
        Filter include = this.matchingConf.getInclude();
        if (include != null) {
            for (String excludedTagName : include.getExcludeTags()) {
                Iterator it = this.defaultTagsList.iterator();
                while (it.hasNext()) {
                    if (!((String)it.next()).startsWith(excludedTagName + ":")) continue;
                    it.remove();
                }
            }
        }
    }

    private void addAdditionalTags() {
        Filter include = this.matchingConf.getInclude();
        if (include != null) {
            for (Map.Entry<String, String> tag : include.getAdditionalTags().entrySet()) {
                String alias = this.replaceByAlias(tag.getValue());
                if (alias.trim().length() > 0 && alias != null) {
                    this.defaultTagsList.add(tag.getKey() + ":" + alias);
                    continue;
                }
                LOGGER.warn((Object)("Unable to apply tag " + tag.getKey() + " - with unknown alias"));
            }
        }
    }

    public static HashMap<String, String> getBeanParametersHash(String beanParametersString) {
        String[] beanParameters = beanParametersString.split(",");
        HashMap<String, String> beanParamsMap = new HashMap<String, String>(beanParameters.length);
        for (String param : beanParameters) {
            String[] paramSplit = param.split("=");
            if (paramSplit.length > 1) {
                beanParamsMap.put(new String(paramSplit[0]), new String(paramSplit[1]));
                continue;
            }
            beanParamsMap.put(new String(paramSplit[0]), "");
        }
        return beanParamsMap;
    }

    private LinkedList<String> getBeanParametersList(String instanceName, Map<String, String> beanParameters, HashMap<String, String> instanceTags) {
        LinkedList<String> beanTags = new LinkedList<String>();
        beanTags.add("instance:" + instanceName);
        beanTags.add("jmx_domain:" + this.domain);
        if (this.renameCassandraMetrics().booleanValue()) {
            beanTags.addAll(JmxAttribute.getCassandraBeanTags(beanParameters));
        } else {
            for (Map.Entry<String, String> param : beanParameters.entrySet()) {
                beanTags.add(param.getKey() + ":" + param.getValue());
            }
        }
        if (instanceTags != null) {
            for (Map.Entry<String, String> tag : instanceTags.entrySet()) {
                if (tag.getValue() != null) {
                    beanTags.add(tag.getKey() + ":" + tag.getValue());
                    continue;
                }
                beanTags.add(tag.getKey());
            }
        }
        return beanTags;
    }

    private static LinkedList<String> sanitizeParameters(LinkedList<String> beanParametersList) {
        LinkedList<String> defaultTagsList = new LinkedList<String>();
        for (String rawBeanParameter : beanParametersList) {
            String beanParameter = rawBeanParameter.replace("|", "");
            if (beanParameter.startsWith("host:")) {
                defaultTagsList.add("bean_host:" + beanParameter.substring("host:".length()));
                continue;
            }
            if (beanParameter.endsWith(":")) {
                defaultTagsList.add(beanParameter.substring(0, beanParameter.length() - 1));
                continue;
            }
            defaultTagsList.add(beanParameter);
        }
        return defaultTagsList;
    }

    protected Boolean renameCassandraMetrics() {
        return this.cassandraAliasing != false && this.domain.equals(CASSANDRA_DOMAIN);
    }

    private static Collection<String> getCassandraBeanTags(Map<String, String> beanParameters) {
        LinkedList<String> tags = new LinkedList<String>();
        for (Map.Entry<String, String> param : beanParameters.entrySet()) {
            if (param.getKey().equals("name")) continue;
            if (param.getKey().equals("scope")) {
                String type = beanParameters.get("type");
                tags.add(type + ":" + param.getValue());
                continue;
            }
            tags.add(param.getKey() + ":" + param.getValue());
        }
        return tags;
    }

    static String convertMetricName(String metricName) {
        metricName = metricName.replaceAll(FIRST_CAP_PATTERN, "$1_$2");
        metricName = metricName.replaceAll(ALL_CAP_PATTERN, "$1_$2").toLowerCase();
        metricName = metricName.replaceAll(METRIC_REPLACEMENT, "_");
        metricName = metricName.replaceAll(DOT_UNDERSCORE, ".").trim();
        return metricName;
    }

    public String toString() {
        return "Bean name: " + this.beanStringName + " - Attribute name: " + this.attributeName + "  - Attribute type: " + this.attribute.getType();
    }

    public abstract LinkedList<HashMap<String, Object>> getMetrics() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException;

    public abstract boolean match(Configuration var1);

    public int getMetricsCount() {
        try {
            return this.getMetrics().size();
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Unable to get metrics from " + this.beanStringName + " - " + this.attributeName + ": " + e.toString()));
            return 0;
        }
    }

    Object getJmxValue() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.connection.getAttribute(this.beanName, this.attribute.getName());
    }

    boolean matchDomain(Configuration conf) {
        String includeDomain = conf.getInclude().getDomain();
        Pattern includeDomainRegex = conf.getInclude().getDomainRegex();
        return !(includeDomain != null && !includeDomain.equals(this.domain) || includeDomainRegex != null && !includeDomainRegex.matcher(this.domain).matches());
    }

    boolean excludeMatchDomain(Configuration conf) {
        String excludeDomain = conf.getExclude().getDomain();
        Pattern excludeDomainRegex = conf.getExclude().getDomainRegex();
        return excludeDomain != null && excludeDomain.equals(this.domain) || excludeDomainRegex != null && excludeDomainRegex.matcher(this.domain).matches();
    }

    Object convertMetricValue(Object metricValue, String field) {
        Object converted = metricValue;
        if (!this.getValueConversions(field).isEmpty() && (converted = this.getValueConversions(field).get(metricValue)) == null && this.getValueConversions(field).get("default") != null) {
            converted = this.getValueConversions(field).get("default");
        }
        return converted;
    }

    double castToDouble(Object metricValue, String field) {
        Object value = this.convertMetricValue(metricValue, field);
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Integer) {
            return new Double(((Integer)value).intValue());
        }
        if (value instanceof AtomicInteger) {
            return new Double(((AtomicInteger)value).get());
        }
        if (value instanceof AtomicLong) {
            Long longValue = ((AtomicLong)value).get();
            return longValue.doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Long) {
            Long longValue = new Long((Long)value);
            return longValue.doubleValue();
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return new Double((Double)value);
        }
        catch (Exception e) {
            throw new NumberFormatException();
        }
    }

    private boolean matchBeanRegex(Filter filter, boolean matchIfNoRegex) {
        ArrayList<Pattern> beanRegexes = filter.getBeanRegexes();
        if (beanRegexes.isEmpty()) {
            return matchIfNoRegex;
        }
        for (Pattern beanRegex : beanRegexes) {
            Matcher matcher = beanRegex.matcher(this.beanStringName);
            if (!matcher.matches()) continue;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                this.beanParameters.put(Integer.toString(i), matcher.group(i));
            }
            return true;
        }
        return false;
    }

    private boolean matchBeanName(Configuration configuration) {
        Filter include = configuration.getInclude();
        if (!include.isEmptyBeanName() && !include.getBeanNames().contains(this.beanStringName)) {
            return false;
        }
        for (String beanAttr : include.keySet()) {
            if (EXCLUDED_BEAN_PARAMS.contains(beanAttr)) continue;
            ArrayList<String> beanValues = include.getParameterValues(beanAttr);
            if (this.beanParameters.get(beanAttr) != null && beanValues.contains(this.beanParameters.get(beanAttr))) continue;
            return false;
        }
        return true;
    }

    private boolean excludeMatchBeanName(Configuration conf) {
        Filter exclude = conf.getExclude();
        ArrayList<String> beanNames = exclude.getBeanNames();
        if (beanNames.contains(this.beanStringName)) {
            return true;
        }
        for (String beanAttr : exclude.keySet()) {
            if (EXCLUDED_BEAN_PARAMS.contains(beanAttr) || this.beanParameters.get(beanAttr) == null) continue;
            ArrayList<String> beanValues = exclude.getParameterValues(beanAttr);
            for (String beanVal : beanValues) {
                if (!this.beanParameters.get(beanAttr).equals(beanVal)) continue;
                return true;
            }
        }
        return false;
    }

    boolean matchBean(Configuration configuration) {
        return this.matchBeanName(configuration) && this.matchBeanRegex(configuration.getInclude(), true);
    }

    boolean excludeMatchBean(Configuration configuration) {
        return this.excludeMatchBeanName(configuration) || this.matchBeanRegex(configuration.getExclude(), false);
    }

    HashMap<Object, Object> getValueConversions(String field) {
        String fullAttributeName;
        String string = fullAttributeName = field != null ? this.getAttribute().getName() + "." + field : this.getAttribute().getName();
        if (this.valueConversions.get(fullAttributeName) == null) {
            LinkedHashMap attribute;
            Object includedAttribute = this.matchingConf.getInclude().getAttribute();
            if (includedAttribute instanceof LinkedHashMap && (attribute = (LinkedHashMap)((LinkedHashMap)includedAttribute).get(fullAttributeName)) != null) {
                this.valueConversions.put(fullAttributeName, (LinkedHashMap<Object, Object>)attribute.get("values"));
            }
            if (this.valueConversions.get(fullAttributeName) == null) {
                this.valueConversions.put(fullAttributeName, new LinkedHashMap());
            }
        }
        return this.valueConversions.get(fullAttributeName);
    }

    public Configuration getMatchingConf() {
        return this.matchingConf;
    }

    public void setMatchingConf(Configuration matchingConf) {
        this.matchingConf = matchingConf;
        this.addAdditionalTags();
        this.applyTagsBlackList();
    }

    MBeanAttributeInfo getAttribute() {
        return this.attribute;
    }

    public ObjectName getBeanName() {
        return this.beanName;
    }

    protected String getAlias(String field) {
        String fullAttributeName;
        String alias = null;
        Filter include = this.getMatchingConf().getInclude();
        LinkedHashMap<String, Object> conf = this.getMatchingConf().getConf();
        String string = fullAttributeName = field != null ? this.getAttribute().getName() + "." + field : this.getAttribute().getName();
        if (include.getAttribute() instanceof LinkedHashMap) {
            LinkedHashMap attribute = (LinkedHashMap)include.getAttribute();
            alias = this.getUserAlias(attribute, fullAttributeName);
        }
        if (alias == null) {
            if (conf.get("metric_prefix") != null) {
                alias = conf.get("metric_prefix") + "." + this.getDomain() + "." + fullAttributeName;
            } else if (this.getDomain().startsWith("org.apache.cassandra")) {
                alias = this.getCassandraAlias();
            }
        }
        if (alias == null) {
            alias = "jmx." + this.getDomain() + "." + fullAttributeName;
        }
        alias = JmxAttribute.convertMetricName(alias);
        return alias;
    }

    protected String getAlias() {
        return this.getAlias(null);
    }

    private String getCassandraAlias() {
        if (this.renameCassandraMetrics().booleanValue()) {
            HashMap<String, String> beanParameters = this.getBeanParameters();
            String metricName = (String)beanParameters.get("name");
            String attributeName = this.getAttributeName();
            if (attributeName.equals("Value")) {
                return "cassandra." + metricName;
            }
            return "cassandra." + metricName + "." + attributeName;
        }
        return this.getDomain().replace("org.apache.", "") + "." + this.getAttributeName();
    }

    private String getUserAlias(LinkedHashMap<String, LinkedHashMap<String, String>> attribute, String fullAttributeName) {
        String alias = attribute.get(fullAttributeName).get(ALIAS);
        if (alias == null) {
            return null;
        }
        alias = this.replaceByAlias(alias);
        alias = alias.replace("$attribute", fullAttributeName);
        if ((alias = alias.replace("$domain", this.domain)).contains("$value")) {
            try {
                alias = alias.replace("$value", this.getJmxValue().toString());
            }
            catch (JMException e) {
                LOGGER.warn((Object)("Unable to replace $value for attribute " + fullAttributeName), (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Unable to replace $value for attribute " + fullAttributeName), (Throwable)e);
            }
        }
        return alias;
    }

    private String replaceByAlias(String alias) {
        for (Map.Entry<String, String> param : this.beanParameters.entrySet()) {
            alias = alias.replace("$" + param.getKey(), param.getValue());
        }
        return alias;
    }

    protected String[] getTags() {
        ArrayList yamlTags;
        LinkedHashMap attributeParams;
        Object includeAttribute;
        if (this.tags != null) {
            return this.tags;
        }
        Filter include = this.matchingConf.getInclude();
        if (include != null && (includeAttribute = include.getAttribute()) instanceof LinkedHashMap && (attributeParams = (LinkedHashMap)((LinkedHashMap)includeAttribute).get(this.attributeName)) != null && (yamlTags = (ArrayList)attributeParams.get("tags")) != null) {
            this.defaultTagsList.addAll(yamlTags);
        }
        this.tags = new String[this.defaultTagsList.size()];
        this.tags = this.defaultTagsList.toArray(this.tags);
        return this.tags;
    }

    String getBeanStringName() {
        return this.beanStringName;
    }

    String getAttributeName() {
        return this.attributeName;
    }

    public static List<String> getExcludedBeanParams() {
        return EXCLUDED_BEAN_PARAMS;
    }

    protected String getDomain() {
        return this.domain;
    }

    protected HashMap<String, String> getBeanParameters() {
        return this.beanParameters;
    }
}

