/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datadog.jmxfetch.ExitWatcher;
import org.datadog.jmxfetch.Status;
import org.datadog.jmxfetch.converter.ExitWatcherConverter;
import org.datadog.jmxfetch.converter.ReporterConverter;
import org.datadog.jmxfetch.reporter.ConsoleReporter;
import org.datadog.jmxfetch.reporter.Reporter;
import org.datadog.jmxfetch.reporter.ReporterFactory;
import org.datadog.jmxfetch.validator.Log4JLevelValidator;
import org.datadog.jmxfetch.validator.PositiveIntegerValidator;
import org.datadog.jmxfetch.validator.ReporterValidator;

@Parameters(separators="=")
public class AppConfig {
    public static final String ACTION_COLLECT = "collect";
    public static final String ACTION_LIST_JVMS = "list_jvms";
    public static final String ACTION_LIST_EVERYTHING = "list_everything";
    public static final String ACTION_LIST_COLLECTED = "list_collected_attributes";
    public static final String ACTION_LIST_MATCHING = "list_matching_attributes";
    public static final String ACTION_LIST_NOT_MATCHING = "list_not_matching_attributes";
    public static final String ACTION_LIST_LIMITED = "list_limited_attributes";
    public static final String ACTION_HELP = "help";
    public static final HashSet<String> ACTIONS = new HashSet<String>(Arrays.asList("collect", "list_everything", "list_collected_attributes", "list_matching_attributes", "list_not_matching_attributes", "list_limited_attributes", "help", "list_jvms"));
    private static final String AD_WIN_PIPE_PATH = "\\\\.\\pipe\\";
    private static final String AD_LEGACY_PIPE_NAME = "dd-service_discovery";
    private static final String AD_PIPE_NAME = "dd-auto_discovery";
    private static final String AD_LAUNCH_FILE = "jmx.launch";
    @Parameter(names={"--help", "-h"}, description="Display this help page", help=true)
    private boolean help;
    @Parameter(names={"--log_level", "-L"}, description="Level of verbosity", validateWith=Log4JLevelValidator.class, required=false)
    private String logLevel = "INFO";
    @Parameter(names={"--log_location", "-l"}, description="Absolute path of the log file (default to null = no logging)", required=false)
    private String logLocation;
    @Parameter(names={"--conf_directory", "-D"}, description="Absolute path to the conf.d directory", required=false)
    private String confdDirectory;
    @Parameter(names={"--tmp_directory", "-T"}, description="Absolute path to a temporary directory", required=false)
    private String tmpDirectory = "/tmp";
    @Parameter(names={"--reporter", "-r"}, description="Reporter to use: should be either \"statsd:[STATSD_PORT]\" or \"console\"", validateWith=ReporterValidator.class, converter=ReporterConverter.class, required=false)
    private Reporter reporter;
    @Parameter(names={"--check", "-c"}, description="Yaml file name to read (must be in the confd directory)", required=false, variableArity=true)
    private List<String> yamlFileList;
    @Parameter(names={"--check_period", "-p"}, description="Sleeping time during two iterations in ms", validateWith=PositiveIntegerValidator.class, required=false)
    private int checkPeriod = 15000;
    @Parameter(names={"--ad_enabled", "--sd_enabled", "-w"}, description="Enable Auto Discovery.", required=false)
    private boolean adEnabled = false;
    @Parameter(names={"--ad_pipe", "--sd_pipe", "-P"}, description="Auto Discovery pipe name.", required=false)
    private String adPipe = "dd-auto_discovery";
    @Parameter(names={"--status_location", "-s"}, description="Absolute path of the status file. (default to null = no status file written)", required=false)
    private String statusLocation;
    @Parameter(names={"--exit_file_location", "-e"}, description="Absolute path of the trigger file to watch to exit. (default to null = no exit on file)", converter=ExitWatcherConverter.class, required=false)
    private ExitWatcher exitWatcher = new ExitWatcher();
    @Parameter(description="Action to take, should be in [help, collect, list_everything, list_collected_attributes, list_matching_attributes, list_not_matching_attributes, list_limited_attributes, list_jvms]", required=true)
    private List<String> action = null;
    @Parameter(names={"--ipc_host", "-H"}, description="IPC host", required=false)
    private String ipcHost;
    @Parameter(names={"--ipc_port", "-I"}, description="IPC port", validateWith=PositiveIntegerValidator.class, required=false)
    private int ipcPort = 0;
    private List<String> instanceConfigResources;
    private List<String> metricConfigResources;
    private List<String> metricConfigFiles;
    private Integer refreshBeansPeriod;
    private Map<String, String> globalTags;
    private Status status = new Status();

    public boolean updateStatus() {
        if (this.statusLocation != null) {
            this.status = new Status(this.statusLocation);
            return true;
        }
        if (this.ipcHost != null && this.ipcPort > 0) {
            this.status = new Status(this.ipcHost, this.ipcPort);
            return true;
        }
        return false;
    }

    public boolean remoteEnabled() {
        return this.ipcHost != null && this.ipcPort > 0;
    }

    public String getStatusLocation() {
        return this.statusLocation;
    }

    public String getAction() {
        return this.action.get(0);
    }

    public boolean isConsoleReporter() {
        return this.reporter != null && this.reporter instanceof ConsoleReporter;
    }

    public boolean isHelp() {
        return this.help;
    }

    public Status getStatus() {
        return this.status;
    }

    public ExitWatcher getExitWatcher() {
        return this.exitWatcher;
    }

    public int getCheckPeriod() {
        return this.checkPeriod;
    }

    public String getIPCHost() {
        return this.ipcHost;
    }

    public int getIPCPort() {
        return this.ipcPort;
    }

    public boolean getAutoDiscoveryPipeEnabled() {
        return this.adEnabled;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public List<String> getYamlFileList() {
        return this.yamlFileList;
    }

    public String getConfdDirectory() {
        return this.confdDirectory;
    }

    public String getTmpDirectory() {
        return this.tmpDirectory;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public String getAutoDiscoveryPipe() {
        String pipePath = System.getProperty("os.name").startsWith("Windows") ? "\\\\.\\pipe\\/" + this.adPipe : this.getTmpDirectory() + "/" + this.adPipe;
        return pipePath;
    }

    public String getJMXLaunchFile() {
        return this.getTmpDirectory() + "/" + AD_LAUNCH_FILE;
    }

    public List<String> getInstanceConfigResources() {
        return this.instanceConfigResources;
    }

    public List<String> getMetricConfigResources() {
        return this.metricConfigResources;
    }

    public List<String> getMetricConfigFiles() {
        return this.metricConfigFiles;
    }

    public Integer getRefreshBeansPeriod() {
        return this.refreshBeansPeriod;
    }

    public Map<String, String> getGlobalTags() {
        return this.globalTags;
    }

    public static AppConfig create(List<String> instanceConfigResources, List<String> metricConfigResources, List<String> metricConfigFiles, Integer checkPeriod, Integer refreshBeansPeriod, Map<String, String> globalTags, String reporter, String logLocation, String logLevel) {
        AppConfig config = new AppConfig();
        config.action = ImmutableList.of((Object)ACTION_COLLECT);
        config.instanceConfigResources = ImmutableList.copyOf(instanceConfigResources);
        config.metricConfigResources = ImmutableList.copyOf(metricConfigResources);
        config.metricConfigFiles = ImmutableList.copyOf(metricConfigFiles);
        if (checkPeriod != null) {
            config.checkPeriod = checkPeriod;
        }
        config.refreshBeansPeriod = refreshBeansPeriod;
        config.globalTags = ImmutableMap.copyOf(globalTags);
        config.reporter = ReporterFactory.getReporter(reporter);
        config.logLocation = logLocation;
        config.logLevel = logLevel;
        return config;
    }
}

