/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.Filter;
import org.datadog.jmxfetch.JMXAttribute;

public class JMXSimpleAttribute
extends JMXAttribute {
    private String metricType;

    public JMXSimpleAttribute(MBeanAttributeInfo attribute, ObjectName beanName, String instanceName, Connection connection, HashMap<String, String> instanceTags, boolean cassandraAliasing, Boolean emptyDefaultHostname) {
        super(attribute, beanName, instanceName, connection, instanceTags, cassandraAliasing, emptyDefaultHostname);
    }

    @Override
    public LinkedList<HashMap<String, Object>> getMetrics() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        HashMap<String, Object> metric = new HashMap<String, Object>();
        metric.put("alias", this.getAlias());
        metric.put("value", this.castToDouble(this.getValue(), null));
        metric.put("tags", this.getTags());
        metric.put("metric_type", this.getMetricType());
        LinkedList<HashMap<String, Object>> metrics = new LinkedList<HashMap<String, Object>>();
        metrics.add(metric);
        return metrics;
    }

    @Override
    public boolean match(Configuration configuration) {
        return this.matchDomain(configuration) && this.matchBean(configuration) && this.matchAttribute(configuration) && !this.excludeMatchDomain(configuration) && !this.excludeMatchBean(configuration) && !this.excludeMatchAttribute(configuration);
    }

    private boolean excludeMatchAttribute(Configuration configuration) {
        Filter exclude = configuration.getExclude();
        if (exclude.getAttribute() == null) {
            return false;
        }
        if (exclude.getAttribute() instanceof LinkedHashMap && ((LinkedHashMap)exclude.getAttribute()).containsKey(this.getAttributeName())) {
            return true;
        }
        return exclude.getAttribute() instanceof ArrayList && ((ArrayList)exclude.getAttribute()).contains(this.getAttributeName());
    }

    private boolean matchAttribute(Configuration configuration) {
        Filter include = configuration.getInclude();
        if (include.getAttribute() == null) {
            return true;
        }
        if (include.getAttribute() instanceof LinkedHashMap && ((LinkedHashMap)include.getAttribute()).containsKey(this.getAttributeName())) {
            return true;
        }
        return include.getAttribute() instanceof ArrayList && ((ArrayList)include.getAttribute()).contains(this.getAttributeName());
    }

    private String getMetricType() {
        Filter include = this.getMatchingConf().getInclude();
        if (this.metricType != null) {
            return this.metricType;
        }
        if (include.getAttribute() instanceof LinkedHashMap) {
            LinkedHashMap attribute = (LinkedHashMap)include.getAttribute();
            this.metricType = (String)((LinkedHashMap)attribute.get(this.getAttributeName())).get("metric_type");
            if (this.metricType == null) {
                this.metricType = (String)((LinkedHashMap)attribute.get(this.getAttributeName())).get("type");
            }
        }
        if (this.metricType == null) {
            this.metricType = "gauge";
        }
        return this.metricType;
    }

    private Object getValue() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, NumberFormatException {
        return this.getJmxValue();
    }
}

