/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.Message;
import com.timgroup.statsd.NonBlockingStatsDClient;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class Telemetry {
    public static int DEFAULT_FLUSH_INTERVAL = 10000;
    protected final AtomicInteger metricsSent = new AtomicInteger(0);
    protected final AtomicInteger gaugeSent = new AtomicInteger(0);
    protected final AtomicInteger countSent = new AtomicInteger(0);
    protected final AtomicInteger histogramSent = new AtomicInteger(0);
    protected final AtomicInteger distributionSent = new AtomicInteger(0);
    protected final AtomicInteger setSent = new AtomicInteger(0);
    protected final AtomicInteger eventsSent = new AtomicInteger(0);
    protected final AtomicInteger serviceChecksSent = new AtomicInteger(0);
    protected final AtomicInteger bytesSent = new AtomicInteger(0);
    protected final AtomicInteger bytesDropped = new AtomicInteger(0);
    protected final AtomicInteger packetsSent = new AtomicInteger(0);
    protected final AtomicInteger packetsDropped = new AtomicInteger(0);
    protected final AtomicInteger packetsDroppedQueue = new AtomicInteger(0);
    protected final AtomicInteger aggregatedContexts = new AtomicInteger(0);
    protected final AtomicInteger aggregatedGaugeContexts = new AtomicInteger(0);
    protected final AtomicInteger aggregatedCountContexts = new AtomicInteger(0);
    protected final AtomicInteger aggregatedSetContexts = new AtomicInteger(0);
    protected final String metricsSentMetric = "datadog.dogstatsd.client.metrics";
    protected final String metricsByTypeSentMetric = "datadog.dogstatsd.client.metrics_by_type";
    protected final String eventsSentMetric = "datadog.dogstatsd.client.events";
    protected final String serviceChecksSentMetric = "datadog.dogstatsd.client.service_checks";
    protected final String bytesSentMetric = "datadog.dogstatsd.client.bytes_sent";
    protected final String bytesDroppedMetric = "datadog.dogstatsd.client.bytes_dropped";
    protected final String packetsSentMetric = "datadog.dogstatsd.client.packets_sent";
    protected final String packetsDroppedMetric = "datadog.dogstatsd.client.packets_dropped";
    protected final String packetsDroppedQueueMetric = "datadog.dogstatsd.client.packets_dropped_queue";
    protected final String aggregatedContextsMetric = "datadog.dogstatsd.client.aggregated_context";
    protected final String aggregatedContextsByTypeMetric = "datadog.dogstatsd.client.aggregated_context_by_type";
    protected Timer timer;
    NonBlockingStatsDClient client;

    Telemetry(NonBlockingStatsDClient client) {
        this.client = client;
    }

    public void start(long flushInterval) {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)new TelemetryTask(this), flushInterval, flushInterval);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void flush() {
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.metrics", this.metricsSent.getAndSet(0));
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.events", this.eventsSent.getAndSet(0));
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.service_checks", this.serviceChecksSent.getAndSet(0));
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.bytes_sent", this.bytesSent.getAndSet(0));
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.bytes_dropped", this.bytesDropped.getAndSet(0));
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.packets_sent", this.packetsSent.getAndSet(0));
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.packets_dropped", this.packetsDropped.getAndSet(0));
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.packets_dropped_queue", this.packetsDroppedQueue.getAndSet(0));
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.aggregated_context", this.aggregatedContexts.getAndSet(0));
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.metrics_by_type", this.gaugeSent.getAndSet(0), "metrics_type:gauge");
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.metrics_by_type", this.countSent.getAndSet(0), "metrics_type:count");
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.metrics_by_type", this.setSent.getAndSet(0), "metrics_type:set");
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.metrics_by_type", this.histogramSent.getAndSet(0), "metrics_type:histogram");
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.metrics_by_type", this.distributionSent.getAndSet(0), "metrics_type:distribution");
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.aggregated_context_by_type", this.aggregatedGaugeContexts.getAndSet(0), "metrics_type:gauge");
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.aggregated_context_by_type", this.aggregatedCountContexts.getAndSet(0), "metrics_type:count");
        this.client.sendTelemetryMetric("datadog.dogstatsd.client.aggregated_context_by_type", this.aggregatedSetContexts.getAndSet(0), "metrics_type:set");
    }

    public void incrMetricsSent(int value) {
        this.metricsSent.addAndGet(value);
    }

    public void incrMetricsSent(int value, Message.Type type) {
        this.incrMetricsSent(value);
        switch (type) {
            case GAUGE: {
                this.incrGaugeSent(value);
                break;
            }
            case COUNT: {
                this.incrCountSent(value);
                break;
            }
            case SET: {
                this.incrSetSent(value);
                break;
            }
            case HISTOGRAM: {
                this.incrHistogramSent(value);
                break;
            }
            case DISTRIBUTION: {
                this.incrDistributionSent(value);
                break;
            }
        }
    }

    public void incrGaugeSent(int value) {
        this.gaugeSent.addAndGet(value);
    }

    public void incrCountSent(int value) {
        this.countSent.addAndGet(value);
    }

    public void incrHistogramSent(int value) {
        this.histogramSent.addAndGet(value);
    }

    public void incrDistributionSent(int value) {
        this.distributionSent.addAndGet(value);
    }

    public void incrSetSent(int value) {
        this.setSent.addAndGet(value);
    }

    public void incrEventsSent(int value) {
        this.eventsSent.addAndGet(value);
    }

    public void incrServiceChecksSent(int value) {
        this.serviceChecksSent.addAndGet(value);
    }

    public void incrBytesSent(int value) {
        this.bytesSent.addAndGet(value);
    }

    public void incrBytesDropped(int value) {
        this.bytesDropped.addAndGet(value);
    }

    public void incrPacketSent(int value) {
        this.packetsSent.addAndGet(value);
    }

    public void incrPacketDropped(int value) {
        this.packetsDropped.addAndGet(value);
    }

    public void incrPacketDroppedQueue(int value) {
        this.packetsDroppedQueue.addAndGet(value);
    }

    public void incrAggregatedContexts(int value) {
        this.aggregatedContexts.addAndGet(value);
    }

    public void incrAggregatedGaugeContexts(int value) {
        this.aggregatedGaugeContexts.addAndGet(value);
    }

    public void incrAggregatedCountContexts(int value) {
        this.aggregatedCountContexts.addAndGet(value);
    }

    public void incrAggregatedSetContexts(int value) {
        this.aggregatedSetContexts.addAndGet(value);
    }

    public void reset() {
        this.metricsSent.set(0);
        this.eventsSent.set(0);
        this.serviceChecksSent.set(0);
        this.bytesSent.set(0);
        this.bytesDropped.set(0);
        this.packetsSent.set(0);
        this.packetsDropped.set(0);
        this.packetsDroppedQueue.set(0);
        this.aggregatedContexts.set(0);
        this.gaugeSent.set(0);
        this.countSent.set(0);
        this.histogramSent.set(0);
        this.distributionSent.set(0);
        this.setSent.set(0);
        this.aggregatedGaugeContexts.set(0);
        this.aggregatedCountContexts.set(0);
        this.aggregatedSetContexts.set(0);
    }

    protected class TelemetryTask
    extends TimerTask {
        private Telemetry telemetry;

        TelemetryTask(Telemetry telemetry) {
            this.telemetry = telemetry;
        }

        @Override
        public void run() {
            this.telemetry.flush();
        }
    }
}

