/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CgroupReader {
    private static final Path CGROUP_PATH = Paths.get("/proc/self/cgroup", new String[0]);
    private static final String UUID_SOURCE = "[0-9a-f]{8}(?:[_-][0-9a-f]{4}){3}[_-][0-9a-f]{12}";
    private static final String CONTAINER_SOURCE = "[0-9a-f]{64}";
    private static final String TASK_SOURCE = "[0-9a-f]{32}-\\d+";
    private static final Pattern LINE_RE = Pattern.compile("^\\d+:[^:]*:(.+)$", 9);
    private static final Pattern CONTAINER_RE = Pattern.compile("([0-9a-f]{8}(?:[_-][0-9a-f]{4}){3}[_-][0-9a-f]{12}|[0-9a-f]{64}|[0-9a-f]{32}-\\d+)(?:.scope)?$");
    private static final Path DEFAULT_CGROUP_MOUNT_PATH = Paths.get("/sys/fs/cgroup", new String[0]);
    private static final Path CGROUP_NS_PATH = Paths.get("/proc/self/ns/cgroup", new String[0]);
    private static final String CGROUPV1_BASE_CONTROLLER = "memory";
    private static final String CGROUPV2_BASE_CONTROLLER = "";
    private static final long HOST_CGROUP_NAMESPACE_INODE = 0xEFFFFFFBL;
    private final Path MOUNTINFO_PATH = Paths.get("/proc/self/mountinfo", new String[0]);
    private final Pattern MOUNTINFO_RE = Pattern.compile(".*/([^\\s/]+)/(([0-9a-f]{64})|([0-9a-f]{32}-\\d+)|([0-9a-f]{8}(-[0-9a-f]{4}){4})$)/[\\S]*hostname");
    private final Fs fs;

    CgroupReader() {
        this(new FilesFs());
    }

    CgroupReader(Fs fs) {
        this.fs = fs;
    }

    public String getContainerID() {
        String containerID = null;
        String cgroupContent = null;
        try {
            cgroupContent = this.fs.getContents(CGROUP_PATH);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!CgroupReader.isEmpty(cgroupContent)) {
            containerID = CgroupReader.parseSelfCgroup(cgroupContent);
        }
        if (!CgroupReader.isEmpty(containerID)) {
            return containerID;
        }
        containerID = this.trySelfMountInfo();
        if (!CgroupReader.isEmpty(containerID)) {
            return containerID;
        }
        if (!CgroupReader.isEmpty(cgroupContent) && !this.isHostCgroupNamespace(CGROUP_NS_PATH)) {
            containerID = this.getCgroupInode(DEFAULT_CGROUP_MOUNT_PATH, cgroupContent);
        }
        return containerID;
    }

    public static String parseSelfCgroup(String cgroupsContent) {
        Matcher lines = LINE_RE.matcher(cgroupsContent);
        while (lines.find()) {
            String path = lines.group(1);
            Matcher matcher = CONTAINER_RE.matcher(path);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private boolean isHostCgroupNamespace(Path path) {
        long hostCgroupInode = this.inodeForPath(path);
        return hostCgroupInode == 0xEFFFFFFBL;
    }

    private long inodeForPath(Path path) {
        try {
            long inode = this.fs.getInode(path);
            return inode;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public String getCgroupInode(Path cgroupMountPath, String cgroupContent) {
        Map<String, String> cgroupControllersPaths = this.parseCgroupNodePath(cgroupContent);
        if (cgroupControllersPaths == null) {
            return null;
        }
        List<String> controllers = Arrays.asList(CGROUPV1_BASE_CONTROLLER, CGROUPV2_BASE_CONTROLLER);
        for (String controller : controllers) {
            String cgroupNodePath = cgroupControllersPaths.get(controller);
            if (cgroupNodePath == null) continue;
            Path path = Paths.get(cgroupMountPath.toString(), controller, cgroupNodePath);
            long inode = this.inodeForPath(path);
            if (inode <= 2L) continue;
            return "in-" + inode;
        }
        return null;
    }

    public Map<String, String> parseCgroupNodePath(String cgroupContent) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String line : cgroupContent.split("\n")) {
            String[] tokens = line.split(":");
            if (tokens.length != 3 || !CGROUPV1_BASE_CONTROLLER.equals(tokens[1]) && !CGROUPV2_BASE_CONTROLLER.equals(tokens[1])) continue;
            res.put(tokens[1], tokens[2]);
        }
        return res;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    String trySelfMountInfo() {
        String mountInfo;
        try {
            mountInfo = this.fs.getContents(this.MOUNTINFO_PATH);
        }
        catch (IOException ex) {
            return null;
        }
        for (String line : mountInfo.split("\n")) {
            Matcher matcher = this.MOUNTINFO_RE.matcher(line);
            if (!matcher.find() || "sandboxes".equals(matcher.group(1))) continue;
            return matcher.group(2);
        }
        return null;
    }

    static class FilesFs
    implements Fs {
        FilesFs() {
        }

        @Override
        public String getContents(Path path) throws IOException {
            return new String(Files.readAllBytes(path));
        }

        @Override
        public long getInode(Path path) throws IOException {
            return (Long)Files.getAttribute(path, "unix:ino", new LinkOption[0]);
        }
    }

    static interface Fs {
        public String getContents(Path var1) throws IOException;

        public long getInode(Path var1) throws IOException;
    }
}

