/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.NamedPipeSocketAddress;
import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDAggregator;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import com.timgroup.statsd.Telemetry;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import jnr.unixsocket.UnixSocketAddress;

public class NonBlockingStatsDClientBuilder
implements Cloneable {
    public int maxPacketSizeBytes = 0;
    public int port = 8125;
    public int telemetryPort = 8125;
    public int queueSize = 4096;
    public int timeout = 100;
    public int bufferPoolSize = 512;
    public int socketBufferSize = -1;
    public int processorWorkers = 1;
    public int senderWorkers = 1;
    public boolean blocking = false;
    public boolean enableTelemetry = true;
    public boolean enableAggregation = true;
    public int telemetryFlushInterval = Telemetry.DEFAULT_FLUSH_INTERVAL;
    public int aggregationFlushInterval = StatsDAggregator.DEFAULT_FLUSH_INTERVAL;
    public int aggregationShards = StatsDAggregator.DEFAULT_SHARDS;
    public boolean originDetectionEnabled = true;
    public Callable<SocketAddress> addressLookup;
    public Callable<SocketAddress> telemetryAddressLookup;
    public String hostname;
    public String telemetryHostname;
    public String namedPipe;
    public String prefix;
    public String entityID;
    public String[] constantTags;
    public String containerID;
    public StatsDClientErrorHandler errorHandler;
    public ThreadFactory threadFactory;

    public NonBlockingStatsDClientBuilder port(int val) {
        this.port = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder telemetryPort(int val) {
        this.telemetryPort = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder queueSize(int val) {
        this.queueSize = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder timeout(int val) {
        this.timeout = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder bufferPoolSize(int val) {
        this.bufferPoolSize = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder socketBufferSize(int val) {
        this.socketBufferSize = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder maxPacketSizeBytes(int val) {
        this.maxPacketSizeBytes = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder processorWorkers(int val) {
        this.processorWorkers = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder senderWorkers(int val) {
        this.senderWorkers = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder blocking(boolean val) {
        this.blocking = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder addressLookup(Callable<SocketAddress> val) {
        this.addressLookup = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder telemetryAddressLookup(Callable<SocketAddress> val) {
        this.telemetryAddressLookup = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder hostname(String val) {
        this.hostname = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder telemetryHostname(String val) {
        this.telemetryHostname = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder namedPipe(String val) {
        this.namedPipe = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder prefix(String val) {
        this.prefix = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder entityID(String val) {
        this.entityID = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder constantTags(String ... val) {
        this.constantTags = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder errorHandler(StatsDClientErrorHandler val) {
        this.errorHandler = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder enableTelemetry(boolean val) {
        this.enableTelemetry = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder enableAggregation(boolean val) {
        this.enableAggregation = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder telemetryFlushInterval(int val) {
        this.telemetryFlushInterval = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder aggregationFlushInterval(int val) {
        this.aggregationFlushInterval = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder aggregationShards(int val) {
        this.aggregationShards = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder threadFactory(ThreadFactory val) {
        this.threadFactory = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder containerID(String val) {
        this.containerID = val;
        return this;
    }

    public NonBlockingStatsDClientBuilder originDetectionEnabled(boolean val) {
        this.originDetectionEnabled = val;
        return this;
    }

    public NonBlockingStatsDClient build() throws StatsDClientException {
        return new NonBlockingStatsDClient(this.resolve());
    }

    protected NonBlockingStatsDClientBuilder resolve() {
        Callable<SocketAddress> telemetryLookup;
        NonBlockingStatsDClientBuilder resolved;
        try {
            resolved = (NonBlockingStatsDClientBuilder)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("clone");
        }
        int packetSize = this.maxPacketSizeBytes;
        Callable<SocketAddress> lookup = this.addressLookup;
        if (lookup == null) {
            String namedPipeFromEnv = System.getenv("DD_DOGSTATSD_PIPE_NAME");
            String resolvedNamedPipe = this.namedPipe == null ? namedPipeFromEnv : this.namedPipe;
            lookup = resolvedNamedPipe == null ? NonBlockingStatsDClientBuilder.staticStatsDAddressResolution(this.hostname, this.port) : NonBlockingStatsDClientBuilder.staticNamedPipeResolution(resolvedNamedPipe);
        }
        if (packetSize == 0) {
            int n = packetSize = this.port == 0 ? 8192 : 1432;
        }
        if ((telemetryLookup = this.telemetryAddressLookup) == null) {
            telemetryLookup = this.telemetryHostname == null ? lookup : NonBlockingStatsDClientBuilder.staticStatsDAddressResolution(this.telemetryHostname, this.telemetryPort);
        }
        resolved.maxPacketSizeBytes = packetSize;
        resolved.addressLookup = lookup;
        resolved.telemetryAddressLookup = telemetryLookup;
        return resolved;
    }

    public static Callable<SocketAddress> volatileAddressResolution(final String hostname, final int port) {
        if (port == 0) {
            return new Callable<SocketAddress>(){

                @Override
                public SocketAddress call() throws UnknownHostException {
                    return new UnixSocketAddress(hostname);
                }
            };
        }
        return new Callable<SocketAddress>(){

            @Override
            public SocketAddress call() throws UnknownHostException {
                return new InetSocketAddress(InetAddress.getByName(hostname), port);
            }
        };
    }

    public static Callable<SocketAddress> staticAddressResolution(String hostname, int port) throws Exception {
        final SocketAddress address = NonBlockingStatsDClientBuilder.volatileAddressResolution(hostname, port).call();
        return new Callable<SocketAddress>(){

            @Override
            public SocketAddress call() {
                return address;
            }
        };
    }

    protected static Callable<SocketAddress> staticStatsDAddressResolution(String hostname, int port) throws StatsDClientException {
        try {
            if (hostname == null) {
                hostname = NonBlockingStatsDClientBuilder.getHostnameFromEnvVar();
                port = NonBlockingStatsDClientBuilder.getPortFromEnvVar(port);
            }
            return NonBlockingStatsDClientBuilder.staticAddressResolution(hostname, port);
        }
        catch (Exception e) {
            throw new StatsDClientException("Failed to lookup StatsD host", e);
        }
    }

    protected static Callable<SocketAddress> staticNamedPipeResolution(String namedPipe) {
        final NamedPipeSocketAddress socketAddress = new NamedPipeSocketAddress(namedPipe);
        return new Callable<SocketAddress>(){

            @Override
            public SocketAddress call() {
                return socketAddress;
            }
        };
    }

    private static String getHostnameFromEnvVar() {
        String hostname = System.getenv("DD_AGENT_HOST");
        if (hostname == null) {
            throw new StatsDClientException("Failed to retrieve agent hostname from environment variable", null);
        }
        return hostname;
    }

    private static int getPortFromEnvVar(int defaultPort) {
        String statsDPortString = System.getenv("DD_DOGSTATSD_PORT");
        if (statsDPortString == null) {
            return defaultPort;
        }
        try {
            int statsDPort = Integer.parseInt(statsDPortString);
            return statsDPort;
        }
        catch (NumberFormatException e) {
            throw new StatsDClientException("Failed to parse DD_DOGSTATSD_PORTenvironment variable value", e);
        }
    }
}

