/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.InvalidMessageException;
import com.timgroup.statsd.Message;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDProcessor;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class StatsDBlockingProcessor
extends StatsDProcessor {
    private final BlockingQueue<Message> messages;

    StatsDBlockingProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int poolSize, int workers, int aggregatorFlushInterval, int aggregatorShards, ThreadFactory threadFactory) throws Exception {
        super(queueSize, handler, maxPacketSizeBytes, poolSize, workers, aggregatorFlushInterval, aggregatorShards, threadFactory);
        this.messages = new ArrayBlockingQueue<Message>(queueSize);
    }

    @Override
    protected ProcessingTask createProcessingTask() {
        return new ProcessingTask();
    }

    @Override
    protected boolean send(Message message) {
        try {
            if (!this.shutdown) {
                this.messages.put(message);
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    private class ProcessingTask
    extends StatsDProcessor.ProcessingTask {
        private ProcessingTask() {
        }

        @Override
        protected void processLoop() {
            ByteBuffer sendBuffer;
            boolean empty = true;
            boolean emptyHighPrio = true;
            try {
                sendBuffer = StatsDBlockingProcessor.this.bufferPool.borrow();
            }
            catch (InterruptedException e) {
                StatsDBlockingProcessor.this.handler.handle(e);
                return;
            }
            while (!((emptyHighPrio = StatsDBlockingProcessor.this.highPrioMessages.isEmpty()) && (empty = StatsDBlockingProcessor.this.messages.isEmpty()) && StatsDBlockingProcessor.this.shutdown)) {
                try {
                    Message message = !emptyHighPrio ? (Message)StatsDBlockingProcessor.this.highPrioMessages.poll() : (Message)StatsDBlockingProcessor.this.messages.poll(10L, TimeUnit.MILLISECONDS);
                    if (message == null || StatsDBlockingProcessor.this.aggregator.aggregateMessage(message)) continue;
                    this.builder.setLength(0);
                    message.writeTo(this.builder);
                    int lowerBoundSize = this.builder.length();
                    if (sendBuffer.capacity() < lowerBoundSize) {
                        throw new InvalidMessageException("Message longer than size of sendBuffer", this.builder.toString());
                    }
                    if (sendBuffer.remaining() < lowerBoundSize + 1) {
                        StatsDBlockingProcessor.this.outboundQueue.put(sendBuffer);
                        sendBuffer = StatsDBlockingProcessor.this.bufferPool.borrow();
                    }
                    sendBuffer.mark();
                    try {
                        this.writeBuilderToSendBuffer(sendBuffer);
                    }
                    catch (BufferOverflowException boe) {
                        StatsDBlockingProcessor.this.outboundQueue.put(sendBuffer);
                        sendBuffer = StatsDBlockingProcessor.this.bufferPool.borrow();
                        this.writeBuilderToSendBuffer(sendBuffer);
                    }
                    if (null != StatsDBlockingProcessor.this.messages.peek()) continue;
                    StatsDBlockingProcessor.this.outboundQueue.put(sendBuffer);
                    sendBuffer = StatsDBlockingProcessor.this.bufferPool.borrow();
                }
                catch (InterruptedException e) {
                    if (!StatsDBlockingProcessor.this.shutdown) continue;
                    break;
                }
                catch (Exception e) {
                    StatsDBlockingProcessor.this.handler.handle(e);
                }
            }
            this.builder.setLength(0);
            this.builder.trimToSize();
        }
    }
}

