/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.InvalidMessageException;
import com.timgroup.statsd.Message;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDProcessor;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class StatsDNonBlockingProcessor
extends StatsDProcessor {
    private final Queue<Message> messages;
    private final AtomicInteger qsize = new AtomicInteger(0);

    StatsDNonBlockingProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int poolSize, int workers) throws Exception {
        super(queueSize, handler, maxPacketSizeBytes, poolSize, workers);
        this.messages = new ConcurrentLinkedQueue<Message>();
    }

    @Override
    protected ProcessingTask createProcessingTask() {
        return new ProcessingTask();
    }

    StatsDNonBlockingProcessor(StatsDNonBlockingProcessor processor) throws Exception {
        super(processor);
        this.messages = new ConcurrentLinkedQueue<Message>();
    }

    @Override
    protected boolean send(Message message) {
        if (!this.shutdown && this.qsize.get() < this.qcapacity) {
            this.messages.offer(message);
            this.qsize.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    void shutdown() {
        this.shutdown = true;
    }

    private class ProcessingTask
    extends StatsDProcessor.ProcessingTask {
        private ProcessingTask() {
        }

        @Override
        public void run() {
            boolean empty;
            ByteBuffer sendBuffer;
            try {
                sendBuffer = StatsDNonBlockingProcessor.this.bufferPool.borrow();
            }
            catch (InterruptedException e) {
                StatsDNonBlockingProcessor.this.handler.handle(e);
                return;
            }
            while (!(empty = StatsDNonBlockingProcessor.this.messages.isEmpty()) || !StatsDNonBlockingProcessor.this.shutdown) {
                try {
                    if (empty) {
                        Thread.sleep(10L);
                        continue;
                    }
                    if (Thread.interrupted()) {
                        return;
                    }
                    Message message = (Message)StatsDNonBlockingProcessor.this.messages.poll();
                    if (message == null) continue;
                    StatsDNonBlockingProcessor.this.qsize.decrementAndGet();
                    this.builder.setLength(0);
                    message.writeTo(this.builder);
                    int lowerBoundSize = this.builder.length();
                    if (sendBuffer.capacity() < lowerBoundSize) {
                        throw new InvalidMessageException("Message longer than size of sendBuffer", this.builder.toString());
                    }
                    if (sendBuffer.remaining() < lowerBoundSize + 1) {
                        StatsDNonBlockingProcessor.this.outboundQueue.put(sendBuffer);
                        sendBuffer = StatsDNonBlockingProcessor.this.bufferPool.borrow();
                    }
                    sendBuffer.mark();
                    if (sendBuffer.position() > 0) {
                        sendBuffer.put((byte)10);
                    }
                    try {
                        this.writeBuilderToSendBuffer(sendBuffer);
                    }
                    catch (BufferOverflowException boe) {
                        StatsDNonBlockingProcessor.this.outboundQueue.put(sendBuffer);
                        sendBuffer = StatsDNonBlockingProcessor.this.bufferPool.borrow();
                        this.writeBuilderToSendBuffer(sendBuffer);
                    }
                    if (null != StatsDNonBlockingProcessor.this.messages.peek()) continue;
                    StatsDNonBlockingProcessor.this.outboundQueue.put(sendBuffer);
                    sendBuffer = StatsDNonBlockingProcessor.this.bufferPool.borrow();
                }
                catch (InterruptedException e) {
                    if (!StatsDNonBlockingProcessor.this.shutdown) continue;
                    StatsDNonBlockingProcessor.this.endSignal.countDown();
                    return;
                }
                catch (Exception e) {
                    StatsDNonBlockingProcessor.this.handler.handle(e);
                }
            }
            this.builder.setLength(0);
            this.builder.trimToSize();
            StatsDNonBlockingProcessor.this.endSignal.countDown();
        }
    }
}

