/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.util;

import ddtrot.com.squareup.moshi.JsonReader;
import ddtrot.dd.trace.util.json.PathCursor;
import ddtrot.okio.BufferedSource;
import ddtrot.okio.Okio;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JsonStreamParser {
    public static boolean tryToParse(String raw, Visitor visitor, PathCursor pathCursor) {
        if (raw.startsWith("{") && raw.endsWith("}") || raw.startsWith("[") && raw.endsWith("]")) {
            boolean bl;
            ByteArrayInputStream is = new ByteArrayInputStream(raw.getBytes());
            try {
                bl = JsonStreamParser.tryToParse(is, visitor, pathCursor.copy());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    visitor.expandValueFailed(pathCursor, e);
                }
            }
            ((InputStream)is).close();
            return bl;
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean tryToParse(InputStream is, Visitor visitor, PathCursor pathCursor) {
        block17: {
            try (BufferedSource source = Okio.buffer(Okio.source(is));){
                boolean bl;
                block18: {
                    byte firstByte = source.peek().readByte();
                    if (firstByte != 123 && firstByte != 91) break block17;
                    JsonReader reader = JsonReader.of(source);
                    try {
                        reader.setLenient(true);
                        JsonStreamParser.tryToParse(reader, visitor, pathCursor);
                        bl = true;
                        if (reader == null) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            visitor.expandValueFailed(pathCursor, e);
                            break block17;
                        }
                    }
                    reader.close();
                }
                return bl;
            }
            catch (Exception e) {
                visitor.expandValueFailed(pathCursor, e);
            }
        }
        return false;
    }

    private static void tryToParse(JsonReader reader, Visitor visitor, PathCursor pathCursor) throws IOException {
        while (visitor.keepParsing(pathCursor)) {
            switch (reader.peek()) {
                case END_DOCUMENT: {
                    return;
                }
                case BEGIN_ARRAY: {
                    if (visitor.visitCompound(pathCursor)) {
                        reader.beginArray();
                        pathCursor.push(0);
                        break;
                    }
                    reader.skipValue();
                    pathCursor.advance();
                    break;
                }
                case BEGIN_OBJECT: {
                    if (visitor.visitCompound(pathCursor)) {
                        reader.beginObject();
                        break;
                    }
                    reader.skipValue();
                    pathCursor.advance();
                    break;
                }
                case NAME: {
                    String key = reader.nextName();
                    pathCursor.push(key);
                    break;
                }
                case END_ARRAY: {
                    reader.endArray();
                    pathCursor.pop();
                    pathCursor.advance();
                    break;
                }
                case END_OBJECT: {
                    reader.endObject();
                    pathCursor.advance();
                    break;
                }
                case BOOLEAN: {
                    if (visitor.visitPrimitive(pathCursor)) {
                        visitor.booleanValue(pathCursor, reader.nextBoolean());
                    } else {
                        reader.skipValue();
                    }
                    pathCursor.advance();
                    break;
                }
                case STRING: {
                    if (!visitor.visitPrimitive(pathCursor)) {
                        reader.skipValue();
                    } else {
                        String str = reader.nextString();
                        if (!JsonStreamParser.tryToParse(str, visitor, pathCursor)) {
                            visitor.stringValue(pathCursor, str);
                        }
                    }
                    pathCursor.advance();
                    break;
                }
                case NUMBER: {
                    if (!visitor.visitPrimitive(pathCursor)) {
                        reader.skipValue();
                    } else {
                        String numberStr = reader.nextString();
                        if (!(JsonStreamParser.tryToParseInt(visitor, pathCursor, numberStr) || JsonStreamParser.tryToParseLong(visitor, pathCursor, numberStr) || JsonStreamParser.tryToParseDouble(visitor, pathCursor, numberStr))) {
                            visitor.stringValue(pathCursor, numberStr);
                        }
                    }
                    pathCursor.advance();
                    break;
                }
                case NULL: {
                    if (visitor.visitPrimitive(pathCursor)) {
                        reader.nextNull();
                        visitor.nullValue(pathCursor);
                    } else {
                        reader.skipValue();
                    }
                    pathCursor.advance();
                }
            }
        }
    }

    private static boolean tryToParseInt(Visitor visitor, PathCursor path, String str) {
        try {
            visitor.intValue(path, Integer.parseInt(str));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean tryToParseLong(Visitor visitor, PathCursor path, String str) {
        try {
            visitor.longValue(path, Long.parseLong(str));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean tryToParseDouble(Visitor visitor, PathCursor path, String str) {
        try {
            visitor.doubleValue(path, Double.parseDouble(str));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static interface Visitor {
        public boolean visitCompound(PathCursor var1);

        public boolean visitPrimitive(PathCursor var1);

        public void booleanValue(PathCursor var1, boolean var2);

        public void stringValue(PathCursor var1, String var2);

        public void intValue(PathCursor var1, int var2);

        public void longValue(PathCursor var1, long var2);

        public void doubleValue(PathCursor var1, double var2);

        public void nullValue(PathCursor var1);

        public boolean keepParsing(PathCursor var1);

        public void expandValueFailed(PathCursor var1, Exception var2);
    }
}

