/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.tagprocessor;

import datadog.trace.api.Config;
import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.TagMap;
import ddtrot.dd.trace.api.telemetry.LogCollector;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessor;
import ddtrot.dd.trace.core.util.JsonStreamParser;
import ddtrot.dd.trace.payloadtags.PayloadTagsData;
import ddtrot.dd.trace.util.json.JsonPath;
import ddtrot.dd.trace.util.json.JsonPathParser;
import ddtrot.dd.trace.util.json.PathCursor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PayloadTagsProcessor
extends TagsPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(PayloadTagsProcessor.class);
    private static final String REDACTED = "redacted";
    private static final String BINARY = "<binary>";
    private static final String DD_PAYLOAD_TAGS_INCOMPLETE = "_dd.payload_tags_incomplete";
    final Map<String, RedactionRules> redactionRulesByTagPrefix;
    final int maxDepth;
    final int maxTags;

    @Nullable
    public static PayloadTagsProcessor create(Config config) {
        HashMap<String, RedactionRules> redactionRulesByTagPrefix = new HashMap<String, RedactionRules>();
        if (config.isCloudRequestPayloadTaggingEnabled()) {
            redactionRulesByTagPrefix.put("aws.request.body", new RedactionRules.Builder().addRedactionJsonPaths(ConfigDefaults.DEFAULT_CLOUD_COMMON_PAYLOAD_TAGGING).addRedactionJsonPaths(ConfigDefaults.DEFAULT_CLOUD_REQUEST_PAYLOAD_TAGGING).addParsedRedactionJsonPaths(config.getCloudRequestPayloadTagging()).build());
        }
        if (config.isCloudResponsePayloadTaggingEnabled()) {
            redactionRulesByTagPrefix.put("aws.response.body", new RedactionRules.Builder().addRedactionJsonPaths(ConfigDefaults.DEFAULT_CLOUD_COMMON_PAYLOAD_TAGGING).addRedactionJsonPaths(ConfigDefaults.DEFAULT_CLOUD_RESPONSE_PAYLOAD_TAGGING).addParsedRedactionJsonPaths(config.getCloudResponsePayloadTagging()).build());
        }
        if (redactionRulesByTagPrefix.isEmpty()) {
            return null;
        }
        int maxDepth = config.getCloudPayloadTaggingMaxDepth();
        int maxTags = config.getCloudPayloadTaggingMaxTags();
        return new PayloadTagsProcessor(redactionRulesByTagPrefix, maxDepth, maxTags);
    }

    PayloadTagsProcessor(Map<String, RedactionRules> redactionRulesByTagPrefix, int maxDepth, int maxTags) {
        this.redactionRulesByTagPrefix = redactionRulesByTagPrefix;
        this.maxDepth = maxDepth;
        this.maxTags = maxTags;
    }

    @Override
    public void processTags(TagMap unsafeTags, DDSpanContext spanContext, List<AgentSpanLink> spanLinks) {
        int spanMaxTags = this.maxTags + unsafeTags.size();
        for (Map.Entry<String, RedactionRules> tagPrefixRedactionRules : this.redactionRulesByTagPrefix.entrySet()) {
            String tagPrefix = tagPrefixRedactionRules.getKey();
            RedactionRules redactionRules = tagPrefixRedactionRules.getValue();
            Object tagValue = unsafeTags.getObject(tagPrefix);
            if (tagValue instanceof PayloadTagsData) {
                if (unsafeTags.remove(tagPrefix)) {
                    --spanMaxTags;
                }
                PayloadTagsData payloadTagsData = (PayloadTagsData)tagValue;
                PayloadTagsCollector payloadTagsCollector = new PayloadTagsCollector(this.maxDepth, spanMaxTags, redactionRules, tagPrefix, unsafeTags);
                this.collectPayloadTags(payloadTagsData, payloadTagsCollector);
                continue;
            }
            if (tagValue == null) continue;
            log.debug(LogCollector.SEND_TELEMETRY, "Expected PayloadTagsData for known payload tag '{}', but got '{}'", (Object)tagPrefix, tagValue);
        }
    }

    private void collectPayloadTags(PayloadTagsData payloadTagsData, PayloadTagsCollector payloadTagsCollector) {
        for (PayloadTagsData.PathAndValue pathAndValue : payloadTagsData.pathAndValues) {
            if (pathAndValue.path.length > this.maxDepth) continue;
            if (!payloadTagsCollector.keepCollectingTags()) break;
            PathCursor cursor = new PathCursor(pathAndValue.path, this.maxDepth);
            if (!payloadTagsCollector.notRedacted(cursor)) continue;
            Object value = pathAndValue.value;
            if (value instanceof InputStream) {
                if (JsonStreamParser.tryToParse((InputStream)value, (JsonStreamParser.Visitor)payloadTagsCollector, cursor)) continue;
                payloadTagsCollector.stringValue(cursor, BINARY);
                continue;
            }
            if (value instanceof String) {
                String str = (String)value;
                if (JsonStreamParser.tryToParse(str, (JsonStreamParser.Visitor)payloadTagsCollector, cursor)) continue;
                payloadTagsCollector.stringValue(cursor, str);
                continue;
            }
            if (value instanceof Boolean) {
                payloadTagsCollector.booleanValue(cursor, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                payloadTagsCollector.intValue(cursor, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                payloadTagsCollector.longValue(cursor, (Long)value);
                continue;
            }
            if (value instanceof Double) {
                payloadTagsCollector.doubleValue(cursor, (Double)value);
                continue;
            }
            if (value == null) {
                payloadTagsCollector.nullValue(cursor);
                continue;
            }
            payloadTagsCollector.stringValue(cursor, String.valueOf(value));
        }
    }

    static final class RedactionRules {
        private final List<JsonPath> paths;

        private RedactionRules(List<JsonPath> paths) {
            this.paths = paths;
        }

        public JsonPath findMatching(PathCursor pathCursor) {
            for (JsonPath jp : this.paths) {
                if (!jp.matches(pathCursor)) continue;
                return jp;
            }
            return null;
        }

        public static final class Builder {
            private final List<JsonPath> redactionRules = new ArrayList<JsonPath>();

            public Builder addRedactionJsonPaths(List<String> jsonPaths) {
                this.redactionRules.addAll(JsonPathParser.parseJsonPaths(jsonPaths));
                return this;
            }

            public Builder addParsedRedactionJsonPaths(List<JsonPath> jsonPaths) {
                if (null == jsonPaths) {
                    log.warn("Provided JsonPaths list is null, skipping.");
                    return this;
                }
                this.redactionRules.addAll(jsonPaths);
                return this;
            }

            RedactionRules build() {
                return new RedactionRules(this.redactionRules);
            }
        }
    }

    private static final class PayloadTagsCollector
    implements JsonStreamParser.Visitor {
        private final int maxTags;
        private final int maxDepth;
        private final RedactionRules redactionRules;
        private final String tagPrefix;
        private final TagMap collectedTags;

        public PayloadTagsCollector(int maxDepth, int maxTags, RedactionRules redactionRules, String tagPrefix, TagMap collectedTags) {
            this.maxDepth = maxDepth;
            this.maxTags = maxTags;
            this.redactionRules = redactionRules;
            this.tagPrefix = tagPrefix;
            this.collectedTags = collectedTags;
        }

        @Override
        public boolean visitCompound(PathCursor path) {
            if (path.length() < this.maxDepth) {
                return this.notRedacted(path);
            }
            return false;
        }

        @Override
        public boolean visitPrimitive(PathCursor path) {
            return this.notRedacted(path);
        }

        private boolean notRedacted(PathCursor path) {
            if (this.redactionRules.findMatching(path) != null) {
                this.collectedTags.put(path.toString(this.tagPrefix), (Object)PayloadTagsProcessor.REDACTED);
                return false;
            }
            return true;
        }

        @Override
        public void booleanValue(PathCursor path, boolean value) {
            this.collectedTags.put(path.toString(this.tagPrefix), (Object)value);
        }

        @Override
        public void stringValue(PathCursor path, String value) {
            this.collectedTags.put(path.toString(this.tagPrefix), (Object)value);
        }

        @Override
        public void intValue(PathCursor path, int value) {
            this.collectedTags.put(path.toString(this.tagPrefix), (Object)value);
        }

        @Override
        public void longValue(PathCursor path, long value) {
            this.collectedTags.put(path.toString(this.tagPrefix), (Object)value);
        }

        @Override
        public void doubleValue(PathCursor path, double value) {
            this.collectedTags.put(path.toString(this.tagPrefix), (Object)value);
        }

        @Override
        public void nullValue(PathCursor path) {
            this.collectedTags.put(path.toString(this.tagPrefix), (Object)null);
        }

        @Override
        public boolean keepParsing(PathCursor path) {
            return this.keepCollectingTags();
        }

        public boolean keepCollectingTags() {
            if (this.collectedTags.size() < this.maxTags) {
                return true;
            }
            this.collectedTags.put(PayloadTagsProcessor.DD_PAYLOAD_TAGS_INCOMPLETE, (Object)true);
            return false;
        }

        @Override
        public void expandValueFailed(PathCursor path, Exception exception) {
            log.debug(LogCollector.EXCLUDE_TELEMETRY, "Failed to expand value at path '{}'", (Object)path.toString(""), (Object)exception);
        }
    }
}

