/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.remoteconfig;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.telemetry.LogCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNameCollector {
    private static final Logger log = LoggerFactory.getLogger(ServiceNameCollector.class);
    private static final int MAX_EXTRA_SERVICE = Config.get().getRemoteConfigMaxExtraServices();
    private static ServiceNameCollector INSTANCE = new ServiceNameCollector();
    private final ConcurrentHashMap<String, String> services = new ConcurrentHashMap(MAX_EXTRA_SERVICE);
    volatile boolean limitReachedLogged = false;

    public static ServiceNameCollector get() {
        return INSTANCE;
    }

    private ServiceNameCollector() {
    }

    public void addService(String serviceName) {
        if (serviceName == null || serviceName.isEmpty()) {
            return;
        }
        if (this.services.size() >= MAX_EXTRA_SERVICE) {
            if (!this.limitReachedLogged) {
                log.debug(LogCollector.SEND_TELEMETRY, "extra service limit({}) reached: service {} can't be added", (Object)MAX_EXTRA_SERVICE, (Object)serviceName);
                this.limitReachedLogged = true;
            }
            return;
        }
        this.services.putIfAbsent(serviceName, serviceName);
    }

    @Nullable
    public List<String> getServices() {
        if (this.services.isEmpty()) {
            return null;
        }
        TreeSet uniqueNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        uniqueNames.addAll(this.services.keySet());
        uniqueNames.remove(Config.get().getServiceName());
        return uniqueNames.isEmpty() ? null : new ArrayList(uniqueNames);
    }

    public void clear() {
        this.services.clear();
    }
}

