/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.instrument.utils;

import ddtrot.dd.instrument.utils.ClassLoaderIndex;
import ddtrot.dd.instrument.utils.ClassLoaderKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;

public abstract class ClassLoaderValue<V> {
    private static final AtomicReferenceFieldUpdater<ClassLoaderValue, Object> BOOT_VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ClassLoaderValue.class, Object.class, "bootValue");
    private static final AtomicReferenceFieldUpdater<ClassLoaderValue, Object> SYSTEM_VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ClassLoaderValue.class, Object.class, "systemValue");
    private volatile V bootValue;
    private volatile V systemValue;
    private final Map<ClassLoaderKey, V> otherValues = new ConcurrentHashMap<ClassLoaderKey, V>();

    protected ClassLoaderValue() {
        ClassLoaderKey.registerCleaner(this.otherValues::remove);
    }

    protected abstract V computeValue(ClassLoader var1);

    public final V get(ClassLoader cl) {
        if (cl == ClassLoaderKey.BOOT_CLASS_LOADER) {
            return this.getBootValue();
        }
        if (cl == ClassLoaderKey.SYSTEM_CLASS_LOADER) {
            return this.getSystemValue();
        }
        return this.getOtherValue(cl);
    }

    public final void remove(ClassLoader cl) {
        if (cl == ClassLoaderKey.BOOT_CLASS_LOADER) {
            this.bootValue = null;
        } else if (cl == ClassLoaderKey.SYSTEM_CLASS_LOADER) {
            this.systemValue = null;
        } else {
            this.otherValues.remove(new ClassLoaderKey.LookupKey(cl));
        }
    }

    public final void clear() {
        this.bootValue = null;
        this.systemValue = null;
        this.otherValues.clear();
    }

    public final void visit(BiConsumer<ClassLoader, V> visitor) {
        if (this.bootValue != null) {
            visitor.accept(ClassLoaderKey.BOOT_CLASS_LOADER, this.bootValue);
        }
        if (this.systemValue != null) {
            visitor.accept(ClassLoaderKey.SYSTEM_CLASS_LOADER, this.systemValue);
        }
        for (Map.Entry<ClassLoaderKey, V> entry : this.otherValues.entrySet()) {
            ClassLoader cl = (ClassLoader)entry.getKey().get();
            if (cl == null) continue;
            visitor.accept(cl, entry.getValue());
        }
    }

    final int size() {
        return (this.bootValue != null ? 1 : 0) + (this.systemValue != null ? 1 : 0) + this.otherValues.size();
    }

    public static void removeStaleEntries() {
        ClassLoaderKey.cleanStaleKeys();
    }

    private V getBootValue() {
        V value;
        while ((value = this.bootValue) == null && !BOOT_VALUE_UPDATER.compareAndSet(this, null, value = Objects.requireNonNull(this.computeValue(ClassLoaderKey.BOOT_CLASS_LOADER)))) {
        }
        return value;
    }

    private V getSystemValue() {
        V value;
        while ((value = this.systemValue) == null && !SYSTEM_VALUE_UPDATER.compareAndSet(this, null, value = Objects.requireNonNull(this.computeValue(ClassLoaderKey.SYSTEM_CLASS_LOADER)))) {
        }
        return value;
    }

    private V computeValueForKey(ClassLoaderKey key) {
        return this.computeValue((ClassLoader)key.get());
    }

    private V getOtherValue(ClassLoader cl) {
        Object value = this.otherValues.get(new ClassLoaderKey.LookupKey(cl));
        if (value == null) {
            value = this.otherValues.computeIfAbsent(ClassLoaderIndex.getClassLoaderKey(cl), this::computeValueForKey);
        }
        return value;
    }
}

