/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.instrument.glue;

import ddtrot.dd.instrument.utils.JVM;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.MissingResourceException;
import java.util.Objects;

public final class Glue {
    private static final String GLUE_RESOURCE_PREFIX = "/ddtrot/dd/instrument/glue/";

    private Glue() {
    }

    public static byte[] unpackBytecode(String bytecode) {
        return bytecode.getBytes(StandardCharsets.UTF_16BE);
    }

    public static byte[] loadBytecode(Class<?> host, String glueName) {
        byte[] byArray;
        block8: {
            String glueResource = GLUE_RESOURCE_PREFIX + glueName;
            InputStream is = Objects.requireNonNull(host.getResourceAsStream(glueResource));
            try {
                byArray = JVM.readAllBytes(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    String detail = "Cannot load " + glueResource + " from " + host + ": " + e;
                    throw new MissingResourceException(detail, host.getName(), glueResource);
                }
            }
            is.close();
        }
        return byArray;
    }
}

