/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.instrument.classmatch;

import ddtrot.dd.instrument.classmatch.ClassHeader;
import ddtrot.dd.instrument.classmatch.ClassOutline;
import ddtrot.dd.instrument.classmatch.FieldOutline;
import ddtrot.dd.instrument.classmatch.MethodOutline;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ClassFile {
    static final String JAVA_LANG_OBJECT = "java/lang/Object";
    static final String STATIC_INITIALIZER = "<clinit>";
    static final String CONSTRUCTOR = "<init>";
    static final String SIMPLE_CALL = "()V";
    private static final String[] NO_INTERFACES = new String[0];
    private static final FieldOutline[] NO_FIELDS = new FieldOutline[0];
    private static final MethodOutline[] NO_METHODS = new MethodOutline[0];
    private static final String[] NO_ANNOTATIONS = new String[0];
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_MODULE = 32768;
    private static final byte[] RUNTIME_ANNOTATIONS = "RuntimeVisibleAnnotations".getBytes(StandardCharsets.US_ASCII);
    private static final Map<String, UtfKey> annotationKeys = new HashMap<String, UtfKey>();
    private static volatile Map<UtfKey, String> annotationsOfInterest;

    private ClassFile() {
    }

    public static ClassHeader header(byte[] bytecode) {
        return ClassFile.parse(bytecode, 0, true);
    }

    public static ClassHeader header(byte[] bytecode, int offset) {
        return ClassFile.parse(bytecode, offset, true);
    }

    public static ClassOutline outline(byte[] bytecode) {
        return (ClassOutline)ClassFile.parse(bytecode, 0, false);
    }

    public static ClassOutline outline(byte[] bytecode, int offset) {
        return (ClassOutline)ClassFile.parse(bytecode, offset, false);
    }

    public static synchronized void annotationOfInterest(String internalName) {
        if (annotationKeys.containsKey(internalName)) {
            return;
        }
        HashMap<UtfKey, String> ofInterest = new HashMap<UtfKey, String>();
        if (annotationsOfInterest != null) {
            ofInterest.putAll(annotationsOfInterest);
        }
        ofInterest.put(annotationKeys.computeIfAbsent(internalName, ClassFile::annotationKey), internalName);
        annotationsOfInterest = ofInterest;
    }

    public static synchronized void annotationsOfInterest(Collection<String> internalNames) {
        if (annotationKeys.keySet().containsAll(internalNames)) {
            return;
        }
        HashMap<UtfKey, String> ofInterest = new HashMap<UtfKey, String>();
        if (annotationsOfInterest != null) {
            ofInterest.putAll(annotationsOfInterest);
        }
        for (String internalName : internalNames) {
            ofInterest.put(annotationKeys.computeIfAbsent(internalName, ClassFile::annotationKey), internalName);
        }
        annotationsOfInterest = ofInterest;
    }

    private static UtfKey annotationKey(String internalName) {
        byte[] descriptor = ('L' + internalName + ';').getBytes(StandardCharsets.US_ASCII);
        return new UtfKey(descriptor);
    }

    private static ClassHeader parse(byte[] bytecode, int offset, boolean onlyHeader) {
        MethodOutline[] methods;
        FieldOutline[] fields;
        String[] interfaces;
        String superName;
        int cursor = offset + 8;
        int cpLen = ClassFile.u2(bytecode, cursor);
        cursor += 2;
        int[] cp = new int[cpLen];
        for (int i = 1; i < cpLen; ++i) {
            byte tag;
            if ((tag = bytecode[cursor++]) == 1) {
                cp[i] = cursor;
                cursor += ClassFile.u2(bytecode, cursor);
            } else if (tag == 7) {
                cp[i] = ClassFile.u2(bytecode, cursor);
            } else {
                switch (tag) {
                    case 8: 
                    case 16: 
                    case 19: 
                    case 20: {
                        break;
                    }
                    case 15: {
                        ++cursor;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 17: 
                    case 18: {
                        cursor += 2;
                        break;
                    }
                    case 5: 
                    case 6: {
                        cursor += 6;
                        ++i;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            cursor += 2;
        }
        int access = ClassFile.u2(bytecode, cursor);
        String className = ClassFile.utf(bytecode, cp[cp[ClassFile.u2(bytecode, cursor += 2)]]);
        cursor += 2;
        if ((access & 0x200) != 0) {
            superName = JAVA_LANG_OBJECT;
        } else if (access != 32768) {
            superName = ClassFile.utf(bytecode, cp[cp[ClassFile.u2(bytecode, cursor)]]);
            if (JAVA_LANG_OBJECT.equals(superName)) {
                superName = JAVA_LANG_OBJECT;
            }
        } else {
            superName = null;
        }
        int interfacesCount = ClassFile.u2(bytecode, cursor += 2);
        cursor += 2;
        if (interfacesCount > 0) {
            interfaces = new String[interfacesCount];
            for (int i = 0; i < interfacesCount; ++i) {
                interfaces[i] = ClassFile.utf(bytecode, cp[cp[ClassFile.u2(bytecode, cursor)]]);
                cursor += 2;
            }
        } else {
            interfaces = NO_INTERFACES;
        }
        if (onlyHeader) {
            return new ClassHeader(access, className, superName, interfaces);
        }
        int fieldsCount = ClassFile.u2(bytecode, cursor);
        cursor += 2;
        if (fieldsCount > 0) {
            fields = new FieldOutline[fieldsCount];
            for (int i = 0; i < fieldsCount; ++i) {
                int fieldAccess = ClassFile.u2(bytecode, cursor);
                String fieldName = ClassFile.utf(bytecode, cp[ClassFile.u2(bytecode, cursor += 2)]);
                String descriptor = ClassFile.utf(bytecode, cp[ClassFile.u2(bytecode, cursor += 2)]);
                int attributesCount = ClassFile.u2(bytecode, cursor += 2);
                cursor += 2;
                for (int j = 0; j < attributesCount; ++j) {
                    int attributeLength = ClassFile.u4(bytecode, cursor += 2);
                    cursor += 4;
                    cursor += attributeLength;
                }
                fields[i] = new FieldOutline(fieldAccess, fieldName, descriptor);
            }
        } else {
            fields = NO_FIELDS;
        }
        int methodsCount = ClassFile.u2(bytecode, cursor);
        cursor += 2;
        if (methodsCount > 0) {
            methods = new MethodOutline[methodsCount];
            for (int i = 0; i < methodsCount; ++i) {
                String descriptor;
                int methodAccess = ClassFile.u2(bytecode, cursor);
                String methodName = ClassFile.utf(bytecode, cp[ClassFile.u2(bytecode, cursor += 2)]);
                if (CONSTRUCTOR.equals(methodName)) {
                    methodName = CONSTRUCTOR;
                }
                if (SIMPLE_CALL.equals(descriptor = ClassFile.utf(bytecode, cp[ClassFile.u2(bytecode, cursor += 2)]))) {
                    descriptor = SIMPLE_CALL;
                }
                String[] annotations = NO_ANNOTATIONS;
                Map<UtfKey, String> ofInterest = annotationsOfInterest;
                int attributesCount = ClassFile.u2(bytecode, cursor += 2);
                cursor += 2;
                for (int j = 0; j < attributesCount; ++j) {
                    int nameIndex = ClassFile.u2(bytecode, cursor);
                    int attributeLength = ClassFile.u4(bytecode, cursor += 2);
                    cursor += 4;
                    if (ofInterest != null && ClassFile.utfEquals(bytecode, cp[nameIndex], RUNTIME_ANNOTATIONS)) {
                        annotations = ClassFile.parseAnnotations(ofInterest, bytecode, cursor, cp);
                        ofInterest = null;
                    }
                    cursor += attributeLength;
                }
                methods[i] = new MethodOutline(methodAccess, methodName, descriptor, annotations);
            }
        } else {
            methods = NO_METHODS;
        }
        String[] annotations = NO_ANNOTATIONS;
        Map<UtfKey, String> ofInterest = annotationsOfInterest;
        int attributesCount = ClassFile.u2(bytecode, cursor);
        cursor += 2;
        for (int j = 0; j < attributesCount; ++j) {
            int nameIndex = ClassFile.u2(bytecode, cursor);
            int attributeLength = ClassFile.u4(bytecode, cursor += 2);
            cursor += 4;
            if (ofInterest != null && ClassFile.utfEquals(bytecode, cp[nameIndex], RUNTIME_ANNOTATIONS)) {
                annotations = ClassFile.parseAnnotations(ofInterest, bytecode, cursor, cp);
                ofInterest = null;
            }
            cursor += attributeLength;
        }
        return new ClassOutline(access, className, superName, interfaces, fields, methods, annotations);
    }

    private static int u2(byte[] bytecode, int cursor) {
        return (0xFF & bytecode[cursor]) << 8 | 0xFF & bytecode[cursor + 1];
    }

    private static int u4(byte[] bytecode, int cursor) {
        return (0xFF & bytecode[cursor]) << 24 | (0xFF & bytecode[cursor + 1]) << 16 | (0xFF & bytecode[cursor + 2]) << 8 | 0xFF & bytecode[cursor + 3];
    }

    private static String utf(byte[] bytecode, int utfOffset) {
        int utfLen = ClassFile.u2(bytecode, utfOffset);
        int utfStart = utfOffset + 2;
        int utfEnd = utfStart + utfLen;
        char[] chars = null;
        for (int u = utfStart; u < utfEnd; ++u) {
            if ((bytecode[u] & 0x80) == 0) continue;
            chars = new char[utfLen];
            break;
        }
        if (chars == null) {
            return new String(bytecode, utfStart, utfLen, StandardCharsets.US_ASCII);
        }
        int charLen = 0;
        for (int u = utfStart; u < utfEnd; ++u) {
            byte b = bytecode[u];
            int c = (b & 0x80) == 0 ? b & 0x7F : ((b & 0xE0) == 192 ? ((b & 0x1F) << 6) + (bytecode[++u] & 0x3F) : ((b & 0xF) << 12) + ((bytecode[++u] & 0x3F) << 6) + (bytecode[++u] & 0x3F));
            chars[charLen++] = (char)c;
        }
        return new String(chars, 0, charLen);
    }

    private static boolean utfEquals(byte[] bytecode, int utfOffset, byte[] expected) {
        int expectedLen = expected.length;
        if (ClassFile.u2(bytecode, utfOffset) == expectedLen) {
            return ClassFile.sameBytes(expected, 0, expectedLen, bytecode, utfOffset + 2);
        }
        return false;
    }

    private static String[] parseAnnotations(Map<UtfKey, String> ofInterest, byte[] bytecode, int cursor, int[] cp) {
        int annotationsCount = ClassFile.u2(bytecode, cursor);
        cursor += 2;
        String[] annotations = NO_ANNOTATIONS;
        for (int i = 0; i < annotationsCount; ++i) {
            int utfLen;
            int utfOffset = cp[ClassFile.u2(bytecode, cursor)];
            String annotation = ofInterest.get(new UtfKey(bytecode, utfOffset + 2, utfLen = ClassFile.u2(bytecode, utfOffset)));
            if (annotation != null) {
                int oldLen = annotations.length;
                annotations = Arrays.copyOf(annotations, oldLen + 1);
                annotations[oldLen] = annotation;
            }
            cursor = ClassFile.nextAnnotationOffset(bytecode, cursor);
        }
        return annotations;
    }

    private static int nextAnnotationOffset(byte[] bytecode, int cursor) {
        int elementPairCount = ClassFile.u2(bytecode, cursor += 2);
        cursor += 2;
        for (int i = 0; i < elementPairCount; ++i) {
            cursor += 2;
            cursor = ClassFile.nextAnnotationElementOffset(bytecode, cursor);
        }
        return cursor;
    }

    private static int nextAnnotationElementOffset(byte[] bytecode, int cursor) {
        switch (bytecode[cursor++]) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 99: 
            case 115: {
                return cursor + 2;
            }
            case 101: {
                return cursor + 4;
            }
            case 64: {
                return ClassFile.nextAnnotationOffset(bytecode, cursor);
            }
            case 91: {
                int elementCount = ClassFile.u2(bytecode, cursor);
                cursor += 2;
                for (int i = 0; i < elementCount; ++i) {
                    cursor = ClassFile.nextAnnotationElementOffset(bytecode, cursor);
                }
                return cursor;
            }
        }
        throw new IllegalArgumentException();
    }

    static boolean sameBytes(byte[] bytes, int start, int end, byte[] otherBytes, int otherStart) {
        int i = start;
        int j = otherStart;
        while (i < end) {
            if (bytes[i] != otherBytes[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    static int hashBytes(byte[] bytes, int start, int end) {
        int hash = 1;
        for (int i = start; i < end; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    static final class UtfKey {
        private final byte[] bytes;
        private final int start;
        private final int len;
        private final int hash;

        UtfKey(byte[] bytes) {
            this(bytes, 0, bytes.length);
        }

        UtfKey(byte[] bytes, int start, int len) {
            this.bytes = bytes;
            this.start = start;
            this.len = len;
            this.hash = ClassFile.hashBytes(bytes, start, start + len);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UtfKey) {
                UtfKey other = (UtfKey)obj;
                if (this.len == other.len) {
                    return ClassFile.sameBytes(this.bytes, this.start, this.start + this.len, other.bytes, other.start);
                }
            }
            return false;
        }
    }
}

