/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.serialization.custom.aiguard;

import ddtrot.dd.communication.serialization.EncodingCache;
import ddtrot.dd.communication.serialization.ValueWriter;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.trace.api.aiguard.AIGuard;
import ddtrot.dd.trace.util.Strings;
import java.util.List;

public class MessageWriter
implements ValueWriter<AIGuard.Message> {
    @Override
    public void write(AIGuard.Message value, Writable writable, EncodingCache encodingCache) {
        int[] size = new int[]{0};
        boolean hasRole = MessageWriter.isNotBlank(value.getRole(), size);
        boolean hasContent = MessageWriter.isNotBlank(value.getContent(), size);
        boolean hasToolCallId = MessageWriter.isNotBlank(value.getToolCallId(), size);
        boolean hasToolCalls = MessageWriter.isNotEmpty(value.getToolCalls(), size);
        writable.startMap(size[0]);
        MessageWriter.writeString(hasRole, "role", value.getRole(), writable, encodingCache);
        MessageWriter.writeString(hasContent, "content", value.getContent(), writable, encodingCache);
        MessageWriter.writeString(hasToolCallId, "tool_call_id", value.getToolCallId(), writable, encodingCache);
        MessageWriter.writeToolCallArray(hasToolCalls, "tool_calls", value.getToolCalls(), writable, encodingCache);
    }

    private static void writeString(boolean present, String key, String value, Writable writable, EncodingCache encodingCache) {
        if (present) {
            writable.writeString(key, encodingCache);
            writable.writeString(value, encodingCache);
        }
    }

    private static void writeToolCallArray(boolean present, String key, List<AIGuard.ToolCall> values, Writable writable, EncodingCache encodingCache) {
        if (present) {
            writable.writeString(key, encodingCache);
            writable.writeObject(values, encodingCache);
        }
    }

    private static boolean isNotBlank(String value, int[] nonBlankCount) {
        boolean hasText = Strings.isNotBlank(value);
        if (hasText) {
            nonBlankCount[0] = nonBlankCount[0] + 1;
        }
        return hasText;
    }

    private static boolean isNotEmpty(List<?> value, int[] nonEmptyCount) {
        boolean nonEmpty;
        boolean bl = nonEmpty = value != null && !value.isEmpty();
        if (nonEmpty) {
            nonEmptyCount[0] = nonEmptyCount[0] + 1;
        }
        return nonEmpty;
    }
}

