/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.serialization;

import ddtrot.dd.communication.serialization.ByteBufferConsumer;
import ddtrot.dd.communication.serialization.StreamingBuffer;
import java.nio.ByteBuffer;

public final class FlushingBuffer
implements StreamingBuffer {
    private final ByteBuffer buffer;
    private final ByteBufferConsumer consumer;
    private int messageCount;
    private int mark;

    public FlushingBuffer(int capacity, ByteBufferConsumer consumer) {
        this.buffer = ByteBuffer.allocate(capacity);
        this.consumer = consumer;
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public boolean isDirty() {
        return this.mark > 0;
    }

    @Override
    public void mark() {
        int current = this.buffer.position();
        if (current != this.mark) {
            ++this.messageCount;
            this.mark = current;
        }
    }

    @Override
    public boolean flush() {
        if (this.messageCount == 0) {
            return false;
        }
        this.buffer.limit(this.mark);
        this.buffer.flip();
        ByteBuffer toPublish = this.buffer.slice();
        this.consumer.accept(this.messageCount, toPublish);
        this.reset();
        return true;
    }

    @Override
    public void put(byte b) {
        this.buffer.put(b);
    }

    @Override
    public void putShort(short s) {
        this.buffer.putShort(s);
    }

    @Override
    public void putChar(char c) {
        this.buffer.putChar(c);
    }

    @Override
    public void putInt(int i) {
        this.buffer.putInt(i);
    }

    @Override
    public void putLong(long l) {
        this.buffer.putLong(l);
    }

    @Override
    public void putFloat(float f) {
        this.buffer.putFloat(f);
    }

    @Override
    public void putDouble(double d) {
        this.buffer.putDouble(d);
    }

    @Override
    public void put(byte[] bytes) {
        this.buffer.put(bytes);
    }

    @Override
    public void put(byte[] bytes, int offset, int length) {
        this.buffer.put(bytes, offset, length);
    }

    @Override
    public void put(ByteBuffer buffer) {
        this.buffer.put(buffer);
    }

    @Override
    public void reset() {
        this.messageCount = 0;
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
        this.mark = 0;
    }

    int getMessageCount() {
        return this.messageCount;
    }
}

