/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.common.socket;

import datadog.trace.api.Config;
import ddtrot.dd.common.filesystem.Files;
import ddtrot.dd.environment.OperatingSystem;
import ddtrot.dd.environment.SystemProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketUtils {
    private static final Logger log = LoggerFactory.getLogger(SocketUtils.class);

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static String discoverApmSocket(Config config) {
        String unixDomainSocket = config.getAgentUnixDomainSocket();
        if (!OperatingSystem.isWindows()) {
            if (unixDomainSocket == null && Config.get().isAgentConfiguredUsingDefault() && Files.exists(new File("/var/run/datadog/apm.socket"))) {
                log.info("Detected {}.  Using it to send trace data.", (Object)"/var/run/datadog/apm.socket");
                unixDomainSocket = "/var/run/datadog/apm.socket";
            }
        } else if (unixDomainSocket != null) {
            log.warn("{} setting not supported on {}. Reverting to the default.", (Object)"trace.agent.unix.domain.socket", (Object)SystemProperties.get("os.name"));
            unixDomainSocket = null;
        }
        return unixDomainSocket;
    }
}

