/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.datadoghq.sketch.ddsketch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Serializer {
    private static final int VARINT = 0;
    private static final int FIXED_64 = 1;
    private static final int LENGTH_DELIMITED = 2;
    private static final int[] VAR_INT_LENGTHS_32 = new int[33];
    private final ByteBuffer buffer;

    public Serializer(int size) {
        this.buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer getBuffer() {
        this.buffer.flip();
        return this.buffer;
    }

    public void writeHeader(int fieldNumber, int length) {
        this.writeTag(fieldNumber, 2);
        this.writeVarInt(length);
    }

    public void writeCompactArray(int fieldIndex, double[] array, int from, int length) {
        this.writeTag(fieldIndex, 2);
        this.writeVarInt(length * 8);
        for (int i = from; i < from + length; ++i) {
            this.buffer.putDouble(array[i]);
        }
    }

    public void writeDouble(int fieldIndex, double value) {
        if (value != 0.0) {
            this.writeTag(fieldIndex, 1);
            this.buffer.putDouble(value);
        }
    }

    public void writeUnsignedInt32(int fieldIndex, int value) {
        if (value != 0) {
            this.writeTag(fieldIndex, 0);
            this.writeVarInt(value);
        }
    }

    public void writeSignedInt32(int fieldIndex, int value) {
        this.writeTag(fieldIndex, 0);
        this.writeVarInt(Serializer.zigZag(value));
    }

    public void writeBin(int fieldPosition, int index, double count) {
        int length = Serializer.signedIntFieldSize(1, index) + Serializer.doubleFieldSize(2, count);
        this.writeHeader(fieldPosition, length);
        this.writeSignedInt32(1, index);
        this.writeDouble(2, count);
    }

    void writeTag(int fieldIndex, int wireType) {
        this.writeVarInt(fieldIndex << 3 | wireType);
    }

    private void writeVarInt(int value) {
        int length = Serializer.varIntLength(value);
        for (int i = 0; i < length; ++i) {
            this.buffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        this.buffer.put((byte)value);
    }

    public static int embeddedSize(int size) {
        return Serializer.varIntLength(size) + 1 + size;
    }

    public static int fieldSize(int fieldIndex, int value) {
        return value == 0 ? 0 : Serializer.tagSize(fieldIndex, 0) + Serializer.varIntLength(value) + 1;
    }

    public static int signedIntFieldSize(int fieldIndex, int value) {
        return Serializer.tagSize(fieldIndex, 0) + Serializer.varIntLength(Serializer.zigZag(value)) + 1;
    }

    public static int doubleFieldSize(int fieldIndex, double value) {
        return value == 0.0 ? 0 : Serializer.tagSize(fieldIndex, 1) + 8;
    }

    public static int embeddedFieldSize(int fieldIndex, int size) {
        return Serializer.tagSize(fieldIndex, 2) + Serializer.embeddedSize(size);
    }

    public static int sizeOfCompactDoubleArray(int fieldIndex, int size) {
        return Serializer.tagSize(fieldIndex, 2) + Serializer.embeddedSize(size * 8);
    }

    public static int sizeOfBin(int fieldPosition, int index, double count) {
        return Serializer.embeddedFieldSize(fieldPosition, Serializer.signedIntFieldSize(1, index) + Serializer.doubleFieldSize(2, count));
    }

    private static int zigZag(int signed) {
        return signed << 1 ^ signed >> 31;
    }

    private static int tagSize(int tag, int type) {
        return Serializer.varIntLength(tag << 3 | type) + 1;
    }

    private static int varIntLength(int value) {
        return VAR_INT_LENGTHS_32[Integer.numberOfLeadingZeros(value)];
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            Serializer.VAR_INT_LENGTHS_32[i] = (31 - i) / 7;
        }
    }
}

