/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.profiling;

import ddtrot.dd.trace.api.flare.TracerFlare;
import ddtrot.org.slf4j.helpers.FormattingTuple;
import ddtrot.org.slf4j.helpers.MessageFormatter;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;

public final class ProfilerFlareLogger
implements TracerFlare.Reporter {
    private final int REPORT_CAPACITY = 0x200000;
    private final List<String> flareReportLines = new ArrayList<String>();
    private int usedReportCapacity = 0;

    ProfilerFlareLogger() {
        TracerFlare.addReporter(this);
    }

    public static ProfilerFlareLogger getInstance() {
        return Singleton.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean log(String msgFormat, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)msgFormat, (Object[])args);
        StringBuilder sb = new StringBuilder(Instant.now().atZone(ZoneOffset.UTC).toString()).append('\t').append(ft.getMessage()).append('\n');
        if (ft.getThrowable() != null) {
            sb.append(ft.getThrowable());
        }
        List<String> list = this.flareReportLines;
        synchronized (list) {
            if (this.usedReportCapacity + sb.length() < 0x200000) {
                this.flareReportLines.add(sb.toString());
                this.usedReportCapacity += sb.length();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReportToFlare(ZipOutputStream zip) throws IOException {
        List<String> list = this.flareReportLines;
        synchronized (list) {
            if (!this.flareReportLines.isEmpty()) {
                TracerFlare.addText(zip, "profiler_log.txt", String.join((CharSequence)"\n", this.flareReportLines));
            }
        }
    }

    @Override
    public void cleanupAfterFlare() {
        this.cleanup();
    }

    int getUsedReportCapacity() {
        return this.usedReportCapacity;
    }

    int getMaxReportCapacity() {
        return 0x200000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int linesSize() {
        List<String> list = this.flareReportLines;
        synchronized (list) {
            return this.flareReportLines.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        List<String> list = this.flareReportLines;
        synchronized (list) {
            this.flareReportLines.clear();
            this.usedReportCapacity = 0;
        }
    }

    private static final class Singleton {
        private static final ProfilerFlareLogger INSTANCE = new ProfilerFlareLogger();

        private Singleton() {
        }
    }
}

