/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigCollector;
import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.ConfigOrigin;
import datadog.trace.api.IdGenerationStrategy;
import datadog.trace.api.InstrumenterConfig;
import datadog.trace.api.Platform;
import datadog.trace.api.ProductActivation;
import datadog.trace.api.PropagationStyle;
import datadog.trace.api.TagMap;
import datadog.trace.api.TracePropagationBehaviorExtract;
import datadog.trace.api.TracePropagationStyle;
import datadog.trace.api.UserIdCollectionMode;
import datadog.trace.api.WellKnownTags;
import datadog.trace.api.config.OtlpConfig;
import datadog.trace.api.profiling.ProfilingEnablement;
import datadog.trace.context.TraceScope;
import ddtrot.dd.environment.JavaVirtualMachine;
import ddtrot.dd.environment.OperatingSystem;
import ddtrot.dd.environment.SystemProperties;
import ddtrot.dd.trace.api.civisibility.CiVisibilityWellKnownTags;
import ddtrot.dd.trace.api.iast.IastContext;
import ddtrot.dd.trace.api.iast.IastDetectionMode;
import ddtrot.dd.trace.api.iast.telemetry.Verbosity;
import ddtrot.dd.trace.api.intake.Intake;
import ddtrot.dd.trace.api.naming.SpanNaming;
import ddtrot.dd.trace.api.rum.RumInjectorConfig;
import ddtrot.dd.trace.api.telemetry.ConfigInversionMetricCollectorImpl;
import ddtrot.dd.trace.api.telemetry.ConfigInversionMetricCollectorProvider;
import ddtrot.dd.trace.api.telemetry.LogCollector;
import ddtrot.dd.trace.api.telemetry.OtelEnvMetricCollectorImpl;
import ddtrot.dd.trace.api.telemetry.OtelEnvMetricCollectorProvider;
import ddtrot.dd.trace.bootstrap.config.provider.CapturedEnvironmentConfigSource;
import ddtrot.dd.trace.bootstrap.config.provider.ConfigProvider;
import ddtrot.dd.trace.bootstrap.config.provider.SystemPropertiesConfigSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.config.inversion.ConfigHelper;
import ddtrot.dd.trace.util.CollectionUtils;
import ddtrot.dd.trace.util.ConfigStrings;
import ddtrot.dd.trace.util.PidHelper;
import ddtrot.dd.trace.util.RandomUtils;
import ddtrot.dd.trace.util.Strings;
import ddtrot.dd.trace.util.json.JsonPath;
import ddtrot.dd.trace.util.json.JsonPathParser;
import ddtrot.dd.trace.util.throwable.FatalAgentMisconfigurationError;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final Pattern COLON = Pattern.compile(":");
    private final InstrumenterConfig instrumenterConfig;
    private final long startTimeMillis = System.currentTimeMillis();
    private final boolean timelineEventsEnabled;
    private final boolean runtimeIdEnabled;
    private final String runtimeVersion;
    private final String applicationKey;
    private final String apiKey;
    private final String site;
    private final String serviceName;
    private final boolean serviceNameSetByUser;
    private final String rootContextServiceName;
    private final boolean integrationSynapseLegacyOperationName;
    private final String writerType;
    private final boolean injectBaggageAsTagsEnabled;
    private final boolean agentConfiguredUsingDefault;
    private final String agentUrl;
    private final String agentHost;
    private final int agentPort;
    private final String agentUnixDomainSocket;
    private final String agentNamedPipe;
    private final int agentTimeout;
    private final boolean forceClearTextHttpForIntakeClient;
    private final Set<String> noProxyHosts;
    private final boolean prioritySamplingEnabled;
    private final String prioritySamplingForce;
    private final boolean traceResolverEnabled;
    private final int spanAttributeSchemaVersion;
    private final boolean peerHostNameEnabled;
    private final boolean peerServiceDefaultsEnabled;
    private final Map<String, String> peerServiceComponentOverrides;
    private final boolean removeIntegrationServiceNamesEnabled;
    private final boolean experimentalPropagateProcessTagsEnabled;
    private final Map<String, String> peerServiceMapping;
    private final Map<String, String> serviceMapping;
    private final Map<String, String> tags;
    private final Map<String, String> spanTags;
    private final Map<String, String> jmxTags;
    private final Map<String, String> requestHeaderTags;
    private final Map<String, String> responseHeaderTags;
    private final Map<String, String> baggageMapping;
    private final boolean requestHeaderTagsCommaAllowed;
    private final BitSet httpServerErrorStatuses;
    private final BitSet httpClientErrorStatuses;
    private final boolean httpServerTagQueryString;
    private final boolean httpServerRawQueryString;
    private final boolean httpServerRawResource;
    private final boolean httpServerDecodedResourcePreserveSpaces;
    private final boolean httpServerRouteBasedNaming;
    private final Map<String, String> httpServerPathResourceNameMapping;
    private final Map<String, String> httpClientPathResourceNameMapping;
    private final boolean httpResourceRemoveTrailingSlash;
    private final boolean httpClientTagQueryString;
    private final boolean httpClientTagHeaders;
    private final boolean httpClientSplitByDomain;
    private final boolean dbClientSplitByInstance;
    private final boolean dbClientSplitByInstanceTypeSuffix;
    private final boolean dbClientSplitByHost;
    private final Set<String> splitByTags;
    private final boolean jeeSplitByDeployment;
    private final int scopeDepthLimit;
    private final boolean scopeStrictMode;
    private final int scopeIterationKeepAlive;
    private final int partialFlushMinSpans;
    private final int traceKeepLatencyThreshold;
    private final boolean traceKeepLatencyThresholdEnabled;
    private final boolean traceStrictWritesEnabled;
    private final boolean logExtractHeaderNames;
    private final Set<PropagationStyle> propagationStylesToExtract;
    private final Set<PropagationStyle> propagationStylesToInject;
    private final boolean tracePropagationStyleB3PaddingEnabled;
    private final Set<TracePropagationStyle> tracePropagationStylesToExtract;
    private final Set<TracePropagationStyle> tracePropagationStylesToInject;
    private final TracePropagationBehaviorExtract tracePropagationBehaviorExtract;
    private final boolean tracePropagationExtractFirst;
    private final int traceBaggageMaxItems;
    private final int traceBaggageMaxBytes;
    private final List<String> traceBaggageTagKeys;
    private final boolean traceInferredProxyEnabled;
    private final int clockSyncPeriod;
    private final boolean logsInjectionEnabled;
    private final boolean appLogsCollectionEnabled;
    private final String dogStatsDNamedPipe;
    private final int dogStatsDStartDelay;
    private final Integer statsDClientQueueSize;
    private final Integer statsDClientSocketBuffer;
    private final Integer statsDClientSocketTimeout;
    private final boolean runtimeMetricsEnabled;
    private final boolean jmxFetchEnabled;
    private final String jmxFetchConfigDir;
    private final List<String> jmxFetchConfigs;
    @Deprecated
    private final List<String> jmxFetchMetricsConfigs;
    private final Integer jmxFetchCheckPeriod;
    private final Integer jmxFetchInitialRefreshBeansPeriod;
    private final Integer jmxFetchRefreshBeansPeriod;
    private final String jmxFetchStatsdHost;
    private final Integer jmxFetchStatsdPort;
    private final boolean jmxFetchMultipleRuntimeServicesEnabled;
    private final int jmxFetchMultipleRuntimeServicesLimit;
    private final boolean metricsOtelEnabled;
    private final int metricsOtelInterval;
    private final int metricsOtelTimeout;
    private final String otlpMetricsEndpoint;
    private final Map<String, String> otlpMetricsHeaders;
    private final OtlpConfig.Protocol otlpMetricsProtocol;
    private final int otlpMetricsTimeout;
    private final OtlpConfig.Temporality otlpMetricsTemporalityPreference;
    private final boolean healthMetricsEnabled;
    private final String healthMetricsStatsdHost;
    private final Integer healthMetricsStatsdPort;
    private final boolean perfMetricsEnabled;
    private final boolean tracerMetricsEnabled;
    private final boolean tracerMetricsBufferingEnabled;
    private final int tracerMetricsMaxAggregates;
    private final int tracerMetricsMaxPending;
    private final boolean reportHostName;
    private final boolean traceAnalyticsEnabled;
    private final String traceClientIpHeader;
    private final boolean traceClientIpResolverEnabled;
    private final boolean traceGitMetadataEnabled;
    private final boolean ssiInjectionForce;
    private final String ssiInjectionEnabled;
    private final String instrumentationSource;
    private final Map<String, String> traceSamplingServiceRules;
    private final Map<String, String> traceSamplingOperationRules;
    private final String traceSamplingRules;
    private final Double traceSampleRate;
    private final int traceRateLimit;
    private final String spanSamplingRules;
    private final String spanSamplingRulesFile;
    private final ProfilingEnablement profilingEnabled;
    private final boolean profilingAgentless;
    private final boolean isDatadogProfilerEnabled;
    @Deprecated
    private final String profilingUrl;
    private final Map<String, String> profilingTags;
    private final int profilingStartDelay;
    private final boolean profilingStartForceFirst;
    private final int profilingUploadPeriod;
    private final String profilingTemplateOverrideFile;
    private final int profilingUploadTimeout;
    private final String profilingUploadCompression;
    private final String profilingProxyHost;
    private final int profilingProxyPort;
    private final String profilingProxyUsername;
    private final String profilingProxyPassword;
    private final int profilingExceptionSampleLimit;
    private final int profilingBackPressureSampleLimit;
    private final boolean profilingBackPressureEnabled;
    private final int profilingDirectAllocationSampleLimit;
    private final int profilingExceptionHistogramTopItems;
    private final int profilingExceptionHistogramMaxCollectionSize;
    private final boolean profilingExcludeAgentThreads;
    private final boolean profilingUploadSummaryOn413Enabled;
    private final boolean profilingRecordExceptionMessage;
    private final boolean crashTrackingAgentless;
    private final Map<String, String> crashTrackingTags;
    private final boolean crashTrackingErrorsIntakeEnabled;
    private final boolean clientIpEnabled;
    private final boolean appSecReportingInband;
    private final String appSecRulesFile;
    private final int appSecReportMinTimeout;
    private final int appSecReportMaxTimeout;
    private final int appSecTraceRateLimit;
    private final boolean appSecWafMetrics;
    private final int appSecWafTimeout;
    private final String appSecObfuscationParameterKeyRegexp;
    private final String appSecObfuscationParameterValueRegexp;
    private final String appSecHttpBlockedTemplateHtml;
    private final String appSecHttpBlockedTemplateJson;
    private final UserIdCollectionMode appSecUserIdCollectionMode;
    private final Boolean appSecScaEnabled;
    private final boolean appSecRaspEnabled;
    private final boolean appSecStackTraceEnabled;
    private final int appSecMaxStackTraces;
    private final int appSecMaxStackTraceDepth;
    private final int appSecBodyParsingSizeLimit;
    private final boolean apiSecurityEnabled;
    private final float apiSecuritySampleDelay;
    private final int apiSecurityEndpointCollectionMessageLimit;
    private final int apiSecurityMaxDownstreamRequestBodyAnalysis;
    private final double apiSecurityDownstreamRequestBodyAnalysisSampleRate;
    private final IastDetectionMode iastDetectionMode;
    private final int iastMaxConcurrentRequests;
    private final int iastVulnerabilitiesPerRequest;
    private final float iastRequestSampling;
    private final boolean iastDebugEnabled;
    private final Verbosity iastTelemetryVerbosity;
    private final boolean iastRedactionEnabled;
    private final String iastRedactionNamePattern;
    private final String iastRedactionValuePattern;
    private final int iastMaxRangeCount;
    private final int iastTruncationMaxValueLength;
    private final boolean iastStacktraceLeakSuppress;
    private final IastContext.Mode iastContextMode;
    private final boolean iastHardcodedSecretEnabled;
    private final boolean iastAnonymousClassesEnabled;
    private final boolean iastSourceMappingEnabled;
    private final int iastSourceMappingMaxSize;
    private final boolean iastStackTraceEnabled;
    private final boolean iastExperimentalPropagationEnabled;
    private final String iastSecurityControlsConfiguration;
    private final int iastDbRowsToTaint;
    private final boolean llmObsAgentlessEnabled;
    private final String llmObsAgentlessUrl;
    private final String llmObsMlApp;
    private final boolean ciVisibilityTraceSanitationEnabled;
    private final boolean ciVisibilityAgentlessEnabled;
    private final String ciVisibilityAgentlessUrl;
    private final String ciVisibilityIntakeAgentlessUrl;
    private final boolean ciVisibilitySourceDataEnabled;
    private final boolean ciVisibilityBuildInstrumentationEnabled;
    private final String ciVisibilityAgentJarUri;
    private final boolean ciVisibilityAutoConfigurationEnabled;
    private final String ciVisibilityAdditionalChildProcessJvmArgs;
    private final boolean ciVisibilityCompilerPluginAutoConfigurationEnabled;
    private final boolean ciVisibilityCodeCoverageEnabled;
    private final Boolean ciVisibilityCoverageLinesEnabled;
    private final String ciVisibilityCodeCoverageReportDumpDir;
    private final String ciVisibilityCompilerPluginVersion;
    private final String ciVisibilityJacocoPluginVersion;
    private final boolean ciVisibilityJacocoPluginVersionProvided;
    private final List<String> ciVisibilityCodeCoverageIncludes;
    private final List<String> ciVisibilityCodeCoverageExcludes;
    private final String[] ciVisibilityCodeCoverageIncludedPackages;
    private final String[] ciVisibilityCodeCoverageExcludedPackages;
    private final List<String> ciVisibilityJacocoGradleSourceSets;
    private final boolean ciVisibilityCodeCoverageReportUploadEnabled;
    private final Integer ciVisibilityDebugPort;
    private final boolean ciVisibilityGitClientEnabled;
    private final boolean ciVisibilityGitUploadEnabled;
    private final boolean ciVisibilityGitUnshallowEnabled;
    private final boolean ciVisibilityGitUnshallowDefer;
    private final long ciVisibilityGitCommandTimeoutMillis;
    private final String ciVisibilityGitRemoteName;
    private final long ciVisibilityBackendApiTimeoutMillis;
    private final long ciVisibilityGitUploadTimeoutMillis;
    private final String ciVisibilitySignalServerHost;
    private final int ciVisibilitySignalServerPort;
    private final int ciVisibilitySignalClientTimeoutMillis;
    private final boolean ciVisibilityItrEnabled;
    private final boolean ciVisibilityTestSkippingEnabled;
    private final boolean ciVisibilityCiProviderIntegrationEnabled;
    private final boolean ciVisibilityRepoIndexDuplicateKeyCheckEnabled;
    private final boolean ciVisibilityRepoIndexFollowSymlinks;
    private final int ciVisibilityExecutionSettingsCacheSize;
    private final int ciVisibilityJvmInfoCacheSize;
    private final int ciVisibilityCoverageRootPackagesLimit;
    private final String ciVisibilityInjectedTracerVersion;
    private final List<String> ciVisibilityResourceFolderNames;
    private final boolean ciVisibilityFlakyRetryEnabled;
    private final boolean ciVisibilityImpactedTestsDetectionEnabled;
    private final boolean ciVisibilityKnownTestsRequestEnabled;
    private final boolean ciVisibilityFlakyRetryOnlyKnownFlakes;
    private final int ciVisibilityFlakyRetryCount;
    private final int ciVisibilityTotalFlakyRetryCount;
    private final boolean ciVisibilityEarlyFlakeDetectionEnabled;
    private final int ciVisibilityEarlyFlakeDetectionLowerLimit;
    private final String ciVisibilitySessionName;
    private final String ciVisibilityModuleName;
    private final String ciVisibilityTestCommand;
    private final boolean ciVisibilityTelemetryEnabled;
    private final long ciVisibilityRumFlushWaitMillis;
    private final boolean ciVisibilityAutoInjected;
    private final String ciVisibilityTestOrder;
    private final boolean ciVisibilityTestManagementEnabled;
    private final Integer ciVisibilityTestManagementAttemptToFixRetries;
    private final boolean ciVisibilityScalatestForkMonitorEnabled;
    private final String gitPullRequestBaseBranch;
    private final String gitPullRequestBaseBranchSha;
    private final String gitCommitHeadSha;
    private final boolean ciVisibilityFailedTestReplayEnabled;
    private final boolean remoteConfigEnabled;
    private final boolean remoteConfigIntegrityCheckEnabled;
    private final String remoteConfigUrl;
    private final float remoteConfigPollIntervalSeconds;
    private final long remoteConfigMaxPayloadSize;
    private final String remoteConfigTargetsKeyId;
    private final String remoteConfigTargetsKey;
    private final int remoteConfigMaxExtraServices;
    private final boolean dbmInjectSqlBaseHash;
    private final String dbmPropagationMode;
    private final boolean dbmTracePreparedStatements;
    private final boolean dbmAlwaysAppendSqlComment;
    private final boolean dbMetadataFetchingOnQuery;
    private final boolean dbMetadataFetchingOnConnect;
    private final boolean dynamicInstrumentationEnabled;
    private final String dynamicInstrumentationSnapshotUrl;
    private final int dynamicInstrumentationUploadTimeout;
    private final int dynamicInstrumentationUploadFlushInterval;
    private final boolean dynamicInstrumentationClassFileDumpEnabled;
    private final int dynamicInstrumentationPollInterval;
    private final int dynamicInstrumentationDiagnosticsInterval;
    private final boolean dynamicInstrumentationMetricEnabled;
    private final String dynamicInstrumentationProbeFile;
    private final int dynamicInstrumentationUploadBatchSize;
    private final long dynamicInstrumentationMaxPayloadSize;
    private final boolean dynamicInstrumentationVerifyByteCode;
    private final String dynamicInstrumentationInstrumentTheWorld;
    private final String dynamicInstrumentationExcludeFiles;
    private final String dynamicInstrumentationIncludeFiles;
    private final int dynamicInstrumentationCaptureTimeout;
    private final String dynamicInstrumentationRedactedIdentifiers;
    private final Set<String> dynamicInstrumentationRedactionExcludedIdentifiers;
    private final String dynamicInstrumentationRedactedTypes;
    private final int dynamicInstrumentationLocalVarHoistingLevel;
    private final boolean symbolDatabaseEnabled;
    private final boolean symbolDatabaseForceUpload;
    private final int symbolDatabaseFlushThreshold;
    private final boolean symbolDatabaseCompressed;
    private final boolean debuggerExceptionEnabled;
    private final int debuggerMaxExceptionPerSecond;
    @Deprecated
    private final boolean debuggerExceptionOnlyLocalRoot;
    private final boolean debuggerExceptionCaptureIntermediateSpansEnabled;
    private final int debuggerExceptionMaxCapturedFrames;
    private final int debuggerExceptionCaptureInterval;
    private final boolean debuggerCodeOriginEnabled;
    private final int debuggerCodeOriginMaxUserFrames;
    private final boolean distributedDebuggerEnabled;
    private final boolean debuggerSourceFileTrackingEnabled;
    private final Set<String> debuggerThirdPartyIncludes;
    private final Set<String> debuggerThirdPartyExcludes;
    private final Set<String> debuggerShadingIdentifiers;
    private final boolean awsPropagationEnabled;
    private final boolean sqsPropagationEnabled;
    private final boolean sqsBodyPropagationEnabled;
    private final boolean kafkaClientPropagationEnabled;
    private final Set<String> kafkaClientPropagationDisabledTopics;
    private final boolean kafkaClientBase64DecodingEnabled;
    private final boolean jmsPropagationEnabled;
    private final Set<String> jmsPropagationDisabledTopics;
    private final Set<String> jmsPropagationDisabledQueues;
    private final int jmsUnacknowledgedMaxAge;
    private final boolean rabbitPropagationEnabled;
    private final Set<String> rabbitPropagationDisabledQueues;
    private final Set<String> rabbitPropagationDisabledExchanges;
    private final boolean rabbitIncludeRoutingKeyInResource;
    private final boolean messageBrokerSplitByDestination;
    private final boolean hystrixTagsEnabled;
    private final boolean hystrixMeasuredEnabled;
    private final boolean resilience4jMeasuredEnabled;
    private final boolean resilience4jTagMetricsEnabled;
    private final boolean igniteCacheIncludeKeys;
    private final String obfuscationQueryRegexp;
    private final boolean playReportHttpStatus;
    private final boolean servletPrincipalEnabled;
    private final boolean servletAsyncTimeoutError;
    private final boolean springDataRepositoryInterfaceResourceName;
    private final int xDatadogTagsMaxLength;
    private final boolean traceAgentV05Enabled;
    private final String logLevel;
    private final boolean debugEnabled;
    private final boolean triageEnabled;
    private final String triageReportTrigger;
    private final String triageReportDir;
    private final boolean startupLogsEnabled;
    private final String configFileStatus;
    private final IdGenerationStrategy idGenerationStrategy;
    private final boolean secureRandom;
    private final boolean trace128bitTraceIdGenerationEnabled;
    private final boolean logs128bitTraceIdEnabled;
    private final Set<String> grpcIgnoredInboundMethods;
    private final Set<String> grpcIgnoredOutboundMethods;
    private final boolean grpcServerTrimPackageResource;
    private final BitSet grpcServerErrorStatuses;
    private final BitSet grpcClientErrorStatuses;
    private final boolean cwsEnabled;
    private final int cwsTlsRefresh;
    private final boolean dataJobsOpenLineageEnabled;
    private final boolean dataJobsOpenLineageTimeoutEnabled;
    private final boolean dataJobsParseSparkPlanEnabled;
    private final boolean dataJobsExperimentalFeaturesEnabled;
    private final boolean dataStreamsEnabled;
    private final float dataStreamsBucketDurationSeconds;
    private final boolean serviceDiscoveryEnabled;
    private final Set<String> iastWeakHashAlgorithms;
    private final Pattern iastWeakCipherAlgorithms;
    private final boolean iastDeduplicationEnabled;
    private final float telemetryHeartbeatInterval;
    private final long telemetryExtendedHeartbeatInterval;
    private final float telemetryMetricsInterval;
    private final boolean isTelemetryDependencyServiceEnabled;
    private final boolean telemetryMetricsEnabled;
    private final boolean isTelemetryLogCollectionEnabled;
    private final int telemetryDependencyResolutionQueueSize;
    private final boolean azureAppServices;
    private final boolean azureFunctions;
    private final boolean awsServerless;
    private final String traceAgentPath;
    private final List<String> traceAgentArgs;
    private final String dogStatsDPath;
    private final List<String> dogStatsDArgs;
    private final int dogStatsDPort;
    private String env;
    private String version;
    private final String primaryTag;
    private final ConfigProvider configProvider;
    private final boolean longRunningTraceEnabled;
    private final long longRunningTraceInitialFlushInterval;
    private final long longRunningTraceFlushInterval;
    private final boolean cassandraKeyspaceStatementExtractionEnabled;
    private final boolean couchbaseInternalSpansEnabled;
    private final boolean elasticsearchBodyEnabled;
    private final boolean elasticsearchParamsEnabled;
    private final boolean elasticsearchBodyAndParamsEnabled;
    private final boolean sparkTaskHistogramEnabled;
    private final boolean sparkAppNameAsService;
    private final boolean jaxRsExceptionAsErrorsEnabled;
    private final boolean websocketMessagesInheritSampling;
    private final boolean websocketMessagesSeparateTraces;
    private final boolean websocketTagSessionId;
    private final boolean axisPromoteResourceName;
    private final float traceFlushIntervalSeconds;
    private final long tracePostProcessingTimeout;
    private final boolean telemetryDebugRequestsEnabled;
    private final int agentlessLogSubmissionQueueSize;
    private final String agentlessLogSubmissionLevel;
    private final String agentlessLogSubmissionUrl;
    private final String agentlessLogSubmissionProduct;
    private final Set<String> cloudPayloadTaggingServices;
    @Nullable
    private final List<JsonPath> cloudRequestPayloadTagging;
    @Nullable
    private final List<JsonPath> cloudResponsePayloadTagging;
    private final int cloudPayloadTaggingMaxDepth;
    private final int cloudPayloadTaggingMaxTags;
    private final long dependecyResolutionPeriodMillis;
    private final boolean apmTracingEnabled;
    private final Set<String> experimentalFeaturesEnabled;
    private final boolean jdkSocketEnabled;
    private final boolean optimizedMapEnabled;
    private final boolean spanBuilderReuseEnabled;
    private final int tagNameUtf8CacheSize;
    private final int tagValueUtf8CacheSize;
    private final int stackTraceLengthLimit;
    private final boolean sfnInjectDatadogAttributeEnabled;
    private final boolean sqsInjectDatadogAttributeEnabled;
    private final boolean snsInjectDatadogAttributeEnabled;
    private final boolean eventbridgeInjectDatadogAttributeEnabled;
    private final RumInjectorConfig rumInjectorConfig;
    private final boolean aiGuardEnabled;
    private final String aiGuardEndpoint;
    private final int aiGuardTimeout;
    private final int aiGuardMaxMessagesLength;
    private final int aiGuardMaxContentSize;
    public static final String DBM_PROPAGATION_MODE_STATIC = "service";
    public static final String DBM_PROPAGATION_MODE_FULL = "full";
    public static final String PREFIX = "dd.";
    private static final Config INSTANCE;

    private Config() {
        this(ConfigProvider.createDefault());
    }

    private Config(ConfigProvider configProvider) {
        this(configProvider, new InstrumenterConfig(configProvider));
    }

    private Config(ConfigProvider configProvider, InstrumenterConfig instrumenterConfig) {
        List<JsonPath> validResponseJsonPaths;
        List<JsonPath> validRequestJsonPaths;
        TracePropagationBehaviorExtract tmpTracePropagationBehaviorExtract;
        IdGenerationStrategy strategy;
        this.configProvider = configProvider;
        this.instrumenterConfig = instrumenterConfig;
        this.configFileStatus = configProvider.getConfigFileStatus();
        this.runtimeIdEnabled = configProvider.getBoolean("runtime-id.enabled", true, "runtime.metrics.runtime-id.enabled");
        this.runtimeVersion = SystemProperties.getOrDefault("java.version", "unknown");
        String apiKeyFile = configProvider.getString("api-key-file");
        String tmpApiKey = configProvider.getStringExcludingSource("api-key", null, SystemPropertiesConfigSource.class, new String[0]);
        if (apiKeyFile != null) {
            try {
                tmpApiKey = new String(Files.readAllBytes(Paths.get(apiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                log.error("Cannot read API key from file {}, skipping. Exception {}", (Object)apiKeyFile, (Object)e.getMessage());
            }
        }
        this.site = configProvider.getString("site", "datadoghq.com", new String[0]);
        String tmpApplicationKey = configProvider.getStringExcludingSource("application-key", null, SystemPropertiesConfigSource.class, "app-key");
        String applicationKeyFile = configProvider.getString("application-key-file");
        if (applicationKeyFile != null) {
            try {
                tmpApplicationKey = new String(Files.readAllBytes(Paths.get(applicationKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                log.error("Cannot read API key from file {}, skipping", (Object)applicationKeyFile, (Object)e);
            }
        }
        this.applicationKey = tmpApplicationKey;
        String userProvidedServiceName = configProvider.getStringExcludingSource(DBM_PROPAGATION_MODE_STATIC, null, CapturedEnvironmentConfigSource.class, "service.name");
        if (userProvidedServiceName == null) {
            this.serviceNameSetByUser = false;
            this.serviceName = configProvider.getString(DBM_PROPAGATION_MODE_STATIC, "unnamed-java-app", "service.name");
        } else {
            this.serviceNameSetByUser = configProvider.getBoolean("service.name.set.by.user", true, new String[0]);
            this.serviceName = userProvidedServiceName;
        }
        this.rootContextServiceName = configProvider.getString("trace.servlet.root-context.service.name", "root-servlet", new String[0]);
        this.experimentalFeaturesEnabled = configProvider.getString("trace.experimental.features.enabled", "", new String[0]).equals("all") ? ConfigDefaults.DEFAULT_TRACE_EXPERIMENTAL_FEATURES_ENABLED : configProvider.getSet("trace.experimental.features.enabled", new HashSet<String>());
        this.integrationSynapseLegacyOperationName = configProvider.getBoolean("integration.synapse.legacy-operation-name", false, new String[0]);
        this.writerType = configProvider.getString("writer.type", "DDAgentWriter", new String[0]);
        this.injectBaggageAsTagsEnabled = configProvider.getBoolean("writer.baggage.inject", true, new String[0]);
        String lambdaInitType = Config.getEnv("AWS_LAMBDA_INITIALIZATION_TYPE");
        this.secureRandom = lambdaInitType != null && lambdaInitType.equals("snap-start") ? true : configProvider.getBoolean("trace.secure-random", false, new String[0]);
        this.cassandraKeyspaceStatementExtractionEnabled = configProvider.getBoolean("trace.cassandra.keyspace.statement.extraction.enabled", false, new String[0]);
        this.couchbaseInternalSpansEnabled = configProvider.getBoolean("trace.couchbase.internal-spans.enabled", true, new String[0]);
        this.elasticsearchBodyEnabled = configProvider.getBoolean("trace.elasticsearch.body.enabled", false, new String[0]);
        this.elasticsearchParamsEnabled = configProvider.getBoolean("trace.elasticsearch.params.enabled", true, new String[0]);
        this.elasticsearchBodyAndParamsEnabled = configProvider.getBoolean("trace.elasticsearch.body-and-params.enabled", false, new String[0]);
        String strategyName = configProvider.getString("id.generation.strategy");
        this.trace128bitTraceIdGenerationEnabled = configProvider.getBoolean("trace.128.bit.traceid.generation.enabled", true, new String[0]);
        this.logs128bitTraceIdEnabled = configProvider.getBoolean("trace.128.bit.traceid.logging.enabled", true, new String[0]);
        if (this.secureRandom) {
            strategyName = "SECURE_RANDOM";
        }
        if (strategyName == null) {
            strategyName = "RANDOM";
        }
        if ((strategy = IdGenerationStrategy.fromName((String)strategyName, (boolean)this.trace128bitTraceIdGenerationEnabled)) == null) {
            log.warn("*** you are trying to use an unknown id generation strategy {} - falling back to RANDOM", (Object)strategyName);
            strategyName = "RANDOM";
            strategy = IdGenerationStrategy.fromName((String)strategyName, (boolean)this.trace128bitTraceIdGenerationEnabled);
        }
        if (!strategyName.equals("RANDOM") && !strategyName.equals("SECURE_RANDOM")) {
            log.warn("*** you are using an unsupported id generation strategy {} - this can impact correctness of traces", (Object)strategyName);
        }
        this.idGenerationStrategy = strategy;
        String agentHostFromEnvironment = null;
        int agentPortFromEnvironment = -1;
        String unixSocketFromEnvironment = null;
        boolean rebuildAgentUrl = false;
        String agentUrlFromEnvironment = configProvider.getString("trace.agent.url");
        if (agentUrlFromEnvironment != null) {
            try {
                URI parsedAgentUrl = new URI(agentUrlFromEnvironment);
                agentHostFromEnvironment = parsedAgentUrl.getHost();
                agentPortFromEnvironment = parsedAgentUrl.getPort();
                if ("unix".equals(parsedAgentUrl.getScheme())) {
                    unixSocketFromEnvironment = parsedAgentUrl.getPath();
                }
            }
            catch (URISyntaxException e) {
                log.warn("{} not configured correctly: {}. Ignoring", (Object)"trace.agent.url", (Object)e.getMessage());
            }
        }
        if (unixSocketFromEnvironment == null) {
            if (agentHostFromEnvironment == null) {
                agentHostFromEnvironment = configProvider.getString("agent.host");
                rebuildAgentUrl = true;
            }
            if (agentPortFromEnvironment < 0) {
                agentPortFromEnvironment = configProvider.getInteger("trace.agent.port", -1, "agent.port");
                rebuildAgentUrl = true;
            }
        }
        this.agentHost = agentHostFromEnvironment == null || agentHostFromEnvironment.isEmpty() ? "localhost" : (agentHostFromEnvironment.charAt(0) == '[' ? agentHostFromEnvironment.substring(1, agentHostFromEnvironment.length() - 1) : agentHostFromEnvironment);
        this.agentPort = agentPortFromEnvironment < 0 ? 8126 : agentPortFromEnvironment;
        this.agentUrl = rebuildAgentUrl ? (this.agentHost.indexOf(58) != -1 ? "http://[" + this.agentHost + "]:" + this.agentPort : "http://" + this.agentHost + ":" + this.agentPort) : agentUrlFromEnvironment;
        if (unixSocketFromEnvironment == null) {
            unixSocketFromEnvironment = configProvider.getString("trace.agent.unix.domain.socket");
            String unixPrefix = "unix://";
            if (unixSocketFromEnvironment != null && unixSocketFromEnvironment.startsWith(unixPrefix)) {
                unixSocketFromEnvironment = unixSocketFromEnvironment.substring(unixPrefix.length());
            }
        }
        this.agentUnixDomainSocket = unixSocketFromEnvironment;
        this.agentNamedPipe = configProvider.getString("trace.pipe.name");
        this.agentConfiguredUsingDefault = agentHostFromEnvironment == null && agentPortFromEnvironment < 0 && unixSocketFromEnvironment == null && this.agentNamedPipe == null;
        this.agentTimeout = configProvider.getInteger("trace.agent.timeout", 10, new String[0]);
        this.forceClearTextHttpForIntakeClient = configProvider.getBoolean("force.clear.text.http.for.intake.client", false, new String[0]);
        this.noProxyHosts = CollectionUtils.tryMakeImmutableSet(configProvider.getSpacedList("proxy.no_proxy"));
        this.prioritySamplingEnabled = configProvider.getBoolean("priority.sampling", true, new String[0]);
        this.prioritySamplingForce = configProvider.getString("priority.sampling.force", ConfigDefaults.DEFAULT_PRIORITY_SAMPLING_FORCE, new String[0]);
        this.traceResolverEnabled = configProvider.getBoolean("trace.resolver.enabled", true, new String[0]);
        this.serviceMapping = configProvider.getMergedMap("service.mapping", new String[0]);
        HashMap<String, String> tags = new HashMap<String, String>(configProvider.getMergedMap("trace.global.tags", new String[0]));
        if (this.experimentalFeaturesEnabled.contains("DD_TAGS")) {
            tags.putAll(configProvider.getMergedTagsMap("trace.tags", "tags"));
        } else {
            tags.putAll(configProvider.getMergedMap("trace.tags", "tags"));
        }
        if (this.serviceNameSetByUser) {
            tags.remove(DBM_PROPAGATION_MODE_STATIC);
        }
        this.tags = this.getMapWithPropertiesDefinedByEnvironment(tags, "env", "version");
        this.spanTags = configProvider.getMergedMap("trace.span.tags", new String[0]);
        this.jmxTags = configProvider.getMergedMap("trace.jmx.tags", new String[0]);
        this.primaryTag = configProvider.getString("primary.tag");
        if (this.isEnabled(false, "trace.header.tags", ".legacy.parsing.enabled")) {
            this.requestHeaderTags = configProvider.getMergedMap("trace.header.tags", new String[0]);
            this.responseHeaderTags = Collections.emptyMap();
            if (configProvider.isSet("trace.request_header.tags")) {
                this.logIgnoredSettingWarning("trace.request_header.tags", "trace.header.tags", ".legacy.parsing.enabled");
            }
            if (configProvider.isSet("trace.response_header.tags")) {
                this.logIgnoredSettingWarning("trace.response_header.tags", "trace.header.tags", ".legacy.parsing.enabled");
            }
        } else {
            this.requestHeaderTags = configProvider.getMergedMapWithOptionalMappings("http.request.headers.", true, "trace.header.tags", "trace.request_header.tags");
            this.responseHeaderTags = configProvider.getMergedMapWithOptionalMappings("http.response.headers.", true, "trace.header.tags", "trace.response_header.tags");
        }
        this.requestHeaderTagsCommaAllowed = configProvider.getBoolean("trace.request_header.tags.comma.allowed", true, new String[0]);
        this.baggageMapping = configProvider.getMergedMapWithOptionalMappings(null, true, "trace.header.baggage");
        this.azureFunctions = Config.getEnv("FUNCTIONS_WORKER_RUNTIME") != null && Config.getEnv("FUNCTIONS_EXTENSION_VERSION") != null;
        this.awsServerless = Config.getEnv("AWS_LAMBDA_FUNCTION_NAME") != null && !Config.getEnv("AWS_LAMBDA_FUNCTION_NAME").isEmpty();
        this.sfnInjectDatadogAttributeEnabled = this.isInjectDatadogAttributeEnabled(true, "sfn");
        this.eventbridgeInjectDatadogAttributeEnabled = this.isInjectDatadogAttributeEnabled(true, "eventbridge");
        this.snsInjectDatadogAttributeEnabled = this.isInjectDatadogAttributeEnabled(true, "sns");
        this.sqsInjectDatadogAttributeEnabled = this.isInjectDatadogAttributeEnabled(true, "sqs");
        this.spanAttributeSchemaVersion = this.schemaVersionFromConfig();
        this.peerHostNameEnabled = configProvider.getBoolean("trace.peer.hostname.enabled", true, new String[0]);
        this.peerServiceDefaultsEnabled = configProvider.getBoolean("trace.peer.service.defaults.enabled", false, new String[0]);
        this.peerServiceComponentOverrides = configProvider.getMergedMap("trace.peer.service.component.overrides", new String[0]);
        this.removeIntegrationServiceNamesEnabled = configProvider.getBoolean("trace.remove.integration-service-names.enabled", false, new String[0]);
        this.experimentalPropagateProcessTagsEnabled = configProvider.getBoolean("experimental.propagate.process.tags.enabled", true, new String[0]);
        this.peerServiceMapping = configProvider.getMergedMap("trace.peer.service.mapping", new String[0]);
        this.httpServerPathResourceNameMapping = configProvider.getOrderedMap("trace.http.server.path-resource-name-mapping");
        this.httpClientPathResourceNameMapping = configProvider.getOrderedMap("trace.http.client.path-resource-name-mapping");
        this.httpResourceRemoveTrailingSlash = configProvider.getBoolean("trace.http.resource.remove-trailing-slash", false, new String[0]);
        this.httpServerErrorStatuses = configProvider.getIntegerRange("trace.http.server.error.statuses", ConfigDefaults.DEFAULT_HTTP_SERVER_ERROR_STATUSES, "http.server.error.statuses");
        this.httpClientErrorStatuses = configProvider.getIntegerRange("trace.http.client.error.statuses", ConfigDefaults.DEFAULT_HTTP_CLIENT_ERROR_STATUSES, "http.client.error.statuses");
        this.httpServerTagQueryString = configProvider.getBoolean("http.server.tag.query-string", true, new String[0]);
        this.httpServerRawQueryString = configProvider.getBoolean("http.server.raw.query-string", true, new String[0]);
        this.httpServerRawResource = configProvider.getBoolean("http.server.raw.resource", false, new String[0]);
        this.httpServerDecodedResourcePreserveSpaces = configProvider.getBoolean("http.server.decoded.resource.preserve-spaces", true, new String[0]);
        this.httpServerRouteBasedNaming = configProvider.getBoolean("http.server.route-based-naming", true, new String[0]);
        this.httpClientTagQueryString = configProvider.getBoolean("trace.http.client.tag.query-string", true, "http.client.tag.query-string");
        this.httpClientTagHeaders = configProvider.getBoolean("http.client.tag.headers", true, new String[0]);
        this.httpClientSplitByDomain = configProvider.getBoolean("trace.http.client.split-by-domain", false, new String[0]);
        this.dbClientSplitByInstance = configProvider.getBoolean("trace.db.client.split-by-instance", false, new String[0]);
        this.dbClientSplitByInstanceTypeSuffix = configProvider.getBoolean("trace.db.client.split-by-instance.type.suffix", false, new String[0]);
        this.dbMetadataFetchingOnQuery = configProvider.getBoolean("trace.db.metadata.fetching.on.query", true, new String[0]);
        this.dbMetadataFetchingOnConnect = configProvider.getBoolean("trace.db.metadata.fetching.on.connect", true, new String[0]);
        this.dbClientSplitByHost = configProvider.getBoolean("trace.db.client.split-by-host", false, new String[0]);
        this.dbmPropagationMode = configProvider.getString("dbm.propagation.mode", "disabled", new String[0]);
        this.dbmTracePreparedStatements = configProvider.getBoolean("dbm.trace_prepared_statements", false, new String[0]);
        this.dbmAlwaysAppendSqlComment = configProvider.getBoolean("dbm.always_append_sql_comment", false, new String[0]);
        this.dbmInjectSqlBaseHash = configProvider.getBoolean("dbm.inject.sql.basehash", false, new String[0]);
        this.splitByTags = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.split-by-tags"));
        this.jeeSplitByDeployment = configProvider.getBoolean("trace.experimental.jee.split-by-deployment", false, new String[0]);
        this.springDataRepositoryInterfaceResourceName = configProvider.getBoolean("spring-data.repository.interface.resource-name", true, new String[0]);
        this.scopeDepthLimit = configProvider.getInteger("trace.scope.depth.limit", 100, new String[0]);
        this.scopeStrictMode = configProvider.getBoolean("trace.scope.strict.mode", false, new String[0]);
        this.scopeIterationKeepAlive = configProvider.getInteger("trace.scope.iteration.keep.alive", 30, new String[0]);
        boolean partialFlushEnabled = configProvider.getBoolean("trace.partial.flush.enabled", true, new String[0]);
        this.partialFlushMinSpans = !partialFlushEnabled ? 0 : configProvider.getInteger("trace.partial.flush.min.spans", 1000, new String[0]);
        this.traceKeepLatencyThreshold = configProvider.getInteger("trace.experimental.keep.latency.threshold.ms", 0, new String[0]);
        this.traceKeepLatencyThresholdEnabled = !partialFlushEnabled && this.traceKeepLatencyThreshold > 0;
        this.traceStrictWritesEnabled = configProvider.getBoolean("trace.strict.writes.enabled", false, new String[0]);
        this.logExtractHeaderNames = configProvider.getBoolean("propagation.extract.log_header_names.enabled", false, new String[0]);
        this.tracePropagationStyleB3PaddingEnabled = this.isEnabled(true, "trace.propagation.style", ".b3.padding.enabled");
        try {
            tmpTracePropagationBehaviorExtract = TracePropagationBehaviorExtract.valueOf((String)configProvider.getString("trace.propagation.behavior.extract", ConfigDefaults.DEFAULT_TRACE_PROPAGATION_BEHAVIOR_EXTRACT.toString(), new String[0]).toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            tmpTracePropagationBehaviorExtract = TracePropagationBehaviorExtract.CONTINUE;
            log.warn("Error while parsing TRACE_PROPAGATION_BEHAVIOR_EXTRACT, defaulting to `continue`");
        }
        this.tracePropagationBehaviorExtract = tmpTracePropagationBehaviorExtract;
        Set<PropagationStyle> deprecatedExtract = this.getSettingsSetFromEnvironment("propagation.style.extract", PropagationStyle::valueOfConfigName, true);
        Set<PropagationStyle> deprecatedInject = this.getSettingsSetFromEnvironment("propagation.style.inject", PropagationStyle::valueOfConfigName, true);
        Set<TracePropagationStyle> common = this.getSettingsSetFromEnvironment("trace.propagation.style", TracePropagationStyle::valueOfDisplayName, false);
        Set<Object> extract = this.getSettingsSetFromEnvironment("trace.propagation.style.extract", TracePropagationStyle::valueOfDisplayName, false);
        Set<Object> inject = this.getSettingsSetFromEnvironment("trace.propagation.style.inject", TracePropagationStyle::valueOfDisplayName, false);
        String extractOrigin = "trace.propagation.style.extract";
        String injectOrigin = "trace.propagation.style.inject";
        if (extract.isEmpty()) {
            extract = common;
            extractOrigin = "trace.propagation.style";
        } else if (!common.isEmpty()) {
            this.logOverriddenSettingWarning("trace.propagation.style", "trace.propagation.style.extract", extract);
        }
        if (inject.isEmpty()) {
            inject = common;
            injectOrigin = "trace.propagation.style";
        } else if (!common.isEmpty()) {
            this.logOverriddenSettingWarning("trace.propagation.style", "trace.propagation.style.inject", inject);
        }
        if (extract.isEmpty()) {
            extract = this.convertSettingsSet(deprecatedExtract, PropagationStyle::getNewStyles);
            if (!extract.isEmpty()) {
                this.logDeprecatedConvertedSetting("propagation.style.extract", deprecatedExtract, "trace.propagation.style.extract", extract);
            }
        } else if (!deprecatedExtract.isEmpty()) {
            this.logOverriddenDeprecatedSettingWarning("propagation.style.extract", extractOrigin, extract);
        }
        if (inject.isEmpty()) {
            inject = this.convertSettingsSet(deprecatedInject, PropagationStyle::getNewStyles);
            if (!inject.isEmpty()) {
                this.logDeprecatedConvertedSetting("propagation.style.inject", deprecatedInject, "trace.propagation.style.inject", inject);
            }
        } else if (!deprecatedInject.isEmpty()) {
            this.logOverriddenDeprecatedSettingWarning("propagation.style.inject", injectOrigin, inject);
        }
        this.traceBaggageTagKeys = configProvider.getList("trace.baggage.tag.keys", ConfigDefaults.DEFAULT_TRACE_BAGGAGE_TAG_KEYS, new String[0]);
        this.tracePropagationStylesToExtract = extract.isEmpty() ? ConfigDefaults.DEFAULT_TRACE_PROPAGATION_STYLE : extract;
        this.tracePropagationStylesToInject = inject.isEmpty() ? ConfigDefaults.DEFAULT_TRACE_PROPAGATION_STYLE : inject;
        this.traceBaggageMaxItems = configProvider.getInteger("trace.baggage.max.items", 64, new String[0]);
        this.traceBaggageMaxBytes = configProvider.getInteger("trace.baggage.max.bytes", 8192, new String[0]);
        this.propagationStylesToExtract = deprecatedExtract.isEmpty() ? ConfigDefaults.DEFAULT_PROPAGATION_STYLE : deprecatedExtract;
        this.propagationStylesToInject = deprecatedInject.isEmpty() ? ConfigDefaults.DEFAULT_PROPAGATION_STYLE : deprecatedInject;
        this.tracePropagationExtractFirst = configProvider.getBoolean("trace.propagation.extract.first", false, new String[0]);
        this.traceInferredProxyEnabled = configProvider.getBoolean("trace.inferred.proxy.services.enabled", false, new String[0]);
        this.clockSyncPeriod = configProvider.getInteger("trace.clock.sync.period", 30, new String[0]);
        this.logsInjectionEnabled = this.experimentalFeaturesEnabled.contains(ConfigStrings.propertyNameToEnvironmentVariableName("logs.injection")) ? configProvider.getBoolean("logs.injection.enabled", false, "logs.injection") : configProvider.getBoolean("logs.injection.enabled", true, "logs.injection");
        this.appLogsCollectionEnabled = configProvider.getBoolean("app.logs.collection.enabled", false, new String[0]);
        this.dogStatsDNamedPipe = configProvider.getString("ddtrot.dogstatsd.pipe.name");
        this.dogStatsDStartDelay = configProvider.getInteger("ddtrot.dogstatsd.start-delay", 15, "jmxfetch.start-delay");
        this.dogStatsDPort = configProvider.getInteger("ddtrot.dogstatsd.port", 8125, new String[0]);
        this.statsDClientQueueSize = configProvider.getInteger("statsd.client.queue.size");
        this.statsDClientSocketBuffer = configProvider.getInteger("statsd.client.socket.buffer");
        this.statsDClientSocketTimeout = configProvider.getInteger("statsd.client.socket.timeout");
        this.metricsOtelEnabled = configProvider.getBoolean("metrics.otel.enabled", false, new String[0]);
        int otelInterval = configProvider.getInteger("metrics.otel.interval", 10000, new String[0]);
        if (otelInterval < 0) {
            log.warn("Invalid OTel metrics interval: {}. The value must be positive", (Object)otelInterval);
            otelInterval = 10000;
        }
        this.metricsOtelInterval = otelInterval;
        int otelTimeout = configProvider.getInteger("metrics.otel.timeout", 7500, new String[0]);
        if (otelTimeout < 0) {
            log.warn("Invalid OTel metrics timeout: {}. The value must be positive", (Object)otelTimeout);
            otelTimeout = 7500;
        }
        this.metricsOtelTimeout = otelTimeout;
        int defaultOtlpTimeout = Math.min(this.metricsOtelTimeout, 7500);
        int otlpTimeout = configProvider.getInteger("otlp.metrics.timeout", defaultOtlpTimeout, new String[0]);
        if (otlpTimeout < 0) {
            log.warn("Invalid OTLP metrics timeout: {}. The value must be positive", (Object)otlpTimeout);
            otlpTimeout = defaultOtlpTimeout;
        }
        this.otlpMetricsTimeout = otlpTimeout;
        this.otlpMetricsHeaders = configProvider.getMergedMap("otlp.metrics.headers", '=', new String[0]);
        this.otlpMetricsProtocol = configProvider.getEnum("otlp.metrics.protocol", OtlpConfig.Protocol.class, OtlpConfig.Protocol.HTTP_PROTOBUF);
        String otlpMetricsEndpointFromEnvironment = configProvider.getString("otlp.metrics.endpoint");
        if (otlpMetricsEndpointFromEnvironment == null) {
            otlpMetricsEndpointFromEnvironment = this.otlpMetricsProtocol == OtlpConfig.Protocol.GRPC ? "http://" + this.agentHost + ':' + "4317" : "http://" + this.agentHost + ':' + "4318" + '/' + "v1/metrics";
        }
        this.otlpMetricsEndpoint = otlpMetricsEndpointFromEnvironment;
        this.otlpMetricsTemporalityPreference = configProvider.getEnum("otlp.metrics.temporality.preference", OtlpConfig.Temporality.class, OtlpConfig.Temporality.DELTA);
        this.runtimeMetricsEnabled = configProvider.getBoolean("runtime.metrics.enabled", true, new String[0]);
        this.jmxFetchEnabled = this.runtimeMetricsEnabled && configProvider.getBoolean("jmxfetch.enabled", true, new String[0]);
        this.jmxFetchConfigDir = configProvider.getString("jmxfetch.config.dir");
        this.jmxFetchConfigs = CollectionUtils.tryMakeImmutableList(configProvider.getList("jmxfetch.config"));
        this.jmxFetchMetricsConfigs = CollectionUtils.tryMakeImmutableList(configProvider.getList("jmxfetch.metrics-configs"));
        this.jmxFetchCheckPeriod = configProvider.getInteger("jmxfetch.check-period");
        this.jmxFetchInitialRefreshBeansPeriod = configProvider.getInteger("jmxfetch.initial-refresh-beans-period");
        this.jmxFetchRefreshBeansPeriod = configProvider.getInteger("jmxfetch.refresh-beans-period");
        this.jmxFetchStatsdPort = configProvider.getInteger("jmxfetch.statsd.port", "ddtrot.dogstatsd.port");
        this.jmxFetchStatsdHost = configProvider.getString("jmxfetch.statsd.host", null != this.jmxFetchStatsdPort && this.jmxFetchStatsdPort > 0 ? this.agentHost : null, "ddtrot.dogstatsd.host");
        this.jmxFetchMultipleRuntimeServicesEnabled = configProvider.getBoolean("jmxfetch.multiple-runtime-services.enabled", false, new String[0]);
        this.jmxFetchMultipleRuntimeServicesLimit = configProvider.getInteger("jmxfetch.multiple-runtime-services.limit", 10, new String[0]);
        this.healthMetricsEnabled = this.runtimeMetricsEnabled && configProvider.getBoolean("trace.health.metrics.enabled", true, new String[0]);
        this.healthMetricsStatsdHost = configProvider.getString("trace.health.metrics.statsd.host");
        this.healthMetricsStatsdPort = configProvider.getInteger("trace.health.metrics.statsd.port");
        this.perfMetricsEnabled = this.runtimeMetricsEnabled && configProvider.getBoolean("trace.perf.metrics.enabled", false, new String[0]);
        this.tracerMetricsEnabled = configProvider.getBoolean("trace.stats.computation.enabled", true, "trace.tracer.metrics.enabled");
        this.tracerMetricsBufferingEnabled = configProvider.getBoolean("trace.tracer.metrics.buffering.enabled", false, new String[0]);
        this.tracerMetricsMaxAggregates = configProvider.getInteger("trace.tracer.metrics.max.aggregates", 2048, new String[0]);
        this.tracerMetricsMaxPending = configProvider.getInteger("trace.tracer.metrics.max.pending", 2048, new String[0]);
        this.reportHostName = configProvider.getBoolean("trace.report-hostname", false, new String[0]);
        this.traceAgentV05Enabled = configProvider.getBoolean("trace.agent.v0.5.enabled", false, new String[0]);
        this.traceAnalyticsEnabled = configProvider.getBoolean("trace.analytics.enabled", false, new String[0]);
        String traceClientIpHeader = configProvider.getString("trace.client-ip-header");
        if (traceClientIpHeader == null) {
            traceClientIpHeader = configProvider.getString("appsec.ipheader");
        }
        if (traceClientIpHeader != null) {
            traceClientIpHeader = traceClientIpHeader.toLowerCase(Locale.ROOT);
        }
        this.traceClientIpHeader = traceClientIpHeader;
        this.traceClientIpResolverEnabled = configProvider.getBoolean("trace.client-ip.resolver.enabled", true, new String[0]);
        this.traceGitMetadataEnabled = configProvider.getBoolean("trace.git.metadata.enabled", true, new String[0]);
        this.traceSamplingServiceRules = configProvider.getMergedMap("trace.sampling.service.rules", new String[0]);
        this.traceSamplingOperationRules = configProvider.getMergedMap("trace.sampling.operation.rules", new String[0]);
        this.traceSamplingRules = configProvider.getString("trace.sampling.rules");
        this.traceSampleRate = configProvider.getDouble("trace.sample.rate");
        this.traceRateLimit = configProvider.getInteger("trace.rate.limit", 100, new String[0]);
        this.spanSamplingRules = configProvider.getString("span.sampling.rules");
        this.spanSamplingRulesFile = configProvider.getString("span.sampling.rules.file");
        String value = configProvider.getString("profiling.enabled", String.valueOf(instrumenterConfig.isProfilingEnabled()), new String[0]);
        ProfilingEnablement.validate(value);
        this.profilingEnabled = ProfilingEnablement.of(value);
        this.profilingAgentless = configProvider.getBoolean("profiling.agentless", false, new String[0]);
        this.isDatadogProfilerEnabled = !Config.isDatadogProfilerEnablementOverridden() && configProvider.getBoolean("profiling.ddprof.enabled", Config.isDatadogProfilerSafeInCurrentEnvironment(), new String[0]) && !Platform.isNativeImageBuilder() && !Platform.isNativeImage();
        this.profilingUrl = configProvider.getString("profiling.url");
        if (tmpApiKey == null) {
            String oldProfilingApiKeyFile = configProvider.getString("profiling.api-key-file");
            tmpApiKey = Config.getEnv(ConfigStrings.propertyNameToEnvironmentVariableName("profiling.api-key"));
            if (oldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(oldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)oldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        if (tmpApiKey == null) {
            String veryOldProfilingApiKeyFile = configProvider.getString("profiling.apikey.file");
            tmpApiKey = Config.getEnv(ConfigStrings.propertyNameToEnvironmentVariableName("profiling.apikey"));
            if (veryOldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(veryOldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)veryOldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        this.profilingTags = configProvider.getMergedMap("profiling.tags", new String[0]);
        int profilingStartDelayValue = configProvider.getInteger("profiling.start-delay", 10, new String[0]);
        boolean profilingStartForceFirstValue = configProvider.getBoolean("profiling.start-force-first", false, new String[0]);
        if (this.profilingEnabled == ProfilingEnablement.AUTO || this.profilingEnabled == ProfilingEnablement.INJECTED) {
            if (profilingStartDelayValue != 10) {
                log.info("Profiling start delay is set to {}s, but profiling enablement is set to auto. Using the default delay of {}s.", (Object)profilingStartDelayValue, (Object)10);
            }
            if (profilingStartForceFirstValue) {
                log.info("Profiling is requested to start immediately, but profiling enablement is set to auto. Profiling will be started with delay of {}s.", (Object)10);
            }
            profilingStartDelayValue = 10;
            profilingStartForceFirstValue = false;
        }
        this.profilingStartDelay = profilingStartDelayValue;
        this.profilingStartForceFirst = profilingStartForceFirstValue;
        this.profilingUploadPeriod = configProvider.getInteger("profiling.upload.period", 60, new String[0]);
        this.profilingTemplateOverrideFile = configProvider.getString("profiling.jfr-template-override-file");
        this.profilingUploadTimeout = configProvider.getInteger("profiling.upload.timeout", 30, new String[0]);
        this.profilingUploadCompression = configProvider.getString("profiling.debug.upload.compression", "zstd", "profiling.upload.compression");
        this.profilingProxyHost = configProvider.getString("profiling.proxy.host");
        this.profilingProxyPort = configProvider.getInteger("profiling.proxy.port", 8080, new String[0]);
        this.profilingProxyUsername = configProvider.getString("profiling.proxy.username");
        this.profilingProxyPassword = configProvider.getString("profiling.proxy.password");
        this.profilingExceptionSampleLimit = configProvider.getInteger("profiling.exception.sample.limit", 10000, new String[0]);
        this.profilingBackPressureSampleLimit = configProvider.getInteger("profiling.exception.sample.limit", 10000, new String[0]);
        this.profilingBackPressureEnabled = configProvider.getBoolean("profiling.backpressure.sampling.enabled", false, new String[0]);
        this.profilingDirectAllocationSampleLimit = configProvider.getInteger("profiling.direct.allocation.sample.limit", 2000, new String[0]);
        this.profilingExceptionHistogramTopItems = configProvider.getInteger("profiling.exception.histogram.top-items", 50, new String[0]);
        this.profilingExceptionHistogramMaxCollectionSize = configProvider.getInteger("profiling.exception.histogram.max-collection-size", 10000, new String[0]);
        this.profilingExcludeAgentThreads = configProvider.getBoolean("profiling.exclude.agent-threads", true, new String[0]);
        this.profilingRecordExceptionMessage = configProvider.getBoolean("profiling.exception.record.message", true, new String[0]);
        this.profilingUploadSummaryOn413Enabled = configProvider.getBoolean("profiling.upload.summary-on-413", false, new String[0]);
        this.crashTrackingAgentless = configProvider.getBoolean("crashtracking.agentless", false, new String[0]);
        this.crashTrackingTags = configProvider.getMergedMap("crashtracking.tags", new String[0]);
        this.crashTrackingErrorsIntakeEnabled = configProvider.getBoolean("crashtracking.errors-intake.enabled", false, new String[0]);
        float telemetryInterval = configProvider.getFloat("telemetry.heartbeat.interval", 60.0f);
        if ((double)telemetryInterval < 0.1 || telemetryInterval > 3600.0f) {
            log.warn("Invalid Telemetry heartbeat interval: {}. The value must be in range 0.1-3600", (Object)Float.valueOf(telemetryInterval));
            telemetryInterval = 60.0f;
        }
        this.telemetryHeartbeatInterval = telemetryInterval;
        this.telemetryExtendedHeartbeatInterval = configProvider.getLong("telemetry.extended.heartbeat.interval", 86400L, new String[0]);
        telemetryInterval = configProvider.getFloat("telemetry.metrics.interval", 10.0f);
        if ((double)telemetryInterval < 0.1 || telemetryInterval > 3600.0f) {
            log.warn("Invalid Telemetry metrics interval: {}. The value must be in range 0.1-3600", (Object)Float.valueOf(telemetryInterval));
            telemetryInterval = 10.0f;
        }
        this.telemetryMetricsInterval = telemetryInterval;
        this.telemetryMetricsEnabled = configProvider.getBoolean("telemetry.metrics.enabled", true, new String[0]);
        this.isTelemetryLogCollectionEnabled = instrumenterConfig.isTelemetryEnabled() && configProvider.getBoolean("telemetry.log-collection.enabled", true, new String[0]);
        this.isTelemetryDependencyServiceEnabled = configProvider.getBoolean("telemetry.dependency-collection.enabled", true, new String[0]);
        this.telemetryDependencyResolutionQueueSize = configProvider.getInteger("telemetry.dependency-resolution.queue.size", 100000, new String[0]);
        this.clientIpEnabled = configProvider.getBoolean("trace.client-ip.enabled", false, new String[0]);
        this.appSecReportingInband = configProvider.getBoolean("appsec.reporting.inband", false, new String[0]);
        this.appSecRulesFile = configProvider.getString("appsec.rules", null, new String[0]);
        this.appSecReportMaxTimeout = configProvider.getInteger("appsec.report.timeout", 60, new String[0]);
        this.appSecReportMinTimeout = Math.min(this.appSecReportMaxTimeout, 5);
        this.appSecTraceRateLimit = configProvider.getInteger("appsec.trace.rate.limit", 100, new String[0]);
        this.appSecWafMetrics = configProvider.getBoolean("appsec.waf.metrics", true, new String[0]);
        this.appSecWafTimeout = configProvider.getInteger("appsec.waf.timeout", 100000, new String[0]);
        this.appSecObfuscationParameterKeyRegexp = configProvider.getString("appsec.obfuscation.parameter_key_regexp", null, new String[0]);
        this.appSecObfuscationParameterValueRegexp = configProvider.getString("appsec.obfuscation.parameter_value_regexp", null, new String[0]);
        this.appSecHttpBlockedTemplateHtml = configProvider.getString("appsec.http.blocked.template.html", null, new String[0]);
        this.appSecHttpBlockedTemplateJson = configProvider.getString("appsec.http.blocked.template.json", null, new String[0]);
        this.appSecUserIdCollectionMode = UserIdCollectionMode.fromString(configProvider.getStringNotEmpty("appsec.auto-user-instrumentation-mode", null, new String[0]), configProvider.getStringNotEmpty("appsec.automated-user-events-tracking", null, new String[0]));
        this.appSecScaEnabled = configProvider.getBoolean("appsec.sca.enabled");
        this.appSecRaspEnabled = configProvider.getBoolean("appsec.rasp.enabled", true, new String[0]);
        this.appSecStackTraceEnabled = configProvider.getBoolean("appsec.stack-trace.enabled", true, "appsec.stacktrace.enabled");
        this.appSecMaxStackTraces = configProvider.getInteger("appsec.max.stack-traces", 2, "appsec.max.stacktraces");
        this.appSecMaxStackTraceDepth = configProvider.getInteger("appsec.max.stack-trace.depth", 32, "appsec.max.stacktrace.depth");
        this.appSecBodyParsingSizeLimit = configProvider.getInteger("appsec.body-parsing-size-limit", 10000000, new String[0]);
        this.apiSecurityEnabled = configProvider.getBoolean("api-security.enabled", true, "experimental.api-security.enabled");
        this.apiSecuritySampleDelay = configProvider.getFloat("api-security.sample.delay", 30.0f);
        this.apiSecurityEndpointCollectionMessageLimit = configProvider.getInteger("api-security.endpoint.collection.message.limit", 300, new String[0]);
        this.apiSecurityMaxDownstreamRequestBodyAnalysis = configProvider.getInteger("api-security.max.downstream.request.body.analysis", 1, new String[0]);
        this.apiSecurityDownstreamRequestBodyAnalysisSampleRate = configProvider.getDouble("api-security.downstream.request.body.analysis.sample_rate", 0.5, "api-security.downstream.request.analysis.sample_rate");
        this.iastDebugEnabled = configProvider.getBoolean("iast.debug.enabled", false, new String[0]);
        this.iastContextMode = configProvider.getEnum("iast.context.mode", IastContext.Mode.class, IastContext.Mode.REQUEST);
        this.iastDetectionMode = configProvider.getEnum("iast.detection.mode", IastDetectionMode.class, IastDetectionMode.DEFAULT);
        this.iastMaxConcurrentRequests = this.iastDetectionMode.getIastMaxConcurrentRequests(configProvider);
        this.iastVulnerabilitiesPerRequest = this.iastDetectionMode.getIastVulnerabilitiesPerRequest(configProvider);
        this.iastRequestSampling = this.iastDetectionMode.getIastRequestSampling(configProvider);
        this.iastDeduplicationEnabled = this.iastDetectionMode.isIastDeduplicationEnabled(configProvider);
        this.iastWeakHashAlgorithms = CollectionUtils.tryMakeImmutableSet(configProvider.getSet("iast.weak-hash.algorithms", ConfigDefaults.DEFAULT_IAST_WEAK_HASH_ALGORITHMS));
        this.iastWeakCipherAlgorithms = Config.getPattern("^(?:PBEWITH(?:HMACSHA(?:2(?:24ANDAES_(?:128|256)|56ANDAES_(?:128|256))|384ANDAES_(?:128|256)|512ANDAES_(?:128|256)|1ANDAES_(?:128|256))|SHA1AND(?:RC(?:2_(?:128|40)|4_(?:128|40))|DESEDE)|MD5AND(?:TRIPLEDES|DES))|DES(?:EDE(?:WRAP)?)?|BLOWFISH|ARCFOUR|RC2).*$", configProvider.getString("iast.weak-cipher.algorithms"));
        this.iastTelemetryVerbosity = configProvider.getEnum("iast.telemetry.verbosity", Verbosity.class, Verbosity.INFORMATION);
        this.iastRedactionEnabled = configProvider.getBoolean("iast.redaction.enabled", true, new String[0]);
        this.iastRedactionNamePattern = configProvider.getString("iast.redaction.name.pattern", "(?:p(?:ass)?w(?:or)?d|pass(?:_?phrase)?|secret|(?:api_?|private_?|public_?|access_?|secret_?)key(?:_?id)?|token|consumer_?(?:id|key|secret)|sign(?:ed|ature)?|auth(?:entication|orization)?)", new String[0]);
        this.iastRedactionValuePattern = configProvider.getString("iast.redaction.value.pattern", "(?:bearer\\s+[a-z0-9\\._\\-]+|glpat-[\\w\\-]{20}|gh[opsu]_[0-9a-zA-Z]{36}|ey[I-L][\\w=\\-]+\\.ey[I-L][\\w=\\-]+(?:\\.[\\w.+/=\\-]+)?|(?:[\\-]{5}BEGIN[a-z\\s]+PRIVATE\\sKEY[\\-]{5}[^\\-]+[\\-]{5}END[a-z\\s]+PRIVATE\\sKEY[\\-]{5}|ssh-rsa\\s*[a-z0-9/\\.+]{100,}))", new String[0]);
        this.iastTruncationMaxValueLength = configProvider.getInteger("iast.truncation.max.value.length", 250, new String[0]);
        this.iastMaxRangeCount = this.iastDetectionMode.getIastMaxRangeCount(configProvider);
        this.iastStacktraceLeakSuppress = configProvider.getBoolean("iast.stack-trace-leak.suppress", false, "iast.stacktrace-leak.suppress");
        this.iastHardcodedSecretEnabled = configProvider.getBoolean("iast.hardcoded-secret.enabled", true, new String[0]);
        this.iastAnonymousClassesEnabled = configProvider.getBoolean("iast.anonymous-classes.enabled", true, new String[0]);
        this.iastSourceMappingEnabled = configProvider.getBoolean("iast.source-mapping.enabled", false, new String[0]);
        this.iastSourceMappingMaxSize = configProvider.getInteger("iast.source-mapping.max-size", 1000, new String[0]);
        this.iastStackTraceEnabled = configProvider.getBoolean("iast.stack-trace.enabled", true, "iast.stacktrace.enabled");
        this.iastExperimentalPropagationEnabled = configProvider.getBoolean("iast.experimental.propagation.enabled", false, new String[0]);
        this.iastSecurityControlsConfiguration = configProvider.getString("iast.security-controls.configuration", null, new String[0]);
        this.iastDbRowsToTaint = configProvider.getInteger("iast.db.rows-to-taint", 1, new String[0]);
        this.llmObsAgentlessEnabled = configProvider.getBoolean("llmobs.agentless.enabled", false, new String[0]);
        String tempLlmObsMlApp = configProvider.getString("llmobs.ml.app");
        this.llmObsMlApp = tempLlmObsMlApp == null || tempLlmObsMlApp.isEmpty() ? this.serviceName : tempLlmObsMlApp;
        String llmObsAgentlessUrlStr = this.getFinalLLMObsUrl();
        URI parsedLLMObsUri = null;
        if (llmObsAgentlessUrlStr != null && !llmObsAgentlessUrlStr.isEmpty()) {
            try {
                parsedLLMObsUri = new URL(llmObsAgentlessUrlStr).toURI();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                log.error("Cannot parse LLM Observability agentless URL '{}', skipping", (Object)llmObsAgentlessUrlStr);
            }
        }
        this.llmObsAgentlessUrl = parsedLLMObsUri != null ? llmObsAgentlessUrlStr : null;
        this.ciVisibilityTraceSanitationEnabled = configProvider.getBoolean("civisibility.trace.sanitation.enabled", true, new String[0]);
        this.ciVisibilityAgentlessEnabled = configProvider.getBoolean("civisibility.agentless.enabled", false, new String[0]);
        this.ciVisibilitySourceDataEnabled = configProvider.getBoolean("civisibility.source.data.enabled", true, new String[0]);
        this.ciVisibilityBuildInstrumentationEnabled = configProvider.getBoolean("civisibility.build.instrumentation.enabled", true, new String[0]);
        String ciVisibilityAgentlessUrlStr = configProvider.getString("civisibility.agentless.url");
        this.ciVisibilityAgentlessUrl = Config.isValidUrl(ciVisibilityAgentlessUrlStr) ? ciVisibilityAgentlessUrlStr : null;
        String ciVisibilityIntakeAgentlessUrlStr = configProvider.getString("civisibility.intake.agentless.url");
        this.ciVisibilityIntakeAgentlessUrl = Config.isValidUrl(ciVisibilityIntakeAgentlessUrlStr) ? ciVisibilityIntakeAgentlessUrlStr : null;
        this.ciVisibilityAgentJarUri = configProvider.getString("civisibility.agent.jar.uri");
        this.ciVisibilityAutoConfigurationEnabled = configProvider.getBoolean("civisibility.auto.configuration.enabled", true, new String[0]);
        this.ciVisibilityAdditionalChildProcessJvmArgs = configProvider.getString("civisibility.additional.child.process.jvm.args");
        this.ciVisibilityCompilerPluginAutoConfigurationEnabled = configProvider.getBoolean("civisibility.compiler.plugin.auto.configuration.enabled", true, new String[0]);
        this.ciVisibilityCodeCoverageEnabled = configProvider.getBoolean("civisibility.code.coverage.enabled", true, new String[0]);
        this.ciVisibilityCoverageLinesEnabled = configProvider.getBoolean("civisibility.code.coverage.lines.enabled");
        this.ciVisibilityCodeCoverageReportDumpDir = configProvider.getString("civisibility.code.coverage.report.dump.dir");
        this.ciVisibilityCompilerPluginVersion = configProvider.getString("civisibility.compiler.plugin.version", "0.2.4", new String[0]);
        this.ciVisibilityJacocoPluginVersion = configProvider.getString("civisibility.jacoco.plugin.version", "0.8.14", new String[0]);
        this.ciVisibilityJacocoPluginVersionProvided = configProvider.getString("civisibility.jacoco.plugin.version") != null;
        this.ciVisibilityCodeCoverageIncludes = Arrays.asList(COLON.split(configProvider.getString("civisibility.code.coverage.includes", ":", new String[0])));
        this.ciVisibilityCodeCoverageExcludes = Arrays.asList(COLON.split(configProvider.getString("civisibility.code.coverage.excludes", "ddtrot.dd.trace.*:org.apache.commons.*:org.mockito.*", new String[0])));
        this.ciVisibilityCodeCoverageIncludedPackages = Config.convertJacocoExclusionFormatToPackagePrefixes(this.ciVisibilityCodeCoverageIncludes);
        this.ciVisibilityCodeCoverageExcludedPackages = Config.convertJacocoExclusionFormatToPackagePrefixes(this.ciVisibilityCodeCoverageExcludes);
        this.ciVisibilityJacocoGradleSourceSets = configProvider.getList("civisibility.gradle.sourcesets", Arrays.asList("main", "test"), new String[0]);
        this.ciVisibilityCodeCoverageReportUploadEnabled = configProvider.getBoolean("civisibility.code.coverage.report.upload.enabled", true, new String[0]);
        this.ciVisibilityDebugPort = configProvider.getInteger("civisibility.debug.port");
        this.ciVisibilityGitClientEnabled = configProvider.getBoolean("civisibility.git.client.enabled", true, new String[0]);
        this.ciVisibilityGitUploadEnabled = configProvider.getBoolean("civisibility.git.upload.enabled", true, new String[0]);
        this.ciVisibilityGitUnshallowEnabled = configProvider.getBoolean("civisibility.git.unshallow.enabled", true, new String[0]);
        this.ciVisibilityGitUnshallowDefer = configProvider.getBoolean("civisibility.git.unshallow.defer", true, new String[0]);
        this.ciVisibilityGitCommandTimeoutMillis = configProvider.getLong("civisibility.git.command.timeout.millis", 30000L, new String[0]);
        this.ciVisibilityBackendApiTimeoutMillis = configProvider.getLong("civisibility.backend.api.timeout.millis", 30000L, new String[0]);
        this.ciVisibilityGitUploadTimeoutMillis = configProvider.getLong("civisibility.git.upload.timeout.millis", 60000L, new String[0]);
        this.ciVisibilityGitRemoteName = configProvider.getString("civisibility.git.remote.name", "origin", new String[0]);
        this.ciVisibilitySignalServerHost = configProvider.getString("civisibility.signal.server.host", "127.0.0.1", new String[0]);
        this.ciVisibilitySignalServerPort = configProvider.getInteger("civisibility.signal.server.port", 0, new String[0]);
        this.ciVisibilitySignalClientTimeoutMillis = configProvider.getInteger("civisibility.signal.client.timeout.millis", 10000, new String[0]);
        this.ciVisibilityItrEnabled = configProvider.getBoolean("civisibility.itr.enabled", true, new String[0]);
        this.ciVisibilityTestSkippingEnabled = configProvider.getBoolean("civisibility.test.skipping.enabled", true, new String[0]);
        this.ciVisibilityCiProviderIntegrationEnabled = configProvider.getBoolean("civisibility.ciprovider.integration.enabled", true, new String[0]);
        this.ciVisibilityRepoIndexDuplicateKeyCheckEnabled = configProvider.getBoolean("civisibility.repo.index.duplicate.key.check.enabled", true, new String[0]);
        this.ciVisibilityRepoIndexFollowSymlinks = configProvider.getBoolean("civisibility.repo.index.follow.symlinks", false, new String[0]);
        this.ciVisibilityExecutionSettingsCacheSize = configProvider.getInteger("civisibility.execution.settings.cache.size", 16, new String[0]);
        this.ciVisibilityJvmInfoCacheSize = configProvider.getInteger("civisibility.jvm.info.cache.size", 8, new String[0]);
        this.ciVisibilityCoverageRootPackagesLimit = configProvider.getInteger("civisibility.code.coverage.root.packages.limit", 50, new String[0]);
        this.ciVisibilityInjectedTracerVersion = configProvider.getString("civisibility.injected.tracer.version");
        this.ciVisibilityResourceFolderNames = configProvider.getList("civisibility.resource.folder.names", ConfigDefaults.DEFAULT_CIVISIBILITY_RESOURCE_FOLDER_NAMES, new String[0]);
        this.ciVisibilityFlakyRetryEnabled = configProvider.getBoolean("civisibility.flaky.retry.enabled", true, new String[0]);
        this.ciVisibilityImpactedTestsDetectionEnabled = configProvider.getBoolean("civisibility.impacted.tests.detection.enabled", true, new String[0]);
        this.ciVisibilityKnownTestsRequestEnabled = configProvider.getBoolean("civisibility.known.tests.request.enabled", true, new String[0]);
        this.ciVisibilityFlakyRetryOnlyKnownFlakes = configProvider.getBoolean("civisibility.flaky.retry.only.known.flakes", false, new String[0]);
        this.ciVisibilityEarlyFlakeDetectionEnabled = configProvider.getBoolean("civisibility.early.flake.detection.enabled", true, new String[0]);
        this.ciVisibilityEarlyFlakeDetectionLowerLimit = configProvider.getInteger("civisibility.early.flake.detection.lower.limit", 30, new String[0]);
        this.ciVisibilityFlakyRetryCount = configProvider.getInteger("civisibility.flaky.retry.count", 5, new String[0]);
        this.ciVisibilityTotalFlakyRetryCount = configProvider.getInteger("civisibility.total.flaky.retry.count", 1000, new String[0]);
        this.ciVisibilitySessionName = configProvider.getString("test.session.name");
        this.ciVisibilityModuleName = configProvider.getString("civisibility.module.name");
        this.ciVisibilityTestCommand = configProvider.getString("civisibility.test.command");
        this.ciVisibilityTelemetryEnabled = configProvider.getBoolean("civisibility.telemetry.enabled", true, new String[0]);
        this.ciVisibilityRumFlushWaitMillis = configProvider.getLong("civisibility.rum.flush.wait.millis", 500L, new String[0]);
        this.ciVisibilityAutoInjected = Strings.isNotBlank(configProvider.getString("civisibility.auto.instrumentation.provider"));
        this.ciVisibilityTestOrder = configProvider.getString("civisibility.test.order");
        this.ciVisibilityTestManagementEnabled = configProvider.getBoolean("test.management.enabled", true, new String[0]);
        this.ciVisibilityTestManagementAttemptToFixRetries = configProvider.getInteger("test.management.attempt.to.fix.retries");
        this.ciVisibilityScalatestForkMonitorEnabled = configProvider.getBoolean("civisibility.scalatest.fork.monitor.enabled", false, new String[0]);
        this.gitPullRequestBaseBranch = configProvider.getString("git.pull.request.base.branch");
        this.gitPullRequestBaseBranchSha = configProvider.getString("git.pull.request.base.branch.sha");
        this.gitCommitHeadSha = configProvider.getString("git.commit.head.sha");
        this.ciVisibilityFailedTestReplayEnabled = configProvider.getBoolean("test.failed.test.replay.enabled", true, new String[0]);
        this.remoteConfigEnabled = configProvider.getBoolean("remote_configuration.enabled", true, "remote_config.enabled");
        this.remoteConfigIntegrityCheckEnabled = configProvider.getBoolean("remote_config.integrity_check.enabled", false, new String[0]);
        this.remoteConfigUrl = configProvider.getString("remote_config.url");
        this.remoteConfigPollIntervalSeconds = configProvider.getFloat("remote_config.poll_interval.seconds", 5.0f);
        this.remoteConfigMaxPayloadSize = (long)configProvider.getInteger("remote_config.max.payload.size", 5120, new String[0]) * 1024L;
        this.remoteConfigTargetsKeyId = configProvider.getString("rc.targets.key.id", "5c4ece41241a1bb513f6e3e5df74ab7d5183dfffbd71bfd43127920d880569fd", new String[0]);
        this.remoteConfigTargetsKey = configProvider.getString("rc.targets.key", "e3f1f98c9da02a93bb547f448b472d727e14b22455235796fe49863856252508", new String[0]);
        this.remoteConfigMaxExtraServices = configProvider.getInteger("remote_config.max_extra_services", 64, new String[0]);
        this.dynamicInstrumentationEnabled = configProvider.getBoolean("dynamic.instrumentation.enabled", false, new String[0]);
        this.dynamicInstrumentationSnapshotUrl = configProvider.getString("dynamic.instrumentation.snapshot.url");
        this.distributedDebuggerEnabled = configProvider.getBoolean("distributed.debugger.enabled", false, new String[0]);
        this.dynamicInstrumentationUploadTimeout = configProvider.getInteger("dynamic.instrumentation.upload.timeout", 30, new String[0]);
        this.dynamicInstrumentationUploadFlushInterval = configProvider.isSet("dynamic.instrumentation.upload.interval.seconds") ? (int)(configProvider.getFloat("dynamic.instrumentation.upload.interval.seconds", 0.0f) * 1000.0f) : configProvider.getInteger("dynamic.instrumentation.upload.flush.interval", 0, new String[0]);
        this.dynamicInstrumentationClassFileDumpEnabled = configProvider.getBoolean("dynamic.instrumentation.classfile.dump.enabled", false, new String[0]);
        this.dynamicInstrumentationPollInterval = configProvider.getInteger("dynamic.instrumentation.poll.interval", 1, new String[0]);
        this.dynamicInstrumentationDiagnosticsInterval = configProvider.getInteger("dynamic.instrumentation.diagnostics.interval", 3600, new String[0]);
        this.dynamicInstrumentationMetricEnabled = this.runtimeMetricsEnabled && configProvider.getBoolean("dynamic.instrumentation.metrics.enabled", false, new String[0]);
        this.dynamicInstrumentationProbeFile = configProvider.getString("dynamic.instrumentation.probe.file");
        this.dynamicInstrumentationUploadBatchSize = configProvider.getInteger("dynamic.instrumentation.upload.batch.size", 100, new String[0]);
        this.dynamicInstrumentationMaxPayloadSize = (long)configProvider.getInteger("dynamic.instrumentation.max.payload.size", 1024, new String[0]) * 1024L;
        this.dynamicInstrumentationVerifyByteCode = configProvider.getBoolean("dynamic.instrumentation.verify.bytecode", true, new String[0]);
        this.dynamicInstrumentationInstrumentTheWorld = configProvider.getString("dynamic.instrumentation.instrument.the.world");
        this.dynamicInstrumentationExcludeFiles = configProvider.getString("dynamic.instrumentation.exclude.files");
        this.dynamicInstrumentationIncludeFiles = configProvider.getString("dynamic.instrumentation.include.files");
        this.dynamicInstrumentationCaptureTimeout = configProvider.getInteger("dynamic.instrumentation.capture.timeout", 100, new String[0]);
        this.dynamicInstrumentationRedactedIdentifiers = configProvider.getString("dynamic.instrumentation.redacted.identifiers", null, new String[0]);
        this.dynamicInstrumentationRedactionExcludedIdentifiers = CollectionUtils.tryMakeImmutableSet(configProvider.getList("dynamic.instrumentation.redaction.excluded.identifiers"));
        this.dynamicInstrumentationRedactedTypes = configProvider.getString("dynamic.instrumentation.redacted.types", null, new String[0]);
        this.dynamicInstrumentationLocalVarHoistingLevel = configProvider.getInteger("dynamic.instrumentation.localvar.hoisting.level", 1, new String[0]);
        this.symbolDatabaseEnabled = configProvider.getBoolean("symbol.database.upload.enabled", true, new String[0]);
        this.symbolDatabaseForceUpload = configProvider.getBoolean("internal.force.symbol.database.upload", false, new String[0]);
        this.symbolDatabaseFlushThreshold = configProvider.getInteger("symbol.database.flush.threshold", 100, new String[0]);
        this.symbolDatabaseCompressed = configProvider.getBoolean("symbol.database.compressed", true, new String[0]);
        this.debuggerExceptionEnabled = configProvider.getBoolean("exception.debugging.enabled", false, "exception.replay.enabled");
        this.debuggerCodeOriginEnabled = configProvider.getBoolean("code.origin.for.spans.enabled", InstrumenterConfig.getDefaultCodeOriginForSpanEnabled(), new String[0]);
        this.debuggerCodeOriginMaxUserFrames = configProvider.getInteger("code.origin.max.user.frames", 8, new String[0]);
        this.debuggerMaxExceptionPerSecond = configProvider.getInteger("exception.replay.max.exception.analysis.limit", 100, new String[0]);
        this.debuggerExceptionOnlyLocalRoot = configProvider.getBoolean("internal.exception.replay.only.local.root", false, new String[0]);
        this.debuggerExceptionCaptureIntermediateSpansEnabled = configProvider.getBoolean("exception.replay.capture.intermediate.spans.enabled", true, new String[0]);
        this.debuggerExceptionMaxCapturedFrames = configProvider.getInteger("exception.replay.max.frames.to.capture", 3, "exception.replay.capture.max.frames");
        this.debuggerExceptionCaptureInterval = configProvider.getInteger("exception.replay.capture.interval.seconds", 3600, new String[0]);
        this.debuggerSourceFileTrackingEnabled = configProvider.getBoolean("dynamic.instrumentation.source.file.tracking.enabled", true, new String[0]);
        this.debuggerThirdPartyIncludes = CollectionUtils.tryMakeImmutableSet(configProvider.getList("third.party.includes", Collections.emptyList(), "third.party.detection.includes"));
        this.debuggerThirdPartyExcludes = CollectionUtils.tryMakeImmutableSet(configProvider.getList("third.party.excludes", Collections.emptyList(), "third.party.detection.excludes"));
        this.debuggerShadingIdentifiers = CollectionUtils.tryMakeImmutableSet(configProvider.getList("third.party.shading.identifiers"));
        this.awsPropagationEnabled = this.isPropagationEnabled(true, "aws", "aws-sdk");
        this.sqsPropagationEnabled = this.isPropagationEnabled(true, "sqs");
        this.sqsBodyPropagationEnabled = configProvider.getBoolean("trace.sqs.body.propagation.enabled", false, new String[0]);
        this.kafkaClientPropagationEnabled = this.isPropagationEnabled(true, "kafka", "kafka.client");
        this.kafkaClientPropagationDisabledTopics = CollectionUtils.tryMakeImmutableSet(configProvider.getList("kafka.client.propagation.disabled.topics"));
        this.kafkaClientBase64DecodingEnabled = configProvider.getBoolean("kafka.client.base64.decoding.enabled", false, new String[0]);
        this.jmsPropagationEnabled = this.isPropagationEnabled(true, "jms");
        this.jmsPropagationDisabledTopics = CollectionUtils.tryMakeImmutableSet(configProvider.getList("jms.propagation.disabled.topics"));
        this.jmsPropagationDisabledQueues = CollectionUtils.tryMakeImmutableSet(configProvider.getList("jms.propagation.disabled.queues"));
        this.jmsUnacknowledgedMaxAge = configProvider.getInteger("jms.unacknowledged.max.age", 3600, new String[0]);
        this.rabbitPropagationEnabled = this.isPropagationEnabled(true, "rabbit", "rabbitmq");
        this.rabbitPropagationDisabledQueues = CollectionUtils.tryMakeImmutableSet(configProvider.getList("rabbit.propagation.disabled.queues"));
        this.rabbitPropagationDisabledExchanges = CollectionUtils.tryMakeImmutableSet(configProvider.getList("rabbit.propagation.disabled.exchanges"));
        this.rabbitIncludeRoutingKeyInResource = configProvider.getBoolean("rabbit.include.routingkey.in.resource", true, new String[0]);
        this.messageBrokerSplitByDestination = configProvider.getBoolean("message.broker.split-by-destination", false, new String[0]);
        this.grpcIgnoredInboundMethods = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.grpc.ignored.inbound.methods"));
        ArrayList<String> tmpGrpcIgnoredOutboundMethods = new ArrayList<String>();
        tmpGrpcIgnoredOutboundMethods.addAll(configProvider.getList("trace.grpc.ignored.outbound.methods"));
        if (InstrumenterConfig.get().isIntegrationEnabled(Collections.singleton("google-pubsub"), true)) {
            tmpGrpcIgnoredOutboundMethods.addAll(configProvider.getList("trace.google-pubsub.ignored.grpc.methods", Arrays.asList("google.pubsub.v1.Subscriber/ModifyAckDeadline", "google.pubsub.v1.Subscriber/Acknowledge", "google.pubsub.v1.Subscriber/Pull", "google.pubsub.v1.Subscriber/StreamingPull", "google.pubsub.v1.Publisher/Publish"), new String[0]));
        }
        this.grpcIgnoredOutboundMethods = CollectionUtils.tryMakeImmutableSet(tmpGrpcIgnoredOutboundMethods);
        this.grpcServerTrimPackageResource = configProvider.getBoolean("trace.grpc.server.trim-package-resource", false, new String[0]);
        this.grpcServerErrorStatuses = configProvider.getIntegerRange("grpc.server.error.statuses", ConfigDefaults.DEFAULT_GRPC_SERVER_ERROR_STATUSES, new String[0]);
        this.grpcClientErrorStatuses = configProvider.getIntegerRange("grpc.client.error.statuses", ConfigDefaults.DEFAULT_GRPC_CLIENT_ERROR_STATUSES, new String[0]);
        this.hystrixTagsEnabled = configProvider.getBoolean("hystrix.tags.enabled", false, new String[0]);
        this.hystrixMeasuredEnabled = configProvider.getBoolean("hystrix.measured.enabled", false, new String[0]);
        this.resilience4jMeasuredEnabled = configProvider.getBoolean("resilience4j.measured.enabled", false, new String[0]);
        this.resilience4jTagMetricsEnabled = configProvider.getBoolean("resilience4j.tag-metrics.enabled", false, new String[0]);
        this.igniteCacheIncludeKeys = configProvider.getBoolean("ignite.cache.include_keys", false, new String[0]);
        this.obfuscationQueryRegexp = configProvider.getString("trace.obfuscation.query.string.regexp", null, "obfuscation.query.string.regexp");
        this.playReportHttpStatus = configProvider.getBoolean("trace.play.report-http-status", false, new String[0]);
        this.servletPrincipalEnabled = configProvider.getBoolean("trace.servlet.principal.enabled", false, new String[0]);
        this.xDatadogTagsMaxLength = configProvider.getInteger("trace.x-datadog-tags.max.length", 512, new String[0]);
        this.servletAsyncTimeoutError = configProvider.getBoolean("trace.servlet.async-timeout.error", true, new String[0]);
        this.logLevel = configProvider.getString("log.level");
        this.debugEnabled = configProvider.getBoolean("trace.debug", false, new String[0]);
        this.triageEnabled = configProvider.getBoolean("trace.triage", instrumenterConfig.isTriageEnabled(), new String[0]);
        this.triageReportTrigger = configProvider.getString("triage.report.trigger");
        this.triageReportDir = null != this.triageReportTrigger ? configProvider.getString("triage.report.dir", Config.getProp("java.io.tmpdir"), new String[0]) : null;
        this.startupLogsEnabled = configProvider.getBoolean("trace.startup.logs", true, new String[0]);
        this.cwsEnabled = configProvider.getBoolean("cws.enabled", false, new String[0]);
        this.cwsTlsRefresh = configProvider.getInteger("cws.tls.refresh", 5000, new String[0]);
        this.dataJobsOpenLineageEnabled = configProvider.getBoolean("data.jobs.openlineage.enabled", false, new String[0]);
        this.dataJobsOpenLineageTimeoutEnabled = configProvider.getBoolean("data.jobs.openlineage.timeout.enabled", true, new String[0]);
        this.dataJobsParseSparkPlanEnabled = configProvider.getBoolean("data.jobs.parse_spark_plan.enabled", true, new String[0]);
        this.dataJobsExperimentalFeaturesEnabled = configProvider.getBoolean("data.jobs.experimental_features.enabled", false, new String[0]);
        this.dataStreamsEnabled = configProvider.getBoolean("data.streams.enabled", false, new String[0]);
        this.dataStreamsBucketDurationSeconds = configProvider.getFloat("data.streams.bucket_duration.seconds", 10.0f);
        this.azureAppServices = configProvider.getBoolean("azure.app.services", false, new String[0]);
        this.traceAgentPath = configProvider.getString("trace.agent.path");
        String traceAgentArgsString = configProvider.getString("trace.agent.args");
        this.traceAgentArgs = traceAgentArgsString == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Config.parseStringIntoSetOfNonEmptyStrings(traceAgentArgsString)));
        this.dogStatsDPath = configProvider.getString("ddtrot.dogstatsd.path");
        String dogStatsDArgsString = configProvider.getString("ddtrot.dogstatsd.args");
        this.dogStatsDArgs = dogStatsDArgsString == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Config.parseStringIntoSetOfNonEmptyStrings(dogStatsDArgsString)));
        this.apiKey = tmpApiKey;
        boolean longRunningEnabled = configProvider.getBoolean("trace.experimental.long-running.enabled", false, new String[0]);
        long longRunningTraceInitialFlushInterval = configProvider.getLong("trace.experimental.long-running.initial.flush.interval", 20L, new String[0]);
        long longRunningTraceFlushInterval = configProvider.getLong("trace.experimental.long-running.flush.interval", 120L, new String[0]);
        this.serviceDiscoveryEnabled = configProvider.getBoolean("trace.service.discovery.enabled", true, new String[0]);
        if (longRunningEnabled && (longRunningTraceInitialFlushInterval < 10L || longRunningTraceInitialFlushInterval > 450L)) {
            log.warn("Provided long running trace initial flush interval of {} seconds. It should be between 10 seconds and 7.5 minutes.Setting the flush interval to the default value of {} seconds .", (Object)longRunningTraceInitialFlushInterval, (Object)20L);
            longRunningTraceInitialFlushInterval = 20L;
        }
        if (longRunningEnabled && (longRunningTraceFlushInterval < 20L || longRunningTraceFlushInterval > 450L)) {
            log.warn("Provided long running trace flush interval of {} seconds. It should be between 20 seconds and 7.5 minutes.Setting the flush interval to the default value of {} seconds .", (Object)longRunningTraceFlushInterval, (Object)120L);
            longRunningTraceFlushInterval = 120L;
        }
        this.longRunningTraceEnabled = longRunningEnabled;
        this.longRunningTraceInitialFlushInterval = longRunningTraceInitialFlushInterval;
        this.longRunningTraceFlushInterval = longRunningTraceFlushInterval;
        this.sparkTaskHistogramEnabled = configProvider.getBoolean("spark.task-histogram.enabled", true, new String[0]);
        this.sparkAppNameAsService = configProvider.getBoolean("spark.app-name-as-service", false, new String[0]);
        this.jaxRsExceptionAsErrorsEnabled = configProvider.getBoolean("trace.jax-rs.exception-as-error.enabled", true, new String[0]);
        this.axisPromoteResourceName = configProvider.getBoolean("trace.axis.promote.resource-name", false, new String[0]);
        this.websocketMessagesInheritSampling = configProvider.getBoolean("trace.websocket.messages.inherit.sampling", true, new String[0]);
        this.websocketMessagesSeparateTraces = configProvider.getBoolean("trace.websocket.messages.separate.traces", true, new String[0]);
        this.websocketTagSessionId = configProvider.getBoolean("trace.websocket.tag.session-id", false, new String[0]);
        this.traceFlushIntervalSeconds = configProvider.getFloat("trace.flush.interval", 1.0f);
        this.tracePostProcessingTimeout = configProvider.getLong("trace.post-processing.timeout", 1000L, new String[0]);
        if (this.isLlmObsEnabled()) {
            log.debug("LLM Observability enabled for ML app {}, agentless mode {}", (Object)this.llmObsMlApp, (Object)this.llmObsAgentlessEnabled);
        }
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            if (this.isCiVisibilityEnabled() && this.ciVisibilityAgentlessEnabled) {
                throw new FatalAgentMisconfigurationError("Attempt to start in CI Visibility in Agentless mode without API key. Please ensure that either an API key is configured, or the tracer is set up to work with the Agent");
            }
            if (this.profilingAgentless) {
                log.warn("Agentless profiling activated but no api key provided. Profile uploading will likely fail");
            }
            if (this.isLlmObsEnabled() && this.llmObsAgentlessEnabled) {
                throw new FatalAgentMisconfigurationError("Attempt to start LLM Observability in Agentless mode without API key. Please ensure that either an API key is configured, or the tracer is set up to work with the Agent");
            }
        }
        this.telemetryDebugRequestsEnabled = configProvider.getBoolean("telemetry.debug.requests.enabled", false, new String[0]);
        this.agentlessLogSubmissionQueueSize = configProvider.getInteger("agentless.log.submission.queue.size", 1024, new String[0]);
        this.agentlessLogSubmissionLevel = configProvider.getString("agentless.log.submission.level", "INFO", new String[0]);
        this.agentlessLogSubmissionUrl = configProvider.getString("agentless.log.submission.url");
        this.agentlessLogSubmissionProduct = this.isCiVisibilityEnabled() ? "citest" : "apm";
        this.cloudPayloadTaggingServices = configProvider.getSet("trace.cloud.payload.tagging.services", ConfigDefaults.DEFAULT_TRACE_CLOUD_PAYLOAD_TAGGING_SERVICES);
        List<String> cloudReqPayloadTaggingConf = configProvider.getList("trace.cloud.request.payload.tagging", null, new String[0]);
        this.cloudRequestPayloadTagging = null == cloudReqPayloadTaggingConf ? null : (cloudReqPayloadTaggingConf.size() == 1 && cloudReqPayloadTaggingConf.get(0).equalsIgnoreCase("all") ? Collections.emptyList() : ((validRequestJsonPaths = JsonPathParser.parseJsonPaths(cloudReqPayloadTaggingConf)).isEmpty() ? null : validRequestJsonPaths));
        List<String> cloudRespPayloadTaggingConf = configProvider.getList("trace.cloud.response.payload.tagging", null, new String[0]);
        this.cloudResponsePayloadTagging = null == cloudRespPayloadTaggingConf ? null : (cloudRespPayloadTaggingConf.size() == 1 && cloudRespPayloadTaggingConf.get(0).equalsIgnoreCase("all") ? Collections.emptyList() : ((validResponseJsonPaths = JsonPathParser.parseJsonPaths(cloudRespPayloadTaggingConf)).isEmpty() ? null : validResponseJsonPaths));
        this.cloudPayloadTaggingMaxDepth = configProvider.getInteger("trace.cloud.payload.tagging.max-depth", 10, new String[0]);
        this.cloudPayloadTaggingMaxTags = configProvider.getInteger("trace.cloud.payload.tagging.max-tags", 758, new String[0]);
        this.dependecyResolutionPeriodMillis = configProvider.getLong("telemetry.dependency.resolution.period.millis", 1000L, new String[0]);
        this.timelineEventsEnabled = configProvider.getBoolean("profiling.timeline.events.enabled", true, new String[0]);
        if (!(this.appSecScaEnabled == null || !this.appSecScaEnabled.booleanValue() || this.isTelemetryEnabled() && this.isTelemetryDependencyServiceEnabled())) {
            log.warn(LogCollector.SEND_TELEMETRY, "AppSec SCA is enabled but telemetry is disabled. AppSec SCA will not work.");
        }
        this.ssiInjectionEnabled = configProvider.getString("injection.enabled");
        this.ssiInjectionForce = configProvider.getBoolean("inject.force", false, new String[0]);
        this.instrumentationSource = configProvider.getString("instrumentation.source", "manual", new String[0]);
        this.apmTracingEnabled = configProvider.getBoolean("apm.tracing.enabled", true, new String[0]);
        this.jdkSocketEnabled = configProvider.getBoolean("jdk.socket.enabled", true, new String[0]);
        this.optimizedMapEnabled = configProvider.getBoolean("optimized.map.enabled", false, new String[0]);
        this.spanBuilderReuseEnabled = configProvider.getBoolean("span.builder.reuse.enabled", true, new String[0]);
        this.tagNameUtf8CacheSize = Math.max(configProvider.getInteger("tag.name.utf8.cache.size", 128, new String[0]), 0);
        this.tagValueUtf8CacheSize = Math.max(configProvider.getInteger("tag.value.utf8.cache.size", 384, new String[0]), 0);
        int defaultStackTraceLengthLimit = instrumenterConfig.isCiVisibilityEnabled() ? 5000 : Integer.MAX_VALUE;
        this.stackTraceLengthLimit = configProvider.getInteger("stack.trace.length.limit", defaultStackTraceLengthLimit, new String[0]);
        this.rumInjectorConfig = this.parseRumConfig(configProvider);
        this.aiGuardEnabled = configProvider.getBoolean("ai_guard.enabled", false, new String[0]);
        this.aiGuardEndpoint = configProvider.getString("ai_guard.endpoint");
        this.aiGuardTimeout = configProvider.getInteger("ai_guard.timeout", 10000, new String[0]);
        this.aiGuardMaxContentSize = configProvider.getInteger("ai_guard.max-content-size", 524288, new String[0]);
        this.aiGuardMaxMessagesLength = configProvider.getInteger("ai_guard.max-messages-length", 16, new String[0]);
        log.debug("New instance: {}", (Object)this);
    }

    private static boolean isValidUrl(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            log.error("Cannot parse URL '{}', skipping", (Object)url);
            return false;
        }
    }

    private RumInjectorConfig parseRumConfig(ConfigProvider configProvider) {
        if (!this.instrumenterConfig.isRumEnabled()) {
            return null;
        }
        try {
            return new RumInjectorConfig(configProvider.getString("rum.application.id"), configProvider.getString("rum.client.token"), configProvider.getString("rum.site"), configProvider.getString("rum.service"), configProvider.getString("rum.environment"), configProvider.getInteger("rum.major.version", 6, new String[0]), configProvider.getString("rum.version"), configProvider.getBoolean("rum.track.user.interaction"), configProvider.getBoolean("rum.track.resources"), configProvider.getBoolean("rum.track.long.tasks"), configProvider.getEnum("rum.default.privacy.level", RumInjectorConfig.PrivacyLevel.class, null), configProvider.getFloat("rum.session.sample.rate", new String[0]), configProvider.getFloat("rum.session.replay.sample.rate", new String[0]), configProvider.getString("rum.remote.configuration.id"));
        }
        catch (IllegalArgumentException e) {
            log.warn("Unable to configure RUM injection", (Throwable)e);
            return null;
        }
    }

    public static String[] convertJacocoExclusionFormatToPackagePrefixes(List<String> packages) {
        return (String[])packages.stream().map(s -> (s.endsWith("*") ? s.substring(0, s.length() - 1) : s).replace('.', '/')).toArray(String[]::new);
    }

    public ConfigProvider configProvider() {
        return this.configProvider;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public String getRuntimeId() {
        return this.runtimeIdEnabled ? RuntimeIdHolder.runtimeId : "";
    }

    public Long getProcessId() {
        return PidHelper.getPidAsLong();
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getSite() {
        return this.site;
    }

    public String getHostName() {
        return HostNameHolder.hostName;
    }

    public Supplier<String> getHostNameSupplier() {
        return HostNameHolder::getHostName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isServiceNameSetByUser() {
        return this.serviceNameSetByUser;
    }

    public String getRootContextServiceName() {
        return this.rootContextServiceName;
    }

    public Set<String> getExperimentalFeaturesEnabled() {
        return this.experimentalFeaturesEnabled;
    }

    public boolean isExperimentalPropagateProcessTagsEnabled() {
        return this.experimentalPropagateProcessTagsEnabled;
    }

    public boolean isTraceEnabled() {
        return this.instrumenterConfig.isTraceEnabled();
    }

    public boolean isServiceDiscoveryEnabled() {
        return this.serviceDiscoveryEnabled;
    }

    public boolean isLongRunningTraceEnabled() {
        return this.longRunningTraceEnabled;
    }

    public long getLongRunningTraceInitialFlushInterval() {
        return this.longRunningTraceInitialFlushInterval;
    }

    public long getLongRunningTraceFlushInterval() {
        return this.longRunningTraceFlushInterval;
    }

    public float getTraceFlushIntervalSeconds() {
        return this.traceFlushIntervalSeconds;
    }

    public long getTracePostProcessingTimeout() {
        return this.tracePostProcessingTimeout;
    }

    public boolean isIntegrationSynapseLegacyOperationName() {
        return this.integrationSynapseLegacyOperationName;
    }

    public String getWriterType() {
        return this.writerType;
    }

    public boolean isInjectBaggageAsTagsEnabled() {
        return this.injectBaggageAsTagsEnabled;
    }

    public boolean isAgentConfiguredUsingDefault() {
        return this.agentConfiguredUsingDefault;
    }

    public String getAgentUrl() {
        return this.agentUrl;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getAgentUnixDomainSocket() {
        return this.agentUnixDomainSocket;
    }

    public String getAgentNamedPipe() {
        return this.agentNamedPipe;
    }

    public int getAgentTimeout() {
        return this.agentTimeout;
    }

    public boolean isForceClearTextHttpForIntakeClient() {
        return this.forceClearTextHttpForIntakeClient;
    }

    public Set<String> getNoProxyHosts() {
        return this.noProxyHosts;
    }

    public boolean isPrioritySamplingEnabled() {
        return this.prioritySamplingEnabled;
    }

    public String getPrioritySamplingForce() {
        return this.prioritySamplingForce;
    }

    public boolean isTraceResolverEnabled() {
        return this.traceResolverEnabled;
    }

    public Set<String> getIastWeakHashAlgorithms() {
        return this.iastWeakHashAlgorithms;
    }

    public Pattern getIastWeakCipherAlgorithms() {
        return this.iastWeakCipherAlgorithms;
    }

    public boolean isIastDeduplicationEnabled() {
        return this.iastDeduplicationEnabled;
    }

    public int getSpanAttributeSchemaVersion() {
        return this.spanAttributeSchemaVersion;
    }

    public boolean isPeerHostNameEnabled() {
        return this.peerHostNameEnabled;
    }

    public boolean isPeerServiceDefaultsEnabled() {
        return this.peerServiceDefaultsEnabled;
    }

    public Map<String, String> getPeerServiceComponentOverrides() {
        return this.peerServiceComponentOverrides;
    }

    public boolean isRemoveIntegrationServiceNamesEnabled() {
        return this.removeIntegrationServiceNamesEnabled;
    }

    public Map<String, String> getPeerServiceMapping() {
        return this.peerServiceMapping;
    }

    public Map<String, String> getServiceMapping() {
        return this.serviceMapping;
    }

    public Map<String, String> getRequestHeaderTags() {
        return this.requestHeaderTags;
    }

    public Map<String, String> getResponseHeaderTags() {
        return this.responseHeaderTags;
    }

    public boolean isRequestHeaderTagsCommaAllowed() {
        return this.requestHeaderTagsCommaAllowed;
    }

    public Map<String, String> getBaggageMapping() {
        return this.baggageMapping;
    }

    public List<String> getTraceBaggageTagKeys() {
        return this.traceBaggageTagKeys;
    }

    public Map<String, String> getHttpServerPathResourceNameMapping() {
        return this.httpServerPathResourceNameMapping;
    }

    public Map<String, String> getHttpClientPathResourceNameMapping() {
        return this.httpClientPathResourceNameMapping;
    }

    public boolean getHttpResourceRemoveTrailingSlash() {
        return this.httpResourceRemoveTrailingSlash;
    }

    public BitSet getHttpServerErrorStatuses() {
        return this.httpServerErrorStatuses;
    }

    public BitSet getHttpClientErrorStatuses() {
        return this.httpClientErrorStatuses;
    }

    public boolean isHttpServerTagQueryString() {
        return this.httpServerTagQueryString;
    }

    public boolean isHttpServerRawQueryString() {
        return this.httpServerRawQueryString;
    }

    public boolean isHttpServerRawResource() {
        return this.httpServerRawResource;
    }

    public boolean isHttpServerDecodedResourcePreserveSpaces() {
        return this.httpServerDecodedResourcePreserveSpaces;
    }

    public boolean isHttpServerRouteBasedNaming() {
        return this.httpServerRouteBasedNaming;
    }

    public boolean isHttpClientTagQueryString() {
        return this.httpClientTagQueryString;
    }

    public boolean isHttpClientTagHeaders() {
        return this.httpClientTagHeaders;
    }

    public boolean isHttpClientSplitByDomain() {
        return this.httpClientSplitByDomain;
    }

    public boolean isDbClientSplitByInstance() {
        return this.dbClientSplitByInstance;
    }

    public boolean isDbClientSplitByInstanceTypeSuffix() {
        return this.dbClientSplitByInstanceTypeSuffix;
    }

    public boolean isDbClientSplitByHost() {
        return this.dbClientSplitByHost;
    }

    public boolean isDbMetadataFetchingOnQueryEnabled() {
        return this.dbMetadataFetchingOnQuery;
    }

    public boolean isDbMetadataFetchingOnConnectEnabled() {
        return this.dbMetadataFetchingOnConnect;
    }

    public Set<String> getSplitByTags() {
        return this.splitByTags;
    }

    public boolean isJeeSplitByDeployment() {
        return this.jeeSplitByDeployment;
    }

    public int getScopeDepthLimit() {
        return this.scopeDepthLimit;
    }

    public boolean isScopeStrictMode() {
        return this.scopeStrictMode;
    }

    public int getScopeIterationKeepAlive() {
        return this.scopeIterationKeepAlive;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    public int getTraceKeepLatencyThreshold() {
        return this.traceKeepLatencyThreshold;
    }

    public boolean isTraceKeepLatencyThresholdEnabled() {
        return this.traceKeepLatencyThresholdEnabled;
    }

    public boolean isTraceStrictWritesEnabled() {
        return this.traceStrictWritesEnabled;
    }

    public boolean isLogExtractHeaderNames() {
        return this.logExtractHeaderNames;
    }

    @Deprecated
    public Set<PropagationStyle> getPropagationStylesToExtract() {
        return this.propagationStylesToExtract;
    }

    @Deprecated
    public Set<PropagationStyle> getPropagationStylesToInject() {
        return this.propagationStylesToInject;
    }

    public boolean isTracePropagationStyleB3PaddingEnabled() {
        return this.tracePropagationStyleB3PaddingEnabled;
    }

    public Set<TracePropagationStyle> getTracePropagationStylesToExtract() {
        return this.tracePropagationStylesToExtract;
    }

    public Set<TracePropagationStyle> getTracePropagationStylesToInject() {
        return this.tracePropagationStylesToInject;
    }

    public TracePropagationBehaviorExtract getTracePropagationBehaviorExtract() {
        return this.tracePropagationBehaviorExtract;
    }

    public boolean isTracePropagationExtractFirst() {
        return this.tracePropagationExtractFirst;
    }

    public boolean isInferredProxyPropagationEnabled() {
        return this.traceInferredProxyEnabled;
    }

    public boolean isBaggageExtract() {
        return this.tracePropagationStylesToExtract.contains(TracePropagationStyle.BAGGAGE);
    }

    public boolean isBaggageInject() {
        return this.tracePropagationStylesToInject.contains(TracePropagationStyle.BAGGAGE);
    }

    public boolean isBaggagePropagationEnabled() {
        return this.isBaggageInject() || this.isBaggageExtract();
    }

    public int getTraceBaggageMaxItems() {
        return this.traceBaggageMaxItems;
    }

    public int getTraceBaggageMaxBytes() {
        return this.traceBaggageMaxBytes;
    }

    public int getClockSyncPeriod() {
        return this.clockSyncPeriod;
    }

    public String getDogStatsDNamedPipe() {
        return this.dogStatsDNamedPipe;
    }

    public int getDogStatsDStartDelay() {
        return this.dogStatsDStartDelay;
    }

    public Integer getStatsDClientQueueSize() {
        return this.statsDClientQueueSize;
    }

    public Integer getStatsDClientSocketBuffer() {
        return this.statsDClientSocketBuffer;
    }

    public Integer getStatsDClientSocketTimeout() {
        return this.statsDClientSocketTimeout;
    }

    public boolean isRuntimeMetricsEnabled() {
        return this.runtimeMetricsEnabled;
    }

    public boolean isJmxFetchEnabled() {
        return this.jmxFetchEnabled;
    }

    public String getJmxFetchConfigDir() {
        return this.jmxFetchConfigDir;
    }

    public List<String> getJmxFetchConfigs() {
        return this.jmxFetchConfigs;
    }

    public List<String> getJmxFetchMetricsConfigs() {
        return this.jmxFetchMetricsConfigs;
    }

    public Integer getJmxFetchCheckPeriod() {
        return this.jmxFetchCheckPeriod;
    }

    public Integer getJmxFetchRefreshBeansPeriod() {
        return this.jmxFetchRefreshBeansPeriod;
    }

    public Integer getJmxFetchInitialRefreshBeansPeriod() {
        return this.jmxFetchInitialRefreshBeansPeriod;
    }

    public String getJmxFetchStatsdHost() {
        return this.jmxFetchStatsdHost;
    }

    public Integer getJmxFetchStatsdPort() {
        return this.jmxFetchStatsdPort;
    }

    public boolean isJmxFetchMultipleRuntimeServicesEnabled() {
        return this.jmxFetchMultipleRuntimeServicesEnabled;
    }

    public int getJmxFetchMultipleRuntimeServicesLimit() {
        return this.jmxFetchMultipleRuntimeServicesLimit;
    }

    public boolean isHealthMetricsEnabled() {
        return this.healthMetricsEnabled;
    }

    public String getHealthMetricsStatsdHost() {
        return this.healthMetricsStatsdHost;
    }

    public Integer getHealthMetricsStatsdPort() {
        return this.healthMetricsStatsdPort;
    }

    public boolean isPerfMetricsEnabled() {
        return this.perfMetricsEnabled;
    }

    public boolean isTracerMetricsEnabled() {
        return this.tracerMetricsEnabled && this.isApmTracingEnabled();
    }

    public boolean isTracerMetricsBufferingEnabled() {
        return this.tracerMetricsBufferingEnabled;
    }

    public int getTracerMetricsMaxAggregates() {
        return this.tracerMetricsMaxAggregates;
    }

    public int getTracerMetricsMaxPending() {
        return this.tracerMetricsMaxPending;
    }

    public boolean isLogsInjectionEnabled() {
        return this.logsInjectionEnabled;
    }

    public boolean isAppLogsCollectionEnabled() {
        return this.appLogsCollectionEnabled;
    }

    public boolean isReportHostName() {
        return this.reportHostName;
    }

    public boolean isTraceAnalyticsEnabled() {
        return this.traceAnalyticsEnabled;
    }

    public String getTraceClientIpHeader() {
        return this.traceClientIpHeader;
    }

    public boolean isTraceClientIpResolverEnabled() {
        return this.traceClientIpResolverEnabled;
    }

    public boolean isTraceGitMetadataEnabled() {
        return this.traceGitMetadataEnabled;
    }

    public Map<String, String> getTraceSamplingServiceRules() {
        return this.traceSamplingServiceRules;
    }

    public Map<String, String> getTraceSamplingOperationRules() {
        return this.traceSamplingOperationRules;
    }

    public String getTraceSamplingRules() {
        return this.traceSamplingRules;
    }

    public Double getTraceSampleRate() {
        return this.traceSampleRate;
    }

    public int getTraceRateLimit() {
        return this.traceRateLimit;
    }

    public String getSpanSamplingRules() {
        return this.spanSamplingRules;
    }

    public String getSpanSamplingRulesFile() {
        return this.spanSamplingRulesFile;
    }

    public boolean isProfilingEnabled() {
        if (Platform.isNativeImage() && !this.instrumenterConfig.isProfilingEnabled() && this.profilingEnabled.isActive()) {
            log.warn("Profiling was not enabled during the native image build. Please set DD_PROFILING_ENABLED=true in your native image build configuration if you wantto use profiling.");
        }
        return this.profilingEnabled.isActive() && this.instrumenterConfig.isProfilingEnabled();
    }

    public boolean isProfilingTimelineEventsEnabled() {
        return this.timelineEventsEnabled;
    }

    public boolean isProfilingAgentless() {
        return this.profilingAgentless;
    }

    public int getProfilingStartDelay() {
        return this.profilingStartDelay;
    }

    public boolean isProfilingStartForceFirst() {
        return this.profilingStartForceFirst;
    }

    public int getProfilingUploadPeriod() {
        return this.profilingUploadPeriod;
    }

    public String getProfilingTemplateOverrideFile() {
        return this.profilingTemplateOverrideFile;
    }

    public int getProfilingUploadTimeout() {
        return this.profilingUploadTimeout;
    }

    public String getProfilingUploadCompression() {
        return this.profilingUploadCompression;
    }

    public String getProfilingProxyHost() {
        return this.profilingProxyHost;
    }

    public int getProfilingProxyPort() {
        return this.profilingProxyPort;
    }

    public String getProfilingProxyUsername() {
        return this.profilingProxyUsername;
    }

    public String getProfilingProxyPassword() {
        return this.profilingProxyPassword;
    }

    public int getProfilingExceptionSampleLimit() {
        return this.profilingExceptionSampleLimit;
    }

    public int getProfilingDirectAllocationSampleLimit() {
        return this.profilingDirectAllocationSampleLimit;
    }

    public int getProfilingBackPressureSampleLimit() {
        return this.profilingBackPressureSampleLimit;
    }

    public boolean isProfilingBackPressureSamplingEnabled() {
        return this.profilingBackPressureEnabled;
    }

    public int getProfilingExceptionHistogramTopItems() {
        return this.profilingExceptionHistogramTopItems;
    }

    public int getProfilingExceptionHistogramMaxCollectionSize() {
        return this.profilingExceptionHistogramMaxCollectionSize;
    }

    public boolean isProfilingExcludeAgentThreads() {
        return this.profilingExcludeAgentThreads;
    }

    public boolean isProfilingUploadSummaryOn413Enabled() {
        return this.profilingUploadSummaryOn413Enabled;
    }

    public boolean isProfilingRecordExceptionMessage() {
        return this.profilingRecordExceptionMessage;
    }

    public boolean isDatadogProfilerEnabled() {
        return this.isProfilingEnabled() && this.isDatadogProfilerEnabled;
    }

    public static boolean isDatadogProfilerEnablementOverridden() {
        return OperatingSystem.isWindows() || JavaVirtualMachine.isJavaVersion(18) || JavaVirtualMachine.isJavaVersion(16) || JavaVirtualMachine.isJavaVersion(15) || JavaVirtualMachine.isJavaVersion(14) || JavaVirtualMachine.isJavaVersion(13) || JavaVirtualMachine.isJavaVersion(12) || JavaVirtualMachine.isJavaVersion(10) || JavaVirtualMachine.isJavaVersion(9);
    }

    public static boolean isDatadogProfilerSafeInCurrentEnvironment() {
        String arch;
        if (!JavaVirtualMachine.isJ9() && JavaVirtualMachine.isJavaVersion(8) && ("aarch64".equalsIgnoreCase(arch = SystemProperties.get("os.arch")) || "arm64".equalsIgnoreCase(arch))) {
            return false;
        }
        if (JavaVirtualMachine.isGraalVM()) {
            return false;
        }
        boolean result = false;
        if (JavaVirtualMachine.isJ9()) {
            result = true;
        } else if (!JavaVirtualMachine.isJavaVersion(18)) {
            result = JavaVirtualMachine.isJavaVersionAtLeast(17, 0, 5) || JavaVirtualMachine.isJavaVersion(11) && JavaVirtualMachine.isJavaVersionAtLeast(11, 0, 17) || JavaVirtualMachine.isJavaVersion(8) && JavaVirtualMachine.isJavaVersionAtLeast(8, 0, 352);
        }
        return result;
    }

    public boolean isCrashTrackingAgentless() {
        return this.crashTrackingAgentless;
    }

    public boolean isCrashTrackingErrorsIntakeEnabled() {
        return this.crashTrackingErrorsIntakeEnabled;
    }

    public boolean isTelemetryEnabled() {
        return this.instrumenterConfig.isTelemetryEnabled();
    }

    public float getTelemetryHeartbeatInterval() {
        return this.telemetryHeartbeatInterval;
    }

    public long getTelemetryExtendedHeartbeatInterval() {
        return this.telemetryExtendedHeartbeatInterval;
    }

    public float getTelemetryMetricsInterval() {
        return this.telemetryMetricsInterval;
    }

    public boolean isTelemetryDependencyServiceEnabled() {
        return this.isTelemetryDependencyServiceEnabled;
    }

    public boolean isTelemetryMetricsEnabled() {
        return this.telemetryMetricsEnabled;
    }

    public boolean isTelemetryLogCollectionEnabled() {
        return this.isTelemetryLogCollectionEnabled;
    }

    public int getTelemetryDependencyResolutionQueueSize() {
        return this.telemetryDependencyResolutionQueueSize;
    }

    public boolean isClientIpEnabled() {
        return this.clientIpEnabled;
    }

    public ProductActivation getAppSecActivation() {
        return this.instrumenterConfig.getAppSecActivation();
    }

    public boolean isAppSecReportingInband() {
        return this.appSecReportingInband;
    }

    public int getAppSecReportMinTimeout() {
        return this.appSecReportMinTimeout;
    }

    public int getAppSecReportMaxTimeout() {
        return this.appSecReportMaxTimeout;
    }

    public int getAppSecTraceRateLimit() {
        return this.appSecTraceRateLimit;
    }

    public boolean isAppSecWafMetrics() {
        return this.appSecWafMetrics;
    }

    public int getAppSecWafTimeout() {
        return this.appSecWafTimeout;
    }

    public String getAppSecObfuscationParameterKeyRegexp() {
        return this.appSecObfuscationParameterKeyRegexp;
    }

    public String getAppSecObfuscationParameterValueRegexp() {
        return this.appSecObfuscationParameterValueRegexp;
    }

    public String getAppSecHttpBlockedTemplateHtml() {
        return this.appSecHttpBlockedTemplateHtml;
    }

    public String getAppSecHttpBlockedTemplateJson() {
        return this.appSecHttpBlockedTemplateJson;
    }

    public UserIdCollectionMode getAppSecUserIdCollectionMode() {
        return this.appSecUserIdCollectionMode;
    }

    public boolean isApiSecurityEnabled() {
        return this.apiSecurityEnabled;
    }

    public float getApiSecuritySampleDelay() {
        return this.apiSecuritySampleDelay;
    }

    public int getApiSecurityEndpointCollectionMessageLimit() {
        return this.apiSecurityEndpointCollectionMessageLimit;
    }

    public int getApiSecurityMaxDownstreamRequestBodyAnalysis() {
        return this.apiSecurityMaxDownstreamRequestBodyAnalysis;
    }

    public double getApiSecurityDownstreamRequestBodyAnalysisSampleRate() {
        return this.apiSecurityDownstreamRequestBodyAnalysisSampleRate;
    }

    public boolean isApiSecurityEndpointCollectionEnabled() {
        return this.instrumenterConfig.isApiSecurityEndpointCollectionEnabled();
    }

    public ProductActivation getIastActivation() {
        return this.instrumenterConfig.getIastActivation();
    }

    public boolean isIastDebugEnabled() {
        return this.iastDebugEnabled;
    }

    public int getIastMaxConcurrentRequests() {
        return this.iastMaxConcurrentRequests;
    }

    public int getIastVulnerabilitiesPerRequest() {
        return this.iastVulnerabilitiesPerRequest;
    }

    public float getIastRequestSampling() {
        return this.iastRequestSampling;
    }

    public Verbosity getIastTelemetryVerbosity() {
        return this.isTelemetryEnabled() ? this.iastTelemetryVerbosity : Verbosity.OFF;
    }

    public boolean isIastRedactionEnabled() {
        return this.iastRedactionEnabled;
    }

    public String getIastRedactionNamePattern() {
        return this.iastRedactionNamePattern;
    }

    public String getIastRedactionValuePattern() {
        return this.iastRedactionValuePattern;
    }

    public int getIastTruncationMaxValueLength() {
        return this.iastTruncationMaxValueLength;
    }

    public int getIastMaxRangeCount() {
        return this.iastMaxRangeCount;
    }

    public boolean isIastStacktraceLeakSuppress() {
        return this.iastStacktraceLeakSuppress;
    }

    public IastContext.Mode getIastContextMode() {
        return this.iastContextMode;
    }

    public boolean isIastHardcodedSecretEnabled() {
        return this.iastHardcodedSecretEnabled;
    }

    public boolean isIastSourceMappingEnabled() {
        return this.iastSourceMappingEnabled;
    }

    public int getIastSourceMappingMaxSize() {
        return this.iastSourceMappingMaxSize;
    }

    public IastDetectionMode getIastDetectionMode() {
        return this.iastDetectionMode;
    }

    public boolean isIastAnonymousClassesEnabled() {
        return this.iastAnonymousClassesEnabled;
    }

    public boolean isIastStackTraceEnabled() {
        return this.iastStackTraceEnabled;
    }

    public boolean isIastExperimentalPropagationEnabled() {
        return this.iastExperimentalPropagationEnabled;
    }

    public String getIastSecurityControlsConfiguration() {
        return this.iastSecurityControlsConfiguration;
    }

    public int getIastDbRowsToTaint() {
        return this.iastDbRowsToTaint;
    }

    public boolean isLlmObsEnabled() {
        return this.instrumenterConfig.isLlmObsEnabled();
    }

    public boolean isLlmObsAgentlessEnabled() {
        return this.llmObsAgentlessEnabled;
    }

    public String getLlMObsAgentlessUrl() {
        return this.llmObsAgentlessUrl;
    }

    public String getLlmObsMlApp() {
        return this.llmObsMlApp;
    }

    public boolean isCiVisibilityEnabled() {
        return this.instrumenterConfig.isCiVisibilityEnabled();
    }

    public boolean isUsmEnabled() {
        return this.instrumenterConfig.isUsmEnabled();
    }

    public boolean isCiVisibilityTraceSanitationEnabled() {
        return this.ciVisibilityTraceSanitationEnabled;
    }

    public boolean isCiVisibilityAgentlessEnabled() {
        return this.ciVisibilityAgentlessEnabled;
    }

    public String getCiVisibilityAgentlessUrl() {
        return this.ciVisibilityAgentlessUrl;
    }

    public String getCiVisibilityIntakeAgentlessUrl() {
        return this.ciVisibilityIntakeAgentlessUrl;
    }

    public boolean isCiVisibilitySourceDataEnabled() {
        return this.ciVisibilitySourceDataEnabled;
    }

    public boolean isCiVisibilityBuildInstrumentationEnabled() {
        return this.ciVisibilityBuildInstrumentationEnabled;
    }

    public String getCiVisibilityAgentJarUri() {
        return this.ciVisibilityAgentJarUri;
    }

    public File getCiVisibilityAgentJarFile() {
        if (this.ciVisibilityAgentJarUri == null || this.ciVisibilityAgentJarUri.isEmpty()) {
            throw new IllegalArgumentException("Agent JAR URI is not set in config");
        }
        try {
            URI agentJarUri = new URI(this.ciVisibilityAgentJarUri);
            return new File(agentJarUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed agent JAR URI: " + this.ciVisibilityAgentJarUri, e);
        }
    }

    public boolean isCiVisibilityAutoConfigurationEnabled() {
        return this.ciVisibilityAutoConfigurationEnabled;
    }

    public String getCiVisibilityAdditionalChildProcessJvmArgs() {
        return this.ciVisibilityAdditionalChildProcessJvmArgs;
    }

    public boolean isCiVisibilityCompilerPluginAutoConfigurationEnabled() {
        return this.ciVisibilityCompilerPluginAutoConfigurationEnabled;
    }

    public boolean isCiVisibilityCodeCoverageEnabled() {
        return this.ciVisibilityCodeCoverageEnabled;
    }

    public boolean isCiVisibilityCoverageLinesEnabled() {
        return this.ciVisibilityCoverageLinesEnabled != null && this.ciVisibilityCoverageLinesEnabled != false;
    }

    public boolean isCiVisibilityCoverageLinesDisabled() {
        return this.ciVisibilityCoverageLinesEnabled != null && this.ciVisibilityCoverageLinesEnabled == false;
    }

    public String getCiVisibilityCodeCoverageReportDumpDir() {
        return this.ciVisibilityCodeCoverageReportDumpDir;
    }

    public String getCiVisibilityCompilerPluginVersion() {
        return this.ciVisibilityCompilerPluginVersion;
    }

    public String getCiVisibilityJacocoPluginVersion() {
        return this.ciVisibilityJacocoPluginVersion;
    }

    public boolean isCiVisibilityJacocoPluginVersionProvided() {
        return this.ciVisibilityJacocoPluginVersionProvided;
    }

    public List<String> getCiVisibilityCodeCoverageIncludes() {
        return this.ciVisibilityCodeCoverageIncludes;
    }

    public List<String> getCiVisibilityCodeCoverageExcludes() {
        return this.ciVisibilityCodeCoverageExcludes;
    }

    public String[] getCiVisibilityCodeCoverageIncludedPackages() {
        return Arrays.copyOf(this.ciVisibilityCodeCoverageIncludedPackages, this.ciVisibilityCodeCoverageIncludedPackages.length);
    }

    public String[] getCiVisibilityCodeCoverageExcludedPackages() {
        return Arrays.copyOf(this.ciVisibilityCodeCoverageExcludedPackages, this.ciVisibilityCodeCoverageExcludedPackages.length);
    }

    public List<String> getCiVisibilityJacocoGradleSourceSets() {
        return this.ciVisibilityJacocoGradleSourceSets;
    }

    public boolean isCiVisibilityCodeCoverageReportUploadEnabled() {
        return this.ciVisibilityCodeCoverageReportUploadEnabled;
    }

    public Integer getCiVisibilityDebugPort() {
        return this.ciVisibilityDebugPort;
    }

    public boolean isCiVisibilityGitClientEnabled() {
        return this.ciVisibilityGitClientEnabled;
    }

    public boolean isCiVisibilityGitUploadEnabled() {
        return this.ciVisibilityGitUploadEnabled;
    }

    public boolean isCiVisibilityGitUnshallowEnabled() {
        return this.ciVisibilityGitUnshallowEnabled;
    }

    public boolean isCiVisibilityGitUnshallowDefer() {
        return this.ciVisibilityGitUnshallowDefer;
    }

    public long getCiVisibilityGitCommandTimeoutMillis() {
        return this.ciVisibilityGitCommandTimeoutMillis;
    }

    public long getCiVisibilityBackendApiTimeoutMillis() {
        return this.ciVisibilityBackendApiTimeoutMillis;
    }

    public long getCiVisibilityGitUploadTimeoutMillis() {
        return this.ciVisibilityGitUploadTimeoutMillis;
    }

    public String getCiVisibilityGitRemoteName() {
        return this.ciVisibilityGitRemoteName;
    }

    public int getCiVisibilitySignalServerPort() {
        return this.ciVisibilitySignalServerPort;
    }

    public int getCiVisibilitySignalClientTimeoutMillis() {
        return this.ciVisibilitySignalClientTimeoutMillis;
    }

    public String getCiVisibilitySignalServerHost() {
        return this.ciVisibilitySignalServerHost;
    }

    public boolean isCiVisibilityItrEnabled() {
        return this.ciVisibilityItrEnabled;
    }

    public boolean isCiVisibilityTestSkippingEnabled() {
        return this.ciVisibilityTestSkippingEnabled;
    }

    public boolean isCiVisibilityCiProviderIntegrationEnabled() {
        return this.ciVisibilityCiProviderIntegrationEnabled;
    }

    public boolean isCiVisibilityRepoIndexDuplicateKeyCheckEnabled() {
        return this.ciVisibilityRepoIndexDuplicateKeyCheckEnabled;
    }

    public boolean isCiVisibilityRepoIndexFollowSymlinks() {
        return this.ciVisibilityRepoIndexFollowSymlinks;
    }

    public int getCiVisibilityExecutionSettingsCacheSize() {
        return this.ciVisibilityExecutionSettingsCacheSize;
    }

    public int getCiVisibilityJvmInfoCacheSize() {
        return this.ciVisibilityJvmInfoCacheSize;
    }

    public int getCiVisibilityCoverageRootPackagesLimit() {
        return this.ciVisibilityCoverageRootPackagesLimit;
    }

    public String getCiVisibilityInjectedTracerVersion() {
        return this.ciVisibilityInjectedTracerVersion;
    }

    public List<String> getCiVisibilityResourceFolderNames() {
        return this.ciVisibilityResourceFolderNames;
    }

    public boolean isCiVisibilityFlakyRetryEnabled() {
        return this.ciVisibilityFlakyRetryEnabled;
    }

    public boolean isCiVisibilityImpactedTestsDetectionEnabled() {
        return this.ciVisibilityImpactedTestsDetectionEnabled;
    }

    public boolean isCiVisibilityKnownTestsRequestEnabled() {
        return this.ciVisibilityKnownTestsRequestEnabled;
    }

    public boolean isCiVisibilityFlakyRetryOnlyKnownFlakes() {
        return this.ciVisibilityFlakyRetryOnlyKnownFlakes;
    }

    public boolean isCiVisibilityEarlyFlakeDetectionEnabled() {
        return this.ciVisibilityEarlyFlakeDetectionEnabled;
    }

    public int getCiVisibilityEarlyFlakeDetectionLowerLimit() {
        return this.ciVisibilityEarlyFlakeDetectionLowerLimit;
    }

    public boolean isCiVisibilityExecutionPoliciesEnabled() {
        return this.ciVisibilityFlakyRetryEnabled || this.ciVisibilityEarlyFlakeDetectionEnabled || this.ciVisibilityTestManagementEnabled;
    }

    public boolean isCiVisibilityScalatestForkMonitorEnabled() {
        return this.ciVisibilityScalatestForkMonitorEnabled;
    }

    public int getCiVisibilityFlakyRetryCount() {
        return this.ciVisibilityFlakyRetryCount;
    }

    public int getCiVisibilityTotalFlakyRetryCount() {
        return this.ciVisibilityTotalFlakyRetryCount;
    }

    public String getCiVisibilitySessionName() {
        return this.ciVisibilitySessionName;
    }

    public String getCiVisibilityModuleName() {
        return this.ciVisibilityModuleName;
    }

    public String getCiVisibilityTestCommand() {
        return this.ciVisibilityTestCommand;
    }

    public boolean isCiVisibilityTelemetryEnabled() {
        return this.ciVisibilityTelemetryEnabled;
    }

    public long getCiVisibilityRumFlushWaitMillis() {
        return this.ciVisibilityRumFlushWaitMillis;
    }

    public boolean isCiVisibilityAutoInjected() {
        return this.ciVisibilityAutoInjected;
    }

    public String getCiVisibilityTestOrder() {
        return this.ciVisibilityTestOrder;
    }

    public boolean isCiVisibilityTestManagementEnabled() {
        return this.ciVisibilityTestManagementEnabled;
    }

    public Integer getCiVisibilityTestManagementAttemptToFixRetries() {
        return this.ciVisibilityTestManagementAttemptToFixRetries;
    }

    public boolean isCiVisibilityFailedTestReplayEnabled() {
        return this.ciVisibilityFailedTestReplayEnabled;
    }

    public String getGitPullRequestBaseBranch() {
        return this.gitPullRequestBaseBranch;
    }

    public String getGitPullRequestBaseBranchSha() {
        return this.gitPullRequestBaseBranchSha;
    }

    public String getGitCommitHeadSha() {
        return this.gitCommitHeadSha;
    }

    public String getAppSecRulesFile() {
        return this.appSecRulesFile;
    }

    public long getRemoteConfigMaxPayloadSizeBytes() {
        return this.remoteConfigMaxPayloadSize;
    }

    public boolean isRemoteConfigEnabled() {
        return this.remoteConfigEnabled;
    }

    public boolean isRemoteConfigIntegrityCheckEnabled() {
        return this.remoteConfigIntegrityCheckEnabled;
    }

    public String getFinalRemoteConfigUrl() {
        return this.remoteConfigUrl;
    }

    public float getRemoteConfigPollIntervalSeconds() {
        return this.remoteConfigPollIntervalSeconds;
    }

    public String getRemoteConfigTargetsKeyId() {
        return this.remoteConfigTargetsKeyId;
    }

    public String getRemoteConfigTargetsKey() {
        return this.remoteConfigTargetsKey;
    }

    public int getRemoteConfigMaxExtraServices() {
        return this.remoteConfigMaxExtraServices;
    }

    public boolean isDynamicInstrumentationEnabled() {
        return this.dynamicInstrumentationEnabled;
    }

    public int getDynamicInstrumentationUploadTimeout() {
        return this.dynamicInstrumentationUploadTimeout;
    }

    public int getDynamicInstrumentationUploadFlushInterval() {
        return this.dynamicInstrumentationUploadFlushInterval;
    }

    public boolean isDynamicInstrumentationClassFileDumpEnabled() {
        return this.dynamicInstrumentationClassFileDumpEnabled;
    }

    public int getDynamicInstrumentationPollInterval() {
        return this.dynamicInstrumentationPollInterval;
    }

    public int getDynamicInstrumentationDiagnosticsInterval() {
        return this.dynamicInstrumentationDiagnosticsInterval;
    }

    public boolean isDynamicInstrumentationMetricsEnabled() {
        return this.dynamicInstrumentationMetricEnabled;
    }

    public int getDynamicInstrumentationUploadBatchSize() {
        return this.dynamicInstrumentationUploadBatchSize;
    }

    public long getDynamicInstrumentationMaxPayloadSize() {
        return this.dynamicInstrumentationMaxPayloadSize;
    }

    public boolean isDynamicInstrumentationVerifyByteCode() {
        return this.dynamicInstrumentationVerifyByteCode;
    }

    public String getDynamicInstrumentationInstrumentTheWorld() {
        return this.dynamicInstrumentationInstrumentTheWorld;
    }

    public String getDynamicInstrumentationExcludeFiles() {
        return this.dynamicInstrumentationExcludeFiles;
    }

    public String getDynamicInstrumentationIncludeFiles() {
        return this.dynamicInstrumentationIncludeFiles;
    }

    public int getDynamicInstrumentationCaptureTimeout() {
        return this.dynamicInstrumentationCaptureTimeout;
    }

    public boolean isSymbolDatabaseEnabled() {
        return this.symbolDatabaseEnabled;
    }

    public boolean isSymbolDatabaseForceUpload() {
        return this.symbolDatabaseForceUpload;
    }

    public int getSymbolDatabaseFlushThreshold() {
        return this.symbolDatabaseFlushThreshold;
    }

    public boolean isSymbolDatabaseCompressed() {
        return this.symbolDatabaseCompressed;
    }

    public boolean isDebuggerExceptionEnabled() {
        return this.debuggerExceptionEnabled;
    }

    public int getDebuggerMaxExceptionPerSecond() {
        return this.debuggerMaxExceptionPerSecond;
    }

    public boolean isDebuggerExceptionOnlyLocalRoot() {
        return this.debuggerExceptionOnlyLocalRoot;
    }

    public boolean isDebuggerExceptionCaptureIntermediateSpansEnabled() {
        return this.debuggerExceptionCaptureIntermediateSpansEnabled;
    }

    public int getDebuggerExceptionMaxCapturedFrames() {
        return this.debuggerExceptionMaxCapturedFrames;
    }

    public int getDebuggerExceptionCaptureInterval() {
        return this.debuggerExceptionCaptureInterval;
    }

    public boolean isDebuggerCodeOriginEnabled() {
        return this.debuggerCodeOriginEnabled;
    }

    public int getDebuggerCodeOriginMaxUserFrames() {
        return this.debuggerCodeOriginMaxUserFrames;
    }

    public boolean isDistributedDebuggerEnabled() {
        return this.distributedDebuggerEnabled;
    }

    public boolean isDebuggerSourceFileTrackingEnabled() {
        return this.debuggerSourceFileTrackingEnabled;
    }

    public Set<String> getThirdPartyIncludes() {
        return this.debuggerThirdPartyIncludes;
    }

    public Set<String> getThirdPartyExcludes() {
        return this.debuggerThirdPartyExcludes;
    }

    public Set<String> getThirdPartyShadingIdentifiers() {
        return this.debuggerShadingIdentifiers;
    }

    private String getFinalDebuggerBaseUrl() {
        if (this.agentUrl.startsWith("unix:")) {
            return "http://" + this.agentHost + ":" + this.agentPort;
        }
        return this.agentUrl;
    }

    public String getFinalDebuggerSnapshotUrl() {
        if (Strings.isNotBlank(this.dynamicInstrumentationSnapshotUrl)) {
            return this.dynamicInstrumentationSnapshotUrl;
        }
        if (this.isCiVisibilityAgentlessEnabled()) {
            return Intake.LOGS.getAgentlessUrl(this) + "logs";
        }
        return this.getFinalDebuggerBaseUrl() + "/debugger/v1/diagnostics";
    }

    public String getFinalDebuggerSymDBUrl() {
        if (this.isCiVisibilityAgentlessEnabled()) {
            return Intake.LOGS.getAgentlessUrl(this) + "logs";
        }
        return this.getFinalDebuggerBaseUrl() + "/symdb/v1/input";
    }

    public String getDynamicInstrumentationProbeFile() {
        return this.dynamicInstrumentationProbeFile;
    }

    public String getDynamicInstrumentationRedactedIdentifiers() {
        return this.dynamicInstrumentationRedactedIdentifiers;
    }

    public Set<String> getDynamicInstrumentationRedactionExcludedIdentifiers() {
        return this.dynamicInstrumentationRedactionExcludedIdentifiers;
    }

    public String getDynamicInstrumentationRedactedTypes() {
        return this.dynamicInstrumentationRedactedTypes;
    }

    public int getDynamicInstrumentationLocalVarHoistingLevel() {
        return this.dynamicInstrumentationLocalVarHoistingLevel;
    }

    public boolean isAwsPropagationEnabled() {
        return this.awsPropagationEnabled;
    }

    public boolean isSqsPropagationEnabled() {
        return this.sqsPropagationEnabled;
    }

    public boolean isSqsBodyPropagationEnabled() {
        return this.sqsBodyPropagationEnabled;
    }

    public boolean isKafkaClientPropagationEnabled() {
        return this.kafkaClientPropagationEnabled;
    }

    public boolean isKafkaClientPropagationDisabledForTopic(String topic) {
        return null != topic && this.kafkaClientPropagationDisabledTopics.contains(topic);
    }

    public boolean isJmsPropagationEnabled() {
        return this.jmsPropagationEnabled;
    }

    public boolean isJmsPropagationDisabledForDestination(String queueOrTopic) {
        return null != queueOrTopic && (this.jmsPropagationDisabledQueues.contains(queueOrTopic) || this.jmsPropagationDisabledTopics.contains(queueOrTopic));
    }

    public int getJmsUnacknowledgedMaxAge() {
        return this.jmsUnacknowledgedMaxAge;
    }

    public boolean isKafkaClientBase64DecodingEnabled() {
        return this.kafkaClientBase64DecodingEnabled;
    }

    public boolean isRabbitPropagationEnabled() {
        return this.rabbitPropagationEnabled;
    }

    public boolean isRabbitPropagationDisabledForDestination(String queueOrExchange) {
        return null != queueOrExchange && (this.rabbitPropagationDisabledQueues.contains(queueOrExchange) || this.rabbitPropagationDisabledExchanges.contains(queueOrExchange));
    }

    public boolean isRabbitIncludeRoutingKeyInResource() {
        return this.rabbitIncludeRoutingKeyInResource;
    }

    public boolean isMessageBrokerSplitByDestination() {
        return this.messageBrokerSplitByDestination;
    }

    public boolean isHystrixTagsEnabled() {
        return this.hystrixTagsEnabled;
    }

    public boolean isHystrixMeasuredEnabled() {
        return this.hystrixMeasuredEnabled;
    }

    public boolean isResilience4jMeasuredEnabled() {
        return this.resilience4jMeasuredEnabled;
    }

    public boolean isResilience4jTagMetricsEnabled() {
        return this.resilience4jTagMetricsEnabled;
    }

    public boolean isIgniteCacheIncludeKeys() {
        return this.igniteCacheIncludeKeys;
    }

    public String getObfuscationQueryRegexp() {
        return this.obfuscationQueryRegexp;
    }

    public boolean getPlayReportHttpStatus() {
        return this.playReportHttpStatus;
    }

    public boolean isServletPrincipalEnabled() {
        return this.servletPrincipalEnabled;
    }

    public boolean isSpringDataRepositoryInterfaceResourceName() {
        return this.springDataRepositoryInterfaceResourceName;
    }

    public int getxDatadogTagsMaxLength() {
        return this.xDatadogTagsMaxLength;
    }

    public boolean isServletAsyncTimeoutError() {
        return this.servletAsyncTimeoutError;
    }

    public boolean isTraceAgentV05Enabled() {
        return this.traceAgentV05Enabled;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isTriageEnabled() {
        return this.triageEnabled;
    }

    public String getTriageReportTrigger() {
        return this.triageReportTrigger;
    }

    public String getTriageReportDir() {
        return this.triageReportDir;
    }

    public boolean isStartupLogsEnabled() {
        return this.startupLogsEnabled;
    }

    public boolean isCwsEnabled() {
        return this.cwsEnabled;
    }

    public int getCwsTlsRefresh() {
        return this.cwsTlsRefresh;
    }

    public boolean isAzureAppServices() {
        return this.azureAppServices;
    }

    public boolean isAwsServerless() {
        return this.awsServerless;
    }

    public boolean isDataStreamsEnabled() {
        return this.dataStreamsEnabled;
    }

    public float getDataStreamsBucketDurationSeconds() {
        return this.dataStreamsBucketDurationSeconds;
    }

    public long getDataStreamsBucketDurationNanoseconds() {
        int milliseconds = Math.round(this.dataStreamsBucketDurationSeconds * 1000.0f);
        return TimeUnit.MILLISECONDS.toNanos(milliseconds);
    }

    public String getTraceAgentPath() {
        return this.traceAgentPath;
    }

    public List<String> getTraceAgentArgs() {
        return this.traceAgentArgs;
    }

    public String getDogStatsDPath() {
        return this.dogStatsDPath;
    }

    public List<String> getDogStatsDArgs() {
        return this.dogStatsDArgs;
    }

    public int getDogsStatsDPort() {
        return this.dogStatsDPort;
    }

    public String getConfigFileStatus() {
        return this.configFileStatus;
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return this.idGenerationStrategy;
    }

    public boolean isTrace128bitTraceIdGenerationEnabled() {
        return this.trace128bitTraceIdGenerationEnabled;
    }

    public boolean isLogs128bitTraceIdEnabled() {
        return this.logs128bitTraceIdEnabled;
    }

    public Set<String> getGrpcIgnoredInboundMethods() {
        return this.grpcIgnoredInboundMethods;
    }

    public Set<String> getGrpcIgnoredOutboundMethods() {
        return this.grpcIgnoredOutboundMethods;
    }

    public boolean isGrpcServerTrimPackageResource() {
        return this.grpcServerTrimPackageResource;
    }

    public BitSet getGrpcServerErrorStatuses() {
        return this.grpcServerErrorStatuses;
    }

    public BitSet getGrpcClientErrorStatuses() {
        return this.grpcClientErrorStatuses;
    }

    public boolean isCassandraKeyspaceStatementExtractionEnabled() {
        return this.cassandraKeyspaceStatementExtractionEnabled;
    }

    public boolean isCouchbaseInternalSpansEnabled() {
        return this.couchbaseInternalSpansEnabled;
    }

    public boolean isElasticsearchBodyEnabled() {
        return this.elasticsearchBodyEnabled;
    }

    public boolean isElasticsearchParamsEnabled() {
        return this.elasticsearchParamsEnabled;
    }

    public boolean isElasticsearchBodyAndParamsEnabled() {
        return this.elasticsearchBodyAndParamsEnabled;
    }

    public boolean isSparkTaskHistogramEnabled() {
        return this.sparkTaskHistogramEnabled;
    }

    public boolean useSparkAppNameAsService() {
        return this.sparkAppNameAsService;
    }

    public boolean isJaxRsExceptionAsErrorEnabled() {
        return this.jaxRsExceptionAsErrorsEnabled;
    }

    public boolean isAxisPromoteResourceName() {
        return this.axisPromoteResourceName;
    }

    public boolean isWebsocketMessagesInheritSampling() {
        return this.websocketMessagesInheritSampling;
    }

    public boolean isWebsocketMessagesSeparateTraces() {
        return this.websocketMessagesSeparateTraces;
    }

    public boolean isWebsocketTagSessionId() {
        return this.websocketTagSessionId;
    }

    public boolean isDataJobsEnabled() {
        return this.instrumenterConfig.isDataJobsEnabled();
    }

    public boolean isDataJobsOpenLineageEnabled() {
        return this.dataJobsOpenLineageEnabled;
    }

    public boolean isDataJobsOpenLineageTimeoutEnabled() {
        return this.dataJobsOpenLineageTimeoutEnabled;
    }

    public boolean isDataJobsParseSparkPlanEnabled() {
        return this.dataJobsParseSparkPlanEnabled;
    }

    public boolean isDataJobsExperimentalFeaturesEnabled() {
        return this.dataJobsExperimentalFeaturesEnabled;
    }

    public boolean isApmTracingEnabled() {
        return this.apmTracingEnabled;
    }

    public boolean isJdkSocketEnabled() {
        return this.jdkSocketEnabled;
    }

    public boolean isOptimizedMapEnabled() {
        return this.optimizedMapEnabled;
    }

    public boolean isSpanBuilderReuseEnabled() {
        return this.spanBuilderReuseEnabled;
    }

    public int getTagNameUtf8CacheSize() {
        return this.tagNameUtf8CacheSize;
    }

    public int getTagValueUtf8CacheSize() {
        return this.tagValueUtf8CacheSize;
    }

    public int getStackTraceLengthLimit() {
        return this.stackTraceLengthLimit;
    }

    public boolean isSqsInjectDatadogAttributeEnabled() {
        return this.sqsInjectDatadogAttributeEnabled;
    }

    public boolean isSnsInjectDatadogAttributeEnabled() {
        return this.snsInjectDatadogAttributeEnabled;
    }

    public boolean isEventbridgeInjectDatadogAttributeEnabled() {
        return this.eventbridgeInjectDatadogAttributeEnabled;
    }

    public boolean isSfnInjectDatadogAttributeEnabled() {
        return this.sfnInjectDatadogAttributeEnabled;
    }

    public TagMap getLocalRootSpanTags() {
        String hostName;
        Map<String, String> runtimeTags = this.getRuntimeTags();
        TagMap result = TagMap.fromMap(runtimeTags);
        result.put("language", (Object)"jvm");
        result.put("_dd.trace_span_attribute_schema", (Object)SpanNaming.instance().version());
        result.put("_dd.profiling.enabled", (Object)(this.isProfilingEnabled() ? 1 : 0));
        if (!this.isApmTracingEnabled()) {
            result.put("_dd.apm.enabled", (Object)0);
        }
        if (this.reportHostName && null != (hostName = this.getHostName()) && !hostName.isEmpty()) {
            result.put("_dd.hostname", (Object)hostName);
        }
        if (this.azureAppServices) {
            result.putAll((Map<? extends String, ? extends Object>)this.getAzureAppServicesTags());
        }
        result.putAll((Map<? extends String, ? extends Object>)this.getProcessIdTag());
        return result.freeze();
    }

    public WellKnownTags getWellKnownTags() {
        return new WellKnownTags(this.getRuntimeId(), this.reportHostName ? this.getHostName() : "", this.getEnv(), this.serviceName, this.getVersion(), "jvm");
    }

    public CiVisibilityWellKnownTags getCiVisibilityWellKnownTags() {
        return new CiVisibilityWellKnownTags(this.getRuntimeId(), this.getEnv(), "jvm", SystemProperties.get("java.runtime.name"), SystemProperties.get("java.version"), SystemProperties.get("java.vendor"), SystemProperties.get("os.arch"), SystemProperties.get("os.name"), SystemProperties.get("os.version"), this.isServiceNameSetByUser() ? "true" : "false");
    }

    public String getPrimaryTag() {
        return this.primaryTag;
    }

    public Set<String> getMetricsIgnoredResources() {
        return CollectionUtils.tryMakeImmutableSet(this.configProvider.getList("trace.tracer.metrics.ignored.resources"));
    }

    public String getEnv() {
        if (this.env == null) {
            this.env = this.getMergedSpanTags().get("env");
            if (this.env == null) {
                this.env = "";
            }
        }
        return this.env;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = this.getMergedSpanTags().get("version");
            if (this.version == null) {
                this.version = "";
            }
        }
        return this.version;
    }

    public Map<String, String> getMergedSpanTags() {
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.spanTags.size());
        result.putAll(this.getGlobalTags());
        result.putAll(this.spanTags);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedJmxTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.jmxTags.size() + runtimeTags.size() + 1);
        result.putAll(this.getGlobalTags());
        result.putAll(this.jmxTags);
        result.putAll(runtimeTags);
        result.put(DBM_PROPAGATION_MODE_STATIC, this.serviceName);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedProfilingTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        String host = this.getHostName();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.profilingTags.size() + runtimeTags.size() + 4);
        result.put("host", host);
        result.putAll(this.getGlobalTags());
        result.putAll(this.profilingTags);
        result.putAll(runtimeTags);
        result.put(DBM_PROPAGATION_MODE_STATIC, this.serviceName);
        result.put("language", "jvm");
        result.put("runtime_version", this.runtimeVersion);
        if (this.azureAppServices) {
            result.putAll(this.getAzureAppServicesTags());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedCrashTrackingTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        String host = this.getHostName();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.crashTrackingTags.size() + this.jmxTags.size() + runtimeTags.size() + 5);
        result.put("host", host);
        result.putAll(this.getGlobalTags());
        result.putAll(this.jmxTags);
        result.putAll(this.crashTrackingTags);
        result.putAll(runtimeTags);
        result.put(DBM_PROPAGATION_MODE_STATIC, this.serviceName);
        result.put("language", "jvm");
        result.put("version", this.getVersion());
        result.put("env", this.getEnv());
        return Collections.unmodifiableMap(result);
    }

    public String getDefaultTelemetryUrl() {
        String site = this.getSite();
        String prefix = "";
        if (site.endsWith("datad0g.com")) {
            prefix = "all-http-intake.logs.";
        } else if (site.endsWith("datadoghq.com") || site.endsWith("datadoghq.eu")) {
            prefix = "instrumentation-telemetry-intake.";
        }
        return "https://" + prefix + site + "/api/v2/apmtelemetry";
    }

    public float getInstrumentationAnalyticsSampleRate(String ... aliases) {
        for (String alias : aliases) {
            String configKey = alias + ".analytics.sample-rate";
            Float rate = this.configProvider.getFloat("trace." + configKey, configKey);
            if (null == rate) continue;
            return rate.floatValue();
        }
        return 1.0f;
    }

    public Map<String, String> getGlobalTags() {
        return this.tags;
    }

    private Map<String, String> getRuntimeTags() {
        return Collections.singletonMap("runtime-id", this.getRuntimeId());
    }

    private Map<String, Long> getProcessIdTag() {
        return Collections.singletonMap("process_id", this.getProcessId());
    }

    private Map<String, String> getAzureAppServicesTags() {
        String websiteOwner;
        HashMap<String, String> aasTags = new HashMap<String, String>();
        String siteName = Config.getEnv("WEBSITE_SITE_NAME");
        if (siteName != null) {
            aasTags.put("aas.site.name", siteName);
        }
        if (Config.getEnv("FUNCTIONS_WORKER_RUNTIME") != null || Config.getEnv("FUNCTIONS_EXTENSIONS_VERSION") != null) {
            aasTags.put("aas.site.kind", "functionapp");
            aasTags.put("aas.site.type", "function");
        } else {
            aasTags.put("aas.site.kind", "app");
            aasTags.put("aas.site.type", "app");
        }
        String resourceGroup = Config.getEnv("WEBSITE_RESOURCE_GROUP");
        if (resourceGroup != null) {
            aasTags.put("aas.resource.group", resourceGroup);
        }
        int plusIndex = (websiteOwner = Config.getEnv("WEBSITE_OWNER_NAME")) == null ? -1 : websiteOwner.indexOf(43);
        String subscriptionId = null;
        if (plusIndex > 0) {
            subscriptionId = websiteOwner.substring(0, plusIndex);
            aasTags.put("aas.subscription.id", subscriptionId);
        }
        if (subscriptionId != null && siteName != null && resourceGroup != null) {
            String resourceId = "/subscriptions/" + subscriptionId + "/resourcegroups/" + resourceGroup + "/providers/microsoft.web/sites/" + siteName;
            resourceId = resourceId.toLowerCase(Locale.ROOT);
            aasTags.put("aas.resource.id", resourceId);
        } else {
            log.warn("Unable to generate resource id subscription id: {}, site name: {}, resource group {}", new Object[]{subscriptionId, siteName, resourceGroup});
        }
        String instanceId = Config.getEnv("WEBSITE_INSTANCE_ID");
        instanceId = instanceId == null ? "unknown" : instanceId;
        aasTags.put("aas.environment.instance_id", instanceId);
        String instanceName = Config.getEnv("COMPUTERNAME");
        instanceName = instanceName == null ? "unknown" : instanceName;
        aasTags.put("aas.environment.instance_name", instanceName);
        String operatingSystem = Config.getEnv("WEBSITE_OS");
        operatingSystem = operatingSystem == null ? "unknown" : operatingSystem;
        aasTags.put("aas.environment.os", operatingSystem);
        String siteExtensionVersion = Config.getEnv("DD_AAS_JAVA_EXTENSION_VERSION");
        siteExtensionVersion = siteExtensionVersion == null ? "unknown" : siteExtensionVersion;
        aasTags.put("aas.environment.extension_version", siteExtensionVersion);
        aasTags.put("aas.environment.runtime", Config.getProp("java.vm.name", "unknown"));
        return aasTags;
    }

    private int schemaVersionFromConfig() {
        String defaultVersion = this.azureFunctions ? "v1" : "v0";
        String versionStr = this.configProvider.getString("trace.span.attribute.schema", defaultVersion, new String[0]);
        Matcher matcher = Pattern.compile("^v?(0|[1-9]\\d*)$").matcher(versionStr);
        int parsedVersion = -1;
        if (matcher.matches()) {
            parsedVersion = Integer.parseInt(matcher.group(1));
        }
        if (parsedVersion < 0 || parsedVersion > 1) {
            log.warn("Invalid attribute schema version {} invalid or out of range [v{}, v{}]. Defaulting to v{}", new Object[]{versionStr, 0, 1, 0});
            parsedVersion = 0;
        }
        return parsedVersion;
    }

    public String getFinalProfilingUrl() {
        if (this.profilingUrl != null) {
            return this.profilingUrl;
        }
        if (this.profilingAgentless) {
            return "https://intake.profile." + this.site + "/api/v2/profile";
        }
        String baseUrl = this.agentUrl.startsWith("unix:") ? "http://" + this.agentHost + ":" + this.agentPort : this.agentUrl;
        return baseUrl + "/profiling/v1/input";
    }

    public String getFinalLLMObsUrl() {
        if (this.llmObsAgentlessEnabled) {
            return "https://llmobs-intake." + this.site + "/api/v2/llmobs";
        }
        return null;
    }

    public String getFinalCrashTrackingTelemetryUrl() {
        if (this.crashTrackingAgentless) {
            return this.getDefaultTelemetryUrl();
        }
        return "http://" + this.agentHost + ":" + this.agentPort + "/telemetry/proxy/api/v2/apmtelemetry";
    }

    public String getFinalCrashTrackingErrorTrackingUrl() {
        if (this.crashTrackingAgentless) {
            return "https://error-tracking-intake." + this.site + "/api/v2/errorsintake";
        }
        return "http://" + this.agentHost + ":" + this.agentPort + "/evp_proxy/v4/api/v2/errorsintake";
    }

    public boolean isJmxFetchIntegrationEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "jmxfetch.", ".enabled", defaultEnabled);
    }

    public boolean isMetricsOtelEnabled() {
        return this.metricsOtelEnabled;
    }

    public int getMetricsOtelInterval() {
        return this.metricsOtelInterval;
    }

    public int getMetricsOtelTimeout() {
        return this.metricsOtelTimeout;
    }

    public String getOtlpMetricsEndpoint() {
        return this.otlpMetricsEndpoint;
    }

    public Map<String, String> getOtlpMetricsHeaders() {
        return this.otlpMetricsHeaders;
    }

    public OtlpConfig.Protocol getOtlpMetricsProtocol() {
        return this.otlpMetricsProtocol;
    }

    public int getOtlpMetricsTimeout() {
        return this.otlpMetricsTimeout;
    }

    public OtlpConfig.Temporality getOtlpMetricsTemporalityPreference() {
        return this.otlpMetricsTemporalityPreference;
    }

    public boolean isRuleEnabled(String name) {
        return this.isRuleEnabled(name, true);
    }

    public boolean isRuleEnabled(String name, boolean defaultEnabled) {
        boolean enabled = this.configProvider.getBoolean("trace." + name + ".enabled", defaultEnabled, new String[0]);
        boolean lowerEnabled = this.configProvider.getBoolean("trace." + name.toLowerCase(Locale.ROOT) + ".enabled", defaultEnabled, new String[0]);
        return defaultEnabled ? enabled && lowerEnabled : enabled || lowerEnabled;
    }

    public static boolean jmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isJmxFetchIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public boolean isEndToEndDurationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".e2e.duration.enabled", defaultEnabled);
    }

    public boolean isPropagationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".propagation.enabled", defaultEnabled);
    }

    public boolean isInjectDatadogAttributeEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".inject.datadog.attribute.enabled", defaultEnabled);
    }

    public boolean isLegacyTracingEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".legacy.tracing.enabled", defaultEnabled);
    }

    public boolean isSqsLegacyTracingEnabled() {
        return SpanNaming.instance().namingSchema().allowInferredServices() && this.isLegacyTracingEnabled(true, "sqs");
    }

    public boolean isAwsLegacyTracingEnabled() {
        return SpanNaming.instance().namingSchema().allowInferredServices() && this.isLegacyTracingEnabled(false, "aws-sdk");
    }

    public boolean isJmsLegacyTracingEnabled() {
        return SpanNaming.instance().namingSchema().allowInferredServices() && this.isLegacyTracingEnabled(true, "jms");
    }

    public boolean isKafkaLegacyTracingEnabled() {
        return SpanNaming.instance().namingSchema().allowInferredServices() && this.isLegacyTracingEnabled(true, "kafka");
    }

    public boolean isGooglePubSubLegacyTracingEnabled() {
        return SpanNaming.instance().namingSchema().allowInferredServices() && this.isLegacyTracingEnabled(true, "google-pubsub");
    }

    public boolean isTimeInQueueEnabled(boolean defaultEnabled, String ... integrationNames) {
        return SpanNaming.instance().namingSchema().allowInferredServices() && this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".time-in-queue.enabled", defaultEnabled);
    }

    public boolean isAddSpanPointers(String integrationName) {
        return this.configProvider.isEnabled(Arrays.asList(integrationName), "", "add.span.pointers", true);
    }

    public boolean isEnabled(boolean defaultEnabled, String settingName, String settingSuffix) {
        return this.configProvider.isEnabled(Collections.singletonList(settingName), "", settingSuffix, defaultEnabled);
    }

    public long getDependecyResolutionPeriodMillis() {
        return this.dependecyResolutionPeriodMillis;
    }

    public boolean isDbmInjectSqlBaseHash() {
        return this.dbmInjectSqlBaseHash;
    }

    public boolean isDbmTracePreparedStatements() {
        return this.dbmTracePreparedStatements;
    }

    public boolean isDbmAlwaysAppendSqlComment() {
        return this.dbmAlwaysAppendSqlComment;
    }

    public String getDbmPropagationMode() {
        return this.dbmPropagationMode;
    }

    public boolean isDbmCommentInjectionEnabled() {
        if (this.dbmPropagationMode == null) {
            return false;
        }
        return this.dbmPropagationMode.equals(DBM_PROPAGATION_MODE_FULL) || this.dbmPropagationMode.equals(DBM_PROPAGATION_MODE_STATIC);
    }

    private void logIgnoredSettingWarning(String setting, String overridingSetting, String overridingSuffix) {
        log.warn("Setting {} ignored since {}{} is enabled.", new Object[]{Config.propertyNameToSystemPropertyName(setting), Config.propertyNameToSystemPropertyName(overridingSetting), overridingSuffix});
    }

    private void logOverriddenSettingWarning(String setting, String overridingSetting, Object value) {
        log.warn("Setting {} is overridden by setting {} with value {}.", new Object[]{Config.propertyNameToSystemPropertyName(setting), Config.propertyNameToSystemPropertyName(overridingSetting), value});
    }

    private void logOverriddenDeprecatedSettingWarning(String setting, String overridingSetting, Object value) {
        log.warn("Setting {} is deprecated and overridden by setting {} with value {}.", new Object[]{Config.propertyNameToSystemPropertyName(setting), Config.propertyNameToSystemPropertyName(overridingSetting), value});
    }

    private void logDeprecatedConvertedSetting(String deprecatedSetting, Object oldValue, String newSetting, Object newValue) {
        log.warn("Setting {} is deprecated and the value {} has been converted to {} for setting {}.", new Object[]{Config.propertyNameToSystemPropertyName(deprecatedSetting), oldValue, newValue, Config.propertyNameToSystemPropertyName(newSetting)});
    }

    public boolean isTraceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "", ".analytics.enabled", defaultEnabled);
    }

    public boolean isTraceAnalyticsIntegrationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".analytics.enabled", defaultEnabled);
    }

    public boolean isSamplingMechanismValidationDisabled() {
        return this.configProvider.getBoolean("trace.sampling.mechanism.validation.disabled", false, new String[0]);
    }

    public <T extends Enum<T>> T getEnumValue(String name, Class<T> type, T defaultValue) {
        return this.configProvider.getEnum(name, type, defaultValue);
    }

    public static boolean traceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isTraceAnalyticsIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public boolean isTelemetryDebugRequestsEnabled() {
        return this.telemetryDebugRequestsEnabled;
    }

    public boolean isAgentlessLogSubmissionEnabled() {
        return this.instrumenterConfig.isAgentlessLogSubmissionEnabled();
    }

    public int getAgentlessLogSubmissionQueueSize() {
        return this.agentlessLogSubmissionQueueSize;
    }

    public String getAgentlessLogSubmissionLevel() {
        return this.agentlessLogSubmissionLevel;
    }

    public String getAgentlessLogSubmissionUrl() {
        return this.agentlessLogSubmissionUrl;
    }

    public String getAgentlessLogSubmissionProduct() {
        return this.agentlessLogSubmissionProduct;
    }

    public boolean isAppSecScaEnabled() {
        return this.appSecScaEnabled != null && this.appSecScaEnabled != false;
    }

    public boolean isAppSecRaspEnabled() {
        return this.appSecRaspEnabled;
    }

    public boolean isAppSecStackTraceEnabled() {
        return this.appSecStackTraceEnabled;
    }

    public int getAppSecMaxStackTraces() {
        return this.appSecMaxStackTraces;
    }

    public int getAppSecMaxStackTraceDepth() {
        return this.appSecMaxStackTraceDepth;
    }

    public int getAppSecBodyParsingSizeLimit() {
        return this.appSecBodyParsingSizeLimit;
    }

    public boolean isCloudPayloadTaggingEnabledFor(String serviceName) {
        return this.cloudPayloadTaggingServices.contains(serviceName);
    }

    public boolean isCloudPayloadTaggingEnabled() {
        return this.isCloudRequestPayloadTaggingEnabled() || this.isCloudResponsePayloadTaggingEnabled();
    }

    public List<JsonPath> getCloudRequestPayloadTagging() {
        return this.cloudRequestPayloadTagging == null ? Collections.emptyList() : this.cloudRequestPayloadTagging;
    }

    public boolean isCloudRequestPayloadTaggingEnabled() {
        return this.cloudRequestPayloadTagging != null;
    }

    public List<JsonPath> getCloudResponsePayloadTagging() {
        return this.cloudResponsePayloadTagging == null ? Collections.emptyList() : this.cloudResponsePayloadTagging;
    }

    public boolean isCloudResponsePayloadTaggingEnabled() {
        return this.cloudResponsePayloadTagging != null;
    }

    public int getCloudPayloadTaggingMaxDepth() {
        return this.cloudPayloadTaggingMaxDepth;
    }

    public int getCloudPayloadTaggingMaxTags() {
        return this.cloudPayloadTaggingMaxTags;
    }

    public RumInjectorConfig getRumInjectorConfig() {
        return this.rumInjectorConfig;
    }

    public boolean isAiGuardEnabled() {
        return this.aiGuardEnabled;
    }

    public String getAiGuardEndpoint() {
        return this.aiGuardEndpoint;
    }

    public int getAiGuardMaxContentSize() {
        return this.aiGuardMaxContentSize;
    }

    public int getAiGuardMaxMessagesLength() {
        return this.aiGuardMaxMessagesLength;
    }

    public int getAiGuardTimeout() {
        return this.aiGuardTimeout;
    }

    private <T> Set<T> getSettingsSetFromEnvironment(String name, Function<String, T> mapper, boolean splitOnWS) {
        String value = this.configProvider.getString(name, "", new String[0]);
        return Config.convertStringSetToSet(name, Config.parseStringIntoSetOfNonEmptyStrings(value, splitOnWS), mapper);
    }

    private <F, T> Set<T> convertSettingsSet(Set<F> fromSet, Function<F, Iterable<T>> mapper) {
        if (fromSet.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(fromSet.size());
        for (F from : fromSet) {
            for (T to : mapper.apply(from)) {
                result.add(to);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    private static String propertyNameToSystemPropertyName(String setting) {
        return PREFIX + setting;
    }

    @Nonnull
    private static Map<String, String> newHashMap(int size) {
        return new HashMap<String, String>(size + 1, 1.0f);
    }

    @Nonnull
    private Map<String, String> getMapWithPropertiesDefinedByEnvironment(@Nonnull Map<String, String> map, String ... propNames) {
        HashMap<String, String> res = new HashMap<String, String>(map);
        for (String propName : propNames) {
            String val = this.configProvider.getString(propName);
            if (val == null) continue;
            res.put(propName, val);
        }
        return Collections.unmodifiableMap(res);
    }

    @Nonnull
    private static Set<String> parseStringIntoSetOfNonEmptyStrings(String str) {
        return Config.parseStringIntoSetOfNonEmptyStrings(str, true);
    }

    @Nonnull
    private static Set<String> parseStringIntoSetOfNonEmptyStrings(String str, boolean splitOnWS) {
        int i;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int start = 0;
        for (i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != ',' && (!splitOnWS || !Character.isWhitespace(c))) continue;
            if (i - start - 1 > 0) {
                result.add(str.substring(start, i));
            }
            start = i + 1;
        }
        if (i - start - 1 > 0) {
            result.add(str.substring(start));
        }
        return Collections.unmodifiableSet(result);
    }

    private static <T> Set<T> convertStringSetToSet(String setting, Set<String> input, Function<String, T> mapper) {
        if (input.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (String value : input) {
            try {
                result.add(mapper.apply(value));
            }
            catch (IllegalArgumentException e) {
                log.warn("Cannot recognize config string value {} for setting {}", (Object)value, (Object)Config.propertyNameToSystemPropertyName(setting));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    static String initHostName() {
        String[] hostNameFiles;
        String possibleHostname = Config.isWindowsOS() ? Config.getEnv("COMPUTERNAME") : Config.getEnv("HOSTNAME");
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from environment variable");
            return possibleHostname.trim();
        }
        for (String hostNameFile : hostNameFiles = new String[]{"/proc/sys/kernel/hostname", "/etc/hostname"}) {
            try {
                Path hostNamePath = FileSystems.getDefault().getPath(hostNameFile, new String[0]);
                if (Files.isRegularFile(hostNamePath, new LinkOption[0])) {
                    byte[] bytes = Files.readAllBytes(hostNamePath);
                    possibleHostname = new String(bytes, StandardCharsets.ISO_8859_1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            possibleHostname = ConfigStrings.trim(possibleHostname);
            if (possibleHostname.isEmpty()) continue;
            log.debug("Determined hostname from file {}", (Object)hostNameFile);
            return possibleHostname;
        }
        try (TraceScope scope = AgentTracer.get().muteTracing();
             BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("hostname").getInputStream()));){
            possibleHostname = reader.readLine();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from hostname command");
            return possibleHostname.trim();
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static boolean isWindowsOS() {
        return Config.getProp("os.name").startsWith("Windows");
    }

    private static String getEnv(String name) {
        String value = ConfigHelper.env(name);
        if (value != null) {
            ConfigCollector.get().put(name, value, ConfigOrigin.ENV, 2);
        }
        return value;
    }

    private static Pattern getPattern(String defaultValue, String userValue) {
        try {
            if (userValue != null) {
                return Pattern.compile(userValue);
            }
        }
        catch (Exception e) {
            log.debug("Cannot create pattern from user value {}", (Object)userValue);
        }
        return Pattern.compile(defaultValue);
    }

    private static String getProp(String name) {
        return Config.getProp(name, null);
    }

    private static String getProp(String name, String def) {
        String value = SystemProperties.getOrDefault(name, def);
        if (value != null) {
            ConfigCollector.get().put(name, value, ConfigOrigin.JVM_PROP, 2);
        }
        return value;
    }

    public static Config get() {
        return INSTANCE;
    }

    @Deprecated
    public static Config get(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return INSTANCE;
        }
        return new Config(ConfigProvider.withPropertiesOverride(properties));
    }

    public String toString() {
        return "Config{instrumenterConfig=" + this.instrumenterConfig + ", runtimeId='" + this.getRuntimeId() + '\'' + ", runtimeVersion='" + this.runtimeVersion + ", apiKey=" + (this.apiKey == null ? "null" : "****") + ", site='" + this.site + '\'' + ", hostName='" + this.getHostName() + '\'' + ", serviceName='" + this.serviceName + '\'' + ", serviceNameSetByUser=" + this.serviceNameSetByUser + ", rootContextServiceName=" + this.rootContextServiceName + ", experimentalFeaturesEnabled=" + this.experimentalFeaturesEnabled + ", integrationSynapseLegacyOperationName=" + this.integrationSynapseLegacyOperationName + ", writerType='" + this.writerType + '\'' + ", agentConfiguredUsingDefault=" + this.agentConfiguredUsingDefault + ", agentUrl='" + this.agentUrl + '\'' + ", agentHost='" + this.agentHost + '\'' + ", agentPort=" + this.agentPort + ", agentUnixDomainSocket='" + this.agentUnixDomainSocket + '\'' + ", agentTimeout=" + this.agentTimeout + ", noProxyHosts=" + this.noProxyHosts + ", prioritySamplingEnabled=" + this.prioritySamplingEnabled + ", prioritySamplingForce='" + this.prioritySamplingForce + '\'' + ", traceResolverEnabled=" + this.traceResolverEnabled + ", serviceMapping=" + this.serviceMapping + ", tags=" + this.tags + ", spanTags=" + this.spanTags + ", jmxTags=" + this.jmxTags + ", requestHeaderTags=" + this.requestHeaderTags + ", responseHeaderTags=" + this.responseHeaderTags + ", baggageMapping=" + this.baggageMapping + ", httpServerErrorStatuses=" + this.httpServerErrorStatuses + ", httpClientErrorStatuses=" + this.httpClientErrorStatuses + ", httpServerTagQueryString=" + this.httpServerTagQueryString + ", httpServerRawQueryString=" + this.httpServerRawQueryString + ", httpServerRawResource=" + this.httpServerRawResource + ", httpServerRouteBasedNaming=" + this.httpServerRouteBasedNaming + ", httpServerPathResourceNameMapping=" + this.httpServerPathResourceNameMapping + ", httpClientPathResourceNameMapping=" + this.httpClientPathResourceNameMapping + ", httpClientTagQueryString=" + this.httpClientTagQueryString + ", httpClientSplitByDomain=" + this.httpClientSplitByDomain + ", httpResourceRemoveTrailingSlash=" + this.httpResourceRemoveTrailingSlash + ", dbClientSplitByInstance=" + this.dbClientSplitByInstance + ", dbClientSplitByInstanceTypeSuffix=" + this.dbClientSplitByInstanceTypeSuffix + ", dbClientSplitByHost=" + this.dbClientSplitByHost + ", dbMetadataFetchingEnabled=" + this.dbMetadataFetchingOnQuery + ", dbMetadataFetchingOnConnect=" + this.dbMetadataFetchingOnConnect + ", dbmInjectSqlBaseHash=" + this.dbmInjectSqlBaseHash + ", dbmPropagationMode=" + this.dbmPropagationMode + ", dbmTracePreparedStatements=" + this.dbmTracePreparedStatements + ", splitByTags=" + this.splitByTags + ", jeeSplitByDeployment=" + this.jeeSplitByDeployment + ", scopeDepthLimit=" + this.scopeDepthLimit + ", scopeStrictMode=" + this.scopeStrictMode + ", scopeIterationKeepAlive=" + this.scopeIterationKeepAlive + ", partialFlushMinSpans=" + this.partialFlushMinSpans + ", traceKeepLatencyThresholdEnabled=" + this.traceKeepLatencyThresholdEnabled + ", traceKeepLatencyThreshold=" + this.traceKeepLatencyThreshold + ", traceStrictWritesEnabled=" + this.traceStrictWritesEnabled + ", traceBaggageTagKeys=" + this.traceBaggageTagKeys + ", tracePropagationStylesToExtract=" + this.tracePropagationStylesToExtract + ", tracePropagationStylesToInject=" + this.tracePropagationStylesToInject + ", tracePropagationBehaviorExtract=" + this.tracePropagationBehaviorExtract + ", tracePropagationExtractFirst=" + this.tracePropagationExtractFirst + ", traceInferredProxyEnabled=" + this.traceInferredProxyEnabled + ", clockSyncPeriod=" + this.clockSyncPeriod + ", jmxFetchEnabled=" + this.jmxFetchEnabled + ", dogStatsDStartDelay=" + this.dogStatsDStartDelay + ", jmxFetchConfigDir='" + this.jmxFetchConfigDir + '\'' + ", jmxFetchConfigs=" + this.jmxFetchConfigs + ", jmxFetchMetricsConfigs=" + this.jmxFetchMetricsConfigs + ", jmxFetchCheckPeriod=" + this.jmxFetchCheckPeriod + ", jmxFetchInitialRefreshBeansPeriod=" + this.jmxFetchInitialRefreshBeansPeriod + ", jmxFetchRefreshBeansPeriod=" + this.jmxFetchRefreshBeansPeriod + ", jmxFetchStatsdHost='" + this.jmxFetchStatsdHost + '\'' + ", jmxFetchStatsdPort=" + this.jmxFetchStatsdPort + ", jmxFetchMultipleRuntimeServicesEnabled=" + this.jmxFetchMultipleRuntimeServicesEnabled + ", jmxFetchMultipleRuntimeServicesLimit=" + this.jmxFetchMultipleRuntimeServicesLimit + ", healthMetricsEnabled=" + this.healthMetricsEnabled + ", healthMetricsStatsdHost='" + this.healthMetricsStatsdHost + '\'' + ", healthMetricsStatsdPort=" + this.healthMetricsStatsdPort + ", perfMetricsEnabled=" + this.perfMetricsEnabled + ", tracerMetricsEnabled=" + this.tracerMetricsEnabled + ", tracerMetricsBufferingEnabled=" + this.tracerMetricsBufferingEnabled + ", tracerMetricsMaxAggregates=" + this.tracerMetricsMaxAggregates + ", tracerMetricsMaxPending=" + this.tracerMetricsMaxPending + ", reportHostName=" + this.reportHostName + ", traceAnalyticsEnabled=" + this.traceAnalyticsEnabled + ", traceSamplingServiceRules=" + this.traceSamplingServiceRules + ", traceSamplingOperationRules=" + this.traceSamplingOperationRules + ", traceSamplingJsonRules=" + this.traceSamplingRules + ", traceSampleRate=" + this.traceSampleRate + ", traceRateLimit=" + this.traceRateLimit + ", spanSamplingRules=" + this.spanSamplingRules + ", spanSamplingRulesFile=" + this.spanSamplingRulesFile + ", profilingAgentless=" + this.profilingAgentless + ", profilingUrl='" + this.profilingUrl + '\'' + ", profilingTags=" + this.profilingTags + ", profilingStartDelay=" + this.profilingStartDelay + ", profilingStartForceFirst=" + this.profilingStartForceFirst + ", profilingUploadPeriod=" + this.profilingUploadPeriod + ", profilingTemplateOverrideFile='" + this.profilingTemplateOverrideFile + '\'' + ", profilingUploadTimeout=" + this.profilingUploadTimeout + ", profilingUploadCompression='" + this.profilingUploadCompression + '\'' + ", profilingProxyHost='" + this.profilingProxyHost + '\'' + ", profilingProxyPort=" + this.profilingProxyPort + ", profilingProxyUsername='" + this.profilingProxyUsername + '\'' + ", profilingProxyPassword=" + (this.profilingProxyPassword == null ? "null" : "****") + ", profilingExceptionSampleLimit=" + this.profilingExceptionSampleLimit + ", profilingExceptionHistogramTopItems=" + this.profilingExceptionHistogramTopItems + ", profilingExceptionHistogramMaxCollectionSize=" + this.profilingExceptionHistogramMaxCollectionSize + ", profilingExcludeAgentThreads=" + this.profilingExcludeAgentThreads + ", crashTrackingTags=" + this.crashTrackingTags + ", crashTrackingAgentless=" + this.crashTrackingAgentless + ", crashTrackingErrorsIntakeEnabled=" + this.crashTrackingErrorsIntakeEnabled + ", remoteConfigEnabled=" + this.remoteConfigEnabled + ", remoteConfigUrl=" + this.remoteConfigUrl + ", remoteConfigPollIntervalSeconds=" + this.remoteConfigPollIntervalSeconds + ", remoteConfigMaxPayloadSize=" + this.remoteConfigMaxPayloadSize + ", remoteConfigIntegrityCheckEnabled=" + this.remoteConfigIntegrityCheckEnabled + ", debuggerEnabled=" + this.dynamicInstrumentationEnabled + ", debuggerUploadTimeout=" + this.dynamicInstrumentationUploadTimeout + ", debuggerUploadFlushInterval=" + this.dynamicInstrumentationUploadFlushInterval + ", debuggerClassFileDumpEnabled=" + this.dynamicInstrumentationClassFileDumpEnabled + ", debuggerPollInterval=" + this.dynamicInstrumentationPollInterval + ", debuggerDiagnosticsInterval=" + this.dynamicInstrumentationDiagnosticsInterval + ", debuggerMetricEnabled=" + this.dynamicInstrumentationMetricEnabled + ", debuggerProbeFileLocation=" + this.dynamicInstrumentationProbeFile + ", debuggerUploadBatchSize=" + this.dynamicInstrumentationUploadBatchSize + ", debuggerMaxPayloadSize=" + this.dynamicInstrumentationMaxPayloadSize + ", debuggerVerifyByteCode=" + this.dynamicInstrumentationVerifyByteCode + ", debuggerInstrumentTheWorld=" + this.dynamicInstrumentationInstrumentTheWorld + ", debuggerExcludeFiles=" + this.dynamicInstrumentationExcludeFiles + ", debuggerIncludeFiles=" + this.dynamicInstrumentationIncludeFiles + ", debuggerCaptureTimeout=" + this.dynamicInstrumentationCaptureTimeout + ", debuggerRedactIdentifiers=" + this.dynamicInstrumentationRedactedIdentifiers + ", debuggerRedactTypes=" + this.dynamicInstrumentationRedactedTypes + ", debuggerSymbolEnabled=" + this.symbolDatabaseEnabled + ", debuggerSymbolForceUpload=" + this.symbolDatabaseForceUpload + ", debuggerSymbolFlushThreshold=" + this.symbolDatabaseFlushThreshold + ", thirdPartyIncludes=" + this.debuggerThirdPartyIncludes + ", thirdPartyExcludes=" + this.debuggerThirdPartyExcludes + ", debuggerExceptionEnabled=" + this.debuggerExceptionEnabled + ", debuggerCodeOriginEnabled=" + this.debuggerCodeOriginEnabled + ", awsPropagationEnabled=" + this.awsPropagationEnabled + ", sqsPropagationEnabled=" + this.sqsPropagationEnabled + ", kafkaClientPropagationEnabled=" + this.kafkaClientPropagationEnabled + ", kafkaClientPropagationDisabledTopics=" + this.kafkaClientPropagationDisabledTopics + ", kafkaClientBase64DecodingEnabled=" + this.kafkaClientBase64DecodingEnabled + ", jmsPropagationEnabled=" + this.jmsPropagationEnabled + ", jmsPropagationDisabledTopics=" + this.jmsPropagationDisabledTopics + ", jmsPropagationDisabledQueues=" + this.jmsPropagationDisabledQueues + ", rabbitPropagationEnabled=" + this.rabbitPropagationEnabled + ", rabbitPropagationDisabledQueues=" + this.rabbitPropagationDisabledQueues + ", rabbitPropagationDisabledExchanges=" + this.rabbitPropagationDisabledExchanges + ", messageBrokerSplitByDestination=" + this.messageBrokerSplitByDestination + ", hystrixTagsEnabled=" + this.hystrixTagsEnabled + ", hystrixMeasuredEnabled=" + this.hystrixMeasuredEnabled + ", resilience4jMeasuredEnable=" + this.resilience4jMeasuredEnabled + ", resilience4jTagMetricsEnabled=" + this.resilience4jTagMetricsEnabled + ", igniteCacheIncludeKeys=" + this.igniteCacheIncludeKeys + ", servletPrincipalEnabled=" + this.servletPrincipalEnabled + ", servletAsyncTimeoutError=" + this.servletAsyncTimeoutError + ", datadogTagsLimit=" + this.xDatadogTagsMaxLength + ", traceAgentV05Enabled=" + this.traceAgentV05Enabled + ", logLevel=" + this.logLevel + ", debugEnabled=" + this.debugEnabled + ", triageEnabled=" + this.triageEnabled + ", triageReportDir=" + this.triageReportDir + ", startLogsEnabled=" + this.startupLogsEnabled + ", configFile='" + this.configFileStatus + '\'' + ", idGenerationStrategy=" + this.idGenerationStrategy + ", trace128bitTraceIdGenerationEnabled=" + this.trace128bitTraceIdGenerationEnabled + ", logs128bitTraceIdEnabled=" + this.logs128bitTraceIdEnabled + ", grpcIgnoredInboundMethods=" + this.grpcIgnoredInboundMethods + ", grpcIgnoredOutboundMethods=" + this.grpcIgnoredOutboundMethods + ", grpcServerErrorStatuses=" + this.grpcServerErrorStatuses + ", grpcClientErrorStatuses=" + this.grpcClientErrorStatuses + ", clientIpEnabled=" + this.clientIpEnabled + ", appSecReportingInband=" + this.appSecReportingInband + ", appSecRulesFile='" + this.appSecRulesFile + "', appSecHttpBlockedTemplateHtml=" + this.appSecHttpBlockedTemplateHtml + ", appSecWafTimeout=" + this.appSecWafTimeout + " us, appSecHttpBlockedTemplateJson=" + this.appSecHttpBlockedTemplateJson + ", apiSecurityEnabled=" + this.apiSecurityEnabled + ", apiSecurityEndpointCollectionMessageLimit=" + this.apiSecurityEndpointCollectionMessageLimit + ", cwsEnabled=" + this.cwsEnabled + ", cwsTlsRefresh=" + this.cwsTlsRefresh + ", longRunningTraceEnabled=" + this.longRunningTraceEnabled + ", longRunningTraceInitialFlushInterval=" + this.longRunningTraceInitialFlushInterval + ", longRunningTraceFlushInterval=" + this.longRunningTraceFlushInterval + ", cassandraKeyspaceStatementExtractionEnabled=" + this.cassandraKeyspaceStatementExtractionEnabled + ", couchbaseInternalSpansEnabled=" + this.couchbaseInternalSpansEnabled + ", elasticsearchBodyEnabled=" + this.elasticsearchBodyEnabled + ", elasticsearchParamsEnabled=" + this.elasticsearchParamsEnabled + ", elasticsearchBodyAndParamsEnabled=" + this.elasticsearchBodyAndParamsEnabled + ", traceFlushInterval=" + this.traceFlushIntervalSeconds + ", injectBaggageAsTagsEnabled=" + this.injectBaggageAsTagsEnabled + ", logsInjectionEnabled=" + this.logsInjectionEnabled + ", sparkTaskHistogramEnabled=" + this.sparkTaskHistogramEnabled + ", sparkAppNameAsService=" + this.sparkAppNameAsService + ", jaxRsExceptionAsErrorsEnabled=" + this.jaxRsExceptionAsErrorsEnabled + ", axisPromoteResourceName=" + this.axisPromoteResourceName + ", peerHostNameEnabled=" + this.peerHostNameEnabled + ", peerServiceDefaultsEnabled=" + this.peerServiceDefaultsEnabled + ", peerServiceComponentOverrides=" + this.peerServiceComponentOverrides + ", removeIntegrationServiceNamesEnabled=" + this.removeIntegrationServiceNamesEnabled + ", spanAttributeSchemaVersion=" + this.spanAttributeSchemaVersion + ", telemetryDebugRequestsEnabled=" + this.telemetryDebugRequestsEnabled + ", telemetryMetricsEnabled=" + this.telemetryMetricsEnabled + ", appSecScaEnabled=" + this.appSecScaEnabled + ", appSecRaspEnabled=" + this.appSecRaspEnabled + ", dataJobsOpenLineageEnabled=" + this.dataJobsOpenLineageEnabled + ", dataJobsOpenLineageTimeoutEnabled=" + this.dataJobsOpenLineageTimeoutEnabled + ", dataJobsParseSparkPlanEnabled=" + this.dataJobsParseSparkPlanEnabled + ", dataJobsExperimentalFeaturesEnabled=" + this.dataJobsExperimentalFeaturesEnabled + ", apmTracingEnabled=" + this.apmTracingEnabled + ", jdkSocketEnabled=" + this.jdkSocketEnabled + ", cloudPayloadTaggingServices=" + this.cloudPayloadTaggingServices + ", cloudRequestPayloadTagging=" + this.cloudRequestPayloadTagging + ", cloudResponsePayloadTagging=" + this.cloudResponsePayloadTagging + ", experimentalPropagateProcessTagsEnabled=" + this.experimentalPropagateProcessTagsEnabled + ", rumInjectorConfig=" + (this.rumInjectorConfig == null ? "null" : this.rumInjectorConfig.jsonPayload()) + ", aiGuardEnabled=" + this.aiGuardEnabled + ", aiGuardEndpoint=" + this.aiGuardEndpoint + ", metricsOtelEnabled=" + this.metricsOtelEnabled + ", metricsOtelInterval=" + this.metricsOtelInterval + ", metricsOtelTimeout=" + this.metricsOtelTimeout + ", otlpMetricsEndpoint=" + this.otlpMetricsEndpoint + ", otlpMetricsHeaders=" + this.otlpMetricsHeaders + ", otlpMetricsProtocol=" + this.otlpMetricsProtocol + ", otlpMetricsTimeout=" + this.otlpMetricsTimeout + ", otlpMetricsTemporalityPreference=" + this.otlpMetricsTemporalityPreference + ", serviceDiscoveryEnabled=" + this.serviceDiscoveryEnabled + ", sfnInjectDatadogAttributeEnabled=" + this.sfnInjectDatadogAttributeEnabled + ", eventbridgeInjectDatadogAttributeEnabled=" + this.eventbridgeInjectDatadogAttributeEnabled + ", sqsInjectDatadogAttributeEnabled=" + this.sqsInjectDatadogAttributeEnabled + ", snsInjectDatadogAttributeEnabled=" + this.snsInjectDatadogAttributeEnabled + '}';
    }

    static {
        OtelEnvMetricCollectorProvider.register(OtelEnvMetricCollectorImpl.getInstance());
        ConfigInversionMetricCollectorProvider.register(ConfigInversionMetricCollectorImpl.getInstance());
        INSTANCE = new Config(Platform.isNativeImageBuilder() ? ConfigProvider.withoutCollector() : ConfigProvider.getInstance(), InstrumenterConfig.get());
    }

    static class HostNameHolder {
        static final String hostName = Config.initHostName();

        HostNameHolder() {
        }

        public static String getHostName() {
            return hostName;
        }
    }

    static class RuntimeIdHolder {
        static final String runtimeId = RandomUtils.randomUUID().toString();

        RuntimeIdHolder() {
        }
    }
}

