/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.relocate.api;

import ddtrot.dd.trace.api.telemetry.LogCollector;
import ddtrot.dd.trace.relocate.api.RatelimitedLogger;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class IOLogger {
    private boolean logNextSuccess = false;
    private final Logger log;
    private final RatelimitedLogger ratelimitedLogger;

    public IOLogger(Logger log) {
        this(log, new RatelimitedLogger(log, 5, TimeUnit.MINUTES));
    }

    IOLogger(Logger log, RatelimitedLogger ratelimitedLogger) {
        this.log = log;
        this.ratelimitedLogger = ratelimitedLogger;
    }

    public boolean success(String format, Object ... arguments) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(LogCollector.EXCLUDE_TELEMETRY, format, arguments);
            return true;
        }
        if (this.logNextSuccess) {
            this.logNextSuccess = false;
            if (this.log.isInfoEnabled()) {
                this.log.info(LogCollector.EXCLUDE_TELEMETRY, format, arguments);
                return true;
            }
        }
        return false;
    }

    public boolean error(String message) {
        return this.error(message, null, null);
    }

    public boolean error(String message, Exception exception) {
        return this.error(message, null, exception);
    }

    public boolean error(String message, Response response) {
        return this.error(message, response, null);
    }

    public boolean error(String message, Response response, Exception exception) {
        if (this.log.isDebugEnabled()) {
            if (response != null) {
                this.log.debug(LogCollector.EXCLUDE_TELEMETRY, "{} Status: {}, Response: {}, Body: {}", new Object[]{message, response.getStatusCode(), response.getMessage(), response.getBody()});
            } else if (exception != null) {
                this.log.debug(LogCollector.EXCLUDE_TELEMETRY, message, (Throwable)exception);
            } else {
                this.log.debug(LogCollector.EXCLUDE_TELEMETRY, message);
            }
            return true;
        }
        boolean hasLogged = response != null ? this.ratelimitedLogger.warn(LogCollector.EXCLUDE_TELEMETRY, "{} Status: {} {}", message, response.getStatusCode(), response.getMessage()) : (exception != null ? this.ratelimitedLogger.warn(LogCollector.EXCLUDE_TELEMETRY, "{} {}: {}", message, exception.getClass().getName(), exception.getMessage()) : this.ratelimitedLogger.warn(message, new Object[0]));
        if (hasLogged) {
            this.logNextSuccess = true;
        }
        return hasLogged;
    }

    public static final class Response {
        private final int statusCode;
        private final String message;
        private final String body;

        public Response(int statusCode, String message, String body) {
            this.statusCode = statusCode;
            this.message = message;
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public String getBody() {
            return this.body;
        }
    }
}

