/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.llmobs.writer.ddintake;

import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.api.llmobs.LLMObs;
import ddtrot.dd.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteMapper;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.Metadata;
import ddtrot.dd.trace.core.MetadataConsumer;
import ddtrot.okhttp3.RequestBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLMObsSpanMapper
implements RemoteMapper {
    private static final String LLMOBS_TAG_PREFIX = "_ml_obs_tag.";
    private static final String LLMOBS_METRIC_PREFIX = "_ml_obs_metric.";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String SPAN_KIND_TAG_KEY = "_ml_obs_tag.span.kind";
    private static final Logger LOGGER = LoggerFactory.getLogger(LLMObsSpanMapper.class);
    private static final byte[] STAGE = "_dd.stage".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EVENT_TYPE = "event_type".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SPAN_ID = "span_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TRACE_ID = "trace_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PARENT_ID = "parent_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NAME = "name".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DURATION = "duration".getBytes(StandardCharsets.UTF_8);
    private static final byte[] START_NS = "start_ns".getBytes(StandardCharsets.UTF_8);
    private static final byte[] STATUS = "status".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ERROR = "error".getBytes(StandardCharsets.UTF_8);
    private static final byte[] META = "meta".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METADATA = "metadata".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SPAN_KIND = "span.kind".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SPANS = "spans".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METRICS = "metrics".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TAGS = "tags".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LLM_MESSAGE_ROLE = "role".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LLM_MESSAGE_CONTENT = "content".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LLM_MESSAGE_TOOL_CALLS = "tool_calls".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LLM_TOOL_CALL_NAME = "name".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LLM_TOOL_CALL_TYPE = "type".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LLM_TOOL_CALL_TOOL_ID = "tool_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LLM_TOOL_CALL_ARGUMENTS = "arguments".getBytes(StandardCharsets.UTF_8);
    private static final String PARENT_ID_TAG_INTERNAL_FULL = "_ml_obs_tag.parent_id";
    private final MetaWriter metaWriter = new MetaWriter();
    private final int size;

    public LLMObsSpanMapper() {
        this(0x500000);
    }

    private LLMObsSpanMapper(int size) {
        this.size = size;
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        List llmobsSpans = trace.stream().filter(LLMObsSpanMapper::isLLMObsSpan).collect(Collectors.toList());
        writable.startMap(3);
        writable.writeUTF8(EVENT_TYPE);
        writable.writeString("span", null);
        writable.writeUTF8(STAGE);
        writable.writeString("raw", null);
        writable.writeUTF8(SPANS);
        writable.startArray(llmobsSpans.size());
        for (CoreSpan span : llmobsSpans) {
            writable.startMap(11);
            writable.writeUTF8(SPAN_ID);
            writable.writeString(String.valueOf(span.getSpanId()), null);
            writable.writeUTF8(TRACE_ID);
            writable.writeString(span.getTraceId().toHexString(), null);
            writable.writeUTF8(PARENT_ID);
            writable.writeString((CharSequence)span.getTag(PARENT_ID_TAG_INTERNAL_FULL), null);
            span.removeTag(PARENT_ID_TAG_INTERNAL_FULL);
            writable.writeUTF8(NAME);
            writable.writeString(span.getOperationName(), null);
            writable.writeUTF8(START_NS);
            writable.writeUnsignedLong(span.getStartTime());
            writable.writeUTF8(DURATION);
            writable.writeFloat(span.getDurationNano());
            writable.writeUTF8(ERROR);
            writable.writeInt(span.getError());
            boolean errored = span.getError() == 1;
            writable.writeUTF8(STATUS);
            writable.writeString(errored ? "error" : "ok", null);
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable, LLMObsSpanMapper.getErrorsMap(span)));
        }
    }

    private static boolean isLLMObsSpan(CoreSpan<?> span) {
        CharSequence type = span.getType();
        return type != null && type.toString().contentEquals(InternalSpanTypes.LLMOBS);
    }

    @Override
    public Payload newPayload() {
        return new PayloadV1();
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
    }

    @Override
    public String endpoint() {
        return (Object)((Object)TrackType.LLMOBS) + "/v2";
    }

    private static Map<String, String> getErrorsMap(CoreSpan<?> span) {
        String errorStack;
        String errorType;
        HashMap<String, String> errors = new HashMap<String, String>();
        String errorMsg = (String)span.getTag("error.message");
        if (errorMsg != null && !errorMsg.isEmpty()) {
            errors.put("error.message", errorMsg);
        }
        if ((errorType = (String)span.getTag("error.type")) != null && !errorType.isEmpty()) {
            errors.put("error.type", errorType);
        }
        if ((errorStack = (String)span.getTag("error.stack")) != null && !errorStack.isEmpty()) {
            errors.put("error.stack", errorStack);
        }
        return errors;
    }

    private static final class MetaWriter
    implements MetadataConsumer {
        private Writable writable;
        private Map<String, String> errorInfo;
        private static final Set<String> TAGS_FOR_REMAPPING = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_ml_obs_tag.input", "_ml_obs_tag.output", "_ml_obs_tag.model_name", "_ml_obs_tag.model_provider", "_ml_obs_tag.model_version", "_ml_obs_tag.metadata")));

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable, Map<String, String> errorInfo) {
            this.writable = writable;
            this.errorInfo = errorInfo;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void accept(Metadata metadata) {
            HashMap<Object, Object> tagsToRemapToMeta = new HashMap<Object, Object>();
            int metricsSize = 0;
            int tagsSize = 0;
            String spanKind = "unknown";
            for (Map.Entry<String, Object> tag : metadata.getTags().entrySet()) {
                void var8_9;
                String string = tag.getKey();
                if (string.equals(LLMObsSpanMapper.SPAN_KIND_TAG_KEY)) {
                    spanKind = String.valueOf(tag.getValue());
                    continue;
                }
                if (TAGS_FOR_REMAPPING.contains(string)) {
                    tagsToRemapToMeta.put(string, tag.getValue());
                    continue;
                }
                if (string.startsWith(LLMObsSpanMapper.LLMOBS_METRIC_PREFIX) && tag.getValue() instanceof Number) {
                    ++metricsSize;
                    continue;
                }
                if (!string.startsWith(LLMObsSpanMapper.LLMOBS_TAG_PREFIX)) continue;
                if (string.startsWith(LLMObsSpanMapper.LLMOBS_TAG_PREFIX)) {
                    String string2 = string.substring(LLMObsSpanMapper.LLMOBS_TAG_PREFIX.length());
                }
                if (TAGS_FOR_REMAPPING.contains(var8_9)) {
                    tagsToRemapToMeta.put(var8_9, tag.getValue());
                    continue;
                }
                ++tagsSize;
            }
            if (!spanKind.equals("unknown")) {
                metadata.getTags().remove(LLMObsSpanMapper.SPAN_KIND_TAG_KEY);
            } else {
                LOGGER.warn("missing span kind");
            }
            this.writable.writeUTF8(METRICS);
            this.writable.startMap(metricsSize);
            for (Map.Entry<String, Object> tag : metadata.getTags().entrySet()) {
                String string = tag.getKey();
                if (!string.startsWith(LLMObsSpanMapper.LLMOBS_METRIC_PREFIX) || !(tag.getValue() instanceof Number)) continue;
                this.writable.writeString(string.substring(LLMObsSpanMapper.LLMOBS_METRIC_PREFIX.length()), null);
                this.writable.writeObject(tag.getValue(), null);
            }
            this.writable.writeUTF8(TAGS);
            this.writable.startArray(tagsSize + 1);
            this.writable.writeString("language:jvm", null);
            for (Map.Entry<String, Object> tag : metadata.getTags().entrySet()) {
                String string = tag.getKey();
                Object value = tag.getValue();
                if (tagsToRemapToMeta.containsKey(string) || !string.startsWith(LLMObsSpanMapper.LLMOBS_TAG_PREFIX)) continue;
                this.writable.writeObject(string.substring(LLMObsSpanMapper.LLMOBS_TAG_PREFIX.length()) + ":" + value, null);
            }
            int metaSize = tagsToRemapToMeta.size() + 1 + (null != this.errorInfo ? this.errorInfo.size() : 0);
            this.writable.writeUTF8(META);
            this.writable.startMap(metaSize);
            this.writable.writeUTF8(SPAN_KIND);
            this.writable.writeString(spanKind, null);
            for (Map.Entry<String, String> entry : this.errorInfo.entrySet()) {
                this.writable.writeUTF8(entry.getKey().getBytes());
                this.writable.writeString(entry.getValue(), null);
            }
            for (Map.Entry<String, String> entry : tagsToRemapToMeta.entrySet()) {
                String key2 = entry.getKey().substring(LLMObsSpanMapper.LLMOBS_TAG_PREFIX.length());
                String val = entry.getValue();
                if (key2.equals(LLMObsSpanMapper.INPUT) || key2.equals(LLMObsSpanMapper.OUTPUT)) {
                    if (!spanKind.equals("llm")) {
                        key2 = key2 + ".value";
                        this.writable.writeString(key2, null);
                        this.writable.writeObject(val, null);
                        continue;
                    }
                    if (!(val instanceof List)) {
                        LOGGER.warn("unexpectedly found incorrect type for LLM span IO {}, expecting list", (Object)val.getClass().getName());
                        continue;
                    }
                    List messages = (List)((Object)val);
                    key2 = key2 + ".messages";
                    this.writable.writeString(key2, null);
                    this.writable.startArray(messages.size());
                    for (LLMObs.LLMMessage message : messages) {
                        List toolCalls = message.getToolCalls();
                        boolean hasToolCalls = null != toolCalls && !toolCalls.isEmpty();
                        this.writable.startMap(hasToolCalls ? 3 : 2);
                        this.writable.writeUTF8(LLM_MESSAGE_ROLE);
                        this.writable.writeString(message.getRole(), null);
                        this.writable.writeUTF8(LLM_MESSAGE_CONTENT);
                        this.writable.writeString(message.getContent(), null);
                        if (!hasToolCalls) continue;
                        this.writable.writeUTF8(LLM_MESSAGE_TOOL_CALLS);
                        this.writable.startArray(toolCalls.size());
                        for (LLMObs.ToolCall toolCall : toolCalls) {
                            Map arguments = toolCall.getArguments();
                            boolean hasArguments = null != arguments && !arguments.isEmpty();
                            this.writable.startMap(hasArguments ? 4 : 3);
                            this.writable.writeUTF8(LLM_TOOL_CALL_NAME);
                            this.writable.writeString(toolCall.getName(), null);
                            this.writable.writeUTF8(LLM_TOOL_CALL_TYPE);
                            this.writable.writeString(toolCall.getType(), null);
                            this.writable.writeUTF8(LLM_TOOL_CALL_TOOL_ID);
                            this.writable.writeString(toolCall.getToolId(), null);
                            if (!hasArguments) continue;
                            this.writable.writeUTF8(LLM_TOOL_CALL_ARGUMENTS);
                            this.writable.startMap(arguments.size());
                            for (Map.Entry argument : arguments.entrySet()) {
                                this.writable.writeString((CharSequence)argument.getKey(), null);
                                this.writable.writeObject(argument.getValue(), null);
                            }
                        }
                    }
                    continue;
                }
                if (key2.equals("metadata") && val instanceof Map) {
                    Map metadataMap = (Map)((Object)val);
                    this.writable.writeUTF8(METADATA);
                    this.writable.startMap(metadataMap.size());
                    for (Map.Entry entry2 : metadataMap.entrySet()) {
                        this.writable.writeString((CharSequence)entry2.getKey(), null);
                        this.writable.writeObject(entry2.getValue(), null);
                    }
                    continue;
                }
                this.writable.writeString(key2, null);
                this.writable.writeObject(val, null);
            }
        }
    }

    private static class PayloadV1
    extends Payload {
        private PayloadV1() {
        }

        @Override
        public int sizeInBytes() {
            if (this.traceCount() == 0) {
                return this.msgpackMapHeaderSize(0);
            }
            return this.body.array().length;
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            if (this.traceCount() == 0) {
                ByteBuffer emptyDict = this.msgpackMapHeader(0);
                while (emptyDict.hasRemaining()) {
                    channel.write(emptyDict);
                }
            } else {
                while (this.body.hasRemaining()) {
                    channel.write(this.body);
                }
            }
        }

        @Override
        public RequestBody toRequest() {
            List<ByteBuffer> buffers = this.traceCount() == 0 ? Collections.singletonList(this.msgpackMapHeader(0)) : Collections.singletonList(this.body);
            return OkHttpUtils.gzippedMsgpackRequestBodyOf(buffers);
        }
    }
}

