/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.core.DDSpanContext;

public final class W3CTraceParent {
    private static final int TRACE_PARENT_LENGTH = 55;

    private W3CTraceParent() {
    }

    public static String from(DDTraceId traceId, long spanId, boolean isSampled) {
        StringBuilder sb = new StringBuilder(55);
        sb.append("00-");
        sb.append(traceId.toHexString());
        sb.append('-');
        sb.append(DDSpanId.toHexStringPadded((long)spanId));
        sb.append(isSampled ? "-01" : "-00");
        return sb.toString();
    }

    public static String from(AgentSpan span) {
        return W3CTraceParent.from(span.getTraceId(), span.getSpanId(), span.context().getSamplingPriority() > 0);
    }

    public static String from(DDSpanContext spanContext) {
        return W3CTraceParent.from(spanContext.getTraceId(), spanContext.getSpanId(), spanContext.getSamplingPriority() > 0);
    }
}

