/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.monitor;

import datadog.trace.api.StatsDClient;
import ddtrot.dd.trace.api.cache.RadixTreeCache;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntFunction;
import org.slf4j.Logger;

public class TracerHealthMetrics
extends HealthMetrics
implements AutoCloseable {
    private static final Logger log;
    private static final IntFunction<String[]> STATUS_TAGS;
    private static final String[] NO_TAGS;
    private static final String[] STATUS_OK_TAGS;
    private final RadixTreeCache<String[]> statusTagsCache = new RadixTreeCache<String[]>(16, 32, STATUS_TAGS, 200, 400);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile AgentTaskScheduler.Scheduled<TracerHealthMetrics> cancellation;
    private final LongAdder apiRequests = new LongAdder();
    private final LongAdder apiErrors = new LongAdder();
    private final LongAdder apiResponsesOK = new LongAdder();
    private final LongAdder userDropEnqueuedTraces = new LongAdder();
    private final LongAdder userKeepEnqueuedTraces = new LongAdder();
    private final LongAdder samplerDropEnqueuedTraces = new LongAdder();
    private final LongAdder samplerKeepEnqueuedTraces = new LongAdder();
    private final LongAdder unsetPriorityEnqueuedTraces = new LongAdder();
    private final LongAdder userDropDroppedTraces = new LongAdder();
    private final LongAdder userKeepDroppedTraces = new LongAdder();
    private final LongAdder samplerDropDroppedTraces = new LongAdder();
    private final LongAdder samplerKeepDroppedTraces = new LongAdder();
    private final LongAdder serialFailedDroppedTraces = new LongAdder();
    private final LongAdder unsetPriorityDroppedTraces = new LongAdder();
    private final LongAdder userDropDroppedSpans = new LongAdder();
    private final LongAdder userKeepDroppedSpans = new LongAdder();
    private final LongAdder samplerDropDroppedSpans = new LongAdder();
    private final LongAdder samplerKeepDroppedSpans = new LongAdder();
    private final LongAdder serialFailedDroppedSpans = new LongAdder();
    private final LongAdder unsetPriorityDroppedSpans = new LongAdder();
    private final LongAdder enqueuedSpans = new LongAdder();
    private final LongAdder enqueuedBytes = new LongAdder();
    private final LongAdder createdTraces = new LongAdder();
    private final LongAdder createdSpans = new LongAdder();
    private final LongAdder finishedSpans = new LongAdder();
    private final LongAdder flushedTraces = new LongAdder();
    private final LongAdder flushedBytes = new LongAdder();
    private final LongAdder partialTraces = new LongAdder();
    private final LongAdder partialBytes = new LongAdder();
    private final LongAdder clientSpansWithoutContext = new LongAdder();
    private final LongAdder singleSpanSampled = new LongAdder();
    private final LongAdder singleSpanUnsampled = new LongAdder();
    private final LongAdder capturedContinuations = new LongAdder();
    private final LongAdder cancelledContinuations = new LongAdder();
    private final LongAdder finishedContinuations = new LongAdder();
    private final LongAdder activatedScopes = new LongAdder();
    private final LongAdder closedScopes = new LongAdder();
    private final LongAdder scopeStackOverflow = new LongAdder();
    private final LongAdder scopeCloseErrors = new LongAdder();
    private final LongAdder userScopeCloseErrors = new LongAdder();
    private final LongAdder longRunningTracesWrite = new LongAdder();
    private final LongAdder longRunningTracesDropped = new LongAdder();
    private final LongAdder longRunningTracesExpired = new LongAdder();
    private final LongAdder clientStatsProcessedSpans = new LongAdder();
    private final LongAdder clientStatsProcessedTraces = new LongAdder();
    private final LongAdder clientStatsP0DroppedSpans = new LongAdder();
    private final LongAdder clientStatsP0DroppedTraces = new LongAdder();
    private final LongAdder clientStatsRequests = new LongAdder();
    private final LongAdder clientStatsErrors = new LongAdder();
    private final LongAdder clientStatsDowngrades = new LongAdder();
    private final StatsDClient statsd;
    private final long interval;
    private final TimeUnit units;

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.cancellation = AgentTaskScheduler.get().scheduleAtFixedRate(new Flush(), this, this.interval, this.interval, this.units);
        }
    }

    public TracerHealthMetrics(StatsDClient statsd) {
        this(statsd, 30L, TimeUnit.SECONDS);
    }

    public TracerHealthMetrics(StatsDClient statsd, long interval, TimeUnit units) {
        this.statsd = statsd;
        this.interval = interval;
        this.units = units;
    }

    @Override
    public void onStart(int queueCapacity) {
        this.statsd.gauge("queue.max_length", queueCapacity, NO_TAGS);
    }

    @Override
    public void onShutdown(boolean flushSuccess) {
    }

    @Override
    public void onPublish(List<DDSpan> trace, int samplingPriority) {
        switch (samplingPriority) {
            case -1: {
                this.userDropEnqueuedTraces.increment();
                break;
            }
            case 2: {
                this.userKeepEnqueuedTraces.increment();
                break;
            }
            case 0: {
                this.samplerDropEnqueuedTraces.increment();
                break;
            }
            case 1: {
                this.samplerKeepEnqueuedTraces.increment();
                break;
            }
            default: {
                this.unsetPriorityEnqueuedTraces.increment();
            }
        }
        this.enqueuedSpans.add(trace.size());
        this.checkForClientSpansWithoutContext(trace);
    }

    private void checkForClientSpansWithoutContext(List<DDSpan> trace) {
        for (DDSpan span : trace) {
            String spanKind;
            if (span == null || span.getParentId() != 0L || !"client".equals(spanKind = span.getTag("span.kind", "undefined"))) continue;
            this.clientSpansWithoutContext.increment();
        }
    }

    @Override
    public void onFailedPublish(int samplingPriority, int spanCount) {
        switch (samplingPriority) {
            case -1: {
                this.userDropDroppedSpans.add(spanCount);
                this.userDropDroppedTraces.increment();
                break;
            }
            case 2: {
                this.userKeepDroppedSpans.add(spanCount);
                this.userKeepDroppedTraces.increment();
                break;
            }
            case 0: {
                this.samplerDropDroppedSpans.add(spanCount);
                this.samplerDropDroppedTraces.increment();
                break;
            }
            case 1: {
                this.samplerKeepDroppedSpans.add(spanCount);
                this.samplerKeepDroppedTraces.increment();
                break;
            }
            default: {
                this.unsetPriorityDroppedSpans.add(spanCount);
                this.unsetPriorityDroppedTraces.increment();
            }
        }
    }

    @Override
    public void onPartialPublish(int numberOfDroppedSpans) {
        this.partialTraces.increment();
        this.samplerDropDroppedSpans.add(numberOfDroppedSpans);
    }

    @Override
    public void onScheduleFlush(boolean previousIncomplete) {
    }

    @Override
    public void onFlush(boolean early) {
    }

    @Override
    public void onPartialFlush(int sizeInBytes) {
        this.partialBytes.add(sizeInBytes);
    }

    @Override
    public void onSingleSpanSample() {
        this.singleSpanSampled.increment();
    }

    @Override
    public void onSingleSpanUnsampled() {
        this.singleSpanUnsampled.increment();
    }

    @Override
    public void onSerialize(int serializedSizeInBytes) {
        this.enqueuedBytes.add(serializedSizeInBytes);
    }

    @Override
    public void onFailedSerialize(List<DDSpan> trace, Throwable optionalCause) {
        if (trace != null) {
            this.serialFailedDroppedTraces.increment();
            this.serialFailedDroppedSpans.add(trace.size());
        }
    }

    @Override
    public void onCreateSpan() {
        this.createdSpans.increment();
    }

    @Override
    public void onFinishSpan() {
        this.finishedSpans.increment();
    }

    @Override
    public void onCreateTrace() {
        this.createdTraces.increment();
    }

    @Override
    public void onScopeCloseError(boolean manual) {
        this.scopeCloseErrors.increment();
        if (manual) {
            this.userScopeCloseErrors.increment();
        }
    }

    @Override
    public void onCaptureContinuation() {
        this.capturedContinuations.increment();
    }

    @Override
    public void onCancelContinuation() {
        this.cancelledContinuations.increment();
    }

    @Override
    public void onFinishContinuation() {
        this.finishedContinuations.increment();
    }

    @Override
    public void onActivateScope() {
        this.activatedScopes.increment();
    }

    @Override
    public void onCloseScope() {
        this.closedScopes.increment();
    }

    @Override
    public void onScopeStackOverflow() {
        this.scopeStackOverflow.increment();
    }

    @Override
    public void onSend(int traceCount, int sizeInBytes, RemoteApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    @Override
    public void onFailedSend(int traceCount, int sizeInBytes, RemoteApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    @Override
    public void onLongRunningUpdate(int dropped, int write, int expired) {
        this.longRunningTracesWrite.add(write);
        this.longRunningTracesDropped.add(dropped);
        this.longRunningTracesExpired.add(expired);
    }

    private void onSendAttempt(int traceCount, int sizeInBytes, RemoteApi.Response response) {
        int status;
        this.apiRequests.increment();
        this.flushedTraces.add(traceCount);
        this.flushedBytes.add(sizeInBytes);
        if (response.exception().isPresent()) {
            this.apiErrors.increment();
        }
        if ((status = response.status().orElse(0)) != 0) {
            if (200 == status) {
                this.apiResponsesOK.increment();
            } else {
                this.statsd.incrementCounter("api.responses.total", this.statusTagsCache.get(status));
            }
        }
    }

    @Override
    public void onClientStatTraceComputed(int countedSpans, int totalSpans, boolean dropped) {
        this.clientStatsProcessedTraces.increment();
        this.clientStatsProcessedSpans.add(countedSpans);
        if (dropped) {
            this.clientStatsP0DroppedTraces.increment();
            this.clientStatsP0DroppedSpans.add(totalSpans);
        }
    }

    @Override
    public void onClientStatPayloadSent() {
        this.clientStatsRequests.increment();
    }

    @Override
    public void onClientStatDowngraded() {
        this.clientStatsDowngrades.increment();
    }

    @Override
    public void onClientStatErrorReceived() {
        this.clientStatsErrors.increment();
    }

    @Override
    public void close() {
        if (null != this.cancellation) {
            this.cancellation.cancel();
        }
    }

    @Override
    public String summary() {
        return "apiRequests=" + this.apiRequests.sum() + "\napiErrors=" + this.apiErrors.sum() + "\napiResponsesOK=" + this.apiResponsesOK.sum() + "\n\nuserDropEnqueuedTraces=" + this.userDropEnqueuedTraces.sum() + "\nuserKeepEnqueuedTraces=" + this.userKeepEnqueuedTraces.sum() + "\nsamplerDropEnqueuedTraces=" + this.samplerDropEnqueuedTraces.sum() + "\nsamplerKeepEnqueuedTraces=" + this.samplerKeepEnqueuedTraces.sum() + "\nunsetPriorityEnqueuedTraces=" + this.unsetPriorityEnqueuedTraces.sum() + "\n\nuserDropDroppedTraces=" + this.userDropDroppedTraces.sum() + "\nuserKeepDroppedTraces=" + this.userKeepDroppedTraces.sum() + "\nsamplerDropDroppedTraces=" + this.samplerDropDroppedTraces.sum() + "\nsamplerKeepDroppedTraces=" + this.samplerKeepDroppedTraces.sum() + "\nserialFailedDroppedTraces=" + this.serialFailedDroppedTraces.sum() + "\nunsetPriorityDroppedTraces=" + this.unsetPriorityDroppedTraces.sum() + "\n\nuserDropDroppedSpans=" + this.userDropDroppedSpans.sum() + "\nuserKeepDroppedSpans=" + this.userKeepDroppedSpans.sum() + "\nsamplerDropDroppedSpans=" + this.samplerDropDroppedSpans.sum() + "\nsamplerKeepDroppedSpans=" + this.samplerKeepDroppedSpans.sum() + "\nserialFailedDroppedSpans=" + this.serialFailedDroppedSpans.sum() + "\nunsetPriorityDroppedSpans=" + this.unsetPriorityDroppedSpans.sum() + "\n\nenqueuedSpans=" + this.enqueuedSpans.sum() + "\nenqueuedBytes=" + this.enqueuedBytes.sum() + "\ncreatedTraces=" + this.createdTraces.sum() + "\ncreatedSpans=" + this.createdSpans.sum() + "\nfinishedSpans=" + this.finishedSpans.sum() + "\nflushedTraces=" + this.flushedTraces.sum() + "\nflushedBytes=" + this.flushedBytes.sum() + "\npartialTraces=" + this.partialTraces.sum() + "\npartialBytes=" + this.partialBytes.sum() + "\n\nclientSpansWithoutContext=" + this.clientSpansWithoutContext.sum() + "\n\nsingleSpanSampled=" + this.singleSpanSampled.sum() + "\nsingleSpanUnsampled=" + this.singleSpanUnsampled.sum() + "\n\ncapturedContinuations=" + this.capturedContinuations.sum() + "\ncancelledContinuations=" + this.cancelledContinuations.sum() + "\nfinishedContinuations=" + this.finishedContinuations.sum() + "\n\nactivatedScopes=" + this.activatedScopes.sum() + "\nclosedScopes=" + this.closedScopes.sum() + "\nscopeStackOverflow=" + this.scopeStackOverflow.sum() + "\nscopeCloseErrors=" + this.scopeCloseErrors.sum() + "\nuserScopeCloseErrors=" + this.userScopeCloseErrors.sum() + "\n\nlongRunningTracesWrite=" + this.longRunningTracesWrite.sum() + "\nlongRunningTracesDropped=" + this.longRunningTracesDropped.sum() + "\nlongRunningTracesExpired=" + this.longRunningTracesExpired.sum() + "\n\nclientStatsRequests=" + this.clientStatsRequests.sum() + "\nclientStatsErrors=" + this.clientStatsErrors.sum() + "\nclientStatsDowngrades=" + this.clientStatsDowngrades.sum() + "\nclientStatsP0DroppedSpans=" + this.clientStatsP0DroppedSpans.sum() + "\nclientStatsP0DroppedTraces=" + this.clientStatsP0DroppedTraces.sum() + "\nclientStatsProcessedSpans=" + this.clientStatsProcessedSpans.sum() + "\nclientStatsProcessedTraces=" + this.clientStatsProcessedTraces.sum();
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class Flush
    implements AgentTaskScheduler.Task<TracerHealthMetrics> {
        private static final String[] USER_DROP_TAG = new String[]{"priority:user_drop"};
        private static final String[] USER_KEEP_TAG = new String[]{"priority:user_keep"};
        private static final String[] SAMPLER_DROP_TAG = new String[]{"priority:sampler_drop"};
        private static final String[] SAMPLER_KEEP_TAG = new String[]{"priority:sampler_keep"};
        private static final String[] SERIAL_FAILED_TAG = new String[]{"failure:serial"};
        private static final String[] UNSET_TAG = new String[]{"priority:unset"};
        private static final String[] SINGLE_SPAN_SAMPLER = new String[]{"sampler:single-span"};
        private final long[] previousCounts = new long[50];
        @SuppressFBWarnings(value={"AT_STALE_THREAD_WRITE_OF_PRIMITIVE"})
        private int countIndex;

        private Flush() {
        }

        @Override
        public void run(TracerHealthMetrics target) {
            this.countIndex = -1;
            try {
                this.reportIfChanged(target.statsd, "api.requests.total", target.apiRequests, NO_TAGS);
                this.reportIfChanged(target.statsd, "api.errors.total", target.apiErrors, NO_TAGS);
                this.reportIfChanged(target.statsd, "api.responses.total", target.apiResponsesOK, STATUS_OK_TAGS);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.userDropEnqueuedTraces, USER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.userKeepEnqueuedTraces, USER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.samplerDropEnqueuedTraces, SAMPLER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.samplerKeepEnqueuedTraces, SAMPLER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.unsetPriorityEnqueuedTraces, UNSET_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.userDropDroppedTraces, USER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.userKeepDroppedTraces, USER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.samplerDropDroppedTraces, SAMPLER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.samplerKeepDroppedTraces, SAMPLER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.serialFailedDroppedTraces, SERIAL_FAILED_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.unsetPriorityDroppedTraces, UNSET_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.userDropDroppedSpans, USER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.userKeepDroppedSpans, USER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.samplerDropDroppedSpans, SAMPLER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.samplerKeepDroppedSpans, SAMPLER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.serialFailedDroppedSpans, SERIAL_FAILED_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.unsetPriorityDroppedSpans, UNSET_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.spans", target.enqueuedSpans, NO_TAGS);
                this.reportIfChanged(target.statsd, "queue.enqueued.bytes", target.enqueuedBytes, NO_TAGS);
                this.reportIfChanged(target.statsd, "trace.pending.created", target.createdTraces, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.pending.created", target.createdSpans, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.pending.finished", target.finishedSpans, NO_TAGS);
                this.reportIfChanged(target.statsd, "flush.traces.total", target.flushedTraces, NO_TAGS);
                this.reportIfChanged(target.statsd, "flush.bytes.total", target.flushedBytes, NO_TAGS);
                this.reportIfChanged(target.statsd, "queue.partial.traces", target.partialTraces, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.flushed.partial", target.partialBytes, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.client.no-context", target.clientSpansWithoutContext, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.sampling.sampled", target.singleSpanSampled, SINGLE_SPAN_SAMPLER);
                this.reportIfChanged(target.statsd, "span.sampling.unsampled", target.singleSpanUnsampled, SINGLE_SPAN_SAMPLER);
                this.reportIfChanged(target.statsd, "span.continuations.captured", target.capturedContinuations, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.continuations.canceled", target.cancelledContinuations, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.continuations.finished", target.finishedContinuations, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.activate.count", target.activatedScopes, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.close.count", target.closedScopes, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.error.stack-overflow", target.scopeStackOverflow, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.close.error", target.scopeCloseErrors, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.user.close.error", target.userScopeCloseErrors, NO_TAGS);
                this.reportIfChanged(target.statsd, "long-running.write", target.longRunningTracesWrite, NO_TAGS);
                this.reportIfChanged(target.statsd, "long-running.dropped", target.longRunningTracesDropped, NO_TAGS);
                this.reportIfChanged(target.statsd, "long-running.expired", target.longRunningTracesExpired, NO_TAGS);
                this.reportIfChanged(target.statsd, "stats.traces_in", target.clientStatsProcessedTraces, NO_TAGS);
                this.reportIfChanged(target.statsd, "stats.spans_in", target.clientStatsProcessedSpans, NO_TAGS);
                this.reportIfChanged(target.statsd, "stats.dropped_p0_traces", target.clientStatsP0DroppedTraces, NO_TAGS);
                this.reportIfChanged(target.statsd, "stats.dropped_p0_spans", target.clientStatsP0DroppedSpans, NO_TAGS);
                this.reportIfChanged(target.statsd, "stats.flush_payloads", target.clientStatsRequests, NO_TAGS);
                this.reportIfChanged(target.statsd, "stats.flush_errors", target.clientStatsErrors, NO_TAGS);
                this.reportIfChanged(target.statsd, "stats.agent_downgrades", target.clientStatsDowngrades, NO_TAGS);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                log.warn("previousCounts array needs resizing to at least {}, was {}", (Object)(this.countIndex + 1), (Object)this.previousCounts.length);
            }
        }

        private void reportIfChanged(StatsDClient statsDClient, String aspect, LongAdder counter, String[] tags) {
            long count = counter.sum();
            long delta = count - this.previousCounts[++this.countIndex];
            if (delta > 0L) {
                statsDClient.count(aspect, delta, tags);
                this.previousCounts[this.countIndex] = count;
            }
        }
    }
}

