/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddagent;

import datadog.trace.api.Config;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.monitor.Counter;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.communication.monitor.Recording;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.RemoteResponseListener;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentApi
extends RemoteApi {
    public static final String DATADOG_META_TRACER_VERSION = "Datadog-Meta-Tracer-Version";
    private static final Logger log = LoggerFactory.getLogger(DDAgentApi.class);
    private static final String DATADOG_CLIENT_COMPUTED_STATS = "Datadog-Client-Computed-Stats";
    private static final String DATADOG_CLIENT_COMPUTED_TOP_LEVEL = "Datadog-Client-Computed-Top-Level";
    private static final String X_DATADOG_TRACE_COUNT = "X-Datadog-Trace-Count";
    private static final String DATADOG_DROPPED_TRACE_COUNT = "Datadog-Client-Dropped-P0-Traces";
    private static final String DATADOG_DROPPED_SPAN_COUNT = "Datadog-Client-Dropped-P0-Spans";
    private static final String DATADOG_AGENT_STATE = "Datadog-Agent-State";
    private final List<RemoteResponseListener> responseListeners = new ArrayList<RemoteResponseListener>();
    private final boolean metricsEnabled;
    private final Recording sendPayloadTimer;
    private final Counter agentErrorCounter;
    private static final JsonAdapter<Map<String, Map<String, Number>>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter(Types.newParameterizedType(Map.class, new Type[]{String.class, Types.newParameterizedType(Map.class, new Type[]{String.class, Double.class})}));
    private final DDAgentFeaturesDiscovery featuresDiscovery;
    private final OkHttpClient httpClient;
    private final HttpUrl agentUrl;
    private final Map<String, String> headers;

    public DDAgentApi(OkHttpClient client, HttpUrl agentUrl, DDAgentFeaturesDiscovery featuresDiscovery, Monitoring monitoring, boolean metricsEnabled) {
        super(false);
        this.featuresDiscovery = featuresDiscovery;
        this.agentUrl = agentUrl;
        this.httpClient = client;
        this.sendPayloadTimer = monitoring.newTimer("trace.agent.send.time");
        this.agentErrorCounter = monitoring.newCounter("trace.agent.error.counter");
        this.metricsEnabled = metricsEnabled;
        this.headers = new HashMap<String, String>();
        this.headers.put(DATADOG_CLIENT_COMPUTED_TOP_LEVEL, "true");
        this.headers.put(DATADOG_META_TRACER_VERSION, DDTraceCoreInfo.VERSION);
    }

    public void addResponseListener(RemoteResponseListener listener) {
        if (!this.responseListeners.contains(listener)) {
            this.responseListeners.add(listener);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public RemoteApi.Response sendSerializedTraces(Payload payload) {
        int sizeInBytes = payload.sizeInBytes();
        String tracesEndpoint = this.featuresDiscovery.getTraceEndpoint();
        if (null == tracesEndpoint) {
            this.featuresDiscovery.discoverIfOutdated();
            tracesEndpoint = this.featuresDiscovery.getTraceEndpoint();
            if (null == tracesEndpoint) {
                log.error("No datadog agent detected");
                this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, null);
                return RemoteApi.Response.failed(404);
            }
        }
        HttpUrl tracesUrl = this.agentUrl.resolve(tracesEndpoint);
        try {
            Request request = OkHttpUtils.prepareRequest(tracesUrl, this.headers).addHeader(X_DATADOG_TRACE_COUNT, Integer.toString(payload.traceCount())).addHeader(DATADOG_DROPPED_TRACE_COUNT, Long.toString(payload.droppedTraces())).addHeader(DATADOG_DROPPED_SPAN_COUNT, Long.toString(payload.droppedSpans())).addHeader(DATADOG_CLIENT_COMPUTED_STATS, this.metricsEnabled && this.featuresDiscovery.supportsMetrics() || !Config.get().isApmTracingEnabled() ? "true" : "").put(payload.toRequest()).build();
            this.totalTraces += (long)payload.traceCount();
            this.receivedTraces += (long)payload.traceCount();
            try (Recording recording = this.sendPayloadTimer.start();){
                Response response;
                block28: {
                    response = this.httpClient.newCall(request).execute();
                    this.handleAgentChange(response.header(DATADOG_AGENT_STATE));
                    if (response.code() == 200) break block28;
                    this.agentErrorCounter.incrementErrorCount(response.message(), payload.traceCount());
                    this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, response, null);
                    RemoteApi.Response response2 = RemoteApi.Response.failed(response.code());
                    if (response != null) {
                        response.close();
                    }
                    return response2;
                }
                this.countAndLogSuccessfulSend(payload.traceCount(), sizeInBytes);
                String responseString = null;
                try {
                    Object parsedResponse;
                    responseString = DDAgentApi.getResponseBody(response);
                    if (!"".equals(responseString) && !"OK".equalsIgnoreCase(responseString)) {
                        parsedResponse = RESPONSE_ADAPTER.fromJson(responseString);
                        String endpoint = tracesUrl.toString();
                        for (RemoteResponseListener listener : this.responseListeners) {
                            listener.onResponse(endpoint, (Map<String, Map<String, Number>>)parsedResponse);
                        }
                    }
                    parsedResponse = RemoteApi.Response.success(response.code(), responseString);
                    if (response != null) {
                        response.close();
                    }
                    return parsedResponse;
                }
                catch (IOException e) {
                    try {
                        log.debug("Failed to parse DD agent response: {}", (Object)responseString, (Object)e);
                        RemoteApi.Response response3 = RemoteApi.Response.success(response.code(), e);
                        if (response != null) {
                            response.close();
                        }
                        if (recording != null) {
                            recording.close();
                        }
                        return response3;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (IOException e) {
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, e);
            return RemoteApi.Response.failed(e);
        }
    }

    private void handleAgentChange(String state) {
        String previous = this.featuresDiscovery.state();
        if (!Objects.equals(state, previous)) {
            this.featuresDiscovery.discover();
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    public void setHeader(String k, String v) {
        this.headers.put(k, v);
    }
}

