/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import ddtrot.dd.trace.common.writer.TraceStructureWriter;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.MetadataConsumer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListWriter
extends CopyOnWriteArrayList<List<DDSpan>>
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(ListWriter.class);
    private static final Filter ACCEPT_ALL = trace -> true;
    private final AtomicInteger traceCount = new AtomicInteger();
    private final TraceStructureWriter structureWriter = new TraceStructureWriter(true);
    private final Object monitor = new Object();
    private Filter filter = ACCEPT_ALL;
    private MetadataConsumer metadataConsumer = MetadataConsumer.NO_OP;

    public List<DDSpan> firstTrace() {
        return (List)this.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void write(List<DDSpan> trace) {
        if (!this.filter.accept(trace)) {
            return;
        }
        for (DDSpan span : trace) {
            span.processTagsAndBaggage(this.metadataConsumer);
        }
        this.add(trace);
        this.structureWriter.write(trace);
        this.traceCount.incrementAndGet();
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitUntilDeadline(long timeout, TimeUnit unit, BooleanSupplier predicate) throws InterruptedException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        while (true) {
            if (predicate.getAsBoolean()) {
                return true;
            }
            long now = System.nanoTime();
            long remaining = deadline - now;
            if (remaining <= 0L) break;
            long millis = TimeUnit.NANOSECONDS.toMillis(remaining);
            long nanos = remaining - TimeUnit.MILLISECONDS.toNanos(millis);
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait(millis, (int)nanos);
            }
        }
        return false;
    }

    public boolean waitForTracesMax(int number, int seconds) throws InterruptedException {
        return this.awaitUntilDeadline(seconds, TimeUnit.SECONDS, () -> this.traceCount.get() >= number);
    }

    public void waitForTraces(int number) throws InterruptedException, TimeoutException {
        if (!this.waitForTracesMax(number, 20)) {
            String msg = "Timeout waiting for " + number + " trace(s). ListWriter.size() == " + this.size() + " : " + super.toString();
            log.warn(msg);
            throw new TimeoutException(msg);
        }
    }

    public void waitUntilReported(DDSpan span) throws InterruptedException, TimeoutException {
        this.waitUntilReported(span, 20, TimeUnit.SECONDS);
    }

    public void waitUntilReported(DDSpan span, int timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean reported = this.awaitUntilDeadline(timeout, unit, () -> this.isReported(span));
        if (!reported) {
            String msg = "Timeout waiting for span to be reported: " + span;
            log.warn(msg);
            throw new TimeoutException(msg);
        }
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setMetadataConsumer(MetadataConsumer metadataConsumer) {
        this.metadataConsumer = metadataConsumer;
    }

    private boolean isReported(DDSpan span) {
        for (List trace : this) {
            for (DDSpan aSpan : trace) {
                if (aSpan != span) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void incrementDropCounts(int spanCount) {
    }

    @Override
    public void start() {
        this.close();
    }

    @Override
    public boolean flush() {
        this.filter = ACCEPT_ALL;
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.traceCount.set(0);
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public String toString() {
        return "ListWriter { size=" + this.size() + " }";
    }

    public static interface Filter {
        public boolean accept(List<DDSpan> var1);
    }
}

