/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import datadog.trace.api.sampling.SamplingRule;
import ddtrot.com.squareup.moshi.FromJson;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.JsonReader;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.ToJson;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.dd.trace.common.sampling.TraceSamplingRules;
import ddtrot.okio.Okio;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanSamplingRules {
    public static final SpanSamplingRules EMPTY = new SpanSamplingRules(Collections.emptyList());
    private static final Logger log = LoggerFactory.getLogger(SpanSamplingRules.class);
    private static final Moshi MOSHI = new Moshi.Builder().add(new RuleAdapter()).build();
    private static final ParameterizedType LIST_OF_RULES = Types.newParameterizedType(List.class, new Type[]{Rule.class});
    private static final JsonAdapter<List<Rule>> LIST_OF_RULES_ADAPTER = MOSHI.adapter(LIST_OF_RULES);
    private final List<Rule> rules;

    public SpanSamplingRules(List<Rule> rules) {
        this.rules = Collections.unmodifiableList(rules);
    }

    public static SpanSamplingRules deserialize(String json) {
        SpanSamplingRules result = EMPTY;
        try {
            result = SpanSamplingRules.filterOutNullRules(LIST_OF_RULES_ADAPTER.fromJson(json));
        }
        catch (Throwable ex) {
            log.error("Couldn't parse Span Sampling Rules from JSON: {}", (Object)json, (Object)ex);
        }
        return result;
    }

    public static SpanSamplingRules deserializeFile(String jsonFile) {
        SpanSamplingRules result = EMPTY;
        try (JsonReader reader = JsonReader.of(Okio.buffer(Okio.source(new File(jsonFile))));){
            result = SpanSamplingRules.filterOutNullRules(LIST_OF_RULES_ADAPTER.fromJson(reader));
        }
        catch (FileNotFoundException e) {
            log.warn("Span Sampling Rules file {} doesn't exist", (Object)jsonFile);
        }
        catch (IOException e) {
            log.error("Couldn't read Span Sampling Rules file {}.", (Object)jsonFile, (Object)e);
        }
        catch (Throwable ex) {
            log.error("Couldn't parse Span Sampling Rules from JSON file {}.", (Object)jsonFile, (Object)ex);
        }
        return result;
    }

    private static SpanSamplingRules filterOutNullRules(List<Rule> rules) {
        if (rules == null || rules.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Rule> notNullRules = new ArrayList<Rule>(rules.size());
        for (Rule rule : rules) {
            if (rule == null) continue;
            notNullRules.add(rule);
        }
        if (notNullRules.isEmpty()) {
            return EMPTY;
        }
        return new SpanSamplingRules(notNullRules);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    static /* synthetic */ Moshi access$200() {
        return MOSHI;
    }

    public static final class Rule
    implements SamplingRule.SpanSamplingRule {
        private final String service;
        private final String name;
        private final String resource;
        private final Map<String, String> tags;
        private final double sampleRate;
        private final int maxPerSecond;
        private final SamplingRule.Provenance provenance;

        private Rule(String service, String name, String resource, Map<String, String> tags, double sampleRate, int maxPerSecond, SamplingRule.Provenance provenance) {
            this.service = service;
            this.name = name;
            this.resource = resource;
            this.tags = tags;
            this.sampleRate = sampleRate;
            this.maxPerSecond = maxPerSecond;
            this.provenance = provenance;
        }

        public static Rule create(JsonRule jsonRule) {
            String service = SamplingRule.normalizeGlob(jsonRule.service);
            String name = SamplingRule.normalizeGlob(jsonRule.name);
            String resource = SamplingRule.normalizeGlob(jsonRule.resource);
            Map<String, String> tags = jsonRule.tags;
            if (tags == null) {
                tags = Collections.emptyMap();
            }
            double sampleRate = 1.0;
            if (jsonRule.sample_rate != null) {
                try {
                    sampleRate = Double.parseDouble(jsonRule.sample_rate);
                }
                catch (NumberFormatException ex) {
                    Rule.logRuleError(jsonRule, "sample_rate must be a number between 0.0 and 1.0");
                    return null;
                }
                if (sampleRate < 0.0 || sampleRate > 1.0) {
                    Rule.logRuleError(jsonRule, "sample_rate must be between 0.0 and 1.0");
                    return null;
                }
            }
            int maxPerSecond = Integer.MAX_VALUE;
            if (jsonRule.max_per_second != null) {
                try {
                    double parsedMaxPerSeconds = Double.parseDouble(jsonRule.max_per_second);
                    if (parsedMaxPerSeconds <= 0.0) {
                        Rule.logRuleError(jsonRule, "max_per_second must be greater than 0.0");
                        return null;
                    }
                    maxPerSecond = Math.max((int)parsedMaxPerSeconds, 1);
                }
                catch (NumberFormatException ex) {
                    Rule.logRuleError(jsonRule, "max_per_second must be a number greater than 0.0");
                    return null;
                }
            }
            return new Rule(service, name, resource, tags, sampleRate, maxPerSecond, SamplingRule.Provenance.LOCAL);
        }

        private static void logRuleError(JsonRule rule, String error) {
            log.error("Skipping invalid Span Sampling Rule: {} - {}", (Object)rule, (Object)error);
        }

        @Override
        public String getService() {
            return this.service;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getResource() {
            return this.resource;
        }

        @Override
        public Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public double getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public int getMaxPerSecond() {
            return this.maxPerSecond;
        }

        @Override
        public SamplingRule.Provenance getProvenance() {
            return this.provenance;
        }
    }

    private static final class RuleAdapter {
        private RuleAdapter() {
        }

        @FromJson
        Rule fromJson(JsonRule jsonRule) {
            return Rule.create(jsonRule);
        }

        @ToJson
        JsonRule toJson(TraceSamplingRules.Rule rule) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class JsonRule {
        private static final JsonAdapter<JsonRule> jsonAdapter = SpanSamplingRules.access$200().adapter(JsonRule.class);
        String service;
        String name;
        String resource;
        Map<String, String> tags;
        String sample_rate;
        String max_per_second;

        private JsonRule() {
        }

        public String toString() {
            return jsonAdapter.toJson(this);
        }
    }
}

