/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.api;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.ContextKey;
import ddtrot.dd.context.ImplicitContextKeyed;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Baggage
implements ImplicitContextKeyed {
    private static final ContextKey<Baggage> CONTEXT_KEY = ContextKey.named("baggage-key");
    private final Map<String, String> items;
    private String w3cHeader;

    @Nullable
    public static Baggage fromContext(Context context) {
        return context.get(CONTEXT_KEY);
    }

    public static Baggage empty() {
        return Baggage.create(new HashMap<String, String>(), "");
    }

    public static Baggage create(Map<String, String> items) {
        return new Baggage(items, null);
    }

    public static Baggage create(Map<String, String> items, String w3cHeader) {
        return new Baggage(items, w3cHeader);
    }

    private Baggage(Map<String, String> items, String w3cHeader) {
        this.items = items;
        this.w3cHeader = w3cHeader;
    }

    public void addItem(String key, String value) {
        this.items.put(key, value);
        this.w3cHeader = null;
    }

    public void removeItem(String key) {
        if (this.items.remove(key) != null) {
            this.w3cHeader = null;
        }
    }

    @Nullable
    public String getW3cHeader() {
        return this.w3cHeader;
    }

    public void setW3cHeader(String w3cHeader) {
        this.w3cHeader = w3cHeader;
    }

    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.items);
    }

    @Override
    public Context storeInto(@Nonnull Context context) {
        return context.with(CONTEXT_KEY, this);
    }
}

