/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.normalize;

import datadog.trace.api.Config;
import datadog.trace.api.Pair;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.api.normalize.AntPatternHttpPathNormalizer;
import ddtrot.dd.trace.api.normalize.SimpleHttpPathNormalizer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class HttpResourceNames {
    public static final UTF8BytesString DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");
    private static final Function<Pair<CharSequence, CharSequence>, UTF8BytesString> JOINER = input -> {
        StringBuilder sb;
        CharSequence path = (CharSequence)input.getRight();
        if (path == null) {
            return DEFAULT_RESOURCE_NAME;
        }
        CharSequence method = (CharSequence)input.getLeft();
        if (method == null) {
            sb = new StringBuilder(path.length());
        } else {
            sb = new StringBuilder(path.length() + method.length() + 1);
            sb.append(method);
            for (int i = 0; i < sb.length(); ++i) {
                sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
            }
            sb.append(' ');
        }
        int l = path.length() - 1;
        if (HttpResourceNames.instance().removeTrailingSlash && l > 0 && path.charAt(l) == '/') {
            sb.append(path, 0, l);
        } else {
            sb.append(path);
        }
        return UTF8BytesString.create(sb);
    };
    private static final DDCache<Pair<CharSequence, CharSequence>, CharSequence> JOINER_CACHE = DDCaches.newFixedSizeCache(128);
    private static final SimpleHttpPathNormalizer simpleHttpPathNormalizer = new SimpleHttpPathNormalizer();
    private static HttpResourceNames INSTANCE;
    private final AntPatternHttpPathNormalizer serverAntPatternHttpPathNormalizer = new AntPatternHttpPathNormalizer(Config.get().getHttpServerPathResourceNameMapping());
    private final AntPatternHttpPathNormalizer clientAntPatternHttpPathNormalizer = new AntPatternHttpPathNormalizer(Config.get().getHttpClientPathResourceNameMapping());
    private final boolean removeTrailingSlash = Config.get().getHttpResourceRemoveTrailingSlash();

    private static HttpResourceNames instance() {
        if (null == INSTANCE) {
            INSTANCE = new HttpResourceNames();
        }
        return INSTANCE;
    }

    private HttpResourceNames() {
    }

    public static AgentSpan setForServer(AgentSpan span, CharSequence method, CharSequence path, boolean encoded) {
        if (path == null) {
            return span;
        }
        Pair<CharSequence, Byte> result = HttpResourceNames.computeForServer(method, path, encoded);
        if (result.hasLeft()) {
            span.setResourceName(result.getLeft(), result.getRight());
        }
        return span;
    }

    public static Pair<CharSequence, Byte> computeForServer(CharSequence method, @Nonnull CharSequence path, boolean encoded) {
        byte priority;
        String resourcePath = HttpResourceNames.instance().serverAntPatternHttpPathNormalizer.normalize(path.toString(), encoded);
        if (resourcePath != null) {
            priority = 4;
        } else {
            resourcePath = simpleHttpPathNormalizer.normalize(path.toString(), encoded);
            priority = 1;
        }
        return Pair.of(HttpResourceNames.join(method, resourcePath), priority);
    }

    public static Pair<CharSequence, Byte> computeForClient(CharSequence method, @Nonnull CharSequence path, boolean encoded) {
        byte priority;
        String resourcePath = HttpResourceNames.instance().clientAntPatternHttpPathNormalizer.normalize(path.toString(), encoded);
        if (resourcePath != null) {
            priority = 4;
        } else {
            resourcePath = simpleHttpPathNormalizer.normalize(path.toString(), encoded);
            priority = 1;
        }
        return Pair.of(HttpResourceNames.join(method, resourcePath), priority);
    }

    public static AgentSpan setForClient(AgentSpan span, CharSequence method, CharSequence path, boolean encoded) {
        if (path == null) {
            return span;
        }
        Pair<CharSequence, Byte> result = HttpResourceNames.computeForClient(method, path, encoded);
        if (result.hasLeft()) {
            span.setResourceName(result.getLeft(), result.getRight());
        }
        return span;
    }

    public static CharSequence join(CharSequence method, CharSequence path) {
        return JOINER_CACHE.computeIfAbsent(Pair.of(method, path), JOINER);
    }
}

